/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import com.atlassian.clover.api.CloverException;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.Logger;
import com.cenqua.clover.MaskedBitSetCoverageProvider;
import com.cenqua.clover.TestResultProcessor;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.Type;
import com.cenqua.clover.reporters.filters.DefaultTestFilter;
import com.cenqua.clover.reporters.filters.FileSetFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Current
extends CloverReportConfig {
    private boolean summary;
    private static final String ERR_INITSTRING_NOT_SPECIFIED = "initstring not specified.";
    public static final Current DEFAULT_HTML = new Current(false);
    public static final Current DEFAULT_XML = new Current(false);
    public static final Current DEFAULT_PDF = new Current(true);
    private int maxTestsPerFile = -1;
    private boolean includeFailedTestCoverage = false;
    private List testSourceFiles = new ArrayList();
    private List globalFileNames = new ArrayList();
    private int numThreads = 2;
    private Interval timeOut = new Interval(9223372036854775L, 0);
    private boolean showUniqueCoverage = false;
    protected List testResultFiles;

    public Current() {
    }

    public Current(Current that) {
        this.summary = that.summary;
    }

    public Current(boolean summary) {
        this.summary = summary;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public boolean getSummary() {
        return this.summary;
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (this.getInitString() == null || this.getInitString().length() == 0) {
            this.setFailureReason(ERR_INITSTRING_NOT_SPECIFIED);
            return false;
        }
        if (this.getFormat() == null) {
            if (this.getSummary()) {
                this.setFormat(Format.DEFAULT_PDF);
            } else {
                this.setFormat(Format.DEFAULT_XML);
            }
        }
        if (this.getFormat().getType() == null) {
            this.setFailureReason("You need to set the report type");
            return false;
        }
        if (this.getFormat().in(new Type[]{Type.PDF}) && !this.getSummary()) {
            this.setFailureReason("Can only do summary reports in PDF");
            return false;
        }
        if (this.numThreads < 0) {
            this.setFailureReason("numThreads must be greater than or equal to zero, not: " + this.numThreads);
            return false;
        }
        return true;
    }

    public String toString() {
        return "Current[" + this.getFormat().getType() + ", " + this.getOutFile().getAbsolutePath() + "]";
    }

    public void addGlobalFileName(String fileName) {
        this.globalFileNames.add(fileName);
    }

    public void addTestResultFile(File file) {
        if (this.testResultFiles == null) {
            this.testResultFiles = new ArrayList();
        }
        this.testResultFiles.add(file);
    }

    public void addTestSourceFile(File file) {
        this.testSourceFiles.add(file);
    }

    public List getTestSourceFiles() {
        return Collections.unmodifiableList(this.testSourceFiles);
    }

    public List getGlobalSourceFileNames() {
        return Collections.unmodifiableList(this.globalFileNames);
    }

    public CloverDatabase getCoverageDatabase() throws CloverException {
        boolean hasTestResult;
        this.setLoadTestResults(this.testResultFiles == null);
        CloverDatabase db = super.getCoverageDatabase();
        try {
            if (!this.isLoadTestResults() && db.getTestOnlyModel() != null) {
                TestResultProcessor.addTestResultsToModel(db.getTestOnlyModel(), this.testResultFiles);
            }
        }
        catch (CloverException e) {
            Logger.getInstance().error("Error parsing test results: " + e.getMessage() + " - Test results will not be included.");
        }
        boolean bl = hasTestResult = db.getTestOnlyModel() != null && db.getTestOnlyModel().hasTestResults();
        if (hasTestResult && !this.isIncludeFailedTestCoverage()) {
            CoverageData data = db.getCoverageData();
            MaskedBitSetCoverageProvider provider = new MaskedBitSetCoverageProvider(data.getPassOnlyAndIncidentalHits(), data, data);
            db.getAppOnlyModel().setDataProvider(provider);
            db.getTestOnlyModel().setDataProvider(provider);
            db.getFullModel().setDataProvider(provider);
            db.getFullModel().setHasTestResults(hasTestResult);
        }
        if (this.isIncludeFailedTestCoverage() && !hasTestResult) {
            Logger.getInstance().debug("includeFailedTestCoverage='" + this.isIncludeFailedTestCoverage() + "', however no test results were found.");
        }
        return db;
    }

    protected HasMetricsFilter.Invertable effectiveTestFilter() {
        if (this.testSourceFiles.size() > 0) {
            return new FileSetFilter(this.testSourceFiles);
        }
        HasMetricsFilter.Invertable filter = this.getTestFilter();
        return filter != null ? filter : new DefaultTestFilter();
    }

    public int getMaxTestsPerFile() {
        return this.maxTestsPerFile;
    }

    public void setMaxTestsPerFile(int maxTestsPerFile) {
        this.maxTestsPerFile = maxTestsPerFile;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public boolean isShowUniqueCoverage() {
        return this.showUniqueCoverage;
    }

    public void setShowUniqueCoverage(boolean showUniqueCoverage) {
        this.showUniqueCoverage = showUniqueCoverage;
    }

    public boolean isIncludeFailedTestCoverage() {
        return this.includeFailedTestCoverage;
    }

    public void setIncludeFailedTestCoverage(boolean includeFailedTestCoverage) {
        this.includeFailedTestCoverage = includeFailedTestCoverage;
    }

    public Interval getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(String timeOutDescription) {
        this.timeOut = new Interval(timeOutDescription);
    }
}

