/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.filters;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.util._Arrays;
import com.cenqua.clover.registry.BaseInvertableFilter;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.util.FilterUtils;
import java.io.File;

public class AntPatternTestFilter
extends BaseInvertableFilter {
    private final String[] includeFilter;
    private final String[] excludeFilter;
    private final String root;

    AntPatternTestFilter(boolean inverted, String root, String[] includePattern, String[] excludePattern) {
        super(inverted);
        this.root = root == null || root.endsWith(File.separator) ? root : root + File.separator;
        this.includeFilter = includePattern;
        this.excludeFilter = excludePattern;
    }

    public AntPatternTestFilter(String root, String[] includePattern, String[] excludePattern) {
        this(false, root, includePattern, excludePattern);
    }

    public AntPatternTestFilter(String root) {
        this(root, new String[0], new String[0]);
    }

    public AntPatternTestFilter invert() {
        return new AntPatternTestFilter(!this.isInverted(), this.root, this.includeFilter, this.excludeFilter);
    }

    public boolean accept(HasMetrics hm) {
        if (hm instanceof ClassInfo) {
            ClassInfo ci = (ClassInfo)hm;
            File file = ((FileInfo)ci.getContainingFile()).getPhysicalFile();
            String path = file.getPath();
            String relative = this.root != null && path.startsWith(this.root) ? path.substring(this.root.length()) : path;
            return this.isInverted() ^ FilterUtils.isIncluded(relative, this.excludeFilter, this.includeFilter, false);
        }
        return true;
    }

    public String toString() {
        return "AntPatternTestFilter:[" + this.root + "]" + _Arrays.toString(this.includeFilter) + _Arrays.toString(this.excludeFilter);
    }

    public /* synthetic */ BaseInvertableFilter invert() {
        return this.invert();
    }

    public /* synthetic */ HasMetricsFilter.Invertable invert() {
        return this.invert();
    }
}

