/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import clover.org.jfree.chart.ChartRenderingInfo;
import clover.org.jfree.chart.ChartUtilities;
import clover.org.jfree.chart.JFreeChart;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.util.FileUtils;
import com.cenqua.clover.CloverLicenseInfo;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.HasMetricsSupport;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageFragment;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.CloverReporter;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.Historical;
import com.cenqua.clover.reporters.TestSelectionHelper;
import com.cenqua.clover.reporters.Type;
import com.cenqua.clover.reporters.filters.SourceFileFilter;
import com.cenqua.clover.reporters.html.HtmlRenderingSupportImpl;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.RenderDashboardAction;
import com.cenqua.clover.reporters.html.RenderFileAction;
import com.cenqua.clover.reporters.html.RenderPackageCoverageCloudAction;
import com.cenqua.clover.reporters.html.RenderPackageSummaryAction;
import com.cenqua.clover.reporters.html.RenderProjectCoverageCloudsAction;
import com.cenqua.clover.reporters.html.RenderTestResultAction;
import com.cenqua.clover.reporters.json.JSONHistoricalReporter;
import com.cenqua.clover.reporters.json.RenderMetricsJSONAction;
import com.cenqua.clover.reporters.json.RenderTreeMapAction;
import com.cenqua.clover.reporters.util.CloverChartFactory;
import com.cenqua.clover.reporters.util.HistoricalReportDescriptor;
import com.cenqua.clover.util.CloverExecutor;
import com.cenqua.clover.util.CloverExecutors;
import com.cenqua.clover.util.CloverUtils;
import com.cenqua.clover.util.Path;
import com.cenqua.clover.util.format.HtmlFormatter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class HtmlReporter
extends CloverReporter {
    private static final Map<String, String> HTML_HOMEPAGE_VALUES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("overview", "pkg-summary.html");
            this.put("aggregate", "agg-pkgs.html");
            this.put(HtmlReporter.HTML_HOMEPAGE_DEFAULT, "dashboard.html");
            this.put("quickwins", "quick-wins.html");
            this.put("projectrisks", "proj-risks.html");
            this.put("testresults", "test-pkg-summary.html");
        }
    });
    private static final String HTML_HOMEPAGE_DEFAULT = "dashboard";
    protected static final Map<String, String> SUMMARY_TABS = Collections.unmodifiableMap(new LinkedHashMap<String, String>(){
        {
            this.put(HtmlReporter.TAB_CLASSES, "pkg-app.html");
            this.put(HtmlReporter.TAB_TESTS, "pkg-test.html");
            this.put(HtmlReporter.TAB_RESULTS, "pkg-results.html");
        }
    });
    protected static final String TAB_CLASSES = "Classes";
    protected static final String TAB_TESTS = "Tests";
    protected static final String TAB_RESULTS = "Results";
    private static final Comparator TEST_SORT_ORDER = HasMetricsSupport.newTestListComparator();
    private static final Comparator<TestCaseInfo> TEST_CASE_COMPARATOR = new Comparator<TestCaseInfo>(){

        @Override
        public int compare(TestCaseInfo lhs, TestCaseInfo rhs) {
            if (rhs.isSuccess() & lhs.isSuccess()) {
                return 0;
            }
            if (!rhs.isSuccess()) {
                return 1;
            }
            return -1;
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((TestCaseInfo)x0, (TestCaseInfo)x1);
        }
    };
    private final DateFormat dateFormat = new SimpleDateFormat("EEE MMM d yyyy HH:mm:ss z");
    private final File basePath;
    private final File baseImagePath;
    private final HtmlRenderingSupportImpl rederingHelper = new HtmlRenderingSupportImpl(this.reportConfig.getFormat(), true);
    private final String reportTimeStamp;
    private final Comparator listComparator;
    private final String pageTitle;
    private final String pageTitleAnchor;
    private final String pageTitleTarget;
    private Date coverageTS;
    private Comparator detailComparator;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$html$HtmlReporter;

    public HtmlReporter(CloverReportConfig config) throws CloverException {
        super(config);
        this.basePath = this.reportConfig.getOutFile();
        this.baseImagePath = new File(this.basePath, "img");
        this.reportTimeStamp = this.dateFormat.format(new Date(System.currentTimeMillis()));
        this.pageTitleAnchor = config.getTitleAnchor() != null ? config.getTitleAnchor() : "";
        this.pageTitleTarget = config.getTitleTarget() != null ? config.getTitleTarget() : "_top";
        this.pageTitle = config.getTitle();
        String comp = config.getFormat().getOrderby();
        this.listComparator = HasMetricsSupport.LEX_COMP;
        this.detailComparator = HasMetricsSupport.PC_ASCENDING_COMP;
        if (comp != null) {
            this.detailComparator = HasMetricsSupport.getHasMetricsComparator(comp);
        }
    }

    protected void validate() throws CloverException {
        super.validate();
        if (!this.isCurrentReport() && !this.isHistoricalReport()) {
            throw new CloverException("Unsupported report type: " + this.reportConfig.getClass().getName());
        }
    }

    protected int executeImpl() throws CloverException {
        try {
            CloverUtils.createDir(this.basePath);
            CloverUtils.createDir(this.baseImagePath);
            if (this.isCurrentReport()) {
                this.executeCurrentReport();
            } else if (this.isHistoricalReport()) {
                this.executeHistoricalReport();
            } else {
                throw new CloverException("No report type specified");
            }
            return 0;
        }
        catch (Exception e) {
            throw new CloverException(e);
        }
    }

    protected long getPerms() {
        return this.isCurrentReport() ? 2L : 32L;
    }

    private void filterLinkedReports() {
        Map linkedReports = this.reportConfig.getLinkedReports();
        LinkedHashMap filteredLinkedReports = new LinkedHashMap();
        Iterator iterator = linkedReports.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            CloverReportConfig link = (CloverReportConfig)e.getValue();
            if (!link.validate()) {
                Logger.getInstance().warn("Not linking report due to: " + link.getValidationFailureReason());
                continue;
            }
            Format format = link.getFormat();
            if (format.in(new Type[]{Type.JSON, Type.XML})) continue;
            filteredLinkedReports.put(e.getKey(), link);
        }
        this.reportConfig.setLinkedReports(filteredLinkedReports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCurrentReport() throws Exception {
        if (!this.reportConfig.isAlwaysReport() && !this.database.hasCoverage()) {
            Logger.getInstance().warn("No coverage recordings found. No report will be generated.");
        } else {
            Logger.getInstance().info("Writing HTML report to '" + this.basePath + "'");
            this.coverageTS = new Date(this.database.getRecordingTimestamp());
            this.filterLinkedReports();
            long currentStartTime = System.currentTimeMillis();
            List<? extends BasePackageInfo> pkgs = this.getFullModel().getPackages();
            this.getFullModel().buildCaches();
            TreeInfo appSrcTree = new TreeInfo("", "App");
            TreeInfo appCloudTree = new TreeInfo("", "AppCloud");
            TreeInfo testSrcTree = new TreeInfo("testsrc-", "Test");
            try {
                List<? extends BaseClassInfo> targetClasses = this.getConfiguredModel().getClasses(HasMetricsFilter.ACCEPT_ALL);
                List<? extends BaseClassInfo> testClasses = this.getTestModel().getClasses(HasMetricsFilter.ACCEPT_ALL);
                List targetFiles = this.getFullModel().getFiles(new SourceFileFilter());
                Map srcFileCharts = CloverChartFactory.generateSrcFileCharts(targetFiles, this.baseImagePath);
                CloverExecutor service = CloverExecutors.newCloverExecutor(this.reportAsCurrent().getNumThreads(), "Clover");
                RenderFileAction.initThreadLocals();
                RenderMetricsJSONAction.initThreadLocals();
                Iterator<? extends BasePackageInfo> it = pkgs.iterator();
                while (it.hasNext()) {
                    PackageInfo pkg = (PackageInfo)it.next();
                    Logger.getInstance().verbose("Processing package " + pkg.getName());
                    long start = System.currentTimeMillis();
                    this.processPackage(pkg, appSrcTree, appCloudTree, testSrcTree, service, srcFileCharts);
                    long total = System.currentTimeMillis() - start;
                    if (!Logger.isDebug()) continue;
                    Logger.getInstance().debug("Processed package: " + pkg.getName() + " (" + pkg.getClasses().size() + " classes, " + pkg.getMetrics().getNumTests() + " tests)" + " in " + total + "ms");
                }
                this.renderDashboard(service, CloverChartFactory.generateHistogramChart(targetClasses, this.baseImagePath), CloverChartFactory.generateScatterChart(targetClasses, this.baseImagePath));
                this.renderProjectCoverageCloudPage(appCloudTree, service);
                this.renderProjectTreeMapPage(service);
                this.renderBasePages();
                this.renderTestResultsPkgsSummaryPage();
                this.renderTopLeftPanePage();
                this.renderAggregatePkgPage(this.getConfiguredModel(), appSrcTree, true);
                this.renderPackagesSummaryPage(this.getConfiguredModel(), appSrcTree, true);
                this.renderAggregatePkgPage(this.getTestModel(), testSrcTree, false);
                this.renderPackagesSummaryPage(this.getTestModel(), testSrcTree, false);
                this.renderPkgClassesPage("classes-summary.vm", null, targetClasses, TAB_CLASSES, false);
                this.renderPkgClassesPage("classes-summary.vm", null, testClasses, TAB_TESTS, false);
                this.renderPkgClassesPage("classes-summary.vm", null, testClasses, TAB_RESULTS, true);
                this.copyCommonImages();
                service.shutdown();
                Interval timeOut = this.reportAsCurrent().getTimeOut();
                if (!service.awaitTermination(timeOut.getValueInMillis(), TimeUnit.MILLISECONDS)) {
                    throw new CloverException("Timeout of '" + timeOut + "' reached during report generation. " + "Please increase this value and try again.");
                }
            }
            finally {
                RenderFileAction.resetThreadLocals();
                RenderMetricsJSONAction.resetThreadLocals();
            }
            long currentTotalTime = System.currentTimeMillis() - currentStartTime;
            int pkgCount = pkgs.size();
            long msPerPkg = pkgCount == 0 ? currentTotalTime : currentTotalTime / (long)pkgCount;
            Logger.getInstance().info("Done. Processed " + pkgCount + " packages in " + currentTotalTime + "ms (" + msPerPkg + "ms per package).");
        }
    }

    private void executeHistoricalReport() throws Exception {
        Logger.getInstance().info("Writing historical report to '" + this.basePath + "'");
        HistoricalReportDescriptor descriptor = new HistoricalReportDescriptor(this.reportConfig);
        boolean hasHistoricalData = descriptor.gatherHistoricalModels();
        if (!hasHistoricalData) {
            Logger.getInstance().warn("No historical data found. No HTML historical report can be generated.");
            return;
        }
        this.coverageTS = new Date(descriptor.getFirstTimestamp());
        VelocityContext context = new VelocityContext();
        this.insertCommonProps(context, "");
        HtmlReportUtil.mergeTemplateToDir(this.basePath, "style.css", context);
        HtmlReportUtil.mergeTemplateToDir(this.basePath, "roundedcorners.css", context);
        File outfile = new File(this.basePath, this.reportConfig.getMainFileName());
        context.put("historical", descriptor);
        CloverReportConfig firstCurrentConfig = this.reportConfig.getFirstCurrentConfig();
        if (firstCurrentConfig != null) {
            String relToCurrentRoot = FileUtils.getRelativePath(outfile.getParentFile(), firstCurrentConfig.getMainOutFile().getParentFile(), "/");
            relToCurrentRoot = "".equals(relToCurrentRoot) ? "" : relToCurrentRoot + "/";
            context.put("relToCurrentRoot", relToCurrentRoot);
            Format format = firstCurrentConfig.getFormat();
            if (format != null) {
                context.put("showSrc", format.getSrcLevel());
            }
        }
        context.put("hasmetrics", descriptor.getSubjectMetrics());
        context.put("endTimestamp", this.dateFormat.format(new Date(descriptor.getLastTimestamp())));
        if (descriptor.showMovers()) {
            context.put("allAdded", descriptor.getAddedDescriptors());
            context.put("allMovers", descriptor.getMoversDescriptors());
        }
        context.put("colSpan", new Integer(6));
        File imgDir = this.copyCommonImages();
        Historical historical = (Historical)this.reportConfig;
        List charts = historical.getCharts();
        SortedMap data = descriptor.getHistoricalModels();
        ArrayList<String> chartNames = new ArrayList<String>();
        HashMap<String, String> imageMaps = new HashMap<String, String>();
        for (int i = 0; i < charts.size(); ++i) {
            String chartName = "chart" + i + ".jpg";
            chartNames.add(chartName);
            Historical.Chart chart = (Historical.Chart)charts.get(i);
            JFreeChart jFreeChart = CloverChartFactory.createJFreeChart(chart, data);
            ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
            ChartUtilities.saveChartAsJPEG(new File(imgDir, chartName), 1.0f, jFreeChart, chart.getWidth(), chart.getHeight(), renderingInfo);
            String imageMap = ChartUtilities.getImageMap(chartName, renderingInfo);
            imageMaps.put(chartName, imageMap);
        }
        context.put("imageMaps", imageMaps);
        context.put("chartNames", chartNames);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/historical.vm");
        if (historical.isJson()) {
            JSONHistoricalReporter jsonReporter = new JSONHistoricalReporter(this.reportConfig.getOutFile());
            jsonReporter.generateHistoricalJSON(context, data, this.pageTitle);
        }
        Logger.getInstance().info("Done.");
    }

    private Current reportAsCurrent() {
        return (Current)this.reportConfig;
    }

    static Current processArgs(String[] args) {
        Current cfg = new Current();
        cfg.setFormat(Format.DEFAULT_HTML);
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") || args[i].equals("--outputdir")) {
                    cfg.setOutFile(new File(args[++i]));
                    cfg.setMainFileName("index.html");
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    cfg.setInitString(args[++i]);
                    continue;
                }
                if (args[i].equals("-t") || args[i].equals("--title")) {
                    cfg.setTitle(args[++i]);
                    continue;
                }
                if (args[i].equals("-e") || args[i].equals("--showempty")) {
                    cfg.getFormat().setShowEmpty(true);
                    continue;
                }
                if (args[i].equals("-a") || args[i].equals("--alwaysreport")) {
                    cfg.setAlwaysReport(true);
                    continue;
                }
                if (args[i].equals("-nu") || args[i].equals("--nounique")) continue;
                if (args[i].equals("-su") || args[i].equals("--showunique")) {
                    cfg.setShowUniqueCoverage(true);
                    continue;
                }
                if (args[i].equals("-h") || args[i].equals("--hidesrc")) {
                    cfg.getFormat().setSrcLevel(false);
                    continue;
                }
                if (args[i].equals("-bw")) {
                    cfg.getFormat().setBw(true);
                    continue;
                }
                if (args[i].equals("-b") || args[i].equals("--hidebars")) {
                    cfg.getFormat().setShowBars(false);
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--span")) {
                    ++i;
                    try {
                        cfg.setSpan(new Interval(args[i]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        HtmlReporter.usage("Invalid interval format. Should be integer followed by unit (s, m, h, d, w).");
                        return null;
                    }
                }
                if (args[i].equals("-c") || args[i].equals("--orderby")) {
                    cfg.getFormat().setOrderby(args[++i]);
                    continue;
                }
                if (args[i].equals("-n") || args[i].equals("--nocache")) {
                    cfg.getFormat().setNoCache(true);
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--debug")) {
                    Logger.setDebug(true);
                    continue;
                }
                if (args[i].equals("-v") || args[i].equals("--verbose")) {
                    Logger.setVerbose(true);
                    continue;
                }
                if (args[i].equals("-if") || args[i].equals("--includefailcoverage")) {
                    cfg.setIncludeFailedTestCoverage(true);
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("--sourcepath")) {
                    cfg.setSourcepath(new Path(args[++i]));
                    continue;
                }
                if (args[i].equals("-r") || args[i].equals("--resultsdir")) {
                    CloverUtils.logDeprecationWarning(args[i] + " argument");
                    continue;
                }
                if (args[i].equals("-f") || args[i].equals("--filter")) {
                    cfg.getFormat().setFilter(args[++i]);
                    continue;
                }
                if (args[i].equals("-tc") || args[i].equals("--threadcount")) {
                    ++i;
                    try {
                        int threadCount = Integer.parseInt(args[i]);
                        if (threadCount < 0) {
                            HtmlReporter.usage("Invalid thread count. Should be zero or a positive integer.");
                            return null;
                        }
                        cfg.setNumThreads(threadCount);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        HtmlReporter.usage("Invalid thread count. Should be an integer.");
                        return null;
                    }
                }
                if (!args[i].equals("-tw") && !args[i].equals("--tabwidth")) continue;
                ++i;
                try {
                    int tabwidth = Integer.parseInt(args[i]);
                    if (tabwidth >= 0 && tabwidth <= 10) {
                        cfg.getFormat().setTabWidth(tabwidth);
                        continue;
                    }
                    Logger.getInstance().warn("ignoring tab width value, out of range 0..10");
                    continue;
                }
                catch (NumberFormatException e) {
                    Logger.getInstance().warn("ignoring illegal tab width: " + e.getMessage());
                }
            }
            TestSelectionHelper.configureTestSelectionFilter(cfg, args);
            if (!cfg.validate()) {
                HtmlReporter.usage(cfg.getValidationFailureReason());
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            HtmlReporter.usage("Missing a parameter.");
            return null;
        }
        return cfg;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer().append("  USAGE: ");
        Class<?> clazz = class$com$cenqua$clover$reporters$html$HtmlReporter;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$reporters$html$HtmlReporter = new HtmlReporter[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" [OPTIONS] PARAMS\n\n").append("  PARAMS:\n").append("    -i, --initstring <string>\tclover initstring\n\n").append("    -o, --outputdir <dir>\toutput directory for generated html.\n\n").append("  OPTIONS:\n").append("    -t, --title <string>\treport title.\n\n").append("    -bw\t\t\t\tDon't colour syntax-hilight source - smaller html output.\n\n").append("    -e, --showempty\t\tshow classes/packages even if they don't have any\n").append("\t\t\t\tstatements, methods or conditionals. default is false\n\n").append("    -nu, --nounique\t\tDon't calculate or show unique per-test coverage (this may significantly speed up report generation time). default is to calculate and show unique coverage.\n\n").append("    -n, --nocache\t\tinsert no-cache browser directives in html output.\n\n").append("    -h, --hidesrc\t\tdon't render source code. default is false.\n\n").append("    -b, --hidebars\t\tdon't render coverage bars. default is false.\n\n").append("    -p, --sourcepath\t\tThe sourcepath that Clover should search on for source files.\n\n").append("    -r, --testresults <dir>\tdirectory in which to look for XML test results.\n\n").append("    -s, --span <interval>\tSpecifies how far back in time to\n").append("\t\t\t\tinclude coverage recordings from since the last Clover build. In Interval\n").append("\t\t\t\tformat. \"60s\" = 60 seconds, \"1h\" = 1 hour, \"1d\" = 1 day etc.\n\n").append("    -tw, --tabwidth <int>\tnumber of spaces a tab should be rendered as. default is 4.\n\n").append("    -tc, --threadcount <int>\tnumber of additional threads to be allocated to report generation. Default is 0.\n\n").append("    -d,  --debug \t\tswitch logging level to debug\n\n").append("    -v,  --verbose \t\tswitch logging level to verbose\n\n").append("    -a,  --alwaysreport\t\tgenerate report even if there is no coverage to report on\n\n").append("    -if, --includefailcoverage\tinclude coverage from failed tests. Default is false.\n\n").append("    -f,  --filter <string>\tcomma separated list of contexts to filter\n").append("\t\t\t\twhen generating coverage reports. Most useful one is \"catch\".\n").append("\t\t\t\tvalid values are \"static\",\"instance\",\"constructor\",\"method\",\"switch\",\n").append("\t\t\t\t\"while\",\"do\",\"for\",\"if\",\"else\",\"try\",\"catch\",\"finally\",\"sync\"\n\n").append("    -c,  --orderby <compname>\tcomparator to use when listing packages and classes.\n").append("\t\t\t\tvalid values are \"alpha\" - alphabetic, \"desc\" - coverage descending,\n").append("\t\t\t\t\"asc\" - coverage ascending. default is \"asc\".\n\n").toString());
        System.err.println(TestSelectionHelper.getParamsUsage());
    }

    public static void main(String[] args) {
        HtmlReporter.loadLicense();
        System.exit(HtmlReporter.runReport(args));
    }

    public static int runReport(String[] args) {
        Current cfg = HtmlReporter.processArgs(args);
        if (HtmlReporter.canProceedWithReporting(cfg)) {
            try {
                return new HtmlReporter(cfg).execute();
            }
            catch (Exception e) {
                Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
            }
        }
        return 1;
    }

    private VelocityContext insertCommonProps(VelocityContext context, String pkg) {
        context.put("rootRelPath", this.rederingHelper.getRootRelPath(pkg));
        context.put("pageTitle", this.pageTitle);
        String title = this.pageTitle != null ? this.pageTitle : "Clover";
        context.put("headerTitle", pkg.length() == 0 ? title : title + ": " + pkg);
        context.put("pageTitleIsLink", this.pageTitleAnchor != null && this.pageTitleAnchor.length() > 0);
        context.put("pageTitleAnchor", this.pageTitleAnchor);
        context.put("pageTitleTarget", this.pageTitleTarget);
        context.put("renderUtil", this.rederingHelper);
        context.put("startTimestamp", this.dateFormat.format(this.coverageTS));
        String cloverURL = "http://www.atlassian.com/software/clover";
        context.put("cloverURL", cloverURL);
        context.put("cloverReleaseNum", "3.1.11");
        context.put("reportTimestamp", this.reportTimeStamp);
        context.put("showEmpty", this.reportConfig.getFormat().getShowEmpty());
        context.put("showSrc", this.reportConfig.getFormat().getSrcLevel());
        context.put("showBars", this.reportConfig.getFormat().getShowBars());
        context.put("noCache", this.reportConfig.getFormat().getNoCache());
        context.put("expired", CloverLicenseInfo.EXPIRED);
        context.put("charset", this.reportConfig.getCharset());
        context.put("skipCoverageTreeMap", this.reportConfig.isSkipCoverageTreeMap());
        HtmlReporter.insertLicenseMessages(context);
        return context;
    }

    static void insertLicenseMessages(VelocityContext context) {
        String headerMsg = CloverLicenseInfo.OWNER_STMT + " ";
        String footerMsg = CloverLicenseInfo.OWNER_STMT + " ";
        if (CloverLicenseInfo.EXPIRED) {
            headerMsg = headerMsg + CloverLicenseInfo.POST_EXPIRY_STMT + " " + CloverLicenseInfo.CONTACT_INFO_STMT;
            footerMsg = footerMsg + CloverLicenseInfo.POST_EXPIRY_STMT;
        } else {
            headerMsg = headerMsg + CloverLicenseInfo.PRE_EXPIRY_STMT;
            footerMsg = footerMsg + CloverLicenseInfo.PRE_EXPIRY_STMT;
        }
        if (CloverLicenseInfo.EXPIRES && !CloverLicenseInfo.EXPIRED) {
            context.put("evalMsg", "This report was generated with an evaluation server license.  <a href=\"http://www.atlassian.com/software/clover\">Purchase Clover</a> or <a href=\"http://confluence.atlassian.com/x/JAgQCQ\">configure your license.</a>");
        }
        context.put("headerMsg", HtmlFormatter.format(headerMsg));
        context.put("footerMsg", HtmlFormatter.format(footerMsg));
    }

    private void renderProjectCoverageCloudPage(TreeInfo appCloudTree, CloverExecutor service) throws Exception {
        VelocityContext cloudsContext = new VelocityContext();
        this.insertCommonProps(cloudsContext, "");
        service.submit(new RenderProjectCoverageCloudsAction(cloudsContext, this.basePath, appCloudTree, this.getConfiguredModel()));
    }

    private void renderProjectTreeMapPage(CloverExecutor service) throws Exception {
        VelocityContext context = new VelocityContext();
        this.insertCommonProps(context, "");
        service.submit(new RenderTreeMapAction(this.getConfiguredModel(), this.basePath, context));
    }

    protected ProjectInfo getConfiguredModel() {
        return this.database.getAppOnlyModel();
    }

    protected ProjectInfo getFullModel() {
        return this.database.getFullModel();
    }

    protected ProjectInfo getTestModel() {
        return this.database.getTestOnlyModel();
    }

    private void renderDashboard(CloverExecutor queue, CloverChartFactory.ChartInfo histogram, CloverChartFactory.ChartInfo scatter) throws Exception {
        VelocityContext ctx = new VelocityContext();
        this.insertCommonProps(ctx, "");
        ProjectInfo configuredProject = this.getConfiguredModel();
        RenderDashboardAction action = new RenderDashboardAction(ctx, this.basePath, configuredProject, this.getFullModel(), histogram, scatter);
        queue.submit(action);
        File outfile = new File(this.reportAsCurrent().getOutFile(), "project.js");
        RenderMetricsJSONAction jsonAction = new RenderMetricsJSONAction(ctx, configuredProject, this.reportAsCurrent(), outfile, this.rederingHelper);
        queue.submit(jsonAction);
    }

    private File copyCommonImages() throws IOException {
        File imgDir = new File(this.basePath, "img");
        imgDir.mkdir();
        this.copyStaticResource("html_res", "img/logo.gif");
        this.copyStaticResource("html_res", "img/expand.gif");
        this.copyStaticResource("html_res", "img/collapse.gif");
        this.copyStaticResource("html_res", "img/icn_up.gif");
        this.copyStaticResource("html_res", "img/icn_down.gif");
        this.copyStaticResource("html_res", "img/back.gif");
        this.copyStaticResource("html_res", "img/more.gif");
        this.copyStaticResource("html_res", "img/more_dark.gif");
        this.copyStaticResource("html_res", "img/less.gif");
        this.copyStaticResource("html_res", "img/less_dark.gif");
        this.copyStaticResource("html_res", "img/test.gif");
        this.copyStaticResource("html_res", "img/cnrL_tl.gif");
        this.copyStaticResource("html_res", "img/cnrL_tr.gif");
        this.copyStaticResource("html_res", "img/spacer.gif");
        this.copyStaticResource("html_res", "img/tick.gif");
        this.copyStaticResource("html_res", "img/cloud.png");
        this.copyStaticResource("html_res", "img/treemap.gif");
        this.copyStaticResource("html_res", "img/ajax-loader.gif");
        this.copyStaticResource("html_res", "img/clover.ico");
        this.copyStaticResource("html_res", "img/failure_gutter.gif");
        this.copyStaticResource("html_res", "overlibmws.js");
        this.copyStaticResource("html_res", "overlibmws_shadow.js");
        this.copyStaticResource("html_res", "clover.js");
        this.copyStaticResource("html_res", "utils.js");
        this.copyStaticResource("html_res", "cloud.js");
        this.copyStaticResource("html_res", "help.js");
        this.copyStaticResource("html_res", "jit.js");
        return imgDir;
    }

    private void copyStaticResource(String aLoadPath, String aName) throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        File outfile = new File(this.basePath, aName);
        InputStream res = loader.getResourceAsStream(aLoadPath + "/" + aName);
        if (res == null) {
            throw new IOException("Resource not found: " + aLoadPath + "/" + aName);
        }
        BufferedInputStream in = new BufferedInputStream(res);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outfile));
        int b = ((InputStream)in).read();
        while (b >= 0) {
            ((OutputStream)out).write(b);
            b = ((InputStream)in).read();
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void processPackage(PackageInfo pkg, TreeInfo appSrcTree, TreeInfo appCloudTree, TreeInfo testSrcTree, CloverExecutor queue, Map charts) throws Exception {
        ProjectInfo projectInfo = this.getFullModel();
        Iterator it = pkg.getFiles().iterator();
        while (it.hasNext()) {
            FileInfo file = (FileInfo)it.next();
            this.renderSourceFilePage(queue, charts, projectInfo, file);
            this.renderTestPages(queue, file);
        }
        PackageInfo pkgAppInfo = (PackageInfo)this.getConfiguredModel().getNamedPackage(pkg.getName());
        PackageInfo pkgTestInfo = (PackageInfo)this.getTestModel().getNamedPackage(pkg.getName());
        List classes = pkgAppInfo != null ? pkgAppInfo.getClasses() : new LinkedList();
        List testClasses = pkgTestInfo != null ? pkgTestInfo.getClasses() : new LinkedList();
        this.renderPkgClassesPage("classes-summary.vm", pkg, classes, TAB_CLASSES, false);
        this.renderPkgClassesPage("classes-summary.vm", pkg, testClasses, TAB_TESTS, false);
        this.renderPkgClassesPage("classes-summary.vm", pkg, testClasses, TAB_RESULTS, true);
        if (pkgAppInfo != null) {
            this.renderPkgSummaryPage(pkgAppInfo, appSrcTree, pkgTestInfo != null, queue, true);
            this.renderPkgCloudPages(pkgAppInfo, appCloudTree, pkgTestInfo != null, queue);
        }
        if (pkgTestInfo != null) {
            this.renderPkgSummaryPage(pkgTestInfo, testSrcTree, pkgAppInfo != null, queue, false);
        }
        this.renderTestResultsPkgSummaryPages(pkg, testClasses);
    }

    private void renderSourceFilePage(CloverExecutor queue, Map charts, ProjectInfo projectInfo, FileInfo file) throws Exception {
        if (this.reportConfig.getFormat().getSrcLevel()) {
            queue.submit(new RenderFileAction(file, this.rederingHelper, this.reportAsCurrent(), this.insertCommonProps(new VelocityContext(), file.getContainingPackage().getName()), this.database, projectInfo, charts));
        }
    }

    private void renderTestPages(CloverExecutor queue, BaseFileInfo file) throws Exception {
        List classes = file.getClasses();
        Iterator clz = classes.iterator();
        while (clz.hasNext()) {
            ClassInfo aClass = (ClassInfo)clz.next();
            if (!aClass.isTestClass()) continue;
            Iterator<TestCaseInfo> tests = aClass.getTestCases().iterator();
            while (tests.hasNext()) {
                TestCaseInfo test = tests.next();
                VelocityContext context = new VelocityContext();
                this.insertCommonProps(context, file.getContainingPackage().getName());
                RenderTestResultAction testResultRenderer = new RenderTestResultAction(test, this.rederingHelper, (Current)this.reportConfig, this.getConfiguredModel(), context, this.getFullModel(), this.database);
                queue.submit(testResultRenderer);
            }
        }
    }

    private void gatherAggregatePackages(Map pkgs, PackageFragment frag) {
        pkgs.put(frag.getQualifiedName(), frag);
        PackageFragment[] kids = frag.getChildren();
        for (int i = 0; kids != null && i < kids.length; ++i) {
            PackageFragment kid = kids[i];
            this.gatherAggregatePackages(pkgs, kid);
        }
    }

    private void renderAggregatePkgPage(ProjectInfo model, TreeInfo tree, boolean linkToClouds) throws Exception {
        String filename = tree.getPathPrefix() + "agg-pkgs.html";
        File outfile = new File(this.basePath, filename);
        VelocityContext context = new VelocityContext();
        context.put("linkToClouds", linkToClouds);
        context.put("currentPageURL", filename);
        context.put("headerMetrics", model.getMetrics());
        context.put("headerMetricsRaw", model.getRawMetrics());
        HtmlReportUtil.addFilteredPercentageToContext(context, model);
        this.insertCommonProps(context, "");
        HashMap aggregatePkgs = new HashMap();
        PackageFragment[] roots = model.getPackageRoots();
        for (int i = 0; i < roots.length; ++i) {
            PackageFragment root = roots[i];
            this.gatherAggregatePackages(aggregatePkgs, root);
        }
        ArrayList kids = new ArrayList(aggregatePkgs.values());
        Collections.sort(kids, this.detailComparator);
        context.put("packageFragments", kids);
        context.put("tree", tree);
        HtmlReportUtil.addColumnsToContext(context, this.reportConfig.getColumns().getPkgColumns(), model, kids);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/agg-pkgs.vm");
    }

    private void renderBasePages() throws Exception {
        File outfile = new File(this.basePath, this.reportConfig.getMainFileName());
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", this.reportConfig.getMainFileName());
        this.insertCommonProps(context, "");
        context.put("homepage", this.getHomepageValue());
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/" + this.reportConfig.getMainFileName());
        HtmlReportUtil.mergeTemplateToDir(this.basePath, "style.css", context);
        HtmlReportUtil.mergeTemplateToDir(this.basePath, "roundedcorners.css", context);
        HtmlReportUtil.mergeTemplateToDir(this.basePath, "tree.css", context);
        this.copyStaticResource("html_res", "sorttable.js");
    }

    private String getHomepageValue() {
        String homepageKey = this.reportConfig.getHomepage() != null ? this.reportConfig.getHomepage() : HTML_HOMEPAGE_DEFAULT;
        return HTML_HOMEPAGE_VALUES.containsKey(homepageKey) ? HTML_HOMEPAGE_VALUES.get(homepageKey) : homepageKey;
    }

    private void renderTopLeftPanePage() throws Exception {
        File outfile = new File(this.basePath, "all-pkgs.html");
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", "all-pkgs.html");
        context.put("reportConfig", this.reportConfig);
        context.put("fileUtils", FileUtils.getInstance());
        List<? extends BasePackageInfo> packages = this.getConfiguredModel().getPackages();
        Collections.sort(packages, this.listComparator);
        this.insertCommonProps(context, "");
        context.put("packages", packages);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/all-pkgs.vm");
    }

    private void renderPackagesSummaryPage(String name, String templateName, VelocityContext context, ProjectInfo model, TreeInfo tree, boolean linkToClouds) throws Exception {
        String filename = tree.getPathPrefix() + name;
        File outfile = new File(this.basePath, filename);
        context.put("currentPageURL", filename);
        List<? extends BasePackageInfo> packages = model.getPackages();
        Collections.sort(packages, this.detailComparator);
        this.insertCommonProps(context, "");
        context.put("linkToClouds", linkToClouds);
        context.put("projectInfo", model);
        context.put("headerMetrics", model.getMetrics());
        context.put("headerMetricsRaw", model.getRawMetrics());
        HtmlReportUtil.addFilteredPercentageToContext(context, model);
        context.put("packages", packages);
        context.put("tree", tree);
        context.put("siblingPresent", Boolean.TRUE);
        HtmlReportUtil.addColumnsToContext(context, this.reportConfig.getColumns().getPkgColumns(), model, packages);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, templateName);
    }

    private void renderPackagesSummaryPage(ProjectInfo model, TreeInfo tree, boolean linkToClouds) throws Exception {
        this.renderPackagesSummaryPage("pkg-summary.html", "html_res/pkgs-summary.vm", new VelocityContext(), model, tree, linkToClouds);
    }

    private void renderTestResultsPkgsSummaryPage() throws Exception {
        File outfile = new File(this.basePath, "test-pkg-summary.html");
        VelocityContext context = new VelocityContext();
        ProjectInfo projectInfo = this.getFullModel().copy(new HasMetricsFilter(){

            public boolean accept(HasMetrics hm) {
                return !(hm instanceof BaseClassInfo) || ((BaseClassInfo)hm).isTestClass();
            }
        });
        List<? extends BasePackageInfo> packages = projectInfo.getPackages();
        Collections.sort(packages, TEST_SORT_ORDER);
        context.put("currentPageURL", outfile.getName());
        this.insertCommonProps(context, "");
        this.insertCommonTestProps(context, packages, "package", null, projectInfo, "test-pkg-summary.html", "Project", "Packages");
        context.put("topLevel", Boolean.TRUE);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/test-pkg-summary.vm");
    }

    private void renderPkgClassesPage(String outfileName, String templateName, PackageInfo pkg, List classes, VelocityContext context, String currentTabName, boolean isTests) throws Exception {
        File outdir = pkg != null ? CloverUtils.createOutDir(pkg, this.basePath) : this.basePath;
        Collections.sort(classes, this.listComparator);
        File outfile = new File(outdir, outfileName);
        context.put("currentPageURL", outfileName);
        String name = pkg != null ? pkg.getName() : "All Classes";
        this.insertCommonProps(context, name);
        context.put("packageInfo", pkg);
        context.put("classlist", classes);
        context.put("currentTabName", currentTabName);
        context.put("isTests", isTests);
        context.put("topLevel", pkg == null);
        context.put("title", TAB_CLASSES);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/" + templateName);
    }

    private void renderPkgClassesPage(String templateName, PackageInfo pkg, List classes, String currentTabName, boolean isTests) throws Exception {
        String outfileName = SUMMARY_TABS.get(currentTabName);
        VelocityContext context = new VelocityContext();
        context.put("tabs", SUMMARY_TABS);
        this.renderPkgClassesPage(outfileName, templateName, pkg, classes, context, currentTabName, isTests);
    }

    public static String renderHtmlBarTable(float pcCovered, int width, String customClass) throws Exception {
        return HtmlReporter.renderHtmlBarTable(pcCovered, width, customClass, "", "");
    }

    public static String renderHtmlBarTable(float pcCovered, int width, String customClass, String customBarPositive, String customBarNegative) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("empty", pcCovered < 0.0f);
        context.put("pccovered", new Float(pcCovered));
        context.put("sortValue", new Float(pcCovered));
        context.put("width", new Integer(width));
        context.put("customClass", customClass);
        context.put("customBarPositive", customBarPositive);
        context.put("customBarNegative", customBarNegative);
        context.put("renderUtil", new HtmlRenderingSupportImpl());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        HtmlReportUtil.getVelocityEngine().mergeTemplate("html_res/bar-graph.vm", "ASCII", context, out);
        out.close();
        return baos.toString();
    }

    private void renderPkgSummaryPage(PackageInfo pkg, TreeInfo tree, boolean siblingPagePresent, CloverExecutor queue, boolean linkToClouds) throws Exception {
        VelocityContext context = new VelocityContext();
        this.insertCommonProps(context, pkg.getName());
        queue.submit(new RenderPackageSummaryAction(context, this.basePath, this.reportConfig, pkg, this.detailComparator, tree, this.rederingHelper, siblingPagePresent, linkToClouds));
    }

    private void renderPkgCloudPages(PackageInfo pkg, TreeInfo tree, boolean siblingPagePresent, CloverExecutor queue) throws Exception {
        VelocityContext context = new VelocityContext();
        this.insertCommonProps(context, pkg.getName());
        queue.submit(new RenderPackageCoverageCloudAction(context, this.basePath, tree, pkg, siblingPagePresent));
    }

    private void renderTestResultsPkgSummaryPages(PackageInfo pkg, List classes) throws Exception {
        File outdir = CloverUtils.createOutDir(pkg, this.basePath);
        TestMethodFilter filter = new TestMethodFilter();
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            ClassInfo testClassInfo = classInfo.copy((FileInfo)classInfo.getContainingFile(), filter);
            this.renderTestClassSummaryPage(testClassInfo);
        }
        Collections.sort(classes, TEST_SORT_ORDER);
        File outfile = new File(outdir, "test-pkg-summary.html");
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", "test-pkg-summary.html");
        this.insertCommonProps(context, pkg.getName());
        this.insertCommonTestProps(context, classes, "class", pkg, pkg, "test-pkg-summary.html", "Package", "Test Classes");
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/test-pkg-summary.vm");
    }

    private void renderTestClassSummaryPage(ClassInfo classInfo) throws Exception {
        String outname = this.rederingHelper.getTestClassLink(false, classInfo);
        File outfile = CloverUtils.createOutFile((FileInfo)classInfo.getContainingFile(), outname, this.basePath);
        ArrayList<TestCaseInfo> tests = new ArrayList<TestCaseInfo>(classInfo.getTestCases());
        Collections.sort(tests, TEST_CASE_COMPARATOR);
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", outname);
        this.insertCommonProps(context, classInfo.getPackage().getName());
        context.put("projInfo", this.getFullModel());
        String link = this.rederingHelper.getTestClassLink(false, classInfo);
        this.insertCommonTestProps(context, tests, "test", classInfo.getPackage(), classInfo, link, "Class", TAB_TESTS);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "html_res/test-class-summary.vm");
    }

    private void insertCommonTestProps(VelocityContext context, List entities, String childEntityType, BasePackageInfo pkg, HasMetrics entity, String link, String title, String subtitle) {
        context.put("entities", entities);
        context.put("childEntityType", childEntityType);
        if (pkg != null) {
            context.put("packageName", pkg.getName());
        }
        context.put("entity", entity);
        context.put("entityLink", link);
        context.put("headerMetrics", entity.getMetrics());
        context.put("headerMetricsRaw", entity.getRawMetrics());
        HtmlReportUtil.addFilteredPercentageToContext(context, entity);
        context.put("topLevel", Boolean.FALSE);
        context.put("title", title);
        context.put("subtitle", subtitle);
        context.put("hasResults", this.getTestModel().hasTestResults());
        context.put("siblingPresent", pkg == null || this.getConfiguredModel().getNamedPackage(pkg.getName()) != null);
    }

    public static class TreeInfo {
        private String pathPrefix;
        private String name;

        public TreeInfo(String pathPrefix, String name) {
            this.pathPrefix = pathPrefix;
            this.name = name;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public String getName() {
            return this.name;
        }

        public String getLowercaseName() {
            return this.name.toLowerCase();
        }

        public String toString() {
            return this.getName();
        }
    }

    static class TestMethodFilter
    implements HasMetricsFilter {
        TestMethodFilter() {
        }

        public boolean accept(HasMetrics hm) {
            return !(hm instanceof MethodInfo) || ((MethodInfo)hm).isTest();
        }
    }
}

