/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.instr.InstrumentationLevel;
import com.atlassian.clover.instr.java.InstrumentationConfig;
import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.TestSourceSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntInstrumentationConfig
extends InstrumentationConfig {
    private final transient Project project;
    protected transient List<FileSet> instrFilesets = null;
    protected transient List<TestSourceSet> testSources = null;
    private transient PatternSet instrPattern;
    private boolean preserve;
    private String compilerDelegate;
    private static final String ANT_BUILD_JAVAC_SOURCE = "ant.build.javac.source";
    private File groverJar;
    private boolean skipGroverJar = false;

    public AntInstrumentationConfig(Project project) {
        this.project = project;
        this.setProjectName(project.getName());
        this.setDefaultBaseDir(project.getBaseDir());
        this.setInitstring(project.getProperty("clover.initstring"));
    }

    @Override
    protected String determineSourceLevel() {
        String srcLevel = this.project.getProperty(ANT_BUILD_JAVAC_SOURCE);
        if (srcLevel == null) {
            srcLevel = super.determineSourceLevel();
        } else {
            Logger.getInstance().verbose(new StringBuffer().append("Using source level of '").append(srcLevel).append("' as set in Ant property '").append(ANT_BUILD_JAVAC_SOURCE).append("'").toString());
        }
        return srcLevel;
    }

    @Override
    public String resolveInitString() {
        File initStringFile;
        File initParent;
        if (this.getInitString() == null) {
            AntInstrumentationConfig cfg = (AntInstrumentationConfig)this.project.getReference("clover.config");
            String initString = null;
            if (cfg != null) {
                initString = cfg.getInitString();
            }
            if (initString == null) {
                initString = this.project.getProperty("clover.initstring");
                if (initString == null) {
                    try {
                        this.createDefaultInitStringDir();
                    }
                    catch (CloverException e) {
                        throw new BuildException(new StringBuffer().append(e.getMessage()).append(" Please use the \"initstring\" attribute to specify a Clover database location.").toString());
                    }
                } else {
                    this.setInitstring(initString);
                }
            } else {
                this.setInitstring(initString);
            }
        }
        String resolvedInitString = this.getInitString();
        if (this.project != null && (initParent = (initStringFile = this.project.resolveFile(this.getInitString())).getParentFile()) != null && initParent.exists()) {
            resolvedInitString = initStringFile.getAbsolutePath();
        }
        return resolvedInitString;
    }

    public boolean isPreserve() {
        return this.preserve;
    }

    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    public String getCompilerDelegate() {
        return this.compilerDelegate;
    }

    public void setCompilerDelegate(String compilerDelegate) {
        this.compilerDelegate = compilerDelegate;
    }

    public static AntInstrumentationConfig getFrom(Project project) {
        return (AntInstrumentationConfig)project.getReference("clover.config");
    }

    public void setIn(Project project) {
        project.addReference("clover.config", (Object)this);
    }

    public void addConfiguredFileSet(FileSet set) {
        if (this.instrFilesets == null) {
            this.instrFilesets = new ArrayList<FileSet>();
        }
        this.instrFilesets.add(set);
    }

    public void addConfiguredTestSources(TestSourceSet testSourceSet) {
        if (this.testSources == null) {
            this.testSources = new ArrayList<TestSourceSet>();
        }
        testSourceSet.validate();
        this.testSources.add(testSourceSet);
    }

    public List<FileSet> getInstrFilesets() {
        return this.instrFilesets;
    }

    public List<TestSourceSet> getTestSources() {
        return this.testSources;
    }

    public void setInstrPattern(PatternSet filesPattern) {
        this.instrPattern = filesPattern;
    }

    public PatternSet getInstrPattern() {
        return this.instrPattern;
    }

    public void setGroverJar(File groverJar) {
        this.groverJar = groverJar;
    }

    public File getGroverJar() {
        return this.groverJar;
    }

    public void setSkipGroverJar(boolean skip) {
        this.skipGroverJar = skip;
    }

    public boolean isSkipGroverJar() {
        return this.skipGroverJar;
    }

    public void configureIncludedFiles() {
        if (this.instrFilesets != null) {
            HashSet<File> includedFiles = new HashSet<File>();
            for (FileSet fileset : this.instrFilesets) {
                String[] included = fileset.getDirectoryScanner(this.project).getIncludedFiles();
                for (int i = 0; i < included.length; ++i) {
                    String path = included[i];
                    includedFiles.add(new File(fileset.getDir(this.project), path));
                }
            }
            this.setIncludedFiles(includedFiles);
        }
    }

    public static class EnumInstrumentationLevel
    extends EnumeratedAttribute {
        public String[] getValues() {
            InstrumentationLevel[] levels = InstrumentationLevel.values();
            String[] values = new String[levels.length];
            for (int i = 0; i < levels.length; ++i) {
                values[i] = levels[i].name().toLowerCase();
            }
            return values;
        }
    }

    public static class Instrumentation
    extends EnumeratedAttribute {
        public String[] getValues() {
            return InstrumentationConfig.INSTR_VALUES;
        }
    }

    public static class FlushPolicy
    extends EnumeratedAttribute {
        public String[] getValues() {
            return InstrumentationConfig.FLUSH_VALUES;
        }
    }
}

