/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.test.optimization;

import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.atlassian.clover.util.Color;
import com.atlassian.clover.util.Formatting;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OptimizationSession {
    private OptimizationOptions optimizationOptions;
    private long savingsInMs;
    private long totalTimeInMs;
    private int originalTestableCount;
    private int optimizedTestableCount;
    private int foundTestableCount;
    private boolean autoSummarize;
    private final Set<String> modifiedFiles = new HashSet<String>();
    private boolean triedToOptimize;

    public OptimizationSession(OptimizationOptions optimizationOptions, boolean autoSummarize) {
        this.optimizationOptions = optimizationOptions;
        this.autoSummarize = autoSummarize;
    }

    public OptimizationSession(OptimizationOptions options) {
        this(options, true);
    }

    void incTotalTime(long inMs) {
        this.totalTimeInMs += inMs;
    }

    void incSavings(long inMs) {
        this.savingsInMs += inMs;
    }

    void incFoundOptimizableCount(int i) {
        ++this.foundTestableCount;
    }

    void incOriginalOptimizableCount(int count) {
        this.originalTestableCount += count;
    }

    void incOptimizedOptimizableCount(int count) {
        this.optimizedTestableCount += count;
    }

    void addModifiedPath(String path) {
        this.modifiedFiles.add(path);
    }

    public Set getOptimizedPaths() {
        return Collections.unmodifiableSet(this.modifiedFiles);
    }

    void afterOptimizaion(boolean triedToOptimize) {
        this.triedToOptimize |= triedToOptimize;
        if (this.autoSummarize) {
            this.summarize();
        }
    }

    public void summarize() {
        if (this.savingsInMs <= 0L) {
            Logger.getInstance().info("Clover " + (this.autoSummarize ? "was" : "is") + " unable to save any time on this optimized test run.");
        } else {
            Logger.getInstance().info(Color.make("Clover estimates " + (this.autoSummarize ? "having saved" : "saving") + " around " + new Interval(Math.max(1000L, this.savingsInMs) / 1000L, 0).toSensibleString() + " on this optimized test run. ").b().green() + this.fullTestRunMsg());
        }
        String pluralTestKind = Formatting.pluralizedWord(2, this.optimizationOptions.getOptimizableName());
        Logger.getInstance().info("Clover " + (this.autoSummarize ? "included " : "is including ") + Color.make(this.optimizedTestableCount + " test " + Formatting.pluralizedWord(this.optimizedTestableCount, this.optimizationOptions.getOptimizableName())).b() + " in this run (total # test " + pluralTestKind + " : " + this.originalTestableCount + ")");
        Logger.getInstance().verbose("Clover matched " + this.foundTestableCount + " of your " + this.originalTestableCount + " test " + pluralTestKind + " with those in the snapshot (optimization heuristic was applied to them)." + (this.foundTestableCount < this.originalTestableCount ? " Unmatched " + pluralTestKind + " either means Clover has a bug, your build is misconfigured for test optimization or you have not instrumented your test source with Clover." : ""));
    }

    private String fullTestRunMsg() {
        String fulltestRunMsg = "The full test run takes approx. " + new Interval(Math.max(1000L, this.totalTimeInMs) / 1000L, 0).toSensibleString();
        return fulltestRunMsg;
    }

    public String getPlainSummary() {
        StringBuffer sb = new StringBuffer();
        String pluralTestKind = Formatting.pluralizedWord(2, this.optimizationOptions.getOptimizableName());
        sb.append("Clover " + (this.autoSummarize ? "included " : "is including ") + this.optimizedTestableCount + " test " + Formatting.pluralizedWord(this.optimizedTestableCount, this.optimizationOptions.getOptimizableName()) + " in this run (total # test " + pluralTestKind + " : " + this.originalTestableCount + ")");
        sb.append('\n');
        if (this.foundTestableCount < this.originalTestableCount) {
            sb.append("Clover matched " + this.foundTestableCount + " of your " + this.originalTestableCount + " test " + pluralTestKind + " with those registered during previous test runs (optimization heuristic was applied to them).\n" + " Unmatched " + pluralTestKind + " may mean your build is misconfigured for test optimization or you have not instrumented your test source with Clover.");
        }
        return sb.toString();
    }

    public OptimizationOptions getOptimizationOptions() {
        return this.optimizationOptions;
    }

    public long getSavingsInMs() {
        return this.savingsInMs;
    }

    public int getOriginalTestableCount() {
        return this.originalTestableCount;
    }

    public int getOptimizedTestableCount() {
        return this.optimizedTestableCount;
    }

    public int getFoundTestableCount() {
        return this.foundTestableCount;
    }

    public boolean isAutoSummarize() {
        return this.autoSummarize;
    }
}

