/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import com.atlassian.clover.api.registry.SourceInfo;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.Logger;
import com.cenqua.clover.RecorderLogging;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class RegistryDumper {
    private static int indent;
    static /* synthetic */ Class class$com$cenqua$clover$util$RegistryDumper;

    public static void main(String[] args) throws Exception {
        RecorderLogging.init();
        if (args.length != 3) {
            RegistryDumper.printUsage();
        } else {
            CloverDatabase db = CloverDatabase.loadWithCoverage(args[2], new CoverageDataSpec(new Interval(args[1]).getValueInMillis()));
            if (args[0].equalsIgnoreCase("pretty")) {
                RegistryDumper.printPretty(db, false);
            } else if (args[0].equalsIgnoreCase("prettyfull")) {
                RegistryDumper.printPretty(db, true);
            } else if (args[0].equalsIgnoreCase("csv")) {
                RegistryDumper.printCSV(db);
            } else {
                System.err.println("Unknown format");
            }
        }
    }

    private static void printUsage() {
        System.err.println("Usage:");
        StringBuffer stringBuffer = new StringBuffer().append("java ");
        Class<?> clazz = class$com$cenqua$clover$util$RegistryDumper;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$util$RegistryDumper = new RegistryDumper[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" pretty|prettyfull|csv span database").toString());
    }

    private static void printPretty(CloverDatabase db, final boolean full) {
        Clover2Registry reg = db.getRegistry();
        Logger.getInstance().info("Loaded registry at " + reg.getRegistryFile());
        Logger.getInstance().info("Init String: " + reg.getInitstring());
        Logger.getInstance().info("Version: " + reg.getVersion());
        Logger.getInstance().info("Coverage Data Length: " + reg.getDataLength());
        Logger.getInstance().info("Instrumentation History:");
        Iterator i$ = reg.getInstrHistory().iterator();
        while (i$.hasNext()) {
            Object o = i$.next();
            Logger.getInstance().info(o.toString());
        }
        reg.getProject().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                Logger.getInstance().info("File " + file.getPackagePath());
                indent++;
                Logger.getInstance().info(RegistryDumper.indent("Encoding: " + file.getEncoding()));
                Logger.getInstance().info(RegistryDumper.indent("Checksum: " + file.getChecksum()));
                Logger.getInstance().info(RegistryDumper.indent("File Size: " + file.getFilesize()));
                Logger.getInstance().info(RegistryDumper.indent("Line Count: " + file.getLineCount()));
                Logger.getInstance().info(RegistryDumper.indent("NC Line Count: " + file.getNcLineCount()));
                Logger.getInstance().info(RegistryDumper.indent("Timestamp: " + DateFormat.getDateTimeInstance().format(new Long(file.getTimestamp()))));
                Logger.getInstance().info(RegistryDumper.indent("Slot Index: " + ((FileInfo)file).getDataIndex()));
                Logger.getInstance().info(RegistryDumper.indent("Slot Length: " + ((FileInfo)file).getDataLength()));
                Logger.getInstance().info(RegistryDumper.indent("Class count: " + RegistryDumper.classCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Method count: " + RegistryDumper.methodCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Test count: " + RegistryDumper.testCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Statement count: " + RegistryDumper.statementCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Branch count: " + RegistryDumper.branchCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Max version supported: " + ((FileInfo)file).getMaxVersion()));
                Logger.getInstance().info(RegistryDumper.indent("Min version supported: " + ((FileInfo)file).getMinVersion()));
                Logger.getInstance().info(RegistryDumper.indent("Classes:"));
                indent++;
                Iterator i$ = file.getClasses().iterator();
                while (i$.hasNext()) {
                    ClassInfo classInfo = (ClassInfo)i$.next();
                    Logger.getInstance().info(RegistryDumper.indent("Class " + classInfo.getQualifiedName()));
                    Logger.getInstance().info(RegistryDumper.indent("Statement count: " + RegistryDumper.statementCount(classInfo)));
                    Logger.getInstance().info(RegistryDumper.indent("Branch count: " + RegistryDumper.branchCount(classInfo)));
                    indent++;
                    Iterator<MethodInfo> i$2 = classInfo.getMethods().iterator();
                    while (i$2.hasNext()) {
                        final MethodInfo methodInfo = i$2.next();
                        if (full) {
                            TestCaseInfo testCase;
                            Logger.getInstance().info(RegistryDumper.indent(methodInfo.getName()));
                            indent++;
                            Logger.getInstance().info(RegistryDumper.indent(methodInfo.toString()));
                            if (methodInfo.isTest() && (testCase = classInfo.getTestCase(methodInfo.getQualifiedName())) != null) {
                                Logger.getInstance().info(RegistryDumper.indent(RegistryDumper.indent(testCase.toString())));
                            }
                            Logger.getInstance().info(RegistryDumper.indent("Statement count: " + methodInfo.getStatements().length));
                            Logger.getInstance().info(RegistryDumper.indent("Branch count: " + methodInfo.getBranches().length));
                            ArrayList<SourceInfo> stmtsAndBranches = new ArrayList<SourceInfo>(){
                                {
                                    this.addAll(Arrays.asList(methodInfo.getBranches()));
                                    this.addAll(Arrays.asList(methodInfo.getStatements()));
                                }
                            };
                            Collections.sort(stmtsAndBranches, new Comparator<SourceInfo>(){

                                @Override
                                public int compare(SourceInfo o1, SourceInfo o2) {
                                    int startLine1 = o1.getStartLine();
                                    int startCol1 = o1.getStartColumn();
                                    int startLine2 = o2.getStartLine();
                                    int startCol2 = o2.getStartColumn();
                                    if (startLine1 < startLine2) {
                                        return -1;
                                    }
                                    if (startLine1 > startLine2) {
                                        return 1;
                                    }
                                    if (startCol1 < startCol2) {
                                        return -1;
                                    }
                                    if (startCol1 > startCol2) {
                                        return 1;
                                    }
                                    return 0;
                                }

                                @Override
                                public /* synthetic */ int compare(Object x0, Object x1) {
                                    return this.compare((SourceInfo)x0, (SourceInfo)x1);
                                }
                            });
                            indent++;
                            Iterator i$3 = stmtsAndBranches.iterator();
                            while (i$3.hasNext()) {
                                SourceInfo stmtOrBranch = (SourceInfo)i$3.next();
                                Logger.getInstance().info(RegistryDumper.indent(stmtOrBranch.toString()));
                            }
                            indent--;
                        } else {
                            Logger.getInstance().info(RegistryDumper.indent(methodInfo.toString()));
                        }
                        indent--;
                    }
                    indent--;
                }
                indent--;
                indent--;
            }
        });
    }

    private static int methodCount(FileInfo fileInfo) {
        int methodCount = 0;
        Iterator iterator = fileInfo.getClasses().iterator();
        while (iterator.hasNext()) {
            methodCount += ((ClassInfo)iterator.next()).getMethods().size();
        }
        return methodCount;
    }

    private static int testCount(FileInfo fileInfo) {
        int testCount = 0;
        Iterator iterator = fileInfo.getClasses().iterator();
        while (iterator.hasNext()) {
            testCount += ((ClassInfo)iterator.next()).getTestCases().size();
        }
        return testCount;
    }

    private static int classCount(FileInfo fileInfo) {
        return fileInfo.getClasses().size();
    }

    private static int statementCount(FileInfo fileInfo) {
        int statementCount = 0;
        Iterator iterator = fileInfo.getClasses().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            statementCount += RegistryDumper.statementCount(classInfo);
        }
        return statementCount;
    }

    private static int statementCount(ClassInfo classInfo) {
        int statementCount = 0;
        Iterator<MethodInfo> i$ = classInfo.getMethods().iterator();
        while (i$.hasNext()) {
            MethodInfo methodInfo = i$.next();
            statementCount += methodInfo.getStatements().length;
        }
        return statementCount;
    }

    private static int branchCount(FileInfo fileInfo) {
        int branchCount = 0;
        Iterator iterator = fileInfo.getClasses().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            branchCount += RegistryDumper.branchCount(classInfo);
        }
        return branchCount;
    }

    private static int branchCount(ClassInfo classInfo) {
        int branchCount = 0;
        Iterator<MethodInfo> i$ = classInfo.getMethods().iterator();
        while (i$.hasNext()) {
            MethodInfo methodInfo = i$.next();
            branchCount += methodInfo.getBranches().length;
        }
        return branchCount;
    }

    private static String indent(String line) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        return line;
    }

    public static void printCSV(CloverDatabase db) {
        Clover2Registry reg = db.getRegistry();
        Logger.getInstance().info("Init String,Version,Coverage Data Length");
        Logger.getInstance().info(reg.getInitstring() + "," + reg.getVersion() + "," + Integer.toString(reg.getDataLength()) + "\n");
        Logger.getInstance().info("File,Encoding,Checksum,File Size,Line Count,NC Line Count,Timestamp,Slot Index,Slot Length,Class Count, Method Count, Statement Count,Branch Count");
        reg.getProject().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                Logger.getInstance().info(file.getPackagePath() + "," + file.getEncoding() + "," + file.getChecksum() + "," + file.getFilesize() + "," + file.getLineCount() + "," + file.getNcLineCount() + "," + DateFormat.getDateTimeInstance().format(new Long(file.getTimestamp())) + "," + ((FileInfo)file).getDataIndex() + "," + Integer.toString(((FileInfo)file).getDataLength()) + "," + Integer.toString(RegistryDumper.classCount((FileInfo)file)) + "," + Integer.toString(RegistryDumper.methodCount((FileInfo)file)) + "," + Integer.toString(RegistryDumper.statementCount((FileInfo)file)) + "," + Integer.toString(RegistryDumper.branchCount((FileInfo)file)) + ",");
            }
        });
    }
}

