/*
 * Decompiled with CFR 0.152.
 */
package jnacontrib.x11.demos;

import com.sun.jna.NativeLong;
import com.sun.jna.platform.unix.X11;
import com.sun.jna.ptr.IntByReference;
import jnacontrib.x11.api.X;

public class XTestDemo {
    private static final long DELAY = 20L;
    private X.Display display = new X.Display();

    public static void main(String[] args) throws InterruptedException {
        new XTestDemo();
    }

    public XTestDemo() throws InterruptedException {
        IntByReference event_basep = new IntByReference();
        IntByReference error_basep = new IntByReference();
        IntByReference majorp = new IntByReference();
        IntByReference minorp = new IntByReference();
        if (X11.XTest.INSTANCE.XTestQueryExtension(this.display.getX11Display(), event_basep, error_basep, majorp, minorp)) {
            System.out.println("event_basep.getValue() = " + event_basep.getValue());
            System.out.println("error_basep.getValue() = " + error_basep.getValue());
            System.out.println("majorp.getValue() = " + majorp.getValue());
            System.out.println("minorp.getValue() = " + minorp.getValue());
        }
        Thread.sleep(1000L);
        this.type("hello world");
        Thread.sleep(1000L);
    }

    private void type(String text) {
        block3: for (int i = 0; i < text.length(); ++i) {
            char myChar = text.charAt(i);
            switch (myChar) {
                case ' ': {
                    this.typeKey(65);
                    continue block3;
                }
                default: {
                    this.typeKey("" + myChar);
                }
            }
        }
    }

    private void typeKey(String keyName) {
        X11.KeySym keysym = X11.INSTANCE.XStringToKeysym(keyName);
        this.typeKey(X11.INSTANCE.XKeysymToKeycode(this.display.getX11Display(), keysym));
    }

    private void typeKey(int keyCode) {
        if (keyCode == -1) {
            return;
        }
        X11.XTest.INSTANCE.XTestFakeKeyEvent(this.display.getX11Display(), keyCode, true, new NativeLong(20L));
        X11.INSTANCE.XFlush(this.display.getX11Display());
        X11.XTest.INSTANCE.XTestFakeKeyEvent(this.display.getX11Display(), keyCode, false, new NativeLong(20L));
        X11.INSTANCE.XFlush(this.display.getX11Display());
    }
}

