/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class CastToList
extends UnaryExpression {
    private ListType targetType;
    private boolean allowEmpty;

    public CastToList(Expression source, ListType targetType, boolean allowEmpty) {
        super(source);
        this.targetType = targetType;
        this.allowEmpty = allowEmpty;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public ListType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        boolean maybeUntyped;
        this.getOperand().typeCheck(visitor, contextInfo);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.STRING, this.allowEmpty ? 24576 : 16384);
        RoleDiagnostic role = new RoleDiagnostic(2, "cast as", 0);
        Expression operand = visitor.getConfiguration().getTypeChecker(false).staticTypeCheck(this.getBaseExpression(), atomicType, role, visitor);
        this.setBaseExpression(operand);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        boolean maybeString = th.relationship(operand.getItemType(), BuiltInAtomicType.STRING) != 4;
        boolean bl = maybeUntyped = th.relationship(operand.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
        if (!maybeString && !maybeUntyped) {
            XPathException err = new XPathException("Casting to list requires an xs:string or xs:untypedAtomic operand");
            err.setErrorCode("XPTY0004");
            err.setLocation(this.getLocation());
            err.setIsTypeError(true);
            throw err;
        }
        if (operand instanceof Literal) {
            GroundedValue<?> literalOperand = ((Literal)operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                try {
                    SequenceIterator<?> seq = this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext());
                    return Literal.makeLiteral(seq.materialize(), this);
                }
                catch (XPathException err) {
                    err.maybeSetErrorCode("FORG0001");
                    err.setLocation(this.getLocation());
                    err.setIsTypeError(true);
                    throw err;
                }
            }
            if (literalOperand.getLength() == 0) {
                if (this.allowEmpty) {
                    return operand;
                }
                XPathException err = new XPathException("Cast can never succeed: the operand must not be an empty sequence");
                err.setErrorCode("XPTY0004");
                err.setLocation(this.getLocation());
                err.setIsTypeError(true);
                throw err;
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.optimize(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        if (!Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
            this.allowEmpty = false;
            this.resetLocalStaticProperties();
        }
        return this;
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public int getIntrinsicDependencies() {
        return this.getTargetType().isNamespaceSensitive() ? 2048 : 0;
    }

    @Override
    public ItemType getItemType() {
        try {
            if (this.targetType.getItemType() instanceof ItemType) {
                return (ItemType)((Object)this.targetType.getItemType());
            }
        }
        catch (MissingComponentException missingComponentException) {
            // empty catch block
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return UType.ANY_ATOMIC;
    }

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x800000;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        CastToList c = new CastToList(this.getBaseExpression().copy(rebindings), this.targetType, this.allowEmpty);
        ExpressionTool.copyLocationInfo(this, c);
        c.setRetainedStaticContext(this.getRetainedStaticContext());
        return c;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.getBaseExpression().evaluateItem(context);
        if (value == null) {
            if (this.allowEmpty) {
                return EmptyIterator.emptyIterator();
            }
            XPathException e = new XPathException("Cast does not allow an empty sequence");
            e.setXPathContext(context);
            e.setLocation(this.getLocation());
            e.setErrorCode("XPTY0004");
            throw e;
        }
        return CastToList.cast(value.getStringValueCS(), this.targetType, this.getRetainedStaticContext(), context.getConfiguration().getConversionRules()).iterate();
    }

    public static AtomicSequence cast(CharSequence value, ListType targetType, NamespaceResolver nsResolver, ConversionRules rules) throws XPathException {
        ValidationFailure failure = targetType.validateContent(value, nsResolver, rules);
        if (failure != null) {
            throw failure.makeException();
        }
        return targetType.getTypedValue(value, nsResolver, rules);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof CastToList && this.targetType == ((CastToList)other).targetType && this.allowEmpty == ((CastToList)other).allowEmpty && ExpressionTool.equalOrNull(this.getRetainedStaticContext(), ((CastToList)other).getRetainedStaticContext());
    }

    @Override
    public int computeHashCode() {
        return super.computeHashCode() ^ this.targetType.hashCode();
    }

    @Override
    public String getExpressionName() {
        return "castToList";
    }

    @Override
    public String toString() {
        return this.targetType.getEQName() + "(" + this.getBaseExpression().toString() + ")";
    }

    @Override
    public String toShortString() {
        return this.targetType.getDisplayName() + "(" + this.getBaseExpression().toShortString() + ")";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("castToList", this);
        out.emitAttribute("as", this.targetType.toString());
        this.getBaseExpression().export(out);
        out.endElement();
    }
}

