.TH KP 1
.SH NAME
kp \- Keyboard Practicer for the X Window System
.SH SYNOPSIS
.B kp
.nh
[\fItoolkitoption\fP ...]
[{-,+}{\fIshowkeytop\fP,\fIkt\fP}]
[{-,+}{\fIshownextkey\fP,\fInk\fP}]
[{-,+}{\fIignorecases\fP,\fIic\fP}]
[-\fIdvorak\fP] [-\fIqwerty\fP]
[-\fIphysical \fP{\fIdvorak\fP,\fIqwerty\fP}]
[-\fIvendor \fP{\fISun\fP,\fIHP\fP,\fIDEC\fP,\fIPC\fP,\fIKinesis\fP}]
[file]
.hy
.SH DESCRIPTION
.I Kp
is a program which runs under the X window system. It is intended to
be used to practice touch-typing.

Note: this man page is taken from the previous version of the program, 
written to use the Motif library.  The current version, using Tcl/Tk,
is \fBnot\fP complete in any stretch of the definition of the word.
This man page is here just to give you a raw idea on how \fIkp\fP will 
look like in the futere.

This program is designed to make it easy for the user to get used to
keyboards.  The program window consists of two panes---the \fIpractice
text\fP and the \fIvirtual keyboard\fP.  The cursor moves on the
practice text as the user hits the key.  The virtual keyboard usually
shows which key the user has just hit and what the user should type
next.

The main difficulty of touch-typing is to ``forget'' about the
physical keyboard---as long as you watch the keytops, you won't master
touch-typing.  Using \fIkp\fP, the user can focus on the screen and
forget about the keytop symbols on the real keyboard.

In addition, \fIkp\fP has two useful features---\fIvirtual Dvorak
support\fP and \fIfiltering\fP.  Dvorak is an alternative keyboard
layout to the conventional Qwerty, and there are enthusiastic
supporters (the author being one) all over the world.  \fIKp\fP lets
you practice Dvorak while using Qwerty on other windows.  The virtual
keyboard aids the user to ``feel'' the Dvorak keyboard, without having
to look up her typing textbook's back cover.

\fIKp\fP allows you to ``filter'' the words in the practice text,
i.e., select only words that contain certain letters.  Thus, the user
can start from the keys she is most familiar with and incrementally
extend the keyset until she masters the full keyboard.  This is
particularly useful for Dvorak keyboards, since the middle row
contains the most frequently used keys and the user can learn very
quickly and easily by starting from the middle row. 

\fIKp\fP has a user-friendly menu-oriented interface to change
configurations and select practice text files.  A good practice text
is your favorite manual page (use the one in the cat? directories, not
the nroff source in man?), and \fIkp\fP will remove the underscores
and doublestrikes for your convenience.

\fIKp\fP tries to guess what your keyboard looks like by looking up
the keycode/keysym translation table.  It currently knows about PC, HP,
Sun and DEC keyboards, Qwerty or Dvorak.  When it doesn't understand
what keyboard it's looking at, it assumes a Sun keyboard.  However, it
doesn't really need this information except for the layout of special
symbols.  I'll probably drop this support in the next release
(it's not very likely that what people want to practice
with \fIkp\fP are special symbols).

In addition, there are some xmodmap files that you can use to remap
your keyboard to Dvorak in the xmodmaps/ subdirectory of the source
distribution.  They come with Qwerty counterparts but they are not
very well tested (I don't use Qwerty!) so use them with care.

.SH OPTIONS
In addition to specifying the practice file (which can be any ASCII
file) from the command line, and all standard \fIX toolkit\fR options,
\fIkp\fR supports the following command line options.  If the option
begins with a `\fB+\fR' instead of a `\fB\-\fR', think it as appending
a ``do not'' in front of the name of the option.  (I know this is very
strange considering the mathematical meanings of the two symbols but
that's the way they are in Unix.)

The options can also be set via the resource names given in
parentheses in the description of each option, and also can be changed
when the program is running via the \fIOptions\fP menu.

.TP
.B \-showkeytop/kt
(.showKeyTop)
Show all the keytop symbols on the virtual keyboard.  When turned off,
only show the key most recently typed, and the next key, if
-shownextkey (see below) is specified.
.TP
.B \-shownextkey/nk
(.showNextKey)
Show the next key to type in reverse video.
.TP
.B \-ignorecases/ic
(.ignoreCases)
Do not care whether a letter is lowercase or uppercase.  When this
option is turned on, the program will ignore cases almost everywhere,
not only when you type practice text---it doesn't reverse the shift
key when displaying the next key to type, collect words with both
uppercase and lowercase versions for filtering, etc.
.TP
.B \-dvorak/qwerty
(.keyboard)
Selects the virtual keyboard.  When specifying via resources, "true"
denotes Dvorak (no flames for this please).
.TP
.B \-physical \fIkeyboardtype\fP
(.physicalKeyboard)
Overrides the keyboard type detection routine of \fIkp\fP.  Valid
arguments are "dvorak" and "qwerty".
.TP
.B \-vendor \fIvendorname\fP
(.vendor)
Overrides the vendor detection routine of \fIkp\fP.  Valid arguments
are "Sun", "HP", "DEC", "PC" and "Kinesis".  Note that Kinesis
keyboards are never detected automatically, since there is no way the
software can distinguish between them and ordinary PC keyboards.

.SH MENUS
Most menu entries should be self-explanatory (that's what menus are
for).  The only (possibly) item that is not clear is the \fIFilter\fP
entry of the Options menu.  If you pull the menu further to the right
and select the \fIFilter\fP entry, \fIkp\fP will produce a dialog
popup in which you can type in characters that you want to proctice.

\fIKp\fP will then display only the words that consist entirely from
those characters.  (Note that case significance is an issue here; if
you are in ``case insensitive'' mode, both uppercase and lowercase
versions of the letter is used, but if you are in ``case sensitive''
mode, only the characters that match exactly to your string are used.

\fIUnfilter\fP will negate the effects of the filter.  Note that
\fIkp\fP won't forget the the characters of choice so that you can use
them again.

.SH ENVIRONMENT
Starting from ``DISPLAY'', \fIkp\fP understands standard X environment
variables.  It has no special variable for itself.

.SH "SEE ALSO"
X(1).

.SH AUTHOR
Satoshi Asami of the Computer Science Division, Department of
Electrical Engineering and Computer Sciences, University of
California, Berkeley.  He wrote this program for his term project in
a user interfaces course.
