/**
 * ===========================================
 * LibLayout : a free Java layouting library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/liblayout/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * $Id: TableRowRenderBox.java 3524 2007-10-16 11:26:31Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;

/**
 * A table section box does not much rendering or layouting at all. It
 * represents one of the three possible sections and behaves like any other
 * block box. But (here it comes!) it refuses to be added to anything else than
 * a TableRenderBox (a small check to save me a lot of insanity ..).
 * <p/>
 * For a valid layout, the major and minor axes need to be flipped.
 *
 * @author Thomas Morgner
 */
public class TableRowRenderBox extends BlockRenderBox
{
  private boolean autoGenerated;
  private TableRowInfoStructure infoStructure;

  public TableRowRenderBox(final BoxDefinition boxDefinition,
                           final boolean autoGenerated)
  {
    super(boxDefinition);
    this.autoGenerated = autoGenerated;
    this.infoStructure = new TableRowInfoStructure();

    /** Cells are laid out from left to right. */
    setMajorAxis(HORIZONTAL_AXIS);
    setMinorAxis(VERTICAL_AXIS);
  }

  public TableRowInfoStructure getRowInfoStructure()
  {
    return infoStructure;
  }

  /**
   * If that method returns true, the element will not be used for rendering.
   * For the purpose of computing sizes or performing the layouting (in the
   * validate() step), this element will treated as if it is not there.
   * <p/>
   * If the element reports itself as non-empty, however, it will affect the
   * margin computation.
   *
   * @return
   */
  public boolean isIgnorableForRendering()
  {
    if (autoGenerated)
    {
      return false;
    }
    return super.isIgnorableForRendering();
  }

  public TableRenderBox getTable()
  {
    final RenderBox parent = getParent();
    if (parent instanceof TableSectionRenderBox)
    {
      final TableSectionRenderBox tableSectionRenderBox =
          (TableSectionRenderBox) parent;
      return tableSectionRenderBox.getTable();
    }
    return null;
  }

  public TableColumnModel getColumnModel()
  {
    final TableRenderBox table = getTable();
    if (table == null)
    {
      return null;
    }
    return table.getColumnModel();
  }

  public Object clone()
  {
    try
    {
      final TableRowRenderBox rb = (TableRowRenderBox) super.clone();
      if (infoStructure.isValidationDone() == false)
      {
        rb.infoStructure = (TableRowInfoStructure) infoStructure.clone();
      }
      return rb;
    }
    catch (CloneNotSupportedException cne)
    {
      throw new IllegalStateException("Clone not supported is not supported.");
    }
  }
}
