/* audio_proc.c
 *
 * Copyright (c) 1999 Scott Manley, Barath Raghavan, Jack Moffitt, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License  
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include "mixer.h"
#include "liveice.h"
#include "audio_proc.h"

/* throw all the effects processing routines into this file */
/* move some stuff from mixer.c into this... */
/* some of these effects are designed to work on 32 bit samples - others
   are designed to work on 16 bit samples - be careful */

/* a couple of buffers for working space */
short work1[32768],work2[32768];

void make_mono(short *stereo,short *mono,int num){
	unsigned int i;
	for(i=0;i<num;i++)
		mono[i]=(short)(((int)stereo[i*2]+(int)stereo[i*2+1])/2);
	
}

void make_stereo(short *mono,short *stereo,int num){
	unsigned int i;
	for(i=0;i<num;i++)
		stereo[i*2]=stereo[i*2+1]=mono[i];
	
}

void sep_stereo(short *stereo,short *left,short *right,int num){
	unsigned int i;
	for(i=0;i<num;i++){
		left[i]=stereo[i*2];
		right[i]=stereo[i*2+1];
	}  
}

void mix_stereo(short *left,short *right,short *stereo,int num){
	unsigned int i;
	for(i=0;i<num;i++){
		stereo[i*2]=left[i];
		stereo[i*2+1]=right[i];
	}  
}

void int_compress_samples(short *in, short *out,int num,int grain){
	unsigned int i,j;
	int smpl;
	
	for(i=0;i<num;i++){
		smpl=in[i*grain];
		for(j=1;j<grain;j++)
			smpl+=in[i*grain+j];
		out[i]=(short)(smpl/grain);
	}
	
}


void int_stretch_samples(short *in,short *out,int num,int grain){
	unsigned int i,j;
	for(i=0;i<num;i++)
		for(j=0;j<grain;j++)
			out[i*grain+j]=in[i];
	
}


/* this is a quick routine just to get proper spped control working - needs
   to be updated to use something whihc is less noisy */

/* no idea if this new routine works */
/* Now... I've figured it out... I was using a 1 offset whan I should have been using 0... */
void compress_samples(short *in, short *out,unsigned int num1,unsigned int num2){
	float sample,pos,step=(float)(num1)/num2;
	int i,j;
	pos=step-1;
	sample=in[0];
	j=0;
	for(i=1;i<num1;i++){
		if(i>pos){
			sample+= in[i] * (pos-i+1);
			sample /= step;
			if(sample>MAX_SAMPLE){
				sample=MAX_SAMPLE;
			} else if(sample<-MAX_SAMPLE){
				sample=-MAX_SAMPLE;
			}	
			out[j] = sample;
			j++;
			sample = in[i] * (i-pos);
			pos=((j+1)*step)-1;
		} else {
			sample += in[i];
		}
	}
	if(j!=num2){
		out[j]=sample/step;
	}	
}

void compress_samples2(short *in, short *out,unsigned int num1,unsigned int num2){
	float step=(float)(num1)/num2;
	int i;
	for(i=0;i<num2;i++){
		out[i]=in[(int)(i*step)];
	}
}


void stretch_samples(short *in, short *out,unsigned int num1,unsigned int num2){
	float step=(float)(num1)/num2;
	int i;
	for(i=0;i<num2;i++){
		out[i]=in[(int)(i*step)];
	}
}


/* changes the length of a buffer of samples uses fast shortcuts where possible */
void change_time(short *in,short *out,unsigned int num_in,unsigned int num_out){
	int i;
	
	if(num_in>num_out){
		/* compress samples */
		if(num_in==(num_out<<1)){
			int_compress_samples(in,out,num_out,2);
		} else if ( num_in==(num_out<<2)) {
			int_compress_samples(in,out,num_out,4);
		} else {
			compress_samples(in,out,num_in,num_out);
		}
	} else if(num_in<num_out) {
		/* stretch samples */
		if((num_in<<1)==num_out){
			int_stretch_samples(in,out,num_in,2);
		} else if ((num_in<<2)==num_out) {
			int_stretch_samples(in,out,num_in,4);
		} else {
			stretch_samples(in,out,num_in,num_out);
		}
	} else {
		for(i=0;i<num_out;i++)
			out[i]=in[i];
	}
}

/* convert_audio(inbuf,ch->inbuf,ch->channels,mixer.channels,num_samples,BUF_SIZE) */

void convert_audio(short *in,short *out,int ch1,int ch2,int n1,int n2){
	int i;
	if((ch1==ch2) &&(n1==n2)){
		for(i=0;i<ch1*n1;i++)
			out[i]=in[i];
		return;
		
	}
	if(ch2==1){
		/* output is mono */
		if(ch1==2){
			/* input is stereo */
			make_mono(in,work1,n1);       
			change_time(work1,out,n1,n2);
		} else {
			/* input is mono */
			change_time(in,out,n1,n2);
		}
	} else {
		/* output is stereo */
		if(ch1==2){
			/* input is stereo */
			sep_stereo(  in,    work1, work2, n1    );
			change_time( work1, in,    n1,    n2    );
			change_time( work2, work1, n1,    n2    );
			mix_stereo(  in,    work1, out,   n2    );
		} else {
			/* input is mono */
			change_time(in,work1,n1,n2);
			make_stereo(work1,out,  n2);
		}
	}
}



/* compressor module - takes audio and applies compression to it */
/* this one doesnt' sound too good :-( */

void compress_audio(int *buffer,int *prebuf,int num,int len,float power , float vol , float gate){
	float avg;
	int t_buf[num];
	int i;
	avg=0;
	for(i=0;i<len;i++)
		avg+=prebuf[i]*prebuf[i];
	
	if(num==len){
		/* LF history is same length as buffer - easy */
		/* process the input buffer */
		for(i=0;i<len;i++){
			avg = avg + buffer[i]*buffer[i] - prebuf[i]*prebuf[i];
			t_buf[i]=buffer[i]*pow(vol/(sqrt(avg/len)+gate),power);
		}
		/* update the prebuffer */
		for(i=0;i<len;i++){
			prebuf[i]=buffer[i];
		}
	} else if(num<len){
		/* LF history is longer than fragment buffer */
		/* process the input buffer */
		for(i=0;i<num;i++){
			avg = avg + buffer[i]*buffer[i] - prebuf[i]*prebuf[i];
			t_buf[i]=buffer[i]*pow(vol/(sqrt(avg/len)+gate),power);
		}
		
		/* update the prebuffer */
		for(i=0;i<(len-num);i++){
			prebuf[i] = prebuf[i+num];
		}
		for(;i<len;i++){
			prebuf[i] = buffer[i-num];
		}
	} else {
		/* LF history is shorter than the fragment buffer*/
		/* process the input */
		for(i=0;i<len;i++){
			avg = avg + buffer[i]*buffer[i] - prebuf[i]*prebuf[i];
			t_buf[i]=buffer[i]*pow(vol/(sqrt(avg/len)+gate),power);
		}
		for(;i<num;i++){
			avg = avg + buffer[i]*buffer[i] - buffer[i-len]*buffer[i-len];
			t_buf[i]=buffer[i]*pow(vol/(sqrt(avg/len)+gate),power);
		}
		
		/* update the prebuffer */
		for(i=0;i<len;i++){
			prebuf[i] = buffer[num-len+i]; 
		}
	}
	if(power>0){
		for(i=0;i<num;i++){
			buffer[i]=t_buf[i];
		}
	}
}


/* alternative version.... seems to sound better and need less memory */

void compress_audio2(int *buffer,float *prev,int num,int len,float power , float vol , float gate){
	int i,j,steps,stepsize;
	float avg,p_avg;
	if(len<=num){
		steps=ceil((float)(num)/(float)(len));
		stepsize=num/steps;
		for(j=0;j<steps;j++){
			avg=0;
			for(i=stepsize*j;i<stepsize*(j+1);i++){
				avg+=buffer[i]*buffer[i];
			}
			avg=sqrt(avg/len);
			if(power>0){
				for(i=stepsize*j;i<stepsize*(j+1);i++){
					p_avg=(*prev*(len-i) + avg * i)/len;
					buffer[i]=buffer[i]*pow(vol/(p_avg+gate),power);
				}    
			}
			*prev=avg;
		}
	}
}


int clip_audio(int *buffer,short *clipped,int num,float threshold){
	int i,clip;
	float clip_a,clip_b;

	clip  = MAX_SAMPLE * threshold;
	clip_a= (MAX_SAMPLE-clip)*(MAX_SAMPLE-clip);
	clip_b= MAX_SAMPLE - 2 * clip;

	for(i=0;i<num;i++) {
		if( (buffer[i]<clip) && (buffer[i]>-clip) )
			clipped[i]=(short)(buffer[i]);
		else if (buffer[i]>0) 
			clipped[i]= (MAX_SAMPLE-( clip_a / (clip_b+buffer[i]) ));
		else 
			clipped[i]=-(MAX_SAMPLE-(clip_a / (clip_b-buffer[i]) ) );
	}

	return 0;
}


int get_max_level32(int *buffer,int num){
	int i,max;
	max=0;
	for(i=0;i<num;i++){
		if(abs(buffer[i])>max)
			max=abs(buffer[i]);
	}
	return max;
}

int get_max_level16(short *buffer,int num){
	int i,max;
	max=0;
	for(i=0;i<num;i++){
		if(abs(buffer[i])>max)
			max=abs(buffer[i]);
	}
	return max;
}


