#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <linux/unistd.h>
#include <linux/sched.h>

#define STACK_SPACE	(1<<20)

int do_clone(void (*fn)(void *), void *data, char *stack)
{
        long	retval;

	if (!stack) {
		stack = mmap(0, STACK_SPACE, PROT_READ | PROT_WRITE | PROT_EXEC,
		    MAP_PRIVATE | MAP_ANONYMOUS | MAP_GROWSDOWN, -1, 0);
		if (-1 == (int)stack) {
			perror("unable to allocate child stack");
			return -1;
		}
		data = stack;
		stack += PAGE_SIZE;

        	/*
         	 * Set up the stack for child function, put the (void *)
         	 * argument on the stack.
         	 */
        	*--stack = (char *)data;
	}

        /*
         * Do clone() system call. We need to do the low-level stuff
         * entirely in assembly as we're returning with a different
         * stack in the child process and we couldn't otherwise guarantee
         * that the program doesn't use the old stack incorrectly.
         *
         * Parameters to clone() system call:
         *      %eax - __NR_clone, clone system call number
         *      %ebx - clone_flags, bitmap of cloned data
         *      %ecx - new stack pointer for cloned child
         *
         * In this example %ebx is CLONE_VM | CLONE_FS | CLONE_FILES |
         * CLONE_SIGHAND which shares as much as possible between parent
         * and child. (We or in the signal to be sent on child termination
         * into clone_flags: SIGCHLD makes the cloned process work like
         * a "normal" unix child process)
         *
         * The clone() system call returns (in %eax) the pid of the newly
         * cloned process to the parent, and 0 to the cloned process. If
         * an error occurs, the return value will be the negative errno.
         *
         * In the child process, we will do a "jsr" to the requested function
         * and then do a "exit()" system call which will terminate the child.
         */
        __asm__ __volatile__(
                "int $0x80\n\t"         /* Linux/i386 system call */
                "testl %0,%0\n\t"       /* check return value */
                "jne 1f\n\t"            /* jump if parent */
                "call *%3\n\t"          /* start subthread function */
                "movl %2,%0\n\t"
                "int $0x80\n"           /* exit system call: exit subthread */
                "1:\t"
                :"=a" (retval)
                :"0" (__NR_clone),"i" (__NR_exit),
                 "r" (fn),
                 "b" (CLONE_VM | CLONE_FS | CLONE_FILES | CLONE_SIGHAND | SIGCHLD),
                 "c" (stack));

        if (retval < 0) {
                errno = -retval;
                retval = -1;
        }
        return retval;
}

void	kid(void *data)
{
	exit(0);
}

int main()
{
        int	pid;
	int	i;
	char	stack[64<<10];
	char	*stacktop = stack + sizeof(stack);

	stacktop--;

	start(0);
	for (i = 0; i < 100000; ++i) {
        	if (do_clone(kid, 0, stacktop) < 0) {
			perror("clone");
			exit(1);
		}
		wait(0);
	}
	stop(0,0);
	micro("clone", 100000);
	exit(0);
}
