/* TECO for Ultrix   Copyright 1986 Matt Fichtenbaum						*/
/* This program and its components belong to GenRad Inc, Concord MA 01742	*/
/* They may be copied if this copyright notice is included					*/

/* te_main.c  main program  5/27/87 */
/* version for multiple buffers  04/13/89 10.22								*/
/* initialize q# to terminal name  04/10/91 09.45							*/
/* sun window version  07/31/91 14.10										*/
/* two filespec buffers 09/17/91  09.22										*/
/* tecotool version 12/02/91  11.00											*/
/* E/ (change directory) and filenames in header  03/26/92  10.05			*/
/* improved free_dly_blist  03/30/92  11.34									*/

/*
* This is TECO for Ultrix on a Vax.  It is mostly compatible with DEC TECO
* as explained in the DEC TECO manual.  It was written from a manual for
* TECO-11 version 34, and so adheres most closely to that version.
*
* This program consists of several source files, as follows:
*
* te_main.c (this file)		Main program - initialize, read command line and
*							startup file, handle errors, high-level read and
*							execute command strings.
*
* te_defs.h					Definitions file, to be #included with other files
*
* te_data.c					Global variables
*
* te_rdcmd.c				Read in a command string
*
* te_exec0.c				First-level command execution - numbers, values,
*							assemble expressions
*
* te_exec1.c				Most commands
*
* te_exec2.c				"E" and "F" commands, and file I/O
*
* te_srch.c					routines associated with "search" commands
*
* te_subs.c					higher-level subroutines
*
* te_utils.c				lower-level subroutines
*
* te_chario.c				keyboard (stdin), typeout (stdout), suspend
*
* te_window.c				display window and display special functions
*
* These routines should be compiled and linked to form the TECO executable.
*/

#include "te_defs.h"
#include <signal.h>
#ifdef _AIX
#include <sys/ioctl.h>
#endif

int cleanup();

main(argc, argv)
	int argc;			/* arg count */
	char *argv[];		/* array of string pointers */
{
	int i;
	VOID init_wd();

	init_wd();				/* set working directory */
	save_args(argc, argv, &qreg[36]);		/* copy command line to Qz */
	read_startup();							/* read startup file */
	setup_tty(TTY_ON);		/* set tty to CBREAK, no echo, asynch mode */
	if (inp_noterm)
		ez_val|=EZ_NOTERM;
	get_term_par();			/* set terminal screen-size parameters */
	window(WIN_INIT);		/* initialize screen-image buffer */
	qsp = &qstack[-1];		/* initialize q-reg stack pointer */

/* set up error restart */
	if (err = setjmp(xxx))
	{
		if (err == E_EFI) goto quit;		/* EOF from standard input - clean up and exit */
		crlf();
		printf("  %s", errors[err-1]);
		if (err == E_SRH) print_string(SERBUF);			/* print unfulfilled search string */
		else if ((err == E_FNF) || (err == E_COF) || (err == E_AMB)) print_string(filbuf);	/* or file string */
		else if (err == E_DIR) print_string(DIRNAME);	/* or directory name string */
		crlf();
		eisw = 0;				/* stop indirect command execution */
		et_val &= ~(ET_CTRLC | ET_NOWAIT | ET_CTRLO | ET_NOECHO);	/* reset ^C trap, read w/o wait, ^O (unused), no echo */
		if (et_val & ET_QUIT)	/* if ET has "quit on error" set, exit (phone home) */
		{
			cleanup();			/* reset screen, keyboard, output files */
			exit(1);			/* and exit */
		}
	}

/* forever: read and execute command strings */

	for (exitflag = 1; exitflag >= 0; )		/* "exit" sets exitflag to -1; ^C to -2; "hangup" to -3 */
	{
		window(WIN_REFR);				/* display the buffer */
		free_blist(insert_p);			/* free any storage from failed insert */
		free_blist(dly_freebuff);		/* return any delayed cells */
		reset_q_usecounts();			/* reset q-reg use counts to "1" if error occurred */
		insert_p = dly_freebuff = NULL;
		et_val &= ~ET_QUIT;				/* clear "abort on error" */
		if (read_cmdstr()) goto quit;
		exitflag = 0;					/* enable ^C detector */
		if (!WN_scroll) window(WIN_REDRAW);		/* if not in scroll mode, force full redraw on first ^W or nW */
		if (inp_noterm)
			ez_val|=EZ_NOTERM;
		exec_cmdstr();
	}

	if (exitflag == -2) ERROR(E_XAB);		/* ^C detected during execution */
	else if (exitflag == -3) panic();		/* hangup during execution: save buffer and close files */

/* exit from program */

  quit:
	ev_val = es_val = 0;	/* no last one-line window */
	window(WIN_REFR);		/* last display */
	cleanup();				/* reset screen, terminal, output files */
	exit(0);				/* and quit */
}


/* reset screen state, keyboard state; remove open output files */

cleanup()
{
	window(WIN_OFF);			/* restore screen */
	setup_tty(TTY_OFF);			/* restore terminal */
	kill_output(&po_file);		/* kill any open primary output file */
	kill_output(&so_file);		/* and secondary file */
}


/* print string for error message */
/* argument is subscript of a qreg qh, prints text from that buffer */

print_string(arg)
	int arg;
{
	int i, c;
	struct buffcell *p;

	type_char('"');
	for (p = qreg[arg].f, c = 0, i = 0; i < qreg[arg].z; i++)
	{
		if (!p->ch[c]) break;
		type_char(p->ch[c]);
		if (++c > CELLSIZE-1)
		{
			p = p->f;
			c = 0;
		}
	}
	type_char('"');
}
/* copy invocation command line to a text buffer */

save_args(argc, argv, q)
	int argc;
	char *argv[];
	struct qh *q;
{
	char c;
	struct qp ptr;
	char *pt = argv[0];			/* pointer to scan for "te_tt as program name */

	if (*pt == 't' && *++pt == 'e' && *++pt == '_' && *++pt == 't' && *++pt == 't' && *++pt == '\0')
		++toolsw;

	make_buffer(q);				/* attach a text buffer */
	ptr.p = q->f;				/* initialize pointer to output string */
	ptr.dot = ptr.c = q->z = 0;			/* and output char count */
	for (; argc > 0; argv++, argc--)	/* for each arg */
	{
		while ( ((c = *((*argv)++)) != '\0') && (q->z < CELLSIZE-1) )
		{
			ptr.p->ch[ptr.c] = c;		/* copy char to q-reg */
			fwdcx(&ptr);
			++q->z;						/* count characters */
		}
		if (argc > 1)					/* if not last argument... */
		{
			ptr.p->ch[ptr.c] = ' ';		/* space to separate arguments */
			fwdcx(&ptr);
			++q->z;
		}
	}
}



/* routine to read startup file */

char startup_name[] = "/.tecorc";		/* name of startup file */

read_startup()
{
	char *hp, *getenv();
	char fn[CELLSIZE];		/* filename storage */
	int i;

/* look for ".tecorc" in current directory first */

	if (!(eisw = fopen(&startup_name[1], "r")))
	{
		if (hp = getenv("HOME"))	/* if not found, look in home directory */
		{
			for (i = 0; i < CELLSIZE; i++) if (!(fn[i] = *(hp++))) break;	/* copy until trailing null */
			for (hp = &startup_name[0]; i < CELLSIZE; i++) if (!(fn[i] = *(hp++))) break;
			eisw = fopen(fn, "r");		/* set eisw if file found, or not if not */
		}
	}
}
/* routine to set directory buffer to current working directory */

VOID init_wd()
{
	char wd_buff[1024];
#ifdef POSIX_TECO
	(VOID) getcwd(wd_buff,1024);
#else
	(VOID) getwd(wd_buff);	/* get current directory */
#endif
	make_buffer(&dirbuf);	/* make a q-register for current directory */
	for (dirbuf.z = 0; dirbuf.z < CELLSIZE && wd_buff[dirbuf.z] != 0; dirbuf.z++)	/* copy to current directory q_reg */
		dirbuf.f->ch[dirbuf.z] = wd_buff[dirbuf.z];
}


/* routine to create/update SunWindows window header */

static char teco_name[] = "\033]lTECOtool - ";
static char pri_name[] = "     File 0:";
static char sec_name[] = "     File 1:";
#define HEADER_SIZE 256

VOID update_header()
{
	char header_text[HEADER_SIZE+3];
	char *ps, *pd;
	char *pdir;
	int i;

	if (toolsw != 0)				/* if running under SunWindows */
	{
		for (ps = teco_name, pd = header_text; *ps != '\0'; *pd++ = *ps++);		/* copy name */
		for (ps = &dirbuf.f->ch[0]; pd < &header_text[HEADER_SIZE] && ps < &dirbuf.f->ch[dirbuf.z];	/* copy default directory */
			*pd++ = *ps++);
		pdir = pd;					/* save first position after default dir */
		if (qreg[FILBUF].f != 0)	/* if there's a primary file name */
		{
			for (ps = pri_name; pd < &header_text[HEADER_SIZE] && *ps != '\0'; *pd++ = *ps++);	/* copy primary name */
			for (ps = &qreg[FILBUF].f->ch[0]; pd < &header_text[HEADER_SIZE] && ps < &qreg[FILBUF].f->ch[qreg[FILBUF].z];
				*pd++ = *ps++);
		}
		if (qreg[FILBUF+1].f != 0)	/* if there's a secondary file name */
		{
			for (ps = sec_name; pd < &header_text[HEADER_SIZE] && *ps != '\0'; *pd++ = *ps++);	/* copy secondary name */
			for (ps = &qreg[FILBUF+1].f->ch[0]; pd < &header_text[HEADER_SIZE] && ps < &qreg[FILBUF+1].f->ch[qreg[FILBUF+1].z];
				*pd++ = *ps++);
		}
		*pd++ = '\033';
		*pd++ = '\\';
		*pd = '\0';
		fputs(header_text, stdout);
		fflush(stdout);
		for (pd = pdir-1; pd >= pdir-8 && *pd != ' '; pd--);	/* back up over tail of directory */
		*pd-- = 'L';
		*pd-- = ']';
		*pd = '\033';
		*pdir++ = '\033';
		*pdir++ = '\\';
		*pdir = '\0';
		fputs(pd, stdout);			/* update icon label */
		fflush(stdout);
	}
}
/* routine to get terminal height and width from termcap */

#ifdef NO_TERMCAP
get_term_par()
{
	char *pname;
	char *getenv();
	struct winsize ws;
	if (ioctl(fileno(stdin), TIOCGWINSZ, &ws) == 0) 
		set_term_par(ws.ws_row, ws.ws_col);
	if (pname=getenv("TERM")) {
		make_buffer(&timbuf);		/* put terminal name in q# */
		for (timbuf.z = 0; *pname != '\0'; )
			timbuf.f->ch[timbuf.z++] = *pname++;
	}
}
#else   /* USE_TERMCAP */
get_term_par()
{
	char tbuff[1024];	/* termcap buffer */
	char *pname;		/* pointer to name of terminal */
	extern char *getenv();

	if (pname = getenv("TERM"))		/* read terminal name */
	{
		tgetent(tbuff, pname);		/* get entry */
		set_term_par(tgetnum("li"), tgetnum("co"));	/* get #lines and #columns and set params */
		make_buffer(&timbuf);		/* put terminal name in q# */
		for (timbuf.z = 0; *pname != '\0'; )
			timbuf.f->ch[timbuf.z++] = *pname++;
	}
}
#endif
