/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/fcntl.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/param.h>
#include <sys/ioctl.h>

#include <errno.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#ifdef LOCALE
# ifdef X_LOCALE
# include <X11/Xlocale.h>
#else  /* non X_LOCALE */
# include <locale.h>
#endif /* X_LOCALE */
#endif

#  define PIXMAP_W     32
#  define PIXMAP_H     32

#ifndef MGLDIR
#define MGLDIR "."
#endif

#define FONTPATH	MGLDIR "/krom.fnt"


#ifdef LOCALE
#ifdef SOLARIS /* for SunOS 5.5.1 i86pc */
#define FONT_8       "-misc-*-medium-r-normal-*-8-*-*-*-*-*-iso8859-*,\
                      -*-*-medium-r-*-*-8-*-*-*-*-*-jisx0208.1983-*"
#define FONT_12      "-misc-fixed-medium-r-semicondensed--12-*-iso8859*,\
               -morisawa-gothic medium bbb-medium-r-normal-sans-12-*-jisx0208*"
#define FONT_16      "-sony-fixed-medium-r-normal--16-*-iso8859*,\
                      -sony-fixed-medium-r-normal--16-*-iso8859*"
#define FONT_24      "-*-fixed-medium-r-normal--24-*-iso8859*,\
                      -*-fixed-medium-r-normal--24-*-jisx0208*"
#else

#define FONT_8       "-*-*-medium-r-normal-*-8-*-*-*-*-*-iso8859-*,\
                     -*-*-medium-*-*-*-8-*-*-*-*-*-jisx0208.1983-*"
#define FONT_12      "-misc-fixed-medium-r-*--12-*-iso8859*,\
                      -*-fixed-medium-r-normal-*-12-*-jisx0208*"
#define FONT_16      "-*-fixed-medium-r-normal--16-*-iso8859*,\
                      -*-fixed-medium-r-normal--16-*-jisx0208*"
#define FONT_24      "-*-fixed-medium-r-normal--24-*-iso8859*,\
                      -*-fixed-medium-r-normal--24-*-jisx0208*"
#endif /* SOLARIS */

#else  /* non LOCALE */
#ifdef SOLARIS /* for SunOS 5.5.1 i86pc */
#define FONT_8A      "-misc-*-medium-r-normal-*-8-*-*-*-*-*-iso8859-*"
#define FONT_8       "-*-*-medium-*-*-*-8-*-*-*-*-*-jisx0208.1983-*"
#define FONT_8K      "-*-*-medium-*-*-*-8-*-*-*-*-*-jisx0201*"

#define FONT_12A     "-misc-fixed-medium-r-semicondensed--12-*-iso8859*"
#define FONT_12      "-morisawa-gothic medium bbb-medium-r-normal-sans-12-*-jisx0208*"
#define FONT_12K     "-morisawa-gothic medium bbb-medium-r-normal-sans-12-*-jisx0201*"

#define FONT_16A     "-sony-fixed-medium-r-normal--16-*-iso8859*"
#define FONT_16      "-*-fixed-medium-r-normal--16-*-jisx0208*"
#define FONT_16K     "-*-fixed-medium-r-normal--16-*-jisx0201*"

#define FONT_24A     "-*-fixed-medium-r-normal--24-*-iso8859*"
#define FONT_24      "-*-fixed-medium-r-normal--24-*-jisx0208*"
#define FONT_24K     "-*-fixed-medium-r-normal--24-*-jisx0201*"
#else  /* non SOLARIS */
#define FONT_8A      "-*-*-medium-r-normal-*-8-*-*-*-*-*-iso8859-*"
#define FONT_8       "-*-*-medium-*-*-*-8-*-*-*-*-*-jisx0208.1983-*"
#define FONT_8K      "-*-*-medium-*-*-*-10-*-*-*-*-*-jisx0201*"

#define FONT_12A     "-misc-fixed-medium-r-*--12-*-iso8859*"
#define FONT_12      "-*-fixed-medium-r-normal-*-12-*-jisx0208*"
#define FONT_12K     "-*-fixed-medium-r-normal-*-12-*-jisx0201*"

#define FONT_16A     "-*-fixed-medium-r-normal--16-*-iso8859*"
#define FONT_16      "-*-fixed-medium-r-normal--16-*-jisx0208*"
#define FONT_16K     "-*-fixed-medium-r-normal--16-*-jisx0201*"

#define FONT_24A     "-*-fixed-medium-r-normal--24-*-iso8859*"
#define FONT_24      "-*-fixed-medium-r-normal--24-*-jisx0208*"
#define FONT_24K     "-*-fixed-medium-r-normal--24-*-jisx0201*"
#endif /* SOLARIS */
#endif /* LOCALE */

char *font_base;

static Display        *display;
static XImage         *ximage;
static GC             fg_gc;
static GC             bg_gc;
static Pixmap         pixmap;

#ifdef LOCALE
static XFontSet       fontset8;
static XFontSet       fontset12;
static XFontSet       fontset16;
static XFontSet       fontset24;
#  else  /* non LOCALE */
static Font           font8a;
static Font           font12a;
static Font           font16a;
static Font           font24a;
static Font           font8;
static Font           font12;
static Font           font16;
static Font           font24;
static Font           font8k;
static Font           font12k;
static Font           font16k;
static Font           font24k;
static XFontStruct    *fs8a;
static XFontStruct    *fs12a;
static XFontStruct    *fs16a;
static XFontStruct    *fs24a;
static XFontStruct    *fs8;
static XFontStruct    *fs12;
static XFontStruct    *fs16;
static XFontStruct    *fs24;
static XFontStruct    *fs8k;
static XFontStruct    *fs12k;
static XFontStruct    *fs16k;
static XFontStruct    *fs24k;
#endif /* LOCALE */


struct romfont {
	int height;
	int width;
	int koffset;
	int kwidth;
	int kbytes;
	int aoffset;
	int awidth;
	int abytes;
	int goffset;
	int gwidth;
	int gbytes;
	int fd;	/* external font */
} romfont[6] = {
	{ 12, 12, 0x00000, 2,32,  0x3f000, 1,16 ,  0x40000, 2,32},
	{ 16, 16, 0x44800, 2,32,  0x83800, 1,16 ,  0x84800, 2,32},
	{ 24, 24, 0x89800, 3,80, 0x127000, 2,48 , 0x12a000, 3,80},
	{  8, 16, 0x00000, 0, 0, 0x89000,  1, 8 , 0x000000, 0, 0},
};

struct romfont *pen_font;

void set_font(int size, int attr) {
	switch (size) {
	case 12: pen_font = &romfont[0]; break;
	case 16: pen_font = &romfont[1]; break;
	case 24: pen_font = &romfont[2]; break;
	case  7: pen_font = &romfont[3]; break;
	default: 
		if (size == romfont[4].height) {
			pen_font = &romfont[4]; break;
		} else if ( size == romfont[5].height) {
			pen_font = &romfont[5]; break;
		}
		pen_font = &romfont[0]; break;
	}
	return;
}

int xset_font(char *str, int bytes, int code) {
#ifdef LOCALE
    XFontSet font;
#else  /* non LOCALE */
    XCharStruct ts;
    int         dir;
    int         as;
    int         de;
#endif /* LOCALE */
    XImage   *image;
    int      width;
    int      height;
    int      sx, sy;
    int      i, j, k;
    int      xcode = code;
    char     *p;
    char     *q;

    if(pen_font == &romfont[0]){
        sx = 0;
#ifdef LOCALE
        sy = 12;
        font = fontset12;
#else  /* non LOCALE */
        if(bytes == 1){
            XSetFont(display, fg_gc, font12a);
            XTextExtents(fs12a, str, bytes, &dir, &as, &de, &ts);
        }else{
            if (((code >> 8) & 0xff) == 0x8E) {
                XSetFont(display, fg_gc, font12k);
                XTextExtents16(fs12k, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            } else {
                XSetFont(display, fg_gc, font12);
                XTextExtents16(fs12, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            }
        }
        sy = as;
#endif /* LOCALE */
    }else
    if(pen_font == &romfont[1]){
        sx = 0;
#ifdef LOCALE
        sy = 16;
        font = fontset16;
#else  /* non LOCALE */
        if(bytes == 1){
            XSetFont(display, fg_gc, font16a);
            XTextExtents(fs16a, str, bytes, &dir, &as, &de, &ts);
        }else{
            if (((code >> 8) & 0xff) == 0x8E) {
                XSetFont(display, fg_gc, font16k);
                XTextExtents16(fs16k, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            } else {
                XSetFont(display, fg_gc, font16);
                XTextExtents16(fs16, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            }
        }
        sy = as;
#endif /* LOCALE */
    }else
    if(pen_font == &romfont[2]){
        sx = 0;
#ifdef LOCALE
        sy = 24;
        font = fontset24;
#else  /* non LOCALE */
        if(bytes == 1){
            XSetFont(display, fg_gc, font24a);
            XTextExtents(fs24a, str, bytes, &dir, &as, &de, &ts);
        }else{
            if (((code >> 8) & 0xff) == 0x8E) {
                XSetFont(display, fg_gc, font24k);
                XTextExtents16(fs24k, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            } else {
                XSetFont(display, fg_gc, font24);
                XTextExtents16(fs24, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            }
        }
        sy = as;
#endif /* LOCALE */
    }else
    if(pen_font == &romfont[3]){
        sx = 0;
#ifdef LOCALE
        sy = 8;
        font = fontset8;
#else  /* non LOCALE */
        if(bytes == 1){
            XSetFont(display, fg_gc, font8a);
            XTextExtents(fs8a, str, bytes, &dir, &as, &de, &ts);
        }else{
            if (((code >> 8) & 0xff) == 0x8E) {
                XSetFont(display, fg_gc, font8k);
                XTextExtents16(fs8k, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            } else {
                XSetFont(display, fg_gc, font8);
                XTextExtents16(fs8, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            }
        }
        sy = as;
#endif /* LOCALE */
    }else{
        sx = 0;
#ifdef LOCALE
        sy = 12;
        font = fontset12;
#else  /* non LOCALE */
        if(bytes == 1){
            XSetFont(display, fg_gc, font12a);
            XTextExtents(fs12a, str, bytes, &dir, &as, &de, &ts);
        }else{
            if (((code >> 8) & 0xff) == 0x8E) {
                XSetFont(display, fg_gc, font12k);
                XTextExtents16(fs12k, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            } else {
                XSetFont(display, fg_gc, font12);
                XTextExtents16(fs12, (XChar2b *)str, bytes, &dir, &as, &de, &ts);
            }
        }
        sy = as;
#endif /* LOCALE */
    }

    /* pixmap򥯥ꥢ */
    XFillRectangle(display, pixmap, bg_gc, 0, 0, PIXMAP_W, PIXMAP_H);

    /* pixmap˥եȤ */
#ifdef LOCALE
    XmbDrawImageString(display, pixmap, font,
                  fg_gc,
                  sx,
                  sy,
                  str, bytes);
#else  /* non LOCALE */
    if(bytes == 1){
        XDrawString(display, pixmap, fg_gc,
                    sx,
                    sy,
                    str, bytes);
    }else{
char dtext[2];

        if (((code >> 8) & 0xff) == 0x8E) {
            dtext[0] = 0x00;
            dtext[1] = str[1] | 0x80;
        } else {
            dtext[0] = str[0] & 0x7f;
            dtext[1] = str[1] & 0x7f;
        }
        XDrawString16(display, pixmap, fg_gc,
                      sx,
                      sy,
                     (XChar2b *)dtext, bytes);
    }
#endif /* LOCALE */

    /* pixmapեȤ */
    image = XGetImage(display, pixmap,
                      0, 0,
                      PIXMAP_W, PIXMAP_H,
                      1, XYPixmap);
    if(!image){
        fprintf(stderr, "Font Image can't get.\n");
        return 0;
    }

    q = image->data;

    /* եȥǡfont_base */
    if (code < 0x100) {
        p = font_base + pen_font->aoffset + pen_font->abytes * code;
        height = pen_font->height;
        width  = pen_font->awidth;
    } else if (((code >> 8) & 0xff) == 0x8E) {
	xcode = (code & 0xff);
	p = font_base + pen_font->aoffset + pen_font->abytes * xcode;
	height = pen_font->height;
	width = pen_font->awidth;
    } else {
        xcode = (((code >> 8) & 0x7f) - 0x21) * 96
               + ((code & 0x7f) - 0x20);
        p = font_base + pen_font->koffset + pen_font->kbytes * xcode;
        height = pen_font->height;
        width  = pen_font->kwidth;
    }

    for (i=0; i< height; i++) {
        /* ä֤ */
        for (j=0; j < width; j++,q++,p++) {
          if (XBitmapBitOrder(display)) {
            *p = ~*q;
          } else {
            for (k=0; k<8; k++) {
                if (!(*q & (1<<(7-k)))) {
                    *p = *p | (1<<k);
                }
            }
          }
        }
        q+=((PIXMAP_W / 8) - width);
    }

    XDestroyImage(image);
    return 1;
}

int font_base_create(void) {
int    i, k;
int    code;
int    fsize[4] = {12,16,24,7};
#ifdef LOCALE
int    num_missing_charsets;
char   **missing_charsets;
char   *default_string;
#endif
unsigned char   str[2];
int fd;

    fprintf(stderr, "generating fonts for mgl. wait a minute.\n");

    font_base = (char *)malloc(0x200000);
    if(!font_base){
        perror("malloc");
        return 0;
    }
    memset(font_base, 0x00, 0x200000);

#ifdef LOCALE
    /***** locale *****/
    if(setlocale(LC_ALL, "") == NULL){
        fprintf(stderr, "setlocale failed \n");
        return 0;
    }

    /**** 8dotեȥåȤκ ****/
    fontset8 = XCreateFontSet(display,
                              FONT_8,
                              &missing_charsets,
                              &num_missing_charsets,
                              &default_string);
    if(fontset8 == NULL){
        fprintf(stderr, "8Dot FontSet can't created\n");
        return 0;
    }

    /**** 12dotեȥåȤκ ****/
    fontset12 = XCreateFontSet(display,
                               FONT_12,
                               &missing_charsets,
                               &num_missing_charsets,
                               &default_string);
    if(fontset12 == NULL){
        fprintf(stderr, "12Dot FontSet can't created\n");
        return 0;
    }

    /**** 16dotեȥåȤκ ****/
    fontset16 = XCreateFontSet(display,
                               FONT_16,
                               &missing_charsets,
                               &num_missing_charsets,
                               &default_string);
    if(fontset16 == NULL){
        fprintf(stderr, "16Dot FontSet can't created\n");
        return 0;
    }

    /**** 24dotեȥåȤκ ****/
    fontset24 = XCreateFontSet(display,
                               FONT_24,
                               &missing_charsets,
                               &num_missing_charsets,
                               &default_string);
    if(fontset24 == NULL){
        fprintf(stderr, "24Dot FontSet can't created\n");
        return 0;
    }
#else  /* non LOCALE */
    fs8a = XLoadQueryFont(display, FONT_8A);
    if(fs8a == NULL){
        fprintf(stderr, "8Dot Ascii Font can't created\n");
        return 0;
    }
    font8a = fs8a->fid;
    fs12a = XLoadQueryFont(display, FONT_12A);
    if(fs12a == NULL){
        fprintf(stderr, "12Dot Ascii Font can't created\n");
        return 0;
    }
    font12a = fs12a->fid;
    fs16a = XLoadQueryFont(display, FONT_16A);
    if(fs16a == NULL){
        fprintf(stderr, "16Dot Ascii Font can't created\n");
        return 0;
    }
    font16a = fs16a->fid;
    fs24a = XLoadQueryFont(display, FONT_24A);
    if(fs24a == NULL){
        fprintf(stderr, "24Dot Ascii Font can't created\n");
        return 0;
    }
    font24a = fs24a->fid;

#if 0
    fs8 = XLoadQueryFont(display, FONT_8);
    if(fs8 == NULL){
        fprintf(stderr, "8Dot Font can't created\n");
        return 0;
    }
    font8 = fs8->fid;
#endif
    fs12 = XLoadQueryFont(display, FONT_12);
    if(fs12 == NULL){
        fprintf(stderr, "12Dot Font can't created\n");
        return 0;
    }
    font12 = fs12->fid;
    fs16 = XLoadQueryFont(display, FONT_16);
    if(fs16 == NULL){
        fprintf(stderr, "16Dot Font can't created\n");
        return 0;
    }
    font16 = fs16->fid;
    fs24 = XLoadQueryFont(display, FONT_24);
    if(fs24 == NULL){
        fprintf(stderr, "24Dot Font can't created\n");
        return 0;
    }
    font24 = fs24->fid;

#if 0
    fs8k = XLoadQueryFont(display, FONT_8K);
    if(fs8k == NULL){
        fprintf(stderr, "8Dot JISX201 Font can't created\n");
        return 0;
    }
    font8k = fs8k->fid;
#endif
    fs12k = XLoadQueryFont(display, FONT_12K);
    if(fs12k == NULL){
        fprintf(stderr, "12Dot JISX201 Font can't created\n");
        return 0;
    }
    font12k = fs12k->fid;
    fs16k = XLoadQueryFont(display, FONT_16K);
    if(fs16k == NULL){
        fprintf(stderr, "16Dot JISX201 Font can't created\n");
        return 0;
    }
    font16k = fs16k->fid;
    fs24k = XLoadQueryFont(display, FONT_24K);
    if(fs24k == NULL){
        fprintf(stderr, "24Dot JISX201 Font can't created\n");
        return 0;
    }
    font24k = fs24k->fid;
#endif /* LOCALE */
    /* pixmap */
    pixmap = XCreatePixmap(display, DefaultRootWindow(display),
                           PIXMAP_W, PIXMAP_H,
                           DefaultDepth(display, DefaultScreen(display)));
    if(!pixmap){
        fprintf(stderr, "Pixmap can't created\n");
        return 0;
    }
    fg_gc = XCreateGC(display, pixmap, 0, 0);
    XSetForeground(display, fg_gc, BlackPixel(display, DefaultScreen(display)));

    bg_gc = XCreateGC(display, pixmap, 0, 0);
    XSetForeground(display, bg_gc, WhitePixel(display, DefaultScreen(display)));


    for(k = 0 ; k < 3 ; k++){
        set_font(fsize[k], 0);

        /* font_baseؤδΥ */
        /* a1a1 - a1fe */
        for(str[0] = 0xa1, str[1] = 0xa1 ; str[1] < 0xff ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a2a1 - a2ae */
        for(str[0] = 0xa2, str[1] = 0xa1 ; str[1] < 0xaf ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a2ba - a2c1 */
        for(str[0] = 0xa2, str[1] = 0xba ; str[1] < 0xc2 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a2ca - a2d0 */
        for(str[0] = 0xa2, str[1] = 0xca ; str[1] < 0xd1 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a2dc - a2ea */
        for(str[0] = 0xa2, str[1] = 0xdc ; str[1] < 0xeb ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a2f2 - a2f9 */
        for(str[0] = 0xa2, str[1] = 0xf2 ; str[1] < 0xfa ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a2fe */
        str[0] = 0xa2;
        str[1] = 0xfe;
        code = (str[0] << 8) & 0xffff;
        code |= str[1] & 0xff;
        if(xset_font((char *)str, 2, code) == 0){
            return 0;
        }
        /* a3b0 - a3b9 */
        for(str[0] = 0xa3, str[1] = 0xb0 ; str[1] < 0xba ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a3c1 - a3da */
        for(str[0] = 0xa3, str[1] = 0xc1 ; str[1] < 0xdb ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a3e1 - a3fa */
        for(str[0] = 0xa3, str[1] = 0xe1 ; str[1] < 0xfb ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a4a1 - a4f3 */
        for(str[0] = 0xa4, str[1] = 0xa1 ; str[1] < 0xf4 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a5a1 - a5f6 */
        for(str[0] = 0xa5, str[1] = 0xa1 ; str[1] < 0xf7 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a6a1 - a6b8 */
        for(str[0] = 0xa6, str[1] = 0xa1 ; str[1] < 0xb9 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a6c1 - a6d8 */
        for(str[0] = 0xa6, str[1] = 0xc1 ; str[1] < 0xd9 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a7a1 - a7c1 */
        for(str[0] = 0xa7, str[1] = 0xa1 ; str[1] < 0xc2 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a7d1 - a7f1 */
        for(str[0] = 0xa7, str[1] = 0xd1 ; str[1] < 0xf2 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /* a8a1 - a8c0 */
        for(str[0] = 0xa8, str[1] = 0xa1 ; str[1] < 0xc0 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }

        /*
           b0a1 - b0fe,
           ...
           cea1 - cefe,
        */
        for(str[0] = 0xb0 ; str[0] < 0xcf ; str[0]++){
            for(str[1] = 0xa1 ; str[1] < 0xff ; str[1]++){
                code = (str[0] << 8) & 0xffff;
                code |= str[1] & 0xff;
                if(xset_font((char *)str, 2, code) == 0){
                    return 0;
                }
            }
        }
        /*
           cfa1 - cfd3,   -
        */
        for(str[0] = 0xcf, str[1] = 0xa1 ; str[1] < 0xd4 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /*
           d0a1 - d0fe,
           d1a1 - d1fe,
           ...
           f3a1 - f3fe,
        */
        for(str[0] = 0xd0 ; str[0] < 0xf4 ; str[0]++){
            for(str[1] = 0xa1 ; str[1] < 0xff ; str[1]++){
                code = (str[0] << 8) & 0xffff;
                code |= str[1] & 0xff;
                if(xset_font((char *)str, 2, code) == 0){
                    return 0;
                }
            }
        }
        /*
           f4a1 - f4a4    -
        */
        for(str[0] = 0xf4, str[1] = 0xa1 ; str[1] < 0xa5 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }
        /*
           ȾҲ̾
           8ea1 - 8edf
        */
        for(str[0] = 0x8e, str[1] = 0xa1 ; str[1] < 0xe0 ; str[1]++){
            code = (str[0] << 8) & 0xffff;
            code |= str[1] & 0xff;
            if(xset_font((char *)str, 2, code) == 0){
                return 0;
            }
        }

        /* font_baseؤasciiΥ */
        /* 20 - 7f */
        for(i = 0x20 ; i < 0x7f; i++){
            str[0] = i;
            str[1] = 0x00;
            code = str[0] & 0xff;
            if(xset_font((char *)str, 1, code) == 0){
                return 0;
            }
        }

        /* font_baseؤglyph ? Υ */
    }

    set_font(fsize[3], 0);
    /* font_baseؤ8dot asciiΥ */
    /* 20 - 7f */
    for(i = 0x20 ; i < 0x7f; i++){
        str[0] = i;
        str[1] = 0x00;
        code = str[0] & 0xff;
        if(xset_font((char *)str, 1, code) == 0){
            return 0;
        }
    }

    set_font(fsize[0], 0);

#ifdef LOCALE
    XFreeFontSet(display, fontset8);
    XFreeFontSet(display, fontset12);
    XFreeFontSet(display, fontset16);
    XFreeFontSet(display, fontset24);
#else  /* non LOCALE */
    XFreeFont(display, fs8a);
    XFreeFont(display, fs12a);
    XFreeFont(display, fs16a);
    XFreeFont(display, fs24a);
#if 0
    XFreeFont(display, fs8);
#endif
    XFreeFont(display, fs12);
    XFreeFont(display, fs16);
    XFreeFont(display, fs24);
#if 0
    XFreeFont(display, fs8k);
#endif
    XFreeFont(display, fs12k);
    XFreeFont(display, fs16k);
    XFreeFont(display, fs24k);
#endif /* LOCALE */
    XFreeGC(display, fg_gc);
    XFreeGC(display, bg_gc);
    XFreePixmap(display, pixmap);

{
    int  fd;
    fd = open(FONTPATH, O_RDWR | O_CREAT, 0644);
    if(fd >= 0) {
            write(fd, font_base, 0x200000);
            close(fd);
    }
}
{
    int  fd,i,j,n;
    char fmagic[32];

    memset(fmagic,0,32);
    sprintf(fmagic,"#MGLFONT%02d%02d%02d",1,12,12);
    fd = open("k12x12.fnt", O_RDWR | O_CREAT, 0644);
    if (fd > 0) {
	write(fd,fmagic,32);
	n = romfont[0].awidth * romfont[0].height;
	for (i=0; i<256; i++) {
            write(fd,font_base + romfont[0].aoffset
		 + i * romfont[0].abytes, n);
	}
	n = romfont[0].kwidth * romfont[0].height;
	for (i=0; i<8064; i++) {
            write(fd,font_base + romfont[0].koffset
		 + i * romfont[0].kbytes, n);
	}
	close(fd);
    }
    memset(fmagic,0,32);
    sprintf(fmagic,"#MGLFONT%02d%02d%02d",1,16,16);
    fd = open("k16x16.fnt", O_RDWR | O_CREAT, 0644);
    if (fd > 0) {
	write(fd,fmagic,32);
	n = romfont[1].awidth * romfont[1].height;
	for (i=0; i<256; i++) {
            write(fd,font_base + romfont[1].aoffset
		 + i * romfont[1].abytes, n);
	}
	n = romfont[1].kwidth * romfont[1].height;
	for (i=0; i<8064; i++) {
            write(fd,font_base + romfont[1].koffset
		 + i * romfont[1].kbytes, n);
	}
	close(fd);
    }
    memset(fmagic,0,32);
    sprintf(fmagic,"#MGLFONT%02d%02d%02d",1,24,24);
    fd = open("k24x24.fnt", O_RDWR | O_CREAT, 0644);
    if (fd > 0) {
	write(fd,fmagic,32);
	n = romfont[2].awidth * romfont[2].height;
	for (i=0; i<256; i++) {
            write(fd,font_base + romfont[2].aoffset
		 + i * romfont[2].abytes, n);
	}
	n = romfont[2].kwidth * romfont[2].height;
	for (i=0; i<8064; i++) {
            write(fd,font_base + romfont[2].koffset
		 + i * romfont[2].kbytes, n);
	}
	close(fd);
    }
}

#if 0
{
int i,j,n;
char *p;

	n = romfont[0].kwidth * romfont[0].height;
	for (i=0; i<8064; i++) {
            p = font_base + romfont[0].koffset
		 + i * romfont[0].kbytes;
	    for (j=0; j<n; j++,p++) {
		if (*p != 0) break;
	    }
	    if (j == n) {
		printf("%04d\n",i);
	    }
	}
}
#endif
    return 1;
}


main() {
    display = XOpenDisplay(NULL);
    if(!display){
printf("cannot get display -- please setenv DISPLAY\n");
exit(1);
    }

    if(!font_base_create()){
printf("font_crate fail.");
exit(1);
        }
	exit(0);
}
