#include "mgl2.h"
#include "mglcol.h"

#include "pai0.h"
#include "pai1.h"
#include "pai2.h"
#include "pai3.h"
#include "misc.h"


struct screen *s1;
struct screen *s2;
struct screen *s3;
struct screen *s4;
struct screen *s5;

#ifndef NULL
#define NULL (void *)0
#endif

#define PAI_W	16
#define PAI_H	21

conv_color(int x,int y,int xs,int ys,int from,int to) {
	int i,j;
	int buf[1024];

	for (i=0; i<ys; i++) {
		get_pixstream(x,y,buf,xs,DIR_NORTH,BLT_MASKING|from);
		for (j=0; j<xs; j++) {
			if (buf[j] == COLOR_TRANSPARENT) {
				buf[j] = to;
			}
		}
		put_pixstream(x,y,buf,xs,DIR_NORTH);
		y++;
	}
}

conv_pai_color(int x,int y,int xs,int ys,int from,int to,int dir) {
	int w,h;
	w = PAI_W;	
	h = PAI_H;
	if (dir & 1) {
		w = PAI_H;
		h = PAI_W;
	}
	conv_color(x*w,y*h,xs*w,ys*h,from,to);
}

fix_borders(int dir) {
	int w,h;
	int i,j;
	w = PAI_W;	
	h = PAI_H;
	if (dir & 1) {
		w = PAI_H;
		h = PAI_W;
	}
	for (i=0;  i<4; i++) {
		for (j=0; j<10; j++) {
			set_color(COLOR_DARKGRAY);
			draw_rect(j*w,i*h,w,h);
			set_color(COLOR_WHITE);
			draw_pixel(j*w,i*h);
			draw_pixel(j*w+w-1,i*h);
			draw_pixel(j*w,i*h+h-1);
			draw_pixel(j*w+w-1,i*h+h-1);
		}
	}

}

conv_colors() {
	int i;
	struct screen *s;
	for (i=0; i<4; i++) {
		switch(i) {
		case 0: s = s1; break;
		case 1: s = s2; break;
		case 2: s = s3; break;
		case 3: s = s4; break;
		}
		push_screen(s);
		/* dark red */
		conv_pai_color(0,0,9,3,COLOR_DARKGRAY,packMC(0,10,10),i);
		conv_pai_color(5,3,1,1,COLOR_DARKGRAY,packMC(0,10,10),i);
		/* red 5 */
		conv_pai_color(9,0,1,3,COLOR_DARKGRAY,packMC(0,10,15),i);
		/* green */
		conv_pai_color(0,2,9,1,COLOR_BLACK,packMC(4,5,5),i);
		conv_pai_color(5,3,1,1,COLOR_BLACK,packMC(4,5,5),i);
		/* pai rev */
		conv_pai_color(7,3,2,1,COLOR_DARKGRAY,packMC(7,10,10),i);
		fix_borders(i);
		pop_screen();
	}
}

main() {
	int i,j;
	int dx,dy,sx,sy;
	struct screen *s;

	SCREEN_WIDTH = 240;
	SCREEN_HEIGHT = 100;
	open_graph();

	s1 = conv_screen_from_v1(&pai0,STK_NATIVE);
	s2 = conv_screen_from_v1(&pai1,STK_NATIVE);
	s3 = conv_screen_from_v1(&pai2,STK_NATIVE);
	s4 = conv_screen_from_v1(&pai3,STK_NATIVE);
	s5 = conv_screen_from_v1(&misc,STK_NATIVE);

	conv_colors();
	for (i=0; i<4; i++) {
		switch(i) {
		case 0: s = s1; break;
		case 1: s = s2; break;
		case 2: s = s3; break;
		case 3: s = s4; break;
		}
		set_color(packMC(3,10,10));
		clear_screen();
		bitblt(NULL,0,0,s,0,0,s->width,s->height,0);
		get_key(-1);
	}
	sx = 5*PAI_H;
	sy = 3*PAI_W;
	for (i=0; i<20; i++) {
		bitblt(NULL,sx,sy+i+1,NULL,sx,sy+i,PAI_H,PAI_W,0);
		get_key(1);
	}
	for (i=20; i>=0; i--) {
		bitblt(NULL,sx,sy+i-1,NULL,sx,sy+i,PAI_H,PAI_W,0);
		get_key(1);
	}
	get_key(-1);
set_color(COLOR_REVERSE);
clear_screen();
	get_key(-1);
clear_screen();
	get_key(-1);
}
