/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "mgl2.h"

/*
ɸ७Υ

13 x 18 = 234

        +---+
        | 1 | 20
        +---+
         20

+-----------------------------------------------+
|Esc| 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 0 | BS|
+---+---+---+---+---+---+---+---+---+---+---+---+
|Tab| q | w | e | r | t | y | u | i | o | p |Ent|
+---+---+---+---+---+---+---+---+---+---+---+-  |
|Caps| a | s | d | f | g | h | j | k | l | ; |er|
+----+---+---+---+---+---+---+---+---+---+---+--|
|Shift| z | x | c | v | b | n | m | , | . ||@ |
+-----+---+---+---+---+---+---+---+---+---+--+--+
|Ctrl |Alt  |Hide |             |Kanji ||||
+-----+-----+-----+-------------+-----------+---+
*/


char *kb_layout1="\
-----------------------------------------------+
Esc| 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 0 | BS|
---+---+---+---+---+---+---+---+---+---+---+---+
Tab| q | w | e | r | t | y | u | i | o | p |Ent|
---+---+---+---+---+---+---+---+---+---+---+-  |
Caps| a | s | d | f | g | h | j | k | l | ; |er|
----+---+---+---+---+---+---+---+---+---+---+--|
Shift| z | x | c | v | b | n | m | , | . ||@ |
-----+---+---+---+---+---+---+---+---+---+--+--+
Ctrl |Alt  |Hide |             |Kanji ||||
-----+-----+-----+-------------+-----------+---+
";

char *kb_layout2="\
-----------------------------------------------+
Esc| ! | \" | # | $ | % | & | ' | ( | ) | ~ | BS|
---+---+---+---+---+---+---+---+---+---+---+---+
Tab| Q | W | E | R | T | Y | U | I | O | P |Ent|
---+---+---+---+---+---+---+---+---+---+---+-  |
Caps| A | S | D | F | G | H | J | K | L | + |er|
----+---+---+---+---+---+---+---+---+---+---+--|
Shift| Z | X | C | V | B | N | M | < | > ||` |
-----+---+---+---+---+---+---+---+---+---+--+--+
Ctrl |Alt  |Hide |             |Kanji ||||
-----+-----+-----+-------------+-----------+---+
";

char *kb_layout3="\
-----------------------------------------------+
Esc|                                       | BS|
---+---+---+---+---+---+---+---+---+---+---+---+
Han| q | w | e | r | t | y | u | i | o | p |Ent|
---+---+---+---+---+---+---+---+---+---+---+-  |
Zen | a | s | d | f | g | h | j | k | l | ; |er|
----+---+---+---+---+---+---+---+---+---+---+--|
Kata | z | x | c | v | b | n | m | , | . ||/ |
-----+---+---+---+---+---+---+---+---+---+--+--+
Dic | \\ | @ | - | = |          |Alpha ||||
-----+-----+-----+-------------+-----------+---+
";

struct {
	char *str;
	char *alt;
	int size;
	int attr;
	int val;
} conv_table[] = {
{"Esc"	,NULL	,12,0		,033},
{"BS"	,NULL	,12,0		,'\b'},
{"Tab"	,NULL	,12,0		,'\t'},
{"Caps"	,NULL	,12,0		,MK_V1},
{"Shift",NULL	,12,0		,MK_V2},
{"Ctrl"	,NULL	,12,0		,MK_V3},
{"Alt"	,NULL	,12,0		,MK_V4},
{"Hide"	,""	,12,0		,MK_V5},
{"Kanji",""	,12,0		,MK_V6},
{"Alpha","ѿ"	,12,0		,MK_V6},
{"Kata"	,""	,12,0		,MK_V7},
{"Han","Ⱦ"	,12,0		,MK_V9},
{"Zen",""	,12,0		,MK_V10},
{"Dic","Ͽ"	,12,0		,MK_V11},
{""	,NULL	,12,FA_BOLD	,MK_UP},
{""	,NULL	,12,FA_BOLD	,MK_LEFT},
{""	,NULL	,12,FA_BOLD	,MK_RIGHT},
{""	,NULL	,12,FA_BOLD	,MK_DOWN},
{"Enter","Ent"	,12,0		,'\n'},
{""	, "er",'\n'},
};

int conv_keyname(s) char *s; {
	int i;
	for (i=0; i<sizeof(conv_table)/sizeof(conv_table[0]); i++) {
		if (!strcmp(conv_table[i].str,s)) {
			if (conv_table[i].alt) {
				strcpy(s,conv_table[i].alt);
			}
			set_font(conv_table[i].size,conv_table[i].attr);
			return conv_table[i].val;
		}
	}
	set_font(12,0);
	return s[0];
}

struct screen *create_keymap(layout,v) char *layout; struct virtual_key *v; {
	static int cell_w = 5;
	static int ch = 16;
	char buf[1024];
	char *p,*top,*line_buf[10];
	int line_size[10];
	char key_name[20];
	int line = 0;
	int ln=0,ls=0;
	int x,xx,kx,w=0;
	int i,j,jmax,code;
	struct virtual_key *vk;
	struct screen *s;

	s = create_memscreen(240,(5*16+1),NULL,STK_GENERIC_4COLOR,0);
	if (!s) return NULL;
	push_screen(s);
	set_color(COLOR_WHITE);
	clear_screen();
	set_color(COLOR_BLACK);
//printf("create_keymap\n");
	strcpy(buf,layout);
	p = buf;
	top = buf;
	ls = 0;
	while (*p) {
		if ((*p == '-') || (*p == '+')) {
			ln++;
		}
		if (!ls && (*p == ' ')) ls = p - top;
		if (*p == '\n') {
			*p = 0;
			if (ln < 10) {
				line_buf[line] = top;
				line++;
			} else {
				line_size[line] = ls;
			}
			top = p+1;
			ln = ls = 0;
		}
		p++;
	}
	set_font(12,0);
	set_color(COLOR_DARKGRAY);
	draw_line(0,0,current_screen->width-1,0);
	for (i=0; i<line; i++) {
		jmax = strlen(line_buf[i]);
		xx = 0;
		p = line_buf[i];
		kx = 0;
		for (x=0; *p; p++,x++) {
			if (*p == '|' && p[1] != '|') {
				if (!kx) {
					key_name[kx++] = ' ';
				}
				key_name[kx] = 0;
				code = conv_keyname(key_name);
				w = ((x - xx)*cell_w) - (strlen(key_name)*6);
				w /= 2;
				vk = create_virtual_key(3+xx*cell_w,i*ch
						,(x-xx)*cell_w,ch,code);
				vk_attach(v,vk);
				set_color(COLOR_BLACK);
				draw_string(3+xx*cell_w+w,i*ch+2,key_name,0);
				set_color(COLOR_DARKGRAY);
				draw_line(3+x*cell_w,i*ch,3+x*cell_w,i*ch+ch);
				xx = x;
				kx = 0;
			}
			else if (*p == '|' && p[1] == '|') {
				key_name[kx++] = *p;
				p++;
			} else if (*p != ' ') {
				key_name[kx++] = *p;
			}
		}
		set_color(COLOR_DARKGRAY);
		if (line_size[i+1])
			draw_line(0,i*ch+ch,3+(line_size[i+1]-1)*cell_w,i*ch+ch);
		else
			draw_line(0,i*ch+ch,3+(x-1)*cell_w,i*ch+ch);
	}
	pop_screen();
	return s;
}

struct screen *keymap_s[3];
struct virtual_key *keymap_v[3];
int cur_layout = 0;

int main(argc, argv) {
	int i,c;
	struct virtual_key *v;
	struct screen *s;
	char *layout;
	int lock = 0;
	int kanji = 0;
	int new_layout = 0;

	//SCREEN_WIDTH =  240;
	//SCREEN_HEIGHT = 320;
	if (!open_graph()) {
		printf("initialized error\n");
		exit(1);
	}
printf("w = %d h = %d\n",SCREEN_WIDTH,SCREEN_HEIGHT);
	for (i=0; i<3; i++) {
		v = create_virtual_key(0,SCREEN_HEIGHT-(5*16+1),240,(5*16+1),MK_V0);
		s = create_keymap((i==0)?kb_layout1:
				  (i==1)?kb_layout2:kb_layout3,v);
		keymap_s[i] = s;
		keymap_v[i] = v;
	}
	set_font(12,0);
	set_color(COLOR_LIGHTGRAY);
	clear_screen();

	s = create_subscreen(NULL,0,SCREEN_HEIGHT-(5*16+1),240,(5*16+1));			
	vk_attach(NULL,keymap_v[cur_layout]);
	bitblt(s,0,0,keymap_s[cur_layout],0,0,-1,-1,0);

	while ((c = get_key(-1)) != 033) {
	    if (c == MK_V1) {
			lock = !lock;
	    }
	    if (c == MK_V6) {
			kanji = !kanji;
	    }
	    if (kanji) new_layout = 2;
	    else if (lock) new_layout = 1;
	    else new_layout = 0;
	    if (new_layout != cur_layout) {
		vk_detach(keymap_v[cur_layout],0);
		vk_attach(NULL,keymap_v[new_layout]);
		bitblt(s,0,0,keymap_s[new_layout],0,0,-1,-1,0);
		cur_layout = new_layout;
	    }
	}
	close_graph();
	exit(0);
}
