/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <canna/jrkanji.h>
#include "mgl2.h"

int im_read(char *ibuf, int ibufsize) {
	struct textscreen *ts2;
	char buf[256];
	jrKanjiStatus st;
	jrKanjiStatusWithValue ksv;
	int ret = 0;
	int c;
	char mode[256]="[  ]";
	int sw;
	int xx,xxs;
	int x,y;

	set_font(12,0);

	ksv.ks = &st;
	ksv.buffer = buf;
	ksv.bytes_buffer = 256;
	ksv.val = CANNA_MODE_HenkanMode;
	jrKanjiControl(0, KC_CHANGEMODE, (char *)(&ksv));

	st.info &= ~KanjiGLineInfo;
	st.length = 0;

	while(1) {
		sw = strlen(mode);
		if (st.info & KanjiGLineInfo) {
			sw += st.gline.length;
		} else if (st.length > 0) {
			sw += st.length;
		}
		sw = sw*6 + 8;

		if (sw > SCREEN_WIDTH) sw = SCREEN_WIDTH;

#if 0
		x =  0;
		y = SCREEN_HEIGHT-(16+12+8);
#else
		im_view_point(sw,12+8,&x,&y);
#endif
		ts2 = create_textscreen(NULL,x,y,sw,12+8
				,TS_SAVE|TS_BORDER|TS_BLINE);
		ts_clear(ts2);
		if (st.info & KanjiModeInfo) {
			strcpy(mode,st.mode);
		}
		set_color(COLOR_BLACK);
		ts_put_string(ts2,mode,0);
		if (st.info & KanjiGLineInfo) {
			ts_put_string(ts2,st.gline.line,0);
			if (st.gline.revLen > 0) {
				xx = 4+(st.gline.revPos+strlen(mode))*6;
				xxs = st.gline.revLen*6;
				set_color(COLOR_REVERSE);
				fill_rect(x+xx,y+4,xxs,12);
			}
		} else if (st.length > 0) {
			ts_put_string(ts2,st.echoStr,0);
			if (st.revLen > 0) {
				xx = 4+(st.revPos+strlen(mode))*6;
				xxs = st.revLen*6;
				set_color(COLOR_REVERSE);
				fill_rect(x+xx,y+4,xxs,12);
			}
		}
refresh();
		c = get_key(-1);
		switch (c) {
		case MK_F1:	 c = CANNA_KEY_F1; 	break;
		case MK_F2:	 c = CANNA_KEY_F2; 	break;
		case MK_F3:	 c = CANNA_KEY_F3; 	break;
		case MK_F4:	 c = CANNA_KEY_F4; 	break;
		case MK_F5:	 c = CANNA_KEY_F5; 	break;
		case MK_F6:	 c = CANNA_KEY_F6; 	break;
		case MK_F7:	 c = CANNA_KEY_F7; 	break;
		case MK_F8:	 c = CANNA_KEY_F8; 	break;
		case MK_F9:	 c = CANNA_KEY_F9; 	break;
		case MK_F10:	 c = CANNA_KEY_F10; 	break;
		case MK_F11:	 c = CANNA_KEY_Nfer; 	break;
		case MK_F12:	 c = CANNA_KEY_Xfer; 	break;
		case MK_HOME:	 c = CANNA_KEY_Home;	break;
		case MK_END:	 c = CANNA_KEY_Help;	break;
		case MK_UP:	 c = CANNA_KEY_Up;	break;
		case MK_DOWN:	 c = CANNA_KEY_Down;	break;
		case MK_LEFT:	 c = CANNA_KEY_Left;	break;
		case MK_RIGHT:	 c = CANNA_KEY_Right;	break;
		case MK_PAGE_UP: 	c = CANNA_KEY_Rolldown;	break;
		case MK_PAGE_DOWN:	c = CANNA_KEY_Rollup;	break;
		case MK_INS:	 c = CANNA_KEY_Insert;	break;
		}
		ret = jrKanjiString(0,c,ibuf,ibufsize,&st);
		free_textscreen(ts2);
		if (ret >=0 && c == ('O'&0x1f) && (st.info & KanjiEmptyInfo)) {
			ibuf[ret] = c;
			ret++;
refresh();
			return ret;
		}
		else if (ret > 0) {
refresh();
			return ret;
		}
	}
}
