/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

const static int same_format=1;
#ifdef SUPPORT_LINUXFB_CFB4
#  define MD_PUT_SCANSEGMENT fb4_put_scansegment
#else
#  define MD_PUT_SCANSEGMENT fb2_put_scansegment
#endif

const static int show_mouse=0;
#define TOUCH_DEVICE            "/dev/touch_psion"
static struct touch_psion_event event;
static int                      mouse_fd;

static int open_touch(){
    mouse_fd = -1;
    mouse_fd = open(TOUCH_DEVICE, O_RDONLY);
    if (mouse_fd < 0) { return -1; }
    do_mouse_smooth = 1;
    return 0;
}

static void close_touch(){
    if (mouse_fd >= 0) close(mouse_fd);
}

static int MD_MOUSE_EVENT() {
    int r;
    fd_set fds;
    struct timeval to;
    struct touch_psion_event ev;

    if (mouse_fd < 0) return -1;

    FD_ZERO(&fds);
    FD_SET(mouse_fd,&fds);
    to.tv_sec = 0;
    to.tv_usec = 0;
    if (select(mouse_fd+1,&fds,0,0,&to) != 1) return 0;
    r = read(mouse_fd,&ev,sizeof(ev));
    if (r < 0) {
	close(mouse_fd);
	mouse_fd = -1;
	return -1;
    }
    if(r == 0){
	printf("lost mouse event?\n");
	return 0;
    }

    event = ev;
    return 1;
}

static void MD_SET_MOUSEXY(int x,int y) {
    event.x_c = x;
    event.y_c = y;
}

static inline int MD_MOUSE_X() { return event.x_c; }
static inline int MD_MOUSE_Y() { return event.y_c; }
static inline int MD_MOUSE_BUTTON() { return event.down; }
