/*
 * MGL -- MobileGear Graphic Library -
 * Copyright (C) 1998, 1999
 *      Koji Suzuki (suz@at.sakura.ne.jp)
 *      Yukihiko Sano (yukihiko@yk.rim.or.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY KOJI SUZUKI AND YUKIHIKO SANO ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MGLKEY_H /* _MGLKEY_H */
#define _MGLKEY_H

#define MGL_NR_KEYS	128

/* common keycodes */

#define	MGL_KEY_ESC		  1
#define	MGL_KEY_1		  2
#define	MGL_KEY_2		  3
#define	MGL_KEY_3		  4
#define	MGL_KEY_4		  5
#define	MGL_KEY_5		  6
#define	MGL_KEY_6		  7
#define	MGL_KEY_7		  8
#define	MGL_KEY_8		  9
#define	MGL_KEY_9		 10
#define	MGL_KEY_0		 11
#define	MGL_KEY_MINUS		 12
#define	MGL_KEY_EQUAL		 13
#define	MGL_KEY_ASCIICIRCUM_J	 13	/* ^ */
#define	MGL_KEY_BACKSPACE	 14


#define	MGL_KEY_TAB		 15
#define	MGL_KEY_Q		 16
#define	MGL_KEY_W		 17
#define	MGL_KEY_E		 18
#define	MGL_KEY_R		 19
#define	MGL_KEY_T		 20
#define	MGL_KEY_Y		 21
#define	MGL_KEY_U		 22
#define	MGL_KEY_I		 23
#define	MGL_KEY_O		 24
#define	MGL_KEY_P		 25
#define	MGL_KEY_LBRACKET_E	 26
#define	MGL_KEY_AT_J		 26
#define	MGL_KEY_RBRACKET_E	 27
#define	MGL_KEY_LBRACKET_J	 27
#define	MGL_KEY_ENTER		 28


#define	MGL_KEY_CAPS		 29
#define	MGL_KEY_A		 30
#define	MGL_KEY_S		 31
#define	MGL_KEY_D		 32
#define	MGL_KEY_F		 33
#define	MGL_KEY_G		 34
#define	MGL_KEY_H		 35
#define	MGL_KEY_J		 36
#define	MGL_KEY_K		 37
#define	MGL_KEY_L		 38
#define	MGL_KEY_SEMICOLON_J	 39
#define	MGL_KEY_SEMICOLON_E	 39
#define	MGL_KEY_APOSTROPHE_E	 40
#define	MGL_KEY_COLON_J		 40
#define	MGL_KEY_GRAVE_E		 41	/* ` */
#define	MGL_KEY_HANZEN_J	 41


#define	MGL_KEY_SHIFT		 42
#define	MGL_KEY_RBRACKET_J	 43
#define	MGL_KEY_Z		 44
#define	MGL_KEY_X		 45
#define	MGL_KEY_C		 46
#define	MGL_KEY_V		 47
#define	MGL_KEY_B		 48
#define	MGL_KEY_N		 49
#define	MGL_KEY_M		 50
#define	MGL_KEY_COMMA		 51
#define	MGL_KEY_PERIOD		 52
#define	MGL_KEY_SLASH		 53
#define	MGL_KEY_CTRL		 58
#define	MGL_KEY_ALT		 56
#define	MGL_KEY_SPACE		 57


#define	MGL_KEY_UP		 95
#define	MGL_KEY_PAGEUP		 96
#define	MGL_KEY_RIGHT		 98
#define	MGL_KEY_LEFT		 97
#define	MGL_KEY_DOWN		100
#define	MGL_KEY_PAGEDOWN	101
#define	MGL_KEY_INS		102
#define	MGL_KEY_DEL		103
#define	MGL_KEY_DEL_ALT		 83
#define	MGL_KEY_HOME		 94
#define	MGL_KEY_END		 99
#define	MGL_KEY_BACKSLASH_UNDER	115
#define	MGL_KEY_BACKSLASH_BAR_E	 43
#define	MGL_KEY_BACKSLASH_BAR_J	125

#define MGL_KEY_MENU		105

#define	MGL_KEY_F1		 59
#define	MGL_KEY_F2		 60
#define	MGL_KEY_F3		 61
#define	MGL_KEY_F4		 62
#define	MGL_KEY_F5		 63
#define	MGL_KEY_F6		 64
#define	MGL_KEY_F7		 65
#define	MGL_KEY_F8		 66
#define	MGL_KEY_F9		 67
#define	MGL_KEY_F10		 68


/* other keycodes */

#define	MGL_EXKEY_RSHIFT	 54
#define MGL_EXKEY_MULT           55
#define MGL_EXKEY_NUMLOCK        69
#define MGL_EXKEY_SCREENLOCK     70
#define MGL_EXKEY_7              71
#define MGL_EXKEY_8              72
#define MGL_EXKEY_9              73
#define MGL_EXKEY_MINUS          74
#define MGL_EXKEY_4              75
#define MGL_EXKEY_5              76
#define MGL_EXKEY_6              77
#define MGL_EXKEY_PLUS           78
#define MGL_EXKEY_1              79
#define MGL_EXKEY_2              80
#define MGL_EXKEY_3              81
#define MGL_EXKEY_0              82
#define MGL_EXKEY_F11            87
#define MGL_EXKEY_F12            88
#define MGL_EXKEY_HOME           89
#define MGL_EXKEY_RCTRL          90
#define MGL_EXKEY_DIV            91
#define MGL_EXKEY_PRINT          92
#define MGL_EXKEY_RALT           93

#define MGL_EXKEY_PAUSE           104
#define MGL_EXKEY_RMENU           106
#define MGL_EXKEY_SELECT          107

#define MGL_EXKEY_KANA          112
#define MGL_EXKEY_KANJI         121
#define MGL_EXKEY_MUHENKAN      123

/* internel key symbols */

#define MK_NONE			(-1)

#define MKE_BASE		0x120

#define MKE_0			(MKE_BASE+0)
#define MKE_1			(MKE_BASE+1)
#define MKE_2			(MKE_BASE+2)
#define MKE_3			(MKE_BASE+3)
#define MKE_4			(MKE_BASE+4)
#define MKE_5			(MKE_BASE+5)
#define MKE_6			(MKE_BASE+6)
#define MKE_7			(MKE_BASE+7)
#define MKE_8			(MKE_BASE+8)
#define MKE_9			(MKE_BASE+9)
#define MKE_PLUS		(MKE_BASE+10)
#define MKE_MINUS		(MKE_BASE+11)
#define MKE_MULT		(MKE_BASE+12)
#define MKE_DIV			(MKE_BASE+13)
#define MKE_BREAK		(MKE_BASE+14)
#define MKE_HANZEN		(MKE_BASE+15)
#define MKE_KANJI		(MKE_BASE+16)
#define MKE_MUHENKAN		(MKE_BASE+17)
/*#define MKE_NUMLOCK		(MKE_BASE+18) move to MK_NUMLOCK */
#define MKE_SCRLOCK		(MKE_BASE+19)
#define MKE_SELECT		(MKE_BASE+20)
#define MKE_DEL			(MKE_BASE+21)
#define MKE_HOME		(MKE_BASE+22)
#define MKE_PRINT		(MKE_BASE+23)
#define MKE_PAUSE		(MKE_BASE+24)
#define MKE_RMENU		(MKE_BASE+25)
#define MKE_END			(MKE_BASE+26)
#define MKE_UP			(MKE_BASE+27)
#define MKE_DOWN		(MKE_BASE+28)
#define MKE_RIGHT		(MKE_BASE+29)
#define MKE_LEFT		(MKE_BASE+30)
#define MKE_INS			(MKE_BASE+31)
#define MKE_PAGE_UP		(MKE_BASE+32)
#define MKE_PAGE_DOWN		(MKE_BASE+33)
#define MKE_BEGIN		(MKE_BASE+34)
#define MKE_RETURN		(MKE_BASE+35)
#define MKE_EXECUTE		(MKE_BASE+36)
#define MKE_HENKAN		(MKE_BASE+37)

#define MKE_PROC_BASE           (MKE_BASE+38)
#define MKE_POWER_OFF		(MKE_PROC_BASE+0)
#define MKE_CONTRAST_UP		(MKE_PROC_BASE+1)
#define MKE_CONTRAST_DOWN	(MKE_PROC_BASE+2)
#define MKE_BRIGHTNESS_UP	(MKE_PROC_BASE+3)
#define MKE_BRIGHTNESS_DOWN	(MKE_PROC_BASE+4)
#define MKE_BACKLIGHT_TOGGLE	(MKE_PROC_BASE+5)
#define MKE_DIAL		(MKE_PROC_BASE+6)
#define MKE_PLAY		(MKE_PROC_BASE+7)
#define MKE_STOP		(MKE_PROC_BASE+8)
#define MKE_RECORD		(MKE_PROC_BASE+9)
#define MKE_SWITCH_WINDOW	(MKE_PROC_BASE+10)
#define MKE_SWITCH_FOCUS	(MKE_PROC_BASE+11)
#define MKE_CONSOLE		(MKE_PROC_BASE+12)
#define MKE_CONSOLE_1		(MKE_CONSOLE + 1)
#define MKE_CONSOLE_2		(MKE_CONSOLE + 2)
#define MKE_CONSOLE_3		(MKE_CONSOLE + 3)
#define MKE_CONSOLE_4		(MKE_CONSOLE + 4)
#define MKE_CONSOLE_5		(MKE_CONSOLE + 5)
#define MKE_CONSOLE_6		(MKE_CONSOLE + 6)
#define MKE_CONSOLE_7		(MKE_CONSOLE + 7)
#define MKE_CONSOLE_8		(MKE_CONSOLE + 8)
#define MKE_CONSOLE_9		(MKE_CONSOLE + 9)
#define MKE_CONSOLE_10		(MKE_CONSOLE + 10)

#define MKE_SIGNAL_SIZE		(MKE_CONSOLE_10 - MKE_PROC_BASE + 1)

#define MKE_F13			(MKE_CONSOLE_10 + 1)
#define MKE_F14			(MKE_F13 + 1)
#define MKE_F15			(MKE_F13 + 2)
#define MKE_F16			(MKE_F13 + 3)
#define MKE_F17			(MKE_F13 + 4)
#define MKE_F18			(MKE_F13 + 5)
#define MKE_F19			(MKE_F13 + 6)
#define MKE_F20			(MKE_F13 + 7)
#define MKE_F21			(MKE_F13 + 8)
#define MKE_F22			(MKE_F13 + 9)
#define MKE_F23			(MKE_F13 + 10)
#define MKE_F24			(MKE_F13 + 11)

#define MKE_SIZE		(MKE_F24 - MKE_BASE + 1)

 /*
   RAW, EXTRANSLATED ⡼ɻ
   ܥˤäƵư٤ꤹ롣
   ͭʥܥ:
         MKE_POWER_OFF
         MKE_CONTRAST_UP
         MKE_CONTRAST_DOWN
         MKE_BRIGHTNESS_UP
         MKE_BRIGHTNESS_DOWN
         MKE_BACKLIGHT_TOGGLE
         MKE_DIAL
         MKE_PLAY
         MKE_STOP
         MKE_RECORD
         MKE_SWITCH_WINDOW
         MKE_SWITCH_FOCUS
         MKE_CONSOLE
         MKE_CONSOLE_1
         MKE_CONSOLE_2
         MKE_CONSOLE_3
         MKE_CONSOLE_4
         MKE_CONSOLE_5
         MKE_CONSOLE_6
         MKE_CONSOLE_7
         MKE_CONSOLE_8
         MKE_CONSOLE_9
         MKE_CONSOLE_10
   ͭʥ:
	 MD_PROC_IGN
	 MD_PROC_DFL
	 MD_PROC_ERR
	 MD_PROC_BRIGHTNESS
	 MD_PROC_BACKLIGHT
	 MD_PROC_CONTRAST
	 MD_PROC_POWER_OFF
	 MD_PROC_PLAY
         MD_PROC_WINDOW
         MD_PROC_FOCUS
	 MD_PROC_CONSOLE
  */

int (*mgl2_signal(int, int (*handler)(int)))(int);

typedef int (*__mgl2_sig_handler_t)(int);
#define MD_PROC_IGN        ((__mgl2_sig_handler_t)0)
#define MD_PROC_DFL        ((__mgl2_sig_handler_t)1)
#define MD_PROC_ERR        ((__mgl2_sig_handler_t)-1)

#endif /* _MGLKEY_H */
