/*
 * tptrans.h
 * Coordinate transform for touch panel.
 * Copyright 1999 Bradley D. LaRonde
 */ 

#define TRANSFORMATION_UNITS_PER_PIXEL 4

typedef struct
{
	/*
	 * Coefficients for the transformation formulas:
	 *
	 *     m = (ax + by + c) / s
	 *     n = (dx + ey + f) / s
	 *
	 * These formulae will transform a device point (x, y) to a
	 * screen point (m, n) in fractional pixels.  The fraction
	 * is 1 / TRANSFORMATION_UNITS_PER_PIXEL.
	 */

	int a, b, c, d, e, f, s;
} TRANSFORMATION_COEFFICIENTS;
