---
title: "Grafana Mimir Helm chart version 4.5 release notes"
menuTitle: "V4.5 release notes"
description: "Release notes for Grafana Mimir Helm chart version 4.5"
weight: 300
---

# Grafana Mimir Helm chart version 4.5 release notes

Grafana Labs is excited to announce version 4.5 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.9 or Grafana Enterprise Metrics (GEM) v2.9. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

To learn about new features and enhancements in Grafana Mimir or GEM, see the release notes for [Grafana Mimir v2.9](/docs/mimir/v2.9.x/release-notes/v2.9/) or [Grafana Enterprise Metrics v2.9](/docs/enterprise-metrics/v2.9.x/release-notes/v2-9/).

The highlights that follow include the top features, enhancements, and bugfixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

> **Note:** If you are upgrading from a previous major version, review the changelog entry for all the major releases since then and perform the necessary migrations.

## Important changes

- **The `graphite-web` component was removed** from the graphite proxy. The `graphite-web` component had several configuration issues which meant it was failing to process requests. The `graphite-web` component was used to render queries that the native query engine cannot, however the majority of graphite functions and features are supported by the native GEM graphite query engine and there is development ongoing to reach feature parity.
- **Cardinality estimation is enabled** in the query-frontend via `frontend.query_sharding_target_series_per_shard` in the Mimir configuration for query sharding by default if `results-cache.enabled` is true. This change improves query performance in case the overhead of query sharding is more than its benefit.

## Features and enhancements

Notable enhancements are as follows:

- The Nginx read timeout (`proxy_read_timeout`) is increased to 300 seconds (increase from default 60 seconds), so that it doesn't interfere with the querier's default 120 seconds timeout (`mimir.structuredConfig.querier.timeout`).
- Store-gateway: set `GOMEMLIMIT` to the memory request value. This should reduce the likelihood the store-gateway may go out of memory, at the cost of an higher CPU utilization due to more frequent garbage collections when the memory utilization gets closer or above the configured requested memory.
- Store-gateway: dynamically set `GOMAXPROCS` based on the CPU request. This should reduce the likelihood a high load on the store-gateway will slow down the entire Kubernetes node.
- Added `global.podLabels` which can add POD labels to PODs directly controlled by this chart (mimir services, nginx).
- Enabled the `track_sizes` feature for Memcached pods to help determine cache efficiency.

## Bug fixes

- [PR 5031](https://github.com/grafana/mimir/pull/5031) Fix Pod Anti-Affinity rule to allow ingesters from the same zone to run on same node, by using `zone` label since the old `app.kubernetes.io/component` did not allow for this.
