---
title: "Grafana Mimir Helm chart version 5.5 release notes"
menuTitle: "V5.5 release notes"
description: "Release notes for Grafana Mimir Helm chart version 5.5"
weight: 300
---

# Grafana Mimir Helm chart version 5.5 release notes

Grafana Labs is excited to announce version 5.5 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.14 or Grafana Enterprise Metrics (GEM) v2.14. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

The highlights that follow include the top features, enhancements, and bug fixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

## Important changes

- The ingester is configured with `GOMAXPROCS` to help with overhead from the Go scheduler, observed on hosts with a large number of CPU cores.
- The GEM query-frontend logs the query author's access policy name and token name in the query statistics logs. This provides more visibility as which token is running a potentially expensive query.
- Dashboards are updated to allow switching between classic and native histograms in the queries that support it.

## Features and enhancements

Notable enhancements are as follows:

- The dashboard configuration maps support setting a namespace.
- The `topologySpreadConstraints` configuration of all components is updated to better match what is allowed in Kubernetes.
- Metamonitoring supports AWS Signature Version 4 (sigv4) authentication for remote write.
- Metamonitoring is updated to allow its Grafana Agent pods to set image pull secrets, node selectors, tolerances, topology spread constraints, and resource requests and limits.
- The continous-test is updated to allow setting separate read and write URLs.
- The continous-test can be enabled in GEM.
