#ifndef __FMT_OPTS_H__
#define __FMT_OPTS_H__

#include "config.h"
#include "common.h"
#include <stack>
#include <vector>
#include <deque>
#include <map>

struct color {
   int r, g, b;
   color() : r(-1), g(-1), b(-1) {}
   bool operator==(const color &clr) const
   {
      return r==clr.r && g==clr.g && b==clr.b;
   }
   bool operator!=(const color &clr) const
   {
      return !(*this==clr);
   }
};

typedef std::vector<color> colorvect;

struct font {
   enum font_family {ff_none, ff_serif, ff_sans_serif, ff_cursive, 
                     ff_fantasy, ff_monospace};
   font_family family;
   std::string name;
   int pitch;
   int charset;
   font() : family(ff_none), name(), pitch(0), charset(0) {}
   bool operator==(const font &f) const
   {
      return family==f.family && name==f.name;
   }
   bool operator!=(const font &f) const
   {
      return !(*this==f);
   }
};

typedef std::map<int, font> fontmap;
typedef std::map<std::string, std::string> strmap;

struct formatting_options
{
   static strmap styles;
   enum halign {align_left, align_right, align_center, align_justify, align_error};
   enum valign {va_normal, va_sub, va_sup};
   bool chpBold, chpAllCaps, chpItalic, chpUnderline;
   valign chpVAlign;
   int chpFontSize, chpHighlight, chpVShift;
   color chpFColor, chpBColor;
   font chpFont;
   int papLeft, papRight, papFirst;
   int papBefore, papAfter;
   halign papAlign;
   bool papInTbl;
   formatting_options()
   {
      chpBold=chpAllCaps=chpItalic=chpUnderline=false;
      chpVAlign=va_normal;
      chpFontSize=chpHighlight=chpVShift=0;
      papLeft=papRight=papFirst=papBefore=papAfter=0;
      papAlign=align_left;
      papInTbl=false;
   }
   bool operator==(const formatting_options &opt) const // tests only for character options
   {
      return chpBold==opt.chpBold && chpAllCaps == opt.chpAllCaps
             && chpItalic==opt.chpItalic
             && chpUnderline==opt.chpUnderline && chpVAlign==opt.chpVAlign
             && chpFontSize==opt.chpFontSize
             && chpFColor==opt.chpFColor && chpBColor==opt.chpBColor
             && chpHighlight==opt.chpHighlight && chpFont==opt.chpFont
             && chpVShift==opt.chpVShift;
   }
   bool operator!=(const formatting_options &opt) const // tests only for character options
   {
      return !(*this==opt);
   }
   std::string get_par_str() const;
   static std::string get_style_id(const std::string &style);
   static std::string get_styles();
};

typedef std::stack<formatting_options> fo_stack;

typedef std::deque<formatting_options> fo_deque;

class formatter {
 private:
   fo_deque opt_stack;
 public:
   std::string format(const formatting_options &opt);
   std::string close();
   void clear() { opt_stack.clear(); }
};

class html_text {
 private:
   const formatting_options &opt;
   formatter fmt;
   std::string text;
 public:
   html_text(const formatting_options &_opt) : opt(_opt) {}
   const std::string &str() { return text; }
   template <class T> void write(T s)
   {
      text+=fmt.format(opt)+s;
   }
   std::string close() { return fmt.close(); }
//   void write(char c) { write(std::string()+c); }
   void clear() { text.clear(); fmt.clear(); }
};

#endif

