#!/usr/bin/perl

##################################################################################
# filter_example1.pl                                            Updated 03/15/2002
#
# Simple example perl automation filter script for NapShare.
#
# This gets the information line from NapShare, breaks it up and prints
# the info to a log file as a test. If the word "jpg" is anywhere in the
# file name, it will queue the file. See other perl scripts for more examples.
#
# Always test your perl programs from a command prompt first, and beware of
# strange results returned by other clients.
#
# This was called with filter "extern" and the string
# "???perl filter_example1.pl", you can take out the ??? later but it will
# show you the time it took to run this program. It's important not to
# spend too much time here or you will lose network connections and strange
# things may happen as timers overlap. NapShare is waiting for you to return.
# If you see a lot of "Time 1s 16ms" returned, meaning it takes > 1 second to
# execute this routine most of the time, then you probably need a faster
# CPU to do what you want to do with perl. Try doing it with a shell script or
# compile your own C program. If you only filter a few files every 10 seconds
# or so, you may be ok. Nodes generally drop after about 6 seconds of inactivity.
# If you put this filter last after all the other builtin filters it will help.
#
# Permissions were set to 755 (CHMOD 755).
#
# "size" is in bytes, "speed" depends on what the other user sets it to, "search"
# is the search phrase that was sent out to the network (512 chars max).
#
# The "status" variable is sent as a decimal int but is really a uint16,
# see search.h for bit positions. You would have to convert it and use &&
# to pick out the bits. With it you could filter out files from servers that
# show busy or show they need a push.
#
# The "tag" variable is the raw data found between the two "nulls" in a
# query hit. This can contain a forward slash and that's why it comes last. You
# will find MP3 bitrates and hashes "sha1:" returned from some clients.
#
##################################################################################


### My Local Variables

# The name of the log file to write to
$LogFile = "filter_log.txt";


### The program

	# get the entire information line from NapShare
	$instring = $ARGV[0];

	# here we split the string up into filename, size...
	($filename, $size, $speed, $status, $search, $tag) = split(/\//,$instring,6);

	# open the log file
	if (-e $LogFile) {  # file exist, open with append
		open(LOG,">>$LogFile") || die("Can't open $LogFile: $!\n");
		}
	else {  # new logfile open with write access
		open(LOG,">$LogFile") || die("Can't open $LogFile: $!\n");
		}


&gettime;  # go get the time

	print LOG<<EOH;
Time: $date
Line: $instring
Filename: $filename
Size: $size
Speed: $speed
Status: $status
Search: $search
Tag: $tag

EOH

	close(LOG);

	# here we check for the word "jpg" if it's anywhere in the filename, queue the file
	# this check is done with "regex" for more info see http://www.perldoc.com/
	if ($filename =~ /jpg/) {
		exit 0;  # exit - yes, queue the file
		}

exit 1; # exit - don't queue the file



### Example exit lines

## exit 1;  # exit - don't queue the file

## exit 0;  # exit - yes, queue the file



##############################################################################
#	Generate time.
##############################################################################
sub gettime {
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	$year = $year + 1900;
	$date = sprintf("%02d:%02d:%02d %02d/%02d/%04d",
		$hour,$min,$sec,$mon+1,$mday,$year);
	$day = sprintf("%02d/%02d/%04d",$mon+1,$mday,$year);
	$today = sprintf("%02d",$mday);
	$month = sprintf("%02d",$mon+1);
}





