
#include "gnutella.h"

#include <signal.h>

// include when using mcheck
// #include <mcheck.h>

#include "interface.h"
#include "support.h"

#include "search.h"
#include "filter.h"

// how many downloads to attempt for every 1 you really want
#define main_try_downloads 3


/* */

GtkWidget *main_window;

struct gnutella_socket *s_listen = NULL;

static gint main_timer_slow_update = 0;
static gint main_timer_update5 = 0;

static guint main_host_idx = 0;

static guint main_host_first = 1;

static guint main_hostcache_timer = 20;

static guint main_netup_timer = 20;

static gboolean netup = TRUE;

static guint hostctr = 0;

static gboolean left_label_clear = TRUE;

guint main_connected_hosts = 0;

gboolean onetime = FALSE; // for mcheck use


/* */

void napshare_exit(gint type)
{

/* needed for new clean up code
	GSList *l = (GSList *) NULL;
	struct gnutella_node *n;
	struct download *d;
	struct upload *u;
*/

	if (auto_enabled) search_reissue_timeout = auto_save_search_reissue_timeout;
	config_save();

/* V1.3 - I tried to get this new clean up part to work, but it still throws a segfault
   every once and a while so screw it for now, it works without this fine. If you
   know why this segfaults and have tested it more than 10 times, post a patch!
   I was trying to make my memory leak checker happy at exit.

	stop_host_get = 1; // just in case
	up_connections = 0;
	max_connections = 0;
	max_downloads = 0;
	max_host_downloads = 0;
	max_uploads = 0;
	netup = FALSE;

	l = sl_nodes;
	while (l) // remove all node connections now
	{
		n = (struct gnutella_node *) l->data;
		if (n) {
			node_remove(n, "Exit", 0);
			node_real_remove(n);
			}
		l = l->next;
	}

	l = sl_downloads;
	while (l) // abort all downloads
	{
		d = (struct download *) l->data;
		if (d && (d->status != GTA_DL_QUEUED)) {
			d->visible = FALSE; // fake it so no need for gui update
			download_abort(d);
			}
		l = l->next;
	}

	l = uploads;
	while (l) // abort all uploads
	{
		u = (struct upload*) l->data;
		if (u) {
			u->status = GTA_UL_COMPLETE; // for no gui update
			upload_remove(u, "Exit");
			}
		l = l->next;
	}
*/

	if (hosts_idle_func) gtk_idle_remove(hosts_idle_func);

	gtk_exit(type);
}

static void SIG_Handler(int n)
{
	napshare_exit(1);
}

static void SIG_Ignore(int n)
{
	return;
}



static void main_connect_cache(void)
{

	gchar tmp[512];

	/*
	 * Round-robin selection of a host catcher, and addition to the list of
	 * nodes, if not already connected to it. urlcache is a pointer to a string
	 */

	if (main_host_first) { // at startup of program pick a random place to start
		main_host_idx = rand() % WEBCACHEURLS; // we also check to limit the number just in case
		if (main_host_idx >= WEBCACHEURLS || main_host_idx < 0) main_host_idx = 0;
		main_host_first = 0;
		}

	if (urlcache[main_host_idx] == NULL) main_host_idx = 0;

	if (urlcache[main_host_idx] != NULL) {
		if (dbg) printf("Trying online static host cache #%d '%s'\n", main_host_idx, urlcache[main_host_idx]);
		g_snprintf(tmp, sizeof(tmp), "Trying host catcher: %s", urlcache[main_host_idx]);
		gtk_label_set(GTK_LABEL(label_left), tmp);
		left_label_clear = FALSE;
		hosts_urlcache_open_socket(urlcache[main_host_idx]);
		main_host_idx++;
		}


}


gboolean main_timer(gpointer p)
{
	GSList *l = (GSList *) NULL;
	struct gnutella_node *n;
	struct download *d;
	guint32 t;
	guint row, dnlds;
	gint missing, max;

	// If we are under the number of connections wanted, we try to connect to
	// up_connections * 3, and stop if we get connected to up_connections limit
	// this lets us try more connections till we get what we want. You may
	// end up with a few more than you wanted at first.
	// if stop_host_get is set, don't load any hosts (for local testing)

	max = 0;
	if (nodes_active < up_connections) {
		max = ((up_connections - nodes_active) * 3) + nodes_active;
		}

	if ((nodes_active < up_connections) && (nodes_in_list < max)
				&& (main_netup_timer++ > 10) && !stop_host_get) {
		if (sl_catched_hosts != NULL) {
			struct gnutella_host *host, *host2;

			missing = up_connections - nodes_active;

			while (missing-- > 0 && sl_catched_hosts) {
				host = (struct gnutella_host *) sl_catched_hosts->data; // pull from top of list
				if (host) {
					node_add(NULL, host->ip, host->port);
					if (nodes_errno == 101) { // 101 network unreachable, try another in host cache to check
						host2 = (struct gnutella_host *) g_slist_nth_data (sl_catched_hosts, hostctr);
						if (host2 == NULL) hostctr = 0; // end of list, start over
						else { // this is like a network "hickup" but will kick start us again shortly
							node_add(NULL, host2->ip, host2->port); // hope they send us some new IPs
							hostctr++; // try a different one next time
							if (nodes_errno != 101) { // no error so we may have network access
								host_remove(host, TRUE); // remove offending host, bad address
								host_remove(host2, TRUE); // good host, do normal remove
								break;
								}
							}
						main_netup_timer = 0; // wait a while before trying again
						netup = FALSE;
						break;
						}
					else {
						main_netup_timer = 20; // don't wait anymore, we are online
						host_remove(host, TRUE); // remove it from host cache list
						netup = TRUE;
						}
					}
				}
			} // no hosts in list, hit a new online static host cache every 15 seconds or so
		else if (main_hostcache_timer++ > 15) {
				main_connect_cache();
				main_hostcache_timer = 0;
				}
		}

	/* The nodes */

	l = sl_nodes;
	main_connected_hosts = 0;

	while (l && !stop_host_get) // we never timeout if stop_host_get is set
	{
		n = (struct gnutella_node *) l->data;
		l = l->next;

		if (n->status == GTA_NODE_CONNECTED) main_connected_hosts++;
		if (n->status == GTA_NODE_REMOVING && (time((time_t *) NULL) - n->last_update) > 3) node_real_remove(n);
		// connection timeout? don't try it again
		else if (n->status == GTA_NODE_CONNECTING && (time((time_t *) NULL) - n->last_update) > node_connecting_timeout) node_remove(n, "Timeout", 0);
		else if ((time((time_t *) NULL) - n->last_update) > node_connected_timeout) node_remove(n, "Timeout", 0);
	}

	/* The downloads */

	l = sl_downloads;
	while (l)
	{
		d = (struct download *) l->data;
		l = l->next;

		switch (d->status)
		{
			case GTA_DL_RECEIVING:
			case GTA_DL_HEADERS:
			case GTA_DL_PUSH_SENT:
			case GTA_DL_CONNECTING:
			case GTA_DL_REQ_SENT:
			case GTA_DL_FALLBACK:
			{
				if (time((time_t *) NULL) - d->last_update < 10) break;

				switch (d->status)
				{
					case GTA_DL_PUSH_SENT:
					case GTA_DL_FALLBACK:
						t = download_push_sent_timeout; break;

					case GTA_DL_CONNECTING:
						t = download_connecting_timeout; break;

					default:
						t = download_connected_timeout;
				}

				if (time((time_t *) NULL) - d->last_update > t)
				{
					if (d->status == GTA_DL_CONNECTING)
						download_fallback_to_push(d, FALSE);
					else {
						if (++d->retries <= download_max_retries) download_retry(d);
						else download_stop(d, GTA_DL_ERROR, "Timeout, Stop");
					}
				}

				break;
		  }
		  case GTA_DL_TIMEOUT_WAIT:
		  {
				download_queue(d); /* Just stick it back in the queue, have it wait there
				if (time((time_t *) NULL) - d->last_update > d->timeout_delay)
					 download_start(d);
				else gui_update_download(d,FALSE);*/
				break;
		  }
		}
	}

	if (clear_downloads) downloads_clear_stopped(TRUE, FALSE);


	/* Uploads */

	for (l = uploads; l; l = l->next) {
		if ((struct upload*)l->data) {
			if (((struct upload*)l->data)->status != GTA_UL_COMPLETE) {
				gui_update_upload((struct upload*)l->data);
				}
			}
		}


	/* Auto */

	if (auto_enabled) auto_brain();

	/* GUI update */

	gui_update_global();
	gui_update_stats();

	if (main_timer_update5++ >= 5) { // every 5 seconds
		main_timer_update5 = 0;
		}

	if (main_timer_slow_update++ > 20) { // update anything that changes slow here
		main_timer_slow_update = 0;
		gui_update_config_port(); // show our current IP:Port

		if (!left_label_clear) {
			gtk_label_set(GTK_LABEL(label_left), ""); // it's a gui thing
			left_label_clear = TRUE;
			}

/*
		if (!onetime) {	// this starts mcheck here, you can start it elsewhere
								// we wait 20 seconds to get gui settled
			setenv("MALLOC_TRACE", "trace.txt", 1);
			mtrace();
			onetime = TRUE;
			}
*/
		}

if (!netup) {
	gtk_widget_set_sensitive(button_host_catcher_get_more, FALSE);
	gtk_widget_set_sensitive(button_search, FALSE);
	return TRUE; // skip the rest if the net is down
	}

	// Here we start downloads from the queue, we will try for main_try_downloads for each one you want

	gtk_clist_freeze(GTK_CLIST(clist_download_queue));
	row=0;
	dnlds = count_running_downloads();
	while (row<GTK_CLIST(clist_download_queue)->rows
			&& dnlds < max_downloads
			&& (count_attempted_downloads() - dnlds) < ((max_downloads - dnlds) * main_try_downloads)) {
		d = (struct download *) gtk_clist_get_row_data(GTK_CLIST(clist_download_queue), row);

		if (!(d)->status == GTA_DL_QUEUED) {
			g_warning("main_timer(): Download '%s' is not in queued state ! (state = %d)\n", d->file_name, d->status);
			continue;
			}

		if (auto_enabled) { // for automation, clear out old files from queue
			if (time((time_t *) NULL) - d->queue_date > auto_flush_timeout) {
				download_free(d); // once cleared a new search may start, fresh data
				continue; // try the next one in the list, this one is gone
				}
			}

		if (count_running_downloads_with_guid(d->guid) < max_host_downloads
				&& count_running_downloads_with_name(d->file_name) == 0) {
			if (time((time_t *) NULL) - d->last_update > d->timeout_delay) {  // wait to restart
				download_start(d);
				break;
				}
			}
		row++;
		}
	gtk_clist_thaw(GTK_CLIST(clist_download_queue));

	if (nodes_active > 0) {
		if (!auto_enabled) gtk_widget_set_sensitive(button_search, TRUE);
		gtk_widget_set_sensitive(button_host_catcher_get_more, TRUE);
		}
	else {
		gtk_widget_set_sensitive(button_search, FALSE);
		gtk_widget_set_sensitive(button_host_catcher_get_more, FALSE);
		}

	return TRUE;
}

gint main(gint argc, gchar **argv)
{
	gint i;
	const gchar *menus[] = { "gnutellaNet" , "Uploads", "Downloads", "Search", "  Monitor", "Automation", "Config", NULL };
	gchar *titles[5];
	gint optimal_width;

	for (i = 3; i < 256; i++) close(i); /* Just in case */

	/* Glade inits */

	gtk_set_locale();

	gtk_init(&argc, &argv);

	add_pixmap_directory(PACKAGE_DATA_DIR "/pixmaps");
	add_pixmap_directory(PACKAGE_SOURCE_DIR "/pixmaps");

	main_window = create_main_window();

	create_popup_nodes();
	create_popup_hosts();
	create_popup_search();
	create_popup_monitor();
	create_popup_uploads();
	create_popup_dl_active();
	create_popup_dl_queued();

	gui_set_status(NULL);

	/* Our inits */

	config_init();
	network_init();
	routing_init();
	search_init();
	share_init();
	filters_init();

	/* Some signal handlers */

	signal(SIGTERM, SIG_Handler);
	signal(SIGINT,  SIG_Handler);
	signal(SIGPIPE, SIG_Ignore); // SIG_IGN is ignore this signal, do nothing

/* on some OSs you may need to use sigset instead if the handlers change back to
   default after one signal is received, this does not happen on Linux kernels
   acording to the man page
	sigset(SIGTERM, SIG_Handler);
	sigset(SIGINT,  SIG_Handler);
	sigset(SIGPIPE, SIG_Ignore); // SIG_IGN is ignore this signal, do nothing
*/

	/* Create the main listening socket */

	if (listen_port) s_listen = socket_listen(0, listen_port, GTA_TYPE_CONTROL);

	/* Final interface setup */

	optimal_width = gtk_clist_optimal_column_width(GTK_CLIST(clist_stats), 0);

	for (i = 0; i < 7; i++) gtk_clist_insert(GTK_CLIST(clist_menu), i, (gchar **) &menus[i]);
	gtk_clist_select_row(GTK_CLIST(clist_menu), 0, 0);

	gtk_widget_set_usize(sw_menu, optimal_width, (clist_menu->style->font->ascent + clist_menu->style->font->descent + 4) * 7);

	gtk_clist_column_titles_passive(GTK_CLIST(clist_nodes));
	gtk_clist_column_titles_passive(GTK_CLIST(clist_uploads));
	gtk_clist_column_titles_passive(GTK_CLIST(clist_downloads));
	gtk_clist_column_titles_passive(GTK_CLIST(clist_download_queue));
	gtk_clist_column_titles_passive(GTK_CLIST(clist_monitor));
	gtk_clist_column_titles_passive(GTK_CLIST(clist_auto));

	gtk_clist_set_reorderable(GTK_CLIST(clist_download_queue), TRUE);

	titles[0] = NULL;

	for (i = 0; i < 4; i++) gtk_clist_append(GTK_CLIST(clist_connections), titles);
	for (i = 0; i < 4; i++) gtk_clist_append(GTK_CLIST(clist_stats), titles);

	gtk_widget_set_usize(sw_connections, optimal_width, (clist_connections->style->font->ascent + clist_connections->style->font->descent + 4) * 4);
	gtk_widget_set_usize(sw_stats, optimal_width, (clist_stats->style->font->ascent + clist_stats->style->font->descent + 4) * 4);

	gui_update_stats();

	gui_update_c_gnutellanet();
	gui_update_c_uploads();
	gui_update_c_downloads(0);
	gui_update_c_queued(0);

	gui_update_global();

	gtk_window_set_title(GTK_WINDOW(main_window), name_version);

	gtk_widget_set_sensitive(popup_hosts_title, FALSE);
	gtk_widget_set_sensitive(popup_dl_active_title, FALSE);
	gtk_widget_set_sensitive(popup_dl_queued_title, FALSE);
	gtk_widget_set_sensitive(popup_monitor_title, FALSE);
	gtk_widget_set_sensitive(popup_nodes_title, FALSE);
	gtk_widget_set_sensitive(popup_uploads_title, FALSE);
	gtk_widget_set_sensitive(popup_search_title, FALSE);

	gtk_widget_set_sensitive(button_search_filter, FALSE); // disabled for now
	gtk_widget_set_sensitive (checkbutton_config_throttle, FALSE);

	gtk_widget_show(main_window); /* Display the main window */

	/* Setup the main timer */

	gtk_timeout_add(1000, (GtkFunction) main_timer, NULL);

	auto_init(); // start automation if it's selected

	/* Okay, here we go */

	gtk_main();

	return 0;
}

/*
Notes:

Recent versions of Linux libc (later than 5.4.23) and GNU libc (2.x) include a malloc implementation
which is tunable via environment variables. When MALLOC_CHECK_ is set, a special (less efficient)
implementation is used which is designed to be tolerant against simple errors, such as double calls
of free() with the same argument, or overruns of a single byte (off-by-one bugs). Not all such
errors can be proteced against, however, and memory leaks can result. If MALLOC_CHECK_ is set to 0,
any detected heap corruption is silently ignored; if set to 1, a diagnostic is printed on stderr;
if set to 2, abort () is called immediately. This can be useful because otherwise a crash may happen
much later, and the true cause for the problem is then very hard to track down.
*/

/* vi: set ts=3: */




