
/* Handles upload of our files to others users */

#include "gnutella.h"
#include "interface.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>


GSList *uploads          = NULL;
gint running_uploads = 0;

guint32 count_uploads = 0;

guint32 global_Bps;


void handle_push_request(struct gnutella_node *n)
{

	struct gnutella_push_request p;
	struct gnutella_socket *s;
	guint32 index = 0;
	guint32 ip;					/* IP	of our partner */
	guint16 port;				/* Port of our partner */

	g_return_if_fail(n);

	if (n->size == sizeof(struct gnutella_push_request)) {
		if (memcmp(n->buffer, guid, 16) == 0) {
			memcpy(&p, n->buffer, sizeof(struct gnutella_push_request));
			READ_GUINT32_LE(p.file_id, index); // extract the guint file index number
			READ_GUINT32_BE(p.host_ip, ip); // IP Address
			READ_GUINT16_LE(p.host_port, port); // Port
			s = socket_connect(ip, port, GTA_TYPE_UPLOAD); // will call upload_send_push_request if it works
			if (s) s->push_index = index;
			}
		}

}


// called from socket_connected if socket is good
void upload_send_push_request(struct gnutella_socket *s)
{

	GSList *files = NULL;
	struct shared_file *requested_file = NULL;
	gchar guidstr[40];
	gchar tmp[4], *tmp2;
	gint i;
	gchar ul_tmp[4096];

	g_return_if_fail(s);

	for (files = shared_files; files; files = files->next) // find the filename by index number
		if ( (((struct shared_file *)(*files).data)->file_index == s->push_index))
			requested_file = (struct shared_file *)(*files).data;

	if (requested_file != NULL) { // found the file in our list

		tmp2 = guidstr;

		for (i = 0; i < 16; i++) {
			g_snprintf(tmp, 4, "%02X", guid[i]);
			*tmp2++ = tmp[0];
			*tmp2++ = tmp[1];
			}
		*tmp2 = '\0';

		g_snprintf(ul_tmp, sizeof(ul_tmp), "GIV %d:%s/%s\n\n", s->push_index, guidstr, requested_file->file_name);

		if (write(s->file_desc, ul_tmp, strlen(ul_tmp)) < 0) {
			socket_destroy(s);
			return;
			}
		}
	else {
		socket_destroy(s); // can't find the file in the list
		}

}

void upload_real_remove(void)
{
}


// called by socket_destroy when it's a upload socket
// called by gui when they clear the row item
void upload_remove(struct upload *d, const gchar * reason)
{
  gint row;

	g_return_if_fail(d);
	g_return_if_fail(d->socket);

	// check all this just in case
	if (d->socket->file_desc != -1) close(d->socket->file_desc);
	if (d->file_desc != -1) close(d->file_desc);
	if (d->socket->gdk_tag) gdk_input_remove(d->socket->gdk_tag);

	// if UL_COMPLETE, we've already decremented it
	// if not, someone else called socket_destroy
	if (d->status != GTA_UL_COMPLETE) {
		running_uploads--;
		gui_update_c_uploads();
		}

	// remove it from gui list
	row = gtk_clist_find_row_from_data(GTK_CLIST(clist_uploads), (gpointer) d);
	gtk_clist_remove(GTK_CLIST(clist_uploads), row);

  uploads = g_slist_remove(uploads, (gpointer) d);

  if (d->socket != NULL)
    {
      d->socket = NULL;

      g_free(d->buffer);
      g_free(d);
    }
  else printf("upload_remove(); upload already free'd %p\n" , d);
}


struct upload* upload_add(struct gnutella_socket *s)
{

  struct upload *new_upload = NULL;
  struct shared_file *requested_file = NULL;
  GSList *files = NULL, *t_uploads = NULL;
  guint32 index = 0, skip = 0, rw = 0, row = 0, upcount = 0;
  gchar http_response[1024], *fpath = NULL, sl[] = "/\0";
	gchar *titles[3], agentstr[40];
	guint32 offs;
	gint i, spaces;

	g_return_val_if_fail(s, NULL);

	titles[0] = titles[1] = titles[2] = NULL;
	agentstr[0] = '\0';

  if(sscanf(s->buffer, "GET /get/%u/", &index)) {
	  if(running_uploads >= max_uploads) {
	    rw = g_snprintf(http_response, sizeof(http_response),
						"HTTP 503 Busy\r\nServer: %s\r\n\r\n", name_version);
		write(s->file_desc, http_response, rw);
		return NULL;
	  }

		for (t_uploads = uploads; t_uploads; t_uploads = t_uploads->next) { // go through all uploads
			if ( ((struct upload *)(*t_uploads).data)->status == GTA_UL_SENDING) { // only if it's in progress
				if ( (((struct upload *)(*t_uploads).data)->index == index) &&
					(((struct upload *)(*t_uploads).data)->socket->ip == s->ip)) {
					rw = g_snprintf(http_response, sizeof(http_response),
							"HTTP 409 Conflict: File already in progress\r\nServer: %s\r\n\r\n", name_version);
					write(s->file_desc, http_response, rw);
					return NULL;
					}
				if ( ((struct upload *)(*t_uploads).data)->socket->ip == s->ip) {
					if (++upcount >= max_uploads_ip) { // check against config max uploads per IP value
						rw = g_snprintf(http_response, sizeof(http_response),
								"HTTP 503 Busy\r\nServer: %s\r\n\r\n", name_version);
						write(s->file_desc, http_response, rw);
						return NULL;
						}
					}
				}
			}

		for (files = shared_files; files; files = files->next) // find the filename by index number
			if ( (((struct shared_file *)(*files).data)->file_index == index))
				requested_file = (struct shared_file *)(*files).data;

		if (requested_file == NULL) goto not_found;


		offs=0;
		do { // move through each line looking for "Range" if skip
			do {
				offs++;
				} while (*(s->buffer+offs) != '\n' && *(s->buffer+offs));
			if (*(s->buffer+offs) == 0) break;
			offs++;
			if (!g_strncasecmp(s->buffer+offs, "User-Agent:", 11)) {
				offs = offs + 12; // skip past the space
				i = 0;
				spaces = 2; // 1 if you want only the agent name displayed. 2 for version, etc....
				do {
					if (s->buffer[offs] == ' ') {
						if (--spaces <= 0) break;
						}
					agentstr[i] = s->buffer[offs];
					offs++;
					i++;
					} while (s->buffer[offs] != '\r' && offs < s->pos && i < 31);
				agentstr[i] = '\0';
				continue;
				}
			if (!sscanf(s->buffer+offs, "Range: bytes=%u-", &skip)) continue;
			} while(1);

		if (skip >= requested_file->file_size) goto not_found;


      new_upload = (struct upload*)g_malloc0( sizeof(struct upload) );

      /* Set the full path to the file */
      if (requested_file->file_directory[strlen(requested_file->file_directory)-1] == sl[0])
	fpath = g_strconcat(requested_file->file_directory, requested_file->file_name, NULL);
      else
	fpath = g_strconcat(requested_file->file_directory, &sl, requested_file->file_name, NULL);

      /* Open the file for reading , READONLY just in case. */
      if((new_upload->file_desc = open(fpath, O_RDONLY)) < 0)
		goto not_found;

      /* Set all the upload information in our newly created upload struct */
      new_upload->index = index;
      new_upload->name = requested_file->file_name;

      s->type = GTA_TYPE_UPLOAD;

      new_upload->socket = s;
      new_upload->skip = skip;
      new_upload->pos = 0;
      new_upload->status = GTA_UL_SENDING;

      new_upload->file_size = requested_file->file_size;
      new_upload->start_date = time((time_t *) NULL);
      new_upload->last_update = 0;
      new_upload->buf_size = 16384*sizeof(gchar);
      new_upload->buffer = (gchar *)g_malloc(new_upload->buf_size);
      new_upload->bpos = 0;
      new_upload->bsize = 0;

		if (s->direction == GTA_CONNECTION_OUTGOING) new_upload->push = TRUE;
		else new_upload->push = FALSE;

      /* Setup and write the HTTP header , including the file size */
		if (skip)
			rw = g_snprintf(http_response, sizeof(http_response),
				"HTTP/1.0 206 Partial Content\r\n"
				"Server: %s\r\n"
				"Content-type: application/binary\r\n"
				"Content-length: %i\r\n"
				"Content-Range: bytes %u-%u/%u\r\n\r\n",
				name_version, new_upload->file_size - skip,
				skip, new_upload->file_size - 1, new_upload->file_size);
		else
			rw = g_snprintf(http_response, sizeof(http_response),
				"HTTP/1.0 200 OK\r\n"
				"Server: %s\r\n"
				"Content-type: application/binary\r\n"
				"Content-length: %i\r\n\r\n",
				name_version, new_upload->file_size);

      write(new_upload->socket->file_desc, http_response, rw);

      /* add the upload structure to the upload slist */
      uploads = g_slist_append(uploads, new_upload);

		g_snprintf(http_response, sizeof(http_response),
				"%s %s", ip_to_gchar( s->ip ), agentstr); // ip_to_gchar str is stored in static buffer see man inet_ntoa
		if (new_upload->push) strcat(http_response, " Push");
      titles[0] = new_upload->name;
      titles[1] = http_response;
      titles[2] = "";

      /* add upload to the gui */
      row = gtk_clist_append(GTK_CLIST(clist_uploads), titles);
      gtk_clist_set_row_data(GTK_CLIST(clist_uploads), row, (gpointer) new_upload);

      running_uploads++;

      gui_update_c_uploads();
      g_free(fpath);

      return new_upload;
  }

  not_found:

  /* What?  Either the sscanf() failed or we don't have the file. */
  rw = g_snprintf(http_response, sizeof(http_response),
				  "HTTP 404 Not Found\r\nServer: %s\r\n\r\n", name_version);

  write(s->file_desc, http_response, rw);

  if (dbg) printf("upload_add(); request from %s failed\n'%s'", ip_to_gchar(s->ip), s->buffer);

  if(new_upload) g_free(new_upload);
  if(fpath) g_free(fpath);

  return NULL;
}


/* Uplaod Write, called when socket is ready for new data
 * FIFO type action to deal with low baud rates. If we try to force
 * 4k then the lower speed downloads will be garbled.
 */
void upload_write(gpointer up, gint source, GdkInputCondition cond)
{
	struct upload* current_upload;
	guint32 write_bytes;
	FILE *f;

	g_return_if_fail(up);

	current_upload = (struct upload*)up;

	if (!(cond & GDK_INPUT_WRITE)) { /* If we can't write then we don't want it, kill the socket */
		if (dbg) printf("upload_write(); Condition %i, Exception = %i\n", cond, GDK_INPUT_EXCEPTION);
		socket_destroy(current_upload->socket);
		return;
		}


	// this is actually done last, we return here because all bytes are sent, ok to close socket now
	if (current_upload->pos == current_upload->file_size) {
		count_uploads++;
		gui_update_count_uploads(); // total count of all uploads
		running_uploads--;
		gui_update_c_uploads(); // currently running uploads
		current_upload->status = GTA_UL_COMPLETE;
		gui_update_upload(current_upload);
		gdk_input_remove(current_upload->socket->gdk_tag); // stop monitoring the socket
		current_upload->socket->gdk_tag = 0;

		if(clear_uploads == TRUE) {
			socket_destroy(current_upload->socket); // calls upload_remove, closes everything
			}
		else { // we will leave the upload struct in memory till they clear it from the gui
			gtk_widget_set_sensitive(button_clear_uploads, 1);
			if (current_upload->socket->file_desc != -1) { // close the socket now
				close(current_upload->socket->file_desc);
				current_upload->socket->file_desc = -1;
				}
			if (current_upload->file_desc != -1) { // close the file now
				close(current_upload->file_desc);
				current_upload->file_desc = -1;
				}
			}
		return;
		}

	if (cond & GDK_INPUT_READ) { // this indicates a closed pipe, they closed it, not complete
		socket_destroy(current_upload->socket);
		return;
		}

  /* If we got a valid skip amount then jump ahead to that position */
	if ((current_upload->pos == 0) && (current_upload->skip > 0)) {
		if (lseek(current_upload->file_desc , current_upload->skip, SEEK_SET) == -1) {
			socket_destroy(current_upload->socket); return;
			}
		current_upload->pos = current_upload->skip;
		}


  /* if the buffer position is equal to zero then we need to read more data from the file. We read in under or equal to 
     the buffer memory size */

  if (current_upload->bpos == 0)
    if((current_upload->bsize = read(current_upload->file_desc, current_upload->buffer, current_upload->buf_size)) == -1)
    {
      socket_destroy(current_upload->socket);
      return;
    }

  if ((write_bytes = write(current_upload->socket->file_desc, &current_upload->buffer[current_upload->bpos],
			   (current_upload->bsize - current_upload->bpos))) == -1)
    {
      socket_destroy(current_upload->socket);
      return;
    }

  current_upload->pos += write_bytes;

  if ((current_upload->bpos+write_bytes) < current_upload->bsize)
    current_upload->bpos += write_bytes;
  else
    current_upload->bpos = 0;

	current_upload->last_update = time((time_t *) NULL);

	if (current_upload->pos == current_upload->file_size) {
		f = fdopen(current_upload->socket->file_desc,"w");
		if (f) fflush(f);
		}

}

/* vi: set ts=3: */
