/***************************************************************************
****************************************************************************
****************************************************************************
*
* NightHawk - By Jason Nunn - Oct 96  (jsno@dayworld.net.au)
* FREEWARE.
*
* Xwindows (C++)
*
* ==================================================================
* Main
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/xpm.h>
#include <X11/keysym.h>
}
#include "nighthawk_defs.h"
#include "misc.h"
#include "tship.h"

struct       itimerval oldtimer,timer;
tship        *ship = NULL;
tscore_table score_table[MAX_SCORE_TABLE];
int          ship_ptr,ship_start = 0;
char         *ship_table[] = {
  "Haldeck",
  "Seafarer",
  "Anoyle",
  "Esperence",
  "Ophukus",
  "Mearkat",
  "Friendship",
  "Discovery",
  "Zaxon",
  "Tobruk",
  NULL};

int intro_module_count,intro_sequence_no,intro_back_bm_no;

/***************************************************************************
*
***************************************************************************/
void kill_pipe(int)
{
  printf("Nb/ Sound engine just died.\n");
  sound_engine_fp = NULL;
}

void init(void)
{
  register int x;

  signal(SIGPIPE,kill_pipe);
  umask(~0666);
  for(x = 0;x < MAX_SCORE_TABLE;x++)
  {
    strcpy(score_table[x].name,"-");
    strcpy(score_table[x].highest_ship,"-");
    strcpy(score_table[x].time,"-");
    score_table[x].score = 0;
  }
}

/***************************************************************************
*
***************************************************************************/
FILE *lopen(char *filename,char *mode)
{
  FILE *fp;

  if((fp = fopen(filename,mode)) != NULL)
    flock(fp->_fileno,LOCK_EX);
  return fp;
}

FILE *load_scores_sub(void)
{
  FILE *fp;

  fp = lopen(SCORES_FILE,"r+b");
  if(fp != NULL)
  {
    rewind(fp);
    fread(score_table,sizeof(tscore_table),MAX_SCORE_TABLE,fp);
    return fp;
  }
  else
  {
    fp = lopen(SCORES_FILE,"w+b");
    if(fp != NULL)
      return fp;
  }
  return NULL;
}

void load_scores(void)
{
  FILE *fp;

  fp = load_scores_sub();
  if(fp != NULL)
    fclose(fp);
}

void update_score(int complete)
{
  FILE *fp;

  intro_module_count = 0;
  intro_sequence_no = 20;
  fp = load_scores_sub();
  if(fp != NULL)
  {
    register int x;

    for(x = 0;x < MAX_SCORE_TABLE;x++)
      if(score > score_table[x].score)
      {
        register int y;
        struct passwd *ps;
        time_t t;
        char *c;

        for(y = MAX_SCORE_TABLE - 1;y > x;y--)
          memcpy(score_table + y,score_table + y - 1,sizeof(tscore_table));
        ps = getpwuid(getuid());
        if(ps != NULL)
          strncpy(score_table[x].name,ps->pw_name,8);
        else
          strcpy(score_table[x].name,"unknown");

        if(ship_start)
        {
          register int a;

          strncpy(score_table[x].highest_ship,ship_table[ship_ptr],15);
          a = strlen(score_table[x].highest_ship);
          score_table[x].highest_ship[a] = '*';
          score_table[x].highest_ship[a + 1] = '0' + (char)ship_start;
        }
        else
        {
          if(complete)
            strcpy(score_table[x].highest_ship,"Complete!");
          else
            strncpy(score_table[x].highest_ship,ship_table[ship_ptr],15);
        }
        score_table[x].highest_ship[15] = 0;
        t = time(NULL);
        c = ctime(&t);
        memcpy(score_table[x].time,c + 8,2);
        memcpy(score_table[x].time + 2,"-",1);
        memcpy(score_table[x].time + 3,c + 4,3);
        memcpy(score_table[x].time + 6,"-",1);
        memcpy(score_table[x].time + 7,c + 20,4);
        score_table[x].time[11] = 0;
        score_table[x].score = score;
        break;
      }
    rewind(fp);
    fwrite(score_table,sizeof(tscore_table),MAX_SCORE_TABLE,fp);
    fclose(fp);
  }
}

/***************************************************************************
*
***************************************************************************/
void bg_init(void (*ptr)(int))
{
  signal(SIGALRM,ptr);
  timer.it_value.tv_sec = 0; 
  timer.it_interval.tv_sec = 0;
  timer.it_value.tv_usec = REALTIME_DELAY;
  timer.it_interval.tv_usec = REALTIME_DELAY;
  setitimer(ITIMER_REAL,&timer,&oldtimer);
}

void bg_deinit(void)
{
  setitimer(ITIMER_REAL,&oldtimer,&timer);
}

/***************************************************************************
*
***************************************************************************/

/****************************
*
*****************************/
void display_message(char *bp,int y)
{
  char *rp;

  rp = bp;
  for(;;)
  {
    register int c;

    if(*rp == '\0')
      break;
    c = (int)(rp - bp);
    if(!c)
      XSetForeground(display,gc_dline,green_pixel[(*bp) - '0']); 
    else
      if(*rp == '\n')
      {
        register int sl;

        sl = (int)(rp - bp - 1);
        XDrawString(display,render_screen,gc_dline,
          SCREEN_HSIZE_X - ((sl * 6) >> 1),y,bp + 1,sl);
        bp = rp + 1;
        y += 12;
      }
    rp++;
  }
}

/****************************
*
*****************************/
void pause_1_bg(void)
{
  intro_module_count++;
  if(intro_module_count > 73)
  {
    intro_module_count = 0;
    intro_sequence_no++;
    intro_back_bm_no = random() & 0x3;
  }
}

void pause_2_bg(void)
{
  intro_module_count++;
  if(intro_module_count > 35)
  {
    intro_module_count = 0;
    intro_sequence_no++;
    intro_back_bm_no = random() & 0x3;
  }
}

void pause_3_bg(void)
{
  intro_module_count++;
  if(intro_module_count > 80)
  {
    intro_module_count = 0;
    intro_sequence_no++;
    intro_back_bm_no = random() & 0x3;
  }
}

void blank_fg(void)
{
  XFillRectangle(display,render_screen,gc_bgblt,
    0,0,window_width,window_height);
}

void credit_1_fg(void)
{
  XFillRectangle(display,render_screen,gc_bgblt,
    0,0,window_width,window_height);
  drawxpm_ani(&credit_1_bm,
    SCREEN_HSIZE_X - (credit_1_bm.width >> 1),
    40,0,1);
}

void credit_2_fg(void)
{
  XFillRectangle(display,render_screen,gc_bgblt,
    0,0,window_width,window_height);
  drawxpm_ani(&credit_2_bm,
    SCREEN_HSIZE_X - (credit_2_bm.width >> 1),
    40,0,1);
}

void credit_3_fg(void)
{
  XFillRectangle(display,render_screen,gc_bgblt,
    0,0,window_width,window_height);
  drawxpm_ani(&credit_3_bm,
    SCREEN_HSIZE_X - (credit_3_bm.width >> 1),
    40,0,1);
}

void credit_4_fg(void)
{
  XFillRectangle(display,render_screen,gc_bgblt,
    0,0,window_width,window_height);
  drawxpm_ani(&credit_4_bm,
    SCREEN_HSIZE_X - (credit_4_bm.width >> 1),
    40,0,1);
}

void credit_5_fg(void)
{
  XFillRectangle(display,render_screen,gc_bgblt,
    0,0,window_width,window_height);
  drawxpm_ani(&credit_5_bm,
    SCREEN_HSIZE_X - (credit_5_bm.width >> 1),
    40,0,1);
}

void main_logo_fg(void)
{
  char *mess =
    "5(C) 1997,98, Jason Nunn (JsNO)\n"
    "5www.downunder.net.au/~jsno\n"
    "5\n"
    "5'Rescue from Vega' (FunktrackerGOLD)\n"
    "5(C) 1998, Vincent Voois (Vv)\n"
    "5home.worldonline.nl/~vvacme\n\0";

  drawxpm_ani(&credit_6_bm,
    SCREEN_HSIZE_X - (credit_6_bm.width >> 1),
    20,0,1);
  display_message(mess,70);
}

void main_logo_fg2(void)
{
  char *mess =
    "0Space to play, Q to Quit.\n"
    "0RTFM for instructions.\n\0";

  main_logo_fg();
  display_message(mess,160);
}

void credit_6_fg(void)
{
  XFillRectangle(display,render_screen,gc_bgblt,
    0,0,window_width,window_height);
  main_logo_fg();
}

void credit_7_fg(void)
{
  XFillRectangle(display,render_screen,gc_bgblt,
    0,0,window_width,window_height);
  main_logo_fg2();
}

void credit_8_fg(void)
{
  drawxpm_ani(&intro_back_bm[intro_back_bm_no],0,0,0,1);
  main_logo_fg2();
}

/****************************
*
*****************************/
void display_scores_bg(void)
{
  intro_module_count++;
  if(intro_module_count > 80)
  {
    intro_module_count = 0;
    intro_sequence_no++;
    intro_back_bm_no = random() & 0x3;
  }
}

void display_scores_fg(void)
{
  char str[STR_LEN];
  register int x;

  drawxpm_ani(&intro_back_bm[intro_back_bm_no],0,0,0,1);
  drawxpm_ani(&ntitle_bm,
    SCREEN_HSIZE_X - (ntitle_bm.width >> 1),5,0,1);
  XSetForeground(display,gc_dline,red_pixel[0]);
  sprintf(str,"%-8s %-15s %-11s    Score","Name","Ship","Date");
  XDrawString(display,render_screen,gc_dline,25,52,str,strlen(str));
  for(x = 0;x < MAX_SCORE_TABLE;x++)
  {
    register int yp;

    yp = 70 + (x * 13);
    XSetForeground(display,gc_dline,green_pixel[x]);
    sprintf(str,"%-8s %-15s %-11s %8d",
      score_table[x].name,
      score_table[x].highest_ship,
      score_table[x].time,
      score_table[x].score);
    XDrawString(display,render_screen,gc_dline,25,yp,str,strlen(str));
  }
}

/****************************
*
*****************************/
#include "scroll.inc"
char *scroll_base_ptr;
int scroll_limit;

void draw_scroll_bg(void)
{
  intro_module_count += 3;
  if(intro_module_count > scroll_limit)
  {
    intro_module_count = 0;
    intro_sequence_no++;
    intro_back_bm_no = 0;
  }
}

void draw_scroll_init_1_fg(void)
{
  scroll_base_ptr = scroll_story;
  intro_module_count = -(190 << 2);
  intro_sequence_no++;
  scroll_limit = 1375;
}

void draw_scroll_fg(void)
{
  register int a,b,c,d;
  int co_tab[16] = {8,7,6,5,4,3,2,1,1,2,3,4,5,6,7,8};

  XFillRectangle(display,render_screen,gc_bgblt,
    0,0,window_width,window_height);
  d = strlen(scroll_base_ptr);
  b = (intro_module_count >> 2) / 12;
  c = (intro_module_count >> 2) % 12;
  for(a = 0;a < 16;a++)
  {
    register int p;

    p = (a + b) * 36;
    if((p >= 0) && (p < d))
    {
      XSetForeground(display,gc_dline,green_pixel[co_tab[a]]);
      XDrawString(display,render_screen,gc_dline,
        55,20 + (a * 12) - c,scroll_base_ptr + p,36);
    }
  }
  XSetForeground(display,gc_dline,red_pixel[7]);
  XFillRectangle(display,render_screen,gc_bgblt,
    55,0,220,12);
  XFillRectangle(display,render_screen,gc_bgblt,
    55,200 - 12,220,12);
}

/****************************
*
*****************************/
void contacts_1_fg(void)
{
  char *mess =
    "0GPL\n"
    "4\n"
    "4Nighthawk   comes   under  the   GNU\n"
    "4GENERAL PUBLIC LICENSE AGREEMENT,and\n"
    "4comes  with  ABSOLUTELY NO WARRANTY.\n"
    "4This is free software,  and  you are\n"
    "4welcome  to  redistribute  it  under\n"
    "4certain conditions.\n\0";

  drawxpm_ani(&intro_back_bm[intro_back_bm_no],0,0,0,1);
  display_message(mess,40);
}

void contacts_2_fg(void)
{
  char *mess =
    "0=Contacts=\n"
    "4\n"
    "4-Jason Nunn-\n"
    "1<jsno@downunder.net.au>\n"
    "1<jsno@stormfront.com.au>\n"
    "1http://www.downunder.net.au/~jsno\n"
    "4\n"
    "432 Rothdale Rd\n"
    "4Moil Darwin NT 0810\n"
    "4AUSTRALIA\n\0";

  drawxpm_ani(&intro_back_bm[intro_back_bm_no],0,0,0,1);
  display_message(mess,40);
}

void contacts_3_fg(void)
{
  char *mess =
    "0=Contacts=\n"
    "4\n"
    "4-Vincent Voois (Musician)-\n"
    "1<vvacme@worldonline.nl>\n"
    "1http://home.worldonline.nl/~vvacme\n"
    "4\n"
    "4Adrian Bridgett (Debian Maintainer)\n"
    "1<adrian.bridgett@poboxes.com>\n";

  drawxpm_ani(&intro_back_bm[intro_back_bm_no],0,0,0,1);
  display_message(mess,40);
}

void contacts_4_fg(void)
{
  char *mess =
    "4Thanks to the  many  people who have\n"
    "4emailed  feedback  about  Nighthawk.\n"
    "4\n"
    "1Support Free Software!\n"
    "4\n"
    "1Go GNU and Linux!!\n"
    "4Stick it up ya arse Billy Gates!\n"
    "4\n"
    "4Hit Space to Start.\n"
    "4RTFM for instructions.\n";

  drawxpm_ani(&intro_back_bm[intro_back_bm_no],0,0,0,1);
  display_message(mess,40);
}

/****************************
*
*****************************/
typedef struct
{
  void (*bg)(void);
  void (*fg)(void);
} tintro_tab;

tintro_tab intro_tab[] = {
  {pause_3_bg,blank_fg},
  {pause_1_bg,credit_1_fg},
  {pause_2_bg,blank_fg},
  {pause_1_bg,credit_2_fg},
  {pause_2_bg,blank_fg},
  {pause_1_bg,credit_3_fg},
  {pause_2_bg,blank_fg},
  {pause_1_bg,credit_4_fg},
  {pause_2_bg,blank_fg},
  {pause_1_bg,credit_5_fg},
  {pause_2_bg,blank_fg},
  {pause_2_bg,credit_6_fg},
  {pause_3_bg,credit_7_fg},
  {draw_scroll_bg,draw_scroll_init_1_fg},
  {draw_scroll_bg,draw_scroll_fg},
  {pause_3_bg,credit_8_fg},
  {pause_3_bg,contacts_1_fg},
  {pause_3_bg,contacts_2_fg},
  {pause_3_bg,contacts_3_fg},
  {pause_3_bg,contacts_4_fg},
  {display_scores_bg,display_scores_fg},
  {NULL,NULL}
};

void draw_intro_bg(int sig)
{
  signal(sig,&draw_intro_bg);
  if(intro_tab[intro_sequence_no].bg != NULL)
    intro_tab[intro_sequence_no].bg();
  else
    intro_sequence_no = 13;
}

int draw_intro(void)
{
  register int intro_f = 0,x;
  XEvent event;

  intro_module_count = 0;
  intro_sequence_no = 0;
  intro_back_bm_no = 0;
  load_scores();
  bg_init(&draw_intro_bg);
  sound_engine_cmd(SND_CMD_LOAD_SONG,0,0,0);
  while(!intro_f)
  {
    if(intro_tab[intro_sequence_no].fg != NULL)
      intro_tab[intro_sequence_no].fg();
    XCopyArea(display,render_screen,window,gc_bgblt,0,0,
      window_width,window_height,0,0);
    while(XPending(display))
    {
      XNextEvent(display,&event);
      if(event.xany.type == KeyPress)
      {
        register int ch;

        ch = XLookupKeysym((XKeyEvent *)&event,0);
        switch(ch)
        {
          case KEY_QUIT:
            intro_f = 1;
            break;
          case KEY_SELECT:
            intro_f = 2;
            break;
        }
      }
      else
        if(event.xany.type == ButtonPress)
          intro_f = 2;
    }
    usleep(UPDATE_DELAY);
  }
  for(x = 0;x < 280;x += 8)
  {
    XFillRectangle(display,window,gc_bgblt,
      0,0,window_width,window_height);
    while(XPending(display))
      XNextEvent(display,&event);
    if(x < 255)
      sound_engine_cmd(SND_CMD_SET_MASTER,255 - x,0,0);
    usleep(UPDATE_DELAY);
  }
  sound_engine_cmd(SND_CMD_UNLOAD_SONG,0,0,0);
  bg_deinit();
  return intro_f - 1;
}

/***************************************************************************
*
***************************************************************************/
void get_ready(void)
{
  register int a,siren_r = 0,siren_c = 0;
  XEvent event;
  char str[STR_LABEL_LEN];

  for(a = 0;a < (4 * 8);a++)
  {
    if(siren_c < 3)
      if(!siren_r)
      {
        siren_r = 6;
        siren_c++;
        sound_engine_cmd(SND_CMD_FX,FX_ALERT_SIREN,0xff,0x80);
      }
      else
        siren_r--;
    XFillRectangle(display,render_screen,gc_bgblt,0,0,
      window_width,window_height);
    drawxpm_ani(&get_ready1_bm,SCREEN_HSIZE_X - (get_ready1_bm.width >> 1),
      12,0,1);
    XSetForeground(display,gc_dline,white_pixel[6]);
    sprintf(str,"Starship %s",ship->name);
    XDrawString(display,render_screen,gc_dline,
    SCREEN_HSIZE_X - ((strlen(str) >> 1) * 7),55,str,strlen(str));
    drawxpm_ani(&ship->map_bm,SCREEN_HSIZE_X - (ship->map_bm.width >> 1),
      70,0,1);
    XCopyArea(display,render_screen,window,gc_bgblt,0,0,window_width,window_height,0,0);
    while(XPending(display))
      XNextEvent(display,&event);
    usleep(125000);
  }
}

/***************************************************************************
*
***************************************************************************/
void display_final_score(void)
{
  char str[STR_LEN];
  register int sl;

  sprintf(str,"Your Final Score: %d",score);
  XSetForeground(display,gc_dline,green_pixel[2]);
  sl = strlen(str);
  XDrawString(display,render_screen,gc_dline,
    SCREEN_HSIZE_X - ((sl * 6) >> 1),180,str,sl);
}

void trans_terminated(void)
{
  register int a;
  XEvent   event;

  sound_engine_cmd(SND_CMD_RANDOM,0,0,0);
  for(a = 0;a < 30;a++)
  {
    register int x,y,ww,wh,ww_inc = 0,wh_inc = 0;

    ww = window_width >> 5;
    wh = window_height / 20;
    for(y = 0;y < 20;y++)
    {
      ww_inc = 0;
      for(x = 0;x < 32;x++)
      {
        XSetForeground(display,gc_line,white_pixel[random() & 0x7]);
        XFillRectangle(display,render_screen,gc_line,ww_inc,wh_inc,ww,wh);
        ww_inc += ww;
      }
      wh_inc += wh;
    }
    XCopyArea(display,render_screen,window,gc_bgblt,0,0,window_width,window_height,0,0);
    while(XPending(display))
      XNextEvent(display,&event);
    usleep(UPDATE_DELAY);
  }
  sound_engine_cmd(SND_CMD_SILENCE,0,0,0);
  sound_engine_cmd(SND_CMD_FX,FX_TRANS_TERM,0xff,0x80);
  for(a = 0;a < (4 * 2);a++)
  {
    XFillRectangle(display,render_screen,gc_bgblt,0,0,window_width,window_height);
    drawxpm_ani(&trans_terminated_bm,
      SCREEN_HSIZE_X - (trans_terminated_bm.width >> 1),50,0,1);
    display_final_score();
    XCopyArea(display,render_screen,window,gc_bgblt,0,0,window_width,window_height,0,0);
    while(XPending(display))
      XNextEvent(display,&event);
    usleep(500000);
  }
}

/***************************************************************************
*
***************************************************************************/
void finale(void)
{
  XEvent event;
  register int a;
  char *mess =
    "1\n"
    "1   You have completed all levels.\n"
    "1\n"
    "1\n"
    "1  Thankyou for playing Nighthawk.\n\0";

  update_score(1);
  for(a = 0;a < (8 * 2);a++)
  {
    XFillRectangle(display,render_screen,gc_bgblt,
      0,0,window_width,window_height);
    display_message(mess,40);
    display_final_score();
    XCopyArea(display,render_screen,window,gc_bgblt,0,0,
      window_width,window_height,0,0);
    while(XPending(display))
      XNextEvent(display,&event);
    usleep(500000);
  }
}

/***************************************************************************
*
***************************************************************************/
void bg_calc(int sig)
{
  signal(sig,&bg_calc);
  if(ship != NULL)
    ship->level_bg_calc();
  if(score != sscore)
    sscore += ((score - sscore) >> 1) | 1;
}

void game(void)
{
  if(x_init())
  {
    init();
    init_colours();
    printf("Loading sprites..\n");
    if(load_flr_xpms())
    {
      if(load_sprite_xpms())
      {
        XMapWindow(display,window);
        XSync(display,0);
        printf("Entering Nighthawk..\n");
        for(;;)
          if(draw_intro())
          {
            register int dead = 0;

            sound_engine_cmd(SND_CMD_FX_INIT,0,0,0);
            sscore = score = 0;
            ship_ptr = ship_start;
            while(!dead)
            {
              ship = new(tship);
              if(ship != NULL)
              {
                if(ship->load(ship_table[ship_ptr]))
                {
                  get_ready();
                  bg_init(&bg_calc);
                  ship->level_run();
                  ship->unload();
                  bg_deinit();
                  if(ship->droids[0]->state == 2)
                  {
                    trans_terminated();
                    dead = 1;
                    update_score(0);
                  }
                }
                delete(ship);
              }
              else
                break;
              ship_ptr++;
              if((ship_table[ship_ptr] == NULL) && !dead)
              {
                ship_ptr--;
                finale();
                break;
              }
            }
          }
          else
            break;
        free_sprite_xpms();
      }
      free_flr_xpms();
    }
    Xreaper();
  }
}

/***************************************************************************
*
***************************************************************************/
int main(int argc,char *argv[])
{
  register int x,sound = 0;
  char sound_param[STR_LEN] = FUNKPLAY_PATH;

  printf(WELCOME);
  for(x = 1;x < argc;x++)
  {
    if(argv[x][0] == '-')
    {
      switch(argv[x][1])
      {
        case 'h':
          printf(
            "Usage: %s <options>\n"
            " -h         Display this help info\n"
            " -c<d>      Start at a given ship (0-9)\n"
            " -m         Sound and music\n\n"
            "'-m' options:\n"
            "  -p<d>   No of Patterns alloc\n"
            "  -s<d>   Sampling rate\n"
            "  -S<d>   Stereo    (S1=Stereo,S0=Mono)\n"
            "  -P<d>   Precision (P8=8 bit,P16=16 bit)\n"
            "  -x<d>   No of FX channels\n"
            "\n",argv[0]);
          return 1;
        case 'c':
          ship_start = atoi(argv[x] + 2);
          if(ship_start < 0) ship_start = 0;
          if(ship_start > 9) ship_start = 9;
          printf("Starting at level '%s' (Nb/ High scores will note "
                 "that you have cheated)\n",ship_table[ship_start]);
          break;
        case 'm':
          sound = 1;
          break;
        case 'p':
        case 's':
        case 'S':
        case 'P':
        case 'x':
          strcat(sound_param," ");
          strcat(sound_param,argv[x]);
          break;
      }
    }
  }
  printf(" Data Directory: " INSTALL_DIR "/data/\n"
         "Score Directory: " SCORES_FILE "\n");
#ifdef REDUCED_SPRITES
  printf("Reduced sprites mode (for slow machines)\n");
#endif
  if(sound)
  {
    fflush(stdout);
    sound_engine_fp = popen(sound_param,"w");
    if(sound_engine_fp != NULL)
    {
      game();
      sound_engine_cmd(SND_CMD_QUIT,0,0,0);
      if(sound_engine_fp != NULL)
        pclose(sound_engine_fp);
    }
    else
      printf("Error: Couldn't run sound engine, aborting.\n");
  }
  else
  {
    printf("No sound.\n");
    game();
  }
  printf("See ya\n");
  return 1;
}
