<?php
//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

// usage: merge_ops.php ops.cpp.new dst_ops.cpp

	$deffile = preg_split("/\n/", file_get_contents($argv[1]));
	$cppfile = preg_split("/\n/", file_get_contents($argv[2]));
	// 末尾に空行が出てしまうので削っておく。
	if ($cppfile[count($cppfile) - 1] == "") {
		array_pop($cppfile);
	}

	// deffile から 関数名 => array(直前のコメント, ...) の連想配列を作る。
	// $def = array(
	//  "nop" => array("// ... NOP"),
	//  :
	// );
	$def = array();
	for ($n = 0; $n < count($deffile); $n++) {
		if (preg_match('/^OP_DEF\((\w+)\)/', $deffile[$n], $m)) {
			$name = $m[1];
			$comms = array();
			for ($i = 1; $n - $i >= 0 ; $i++) {
				$buf = $deffile[$n - $i];
				if (preg_match("|^// |", $buf)) {
					array_unshift($comms, $buf);
				} else {
					break;
				}
			}
			$def[$name] = $comms;
		}
	}

	// 見つかった回数
	$founds = array();

	// cppfile を辿る。
	for ($c = 0; $c < count($cppfile); $c++) {
		if (preg_match('/^OP_DEF\((\w+)\)/', $cppfile[$c], $m)) {
			$name = $m[1];
			if (isset($def[$name])) {
				// すでに処理したやつがもう一度来た?
				if (isset($founds[$name])) {
					error("{$def[$name]} appeared again!\n");
				}
				$founds[$name] = true;

				// この直前のコメントの行数を数える。
				$i = 0;
				while (isset($cppfile[$c - 1 - $i]) &&
				       preg_match("|^// |", $cppfile[$c - 1 - $i])) {
					$i++;
				}
				array_splice($cppfile, $c - $i, $i, $def[$name]);
				$c = $c - $i + count($def[$name]);
			} else {
				array_splice($cppfile, $c, 0, "// # removed (merge.sh)");
				$c++;
			}
		}
	}

	foreach ($cppfile as $buf) {
		print "{$buf}\n";
	}

	// 処理したやつを def[] から削除して、残りが出たら新規追加分。
	// 本当はそれっぽい位置に入れたい。
	foreach ($founds as $name => $dummy) {
		unset($def[$name]);
	}
	if (count($def) > 0) {
		foreach ($def as $name => $comms) {
			print "\n";
			print "// # added (merge.sh)\n";
			foreach ($comms as $line) {
				print "{$line}\n";
			}
			print "OP_DEF({$name})\n";
			print "{\n";
			print "\tOP_FUNC(unimpl);\n";
			print "}\n";
		}
	}
?>
