//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// サブウィンドウ
//

#pragma once

#include "wxnono.h"

class WXTextScreen;

// サブウィンドウ
//
// メインウィンドウのメニューから表示されて、表示されてる間チェック状態を
// 維持するタイプのウィンドウ。クローズ処理が共通に必要なだけで、中身に
// ついては関与していない。
class WXSubWindow : public wxFrame
{
	using inherited = wxFrame;
 public:
	static const int DEFAULT_STYLE =
		(wxDEFAULT_FRAME_STYLE | wxFRAME_FLOAT_ON_PARENT)
		& ~wxMAXIMIZE_BOX
		& ~wxRESIZE_BORDER;

 public:
	WXSubWindow(wxWindow *parent, wxWindowID id, const wxString& name,
		int style);
	WXSubWindow(wxWindow *parent, wxWindowID id, const wxString& name)
		: WXSubWindow(parent, id, name, DEFAULT_STYLE) { }
	virtual ~WXSubWindow() override;

	// フォントサイズ変更
	virtual void FontChanged();

	// コントロールからウィンドウサイズを設定する。
	void Fit() override;

 private:
	void OnClose(wxCloseEvent& event);

	wxDECLARE_EVENT_TABLE();
};
