<!--
 nono
 Copyright (C) 2020 nono project
 Licensed under nono-license.txt
-->
<?php require_once "common.php"; ?>
<html>
<head>
<?php print_head_common(); ?>
<title>nono changes</title>
</head>
<body>
<h3>nono: changes</h3>

灰色のは実験用か開発用のメモです。
<q>Grey colored items are experimental or just a log for us developers.</q>
<hr>
<div class="main1">
<dl>

<dt>1.6.0 (2025/10/29)
<dd><ul>
<li>host(New): サウンド出力を実装。<q>Implement sound output.</q>
<li>vm(New): X68030 の ADPCM (再生側のみ) を実装。
 <q>Implement ADPCM (playback only) on X68030.</q>
<li>vm(Update): X68030 DMAC の外部要求転送を実装。
 <q>Implement external request transfer on X68030 DMAC.</q>
<li>vm(Update): X68030 DMAC のリンクアレイチェインモードを実装。
 <q>Implement link array chain mode on X68030 DMAC.</q>
<li>vm(Update): X68030 DMAC のログをチャンネルごとに分離。
 <q>Separate loglevel per channel.</q>
<li>vm(Update): Human68k モードの FPACK __LTOS を実装。
 <q>Implement FPACK __LTOS on Human68k mode.</q>
<li>GUI(New): スレッドモニタを実装。
 <q>Implement thread monitor.</q>
<li>app(New): ヘテロジニアス構成 CPU のコアの指定に (正式に) 対応。
 <q>Support specifying cores for heterogeneous CPU (formally).</q>
<li>vm(Fix): X68030 もキー押下で高速モードを抑制するように戻す。
ver 1.5.0 で廃止したが副作用があったため。
 <q>Revert to suppressing full speed mode on key press on X68030.
 It was removed in ver 1.5.0, but was reintroduced
 to address unintended side effects.</q>
<li>host(Update): 設定項目 <tt>host-avx2</tt>, <tt>host-neon</tt> を
 <tt>hostcpu-avx2</tt>, <tt>hostcpu-neon</tt> にリネーム。
 <q><tt>host-avx2</tt>, <tt>host-neon</tt> are renamed to
 <tt>hostcpu-avx2</tt>, <tt>hostcpu-neon</tt>.</q>
<li>app(Fix): NetBSD 11.0_BETA で設定ファイルに非 ASCII
 文字があると不正終了する場合があったのを修正。
 <q>Fix possible abnormal termination if the configuration file contains
 non-ASCII characters on NetBSD 11.0_BETA.</q>
</ul><p>

<dt>1.5.0 (2025/09/07)
<dd><ul>
<li>vm(New): X68030 のグラフィック画面を 1024x1024 モードのみ簡易実装。
NetBSD/x68k の X サーバが標準設定で動きます。
 <q>Implement 1024x1024 mode of the graphic screen partially on X68030.
 This makes NetBSD/x68k X server work though default configuration only.</q>
<li>vm(New): VirtIO Block に VIRTIO_BLK_T_GET_ID コマンドを実装。
 <q>Implement VIRTIO_BLK_T_GET_ID command in VirtIO Block.</q>
<li>vm(Update): キー押下で高速モードを抑制するのを LUNA に限定する。
 <q>Limit suppressing full speed mode by key press to LUNA.</q>
<li>vm(Update): X68030 で SRAM.DAT がなければ初期状態で作成する。
それに伴い --create-sram オプションを廃止。
 <q>Create an initialized SRAM.DAT if it doesn't exist on X68030.
 This also obsoletes --create-sram option.</q>
<li>vm(Fix): Nereid バンクメモリのアクセスウェイトを修正。
 <q>Fix wait state count for Nereid bank memory.</q>
<li>m88k(Update): SFD1 がセットされていると浮動小数点命令が例外を
起こすのを実装。
 <q>Implement that floating-point instructions raise an exception
 when SFD1 is set.</q>
<li>m88k(Fix): rte 命令がユーザモードで例外を起こさなかったのを修正。
 <q>Fix missing exception for rte instruction in user mode.</q>
<li>GUI(Update): パフォーマンスカウンタに MHz 表記の追加。
 <q>Display MHz too in the performance counter.</q>
<li>GUI(Fix): いくつかのモニタウィンドウのオープン/クローズで不正終了する可能性があったのを修正。
 <q>Fix possible abnormal termination when opening or closeing some
 monitor windows.</q>
<li>host(Update): ログ機構を書き直し。
 <q>Reimplement log.</q>
</ul><p>

<dt>1.4.2 (2025/05/17)
<dd><ul>
<li>m88k(Update): テーブルサーチは暗黙で CI 扱いになるところを実装。
 <q>Implement a table search operation with CI.</q>
<li>m88k(Update): CI アクセスでキャッシュヒットするとエントリが無効化されるところを実装。
この2点で、ver 0.7.1 以降 OpenBSD がまれに panic していたのが直ると思います。
 <q>Implement that a cache hit invalidates the cache entry if the accesss is CI.
 These two changes should fix an occasional OpenBSD panic since ver 0.7.1.</q>
<li>m88k(Fix): CI 領域に対する xmem 命令の動作を修正。
 <q>Fix the behavior of the xmem instruction in a cache-inhibited region.</q>
<li>m88k(Fix): バススヌープでキャッシュの状態が変わらない場合があったのを修正。
 <q>Fix an issue that bus snooping didn't change cache status in some
 case.</q>
<li>m88k(Fix): m88200 の Cache Copyback {,and Invalidate} コマンド実行後の
キャッシュステータスを修正。
 <q>Fix the cache status on 88200 Cache Copyback {,and Invalidate} commands.</q>
<li>m88k(Fix): FP precise 例外時にソースレジスタが 0 の場合の FPHS[12]
 レジスタを修正。
 <q>Fix the FPHS[12] registers if any source register contains 0
 when the FP precise exception occurs.</q>
</ul><p>

<dt>1.4.1 (2025/04/30)
<dd><ul>
<li>m88k(New): 不当命令例外を実装。
 <q>Implement the illegal instruction exception.</q>
<li>m88k(Fix): 例外優先度をいろいろ修正。
 <q>Fix several exception priorities.</q>
<li>m88k(Fix): データアクセス例外発生時の DMx レジスタをいくつか修正。
 <q>Fix several DMx registers upon a data access exception.</q>
<li>m88k(Fix): ld.d 命令の第2ワードで例外が発生した時の動作を修正。
 <q>Fix the behavior of the ld.d instruction when an exception occurred on
 the second word.</q>
<li>m88k(Fix): PID, SXIP レジスタが書き込み可能になっていたのを修正。
 <q>Fix that PID and SXIP registers were writeable.</q>
<li>m88k(Update): m88200 の内部の BATC/PATC サーチ方法を ver 0.6.1 のものに戻す。
 <q>Revert the search method inside the BATC/PATC to that of ver 0.6.1.</q>
<li>vm(Update): 内蔵 LUNA-88K PROM の割り込みハンドラを整備。
 OpenBSD/luna88k の /boot の hexdump コマンドがバスエラー領域でハングアップ
 していたのが直ります。
 <q>Implement an interrupt handler in the builtin emulated PROM on LUNA-88K.
 This fixes the issue where the hexdump command on the OpenBSD/luna88k boot
 loader was hanging when accessing the bus error region.</q>
<li>vm(Update): LUNA-88K のメモリマップを全体的に更新。実機に近づける。
 <q>Modify and adjust the memory map on LUNA-88K.</q>
<li>vm(New): SCSI バスでセレクションフェーズからメッセージアウトフェーズへの移行を
 実装。
 これで UniOS Mach 起動中に nono が不正終了していたのは直ります(まだ動きません)。
 <q>Implement the SCSI bus transition from the selection phase to
 the message out phase.
 This fixes the abnormal termination while booting UniOS Mach.
 (But it doesn't work yet.)</q>
<li>vm(Fix): 書き込み禁止の SCSI イメージファイルの扱いを変更。
 <q>Change the handling of write-protected SCSI image files.</q>
<li>vm(New): ソフトウェアキーボードを LUNA-88K に対応(?)。
それに伴い LUNA-I、X68030 の一部の内部キーコードも変更。
 <q>Support the LUNA-88K software keyboard(?).  As a result of this,
 several internal keycodes on LUNA-I and X68030 are also moved.</q>
<li>debugger(Update): ブレークポイントモニタを m88k に対応。
 <q>The breakpoint monitor now supports m88k.</q>
<li>debugger(Update): ブレークポイントモニタの命令ブレークポイントを 1バイト命令
(HD64180) にも対応。
 <q>The breakpoint monitor now supports 1-byte instructions like HD64180.</q>
<li>debugger(Fix): ブレークポイントの CPU 名が正しくない場合に不正終了する場合があったのを修正。
 <q>Fix the abnormal termination when a breakpoint has an invalid CPU name.</q>
<li>debugger(Update): ベクタテーブルを LUNA-88K に対応。
 <q>The vector table now supports LUNA-88K.</q>
<li>debugger(Update): bv コマンドの書式を変更。
 <q>Change the syntax of the bv command.</q>
<li>debugger(Update): bi コマンドで一部のニーモニック表記を実装。
 <q>The bi command supports some mnemonics.</q>
<li>debugger(New): --bi オプション、--bv オプションを実装。
 <q>Implement --bi and --bv options.</q>
<li>util/nvramedit(Fix): NVRAM.DAT のファイルサイズを修正。
 <q>Fix the file size of NVRAM.DAT.</q>
</ul><p>

<dt>1.4.0 (2025/03/30)
<dd><ul>
<li>vm(New): HD647180 ASCI (非同期シリアル) を実装。
 <q>Implement HD647180 ASCI (Asynchronous Serial Communication Interface).</q>
<li>vm(Fix): X68030 キーボード LED の変更がソフトウェアキーボードに
反映されないことがあったのを修正。
 <q>Fix an issue that keyboard LED changes may not be reflected in the
 software keyboard window on X68030.</q>
<li>host(New): ネットワークとシリアルのホストドライバの実行時切り替えを実装。
 <q>Implement run-time switching of the network and serial host driver.</q>
<li>app(Update): <tt>hostcom-driver=cons</tt> を
<tt>hostcom-driver=console</tt> に変更。(<tt>cons</tt> も引き続き使用可能)
 <q>Change <tt>hostcom-driver=cons</tt> to <tt>hostcom-driver=console</tt>
 (<tt>cons</tt> is still available).</q>
<li>GUI(Fix): マウスモードを抜けてもタイトルが戻らない場合があったのを修正。
 <q>Fix an issue that the title might not change after leaving mouse mode.</q>
<li>GUI(Fix): ステータスパネルの幅によっては不正終了していたのを修正。
 <q>Fix abnormal terminations caused by status panel width.</q>
<li>GUI(Fix): ログモニタ表示中にフォントサイズ変更すると不正終了する場合が
あったのを修正。
 <q>Fix an issue that changing the font size while the log monitor is
 displayed might cause an abnormal termination.</q>
<li>GUI(Fix): ログモニタ、LCD モニタがフォントサイズ変更でレイアウトが
崩れる場合があったのを修正。
 <q>Fix an issue that changing the font size might break layout
 on the log monitor and LCD monitor.</q>
<li>GUI(Fix): ウィンドウの描画で不正終了する可能性があったのを修正。
 <q>Fix several issues that drawing window might cause abnormal termination.</q>
<li>GUI(Fix): メモリモニタのボタンサイズを調整。
 <q>Adjust button size on the memory monitor.</q>
<li>GUI(Update): メイン画面縮小時のレイアウトを調整。
 <q>Adjust main window layout when the window is shrunk.</q>
<li>GUI(Update): メモリモニタ、ビットマップモニタの初期サイズを調整。
 <q>Adjust initial size of memory monitorand bitmap monitor.</q>
<li>GUI(Update): メモリモニタ、ログモニタ、履歴モニタ、ベクタモニタの
ウィンドウの伸縮を1行単位に変更。
 <q>Adjust window stretch of memory monitor, log monitor, history monitor
and vector monitor.</q>
</ul><p>

<dt>1.3.0 (2025/02/26)
<dd><ul>
<li>vm(New): VirtIO SCSI を実装。
 <q>Implement VirtIO SCSI.</q>
<li>vm(New): X68030 MFP のタイマー割り込みを実時間同期モードに対応。
 <q>X68030 MFP timer interrupts now support real-time synchronization.</q>
<li>vm(New): NWS-1750 のシステムタイマー割り込みを実時間同期モードに対応。
 <q>NWS-1750 system timer interrupt now supports real-time synchronization.</q>
<li>vm(Update): X68030 MFP のフリーランタイマーはイベントを使わないように変更。
 <q>X68030 MFP free-run timer now doesn't use scheduler events.</q>
<li>vm(Fix): (virt-m68k で) メモリ 2GB 以上の指定がエラーになっていたのを修正。
 <q>Fix an issue that specifying 2GB or more of memory would cause an error
 (on virt-m68k).</q>
<li>vm(Fix): X68030 の JP キーボードモードで SHIFT
キー押下で高速モードが解除されなかった問題を修正。
 <q>Fix an issue that full speed mode could not be relased by pressing
 SHIFT key in X68030 JP keyboard mode.</q>
<li>vm(Fix): SCSI デバイスが RST をアサートしたらバスフリーフェーズに移行するよう修正。
 <q>Fix to transition to bus free phase when a SCSI device asserts RST.</q>
<li>vm(Fix): SCSI デバイスモニタで 10GB 以上の容量が正しく表示できていなかったのを修正。
 <q>Fix an issue that the disk size over 10GB was not displayed correctly
 on SCSI device monitor.</q>
<li>m68k(Update): 68040 のテーブルサーチ処理をいろいろ改善。
 <q>Make various improvements to 68040 table search processing.</q>
<li>m68k(Update): 68040 の命令サイクル数をなんとなく近づける。
 <q>Improve almost 68040 instruction cycles somewhat closer.</q>
<li>m68k(Fix): 68030 の命令サイクル数をいろいろ修正、あるいは実装。
 <q>Improve or implement some 68030 instruction cycles.</q>
<li>m68k(Fix): MPU が 68040 だと例外履歴で IOCS コールを認識できていなかったのを修正。
 <q>Fix an issue that the exception history could not detect the IOCS call on 68040.</q>
<li>m68k(Update): 例外履歴を Human68k の DOS コールに対応。
 <q>The exception history now supports Human68k DOS calls.</q>
<li>m88k(Fix): ver 0.7.2 以降、メインメモリ以外へのアクセスが失敗するケースがあったのを修正。
 <q>Fix an issue that access to devices other than main memory may fail
 since ver 0.7.2.</q>
<li>host(Fix): ユーザモードネットワークで
ルータのリンクローカルアドレスへの ICMPv6 Echo Request
パケットをドロップしていたのを修正。
 <q>Fix an issue dropping ICMPv6 Echo Request packet to router's link local
 address on the usermode network.</q>
<li>app(New): (X68030 に) --fd0, --fd1 オプションを実装。
 <q>Support --fd0, --fd1 options for X68030.</q>
<li>GUI(Fix): NWS-1750、virt-m68k のメニューからソフトウェアキーボードウィンドウを削除。
 <q>Remove incorrect software keyboard window from the menu
 on NWS-1750 and virt-m68k.</q>
<li><span class="strike">vm(Update): virt-m68k のパフォーマンス測定ギミックを
VirtIONet から GFTTY に変更。
 <q>Change performance measurement gimic on virt-m68k from VirtIONet to GFTTY.</q></span>
</ul></p>

<dt>1.2.0 (2025/01/26)
<dd><ul>
<li>host(New): ホストネットワークドライバに usermode (SLIRP) をサポート。
 <q>Add a usermode (SLIRP) to host network driver.</q>
<li>host(Update): <tt>hostnet-driver</tt> の値 <tt>auto</tt> の動作を変更。
 <q>Change the behavior when <tt>hostnet-driver</tt> value is <tt>auto</tt>.</q>
<li>vm(Update): 高速モード動作中に CPU が STOP 状態になっても
X68030 の DMAC が動作中は高速モードを維持する。
 <q>Even if the CPU goes into STOP state during full speed mode,
 keep it if DMAC is active on X68030.</q>
<li>vm(Fix): X68030 の FDC がドライブセレクト信号の変化でポーリングを再開するよう修正。
 <q>Fix problem that polling didn't resume when the drive select signal
 changed.</q>
<li>vm(Fix): virtio_net がマルチキャストパケットを受信していなかったのを修正。
 <q>Fix virtio_net not receiving multicast packets.</q>
<li>vm(Fix): Lance(AM7990) のマルチキャスト受信ハッシュを修正。
 <q>Fix multicast hash on Lance(AM7990).</q>
<li>vm(Fix): RTL8019AS のマルチキャストハッシュを含む受信制御を修正。
 <q>Fix RTL8019AS whole receiving algorithm including multicast hash.
<li>vm(New): RTL8019AS の RSR.PHY ビットを実装。
 <q>Implement RSR.PHY bit on RTL8019AS.</q>
</ul></p>

<dt>1.1.2 (2025/01/12)
<dd><ul>
<li>m68k(Fix): FMOVEM.X -(An),&lt;fplist&gt;、
FMOVEM.X &lt;fplist&gt;,(An)+ は挙動が観測できなくなったので不当命令に戻しました。
 <q>Revert FMOVEM.X -(An),&lt;fplist&gt; and
 FMOVEM.X &lt;fplist&gt;,(An)+ to the illegal instruction
 because the behavior can no longer be observed.</q>
<li>m68k(Fix): FMOVE.X FPn,&lt;ea&gt; 付近の不当命令でフラグが変化していたのを修正。
 <q>Fix that illegal instructions around FMOVE.X FPn,&lt;ea&gt; might
 change FPSR.</q>
<li>m68k(Fix): ver 0.7.2 以降、68030 ATC で Modified ビットの処理が動作していなかったのを修正。
 <q>Fix problem that 68030 ATC incorrectly operated Modified bit since ver 0.7.2.</q>
<li>m68k(Fix): ver 1.1.0 以降、CMP.[WL] An,Dn が逆アセンブルできなくなっていたのを修正。
 <q>Fix disassemble of CMP.[WL] An,Dn since ver 1.1.0.</q>
<li>vm/human68k(Update): タイマー用のワークエリアを実装。
 <q>Implement timer work area.</q>
<li>util/runx(Fix): バグ修正。
 <q>Fix several problems.</q>
<li><span class="strike">m68k(Experimental): 68LC040 に対応。</span>
</ul><p>

<dt>1.1.1 (2024/12/31)
<dd><ul>
<li>m68k(Fix): FABS、FNEG、FMOVE.D &lt;ea&gt;,FPn、FMOVE.X &lt;ea&gt;,FPn、
FMOVE.X FPn,&lt;ea&gt; 命令のフラグ変化を修正。
 <q>Fix flags on FABS, FNEG, FMOVE.D &lt;ea&gt;,FPn, FMOVE.X &lt;ea&gt;,FPn
 and FMOVE.X FPn,&lt;ea&gt;.</q>
<li><s>m68k(Update): 不当命令のはずの FMOVEM.X -(An),&lt;fplist&gt; の挙動を実装。
 <q>Implement behaviors of FMOVEM.X -(An),&lt;fplist&gt;
 that should be an illegal instruction.</q></s>
<li><s>m68k(Update): 不当命令のはずの FMOVEM.X &lt;fplist&gt;,(An)+ の挙動を一部実装。
 <q>Implement a part of behaviros of FMOVEM.X &lt;fplist&gt;,(An)+
 that should be an illegal instruction.</q></s>
<li>vm(Fix): ver 0.7.0 以降、X68030 でフロッピー2枚指定した状態で起動すると
IPLROM 画面でハングアップしていたバグを修正。
 <q>Fix hangup problem when you insert two floppies on startup on X68030
 since ver 0.7.0.</q>
<li>vm(Update): Human68k モードで IOCS _B_INTVCS に一部対応。
 <q>Implement a part of IOCS _B_INTVCS on Human68k mode.</q>
<li>util(Update): runx で IOCS _B_INTVCS に一部対応。
 <q>Implement a part of IOCS _B_INTVCS on runx.</q>
</ul>
<p>

<dt>1.1.0 (2024/12/25)
<dd><ul>
<li>m68k(New): 68040 に対応開始。新設命令の一部と MMU/FPU くらい。
 <q>Start implementing 68040.  Currently, it supports some new instructions,
 MMU and FPU.</q>
<li>m68k(New): (68030 の) cpSAVE、cpRESTORE の挙動を実装。
 <q>Implement cpSAVE, cpRESTORE behavior on 68030.</q>
<li>m68k(Fix): FSAVE 命令のメモリへの書き出し順を修正。
 <q>Fix the order that FSAVE writes to the memory.</q>
<li>m68k(Fix): FBcc、FDBcc、FScc、FTRAPcc のフラグ動作を修正。
 <q>Fix flags on FBcc, FDBcc, FScc and FTRAPcc.</q>
<li>m68k(Fix): FDBcc の分岐アドレスの計算を修正。
 <q>Fix branch address calculation on FDBcc.</q>
<li>m68k(Fix): FMOVE.X FPn,&lt;ea&gt; 命令の OVFL, UNFL フラグ変化を修正。
 <q>Fix OVFL, UNFL flags on FMOVE.X FPn,&lt;ea&gt;.</q>
<li>m68k(Fix): FMOVE.[BW] FPn,&lt;ea&gt; 命令で FPn が範囲外の場合の結果を改善。
 <q>Improve result of FMOVE.[BW] FPn,&lt;ea&gt; when FPn is out of range.</q>
<li>m68k(Fix): F ライン中の不当命令パターンで F ライン例外が起きないケースが
あったのを修正。
 <q>Fix a problem that there were cases where F-line exception was not occurred
 even if the F-line instruction pattern was illegal.</q>
<li>m68k(Fix): FPU リセット時のレジスタの初期化を実装。
 <q>Implement that initialize FPU registers on the FPU reset.</q>
<li>m68k(Fix): RTE 命令と FRESTORE 命令がフォーマットエラー例外を起こすケースを実装。
 <q>Implement a format error exception on RTE and FRESTORE.</q>
<li>m68k(Update): レジスタモニタに FPn の10進表記を実装。
 <q>Implement the decimal representation of the FPn on the register monitor.</q>
<li>m68k(Update): 不当な EA を持つ命令は逆アセンブラで不当命令として表示する。
 <q>If an instruction has an illegal EA, the debugger now shows it as
 an illegal instruction.</q>
<li>m68k(Update): デバッガで FBcc、FDBcc、FScc、FTRAPcc の分岐情報表示に対応。
 <q>The debugger now shows branch condition even on FBcc, FDBcc, FScc
 and FTRAPcc.</q>
<li>hd64180(Fix): CPIR, CPDR, INIR, INDR, OTIR, OTDR 命令の動作を修正。
 <q>Fix CPIR, CPDR, INIR, INDR, OTIR, OTDR instructions.</q>
<li>hd64180(Fix): 未定義命令トラップでスタックに積む内容が
正しくないケースがあったのを修正。
 <q>Fix contents that is pushed into the stack when the undefined opcode trap.</q>
<li>hd64180(Update): Z80 の未定義命令 SLL、LD IXr,n の逆アセンブルに対応。
 <q>Supports disassemble of Z80's undefined opcode as SLL or LD IXr,n.</q>
<li>hd64180(New): 設定項目 <tt>xp-clock</tt> を追加。
 <q>Add <tt>xp-clock</tt> configuration.</q>
<li>vm(New): virt-m68k (と NEWS) のシリアルコンソールの端末エミュレーションを実装。
 <q>Implement a terminal emulation of serial console on virt-m68k (and NEWS).</q>
<li>vm(New): virt-m68k の BootInfo BI_COMMANDLINE を実装。
NetBSD/virt68k にルートデバイスを指定できるようになります。
 <q>Implement BI_COMMANDLINE on BootInfo.
 Now you can specify the root device to NetBSD/virt68k.</q>
<li>vm(Fix): SPC リセット時にキューをクリアする。
IPLROM 1.6 でリセット時に SASI 機と誤認されるケースがあったのが直ります。
 <q>Clear the SPC's internal queue on the reset.</q>
<li>vm(Fix): virtio-net のリセット処理を実装。
 <q>Implement a reset on virtio-net.</q>
<li>vm(Fix): Goldfish Timer のリセット以降タイマーが動作しない場合があったのを修正。
 <q>Fix a problem that Goldfish Timer might not work after the reset.</q>
<li>vm(Fix): Goldfish PIC もリセット時にカウンタをクリアする。
 <q>Clear the Goldfish PIC's monitor counter on the reset.</q>
<li>GUI(Fix): SPC モニタの X68030 のアドレスを修正。
 <q>Fix SPC address label on X68030 SPC monitor.</q>
<li>GUI(Fix): ベクタテーブルモニタを virt-m68k に対応。
 <q>Support virt-m68k on the vector table monitor.</q>
<li>GUI(Fix): 文字入力モードでカーソルキーが入力できないケースがあったのを修正。
 <q>Fix a proiblem where cursor key input was sometimes not possible.</q>
</ul>
<p>

<dt>1.0.0 (2024/10/31)
<dd><ul>
<li>m68k(New): データキャッシュを実装。
 <q>Implement data cache.</q>
<li>vm(Update): バス構造を全面書き直し。
 <q>Rewrite whole bus structure.</q>
<li>m68k(Update): FTRAPcc 命令を実装。
 <q>Implement FTRAPcc instructions.</q>
<li>m68k(Fix): MOVE.W ea,CCR 命令が特権命令になっていなかったのを修正。
 <q>Fix problem that MOVE.W ea,CCR instruction was not privileged.</q>
<li>m68k(Fix): キャッシュエントリクリア動作を修正。
 <q>Fix cache entry clear operation.</q>
<li>m68k(Fix): 同じレジスタの (An)+ か -(An) が2回現れる命令で
バスエラーが起きた場合に RTE で回復できない可能性があるのを修正。
 <q>Fix problem that RTE instruction may not be able to recover from a bus error
 if it occurred on an instruction which
 accesses the same register's (An)+ or -(An) twice.</q>
<li>m68k(Fix): リセット例外以外の例外ベクタをデータ空間から取得するよう修正。
 <q>Fix problem that some exception vector was fetched from wrong
 address space.</q>
<li>m68k(Fix): FPU なしの時にもモニタに FPU レジスタが表示されていたのを修正。
 <q>Fix problem that 68030 register monitor displays FPU registers
 even though no FPU.</q>
<li>vm(Update): LUNA-88K で Lance の未定義ポートへのアクセスを修正。
 <q>Fix accessing to Lance's undefined port on LUNA-88K.</q>
<li>vm(Update): X68030 CRTC の未定義ポートへのアクセスを修正。
 <q>Fix accessing to CRTC's undefined port on X68030.</q>
<li>vm(Update): Human68k モードに DOS コールをいくつか追加。
fputest.x (0.17.* 以降) が動作するようになりました。
 <q>Implement several DOS calls on Human68k mode.
 Now you can run fputest.x (0.17.* and later) on it.</q>
<li>vm(Fix): VirtIO Network のデバイスリセットを修正。
 <q>Fix a device reset on VirtIO Network device.</q>
<li>vm(Fix): X68030 DMAC の一部のレジスタのワードアクセスを修正。
 <q>Fix a word access to some DMAC registers on X68030.</q>
<li>vm(Fix): 設定項目 <tt>mpu-clock</tt>
 の小数点以下3桁目が正しく指定できない場合がある問題を修正。
 <q>Fix problem that the third decimal place of configuration item
 <tt>mpu-clock</tt> may not be able to specified correctly.</q>
<li>vm(Fix): X68030 の CTRL+OPT.1+DEL 入力で不正終了する可能性があるのを修正。
 <q>Fix possibility of an abnormal termination on CTRL+OPT.1+DEL input
 on X68030.</q>
<li>vm(Fix): X68030 フロッピーのモーター回転中の再アクセスが出来ない問題を修正。
 <q>Fix problem that you could not access the floppy again while
 the motor is on on X68030.</q>
<li>app(Update): <tt>-H</tt> オプション指定時は <tt>-c</tt> を省略可能にする。
 <q>Make <tt>-c</tt> optional when <tt>-H</tt> is specified.</q>
<li>GUI(Fix): パフォーマンスカウンタを 100倍速以上の表示に対応。
 <q>Support display of 100x speed or more on performance counter.</q>
<li>util(New): runx を実装。
instructiontest.x と fputest.x (0.16.* 以前および 0.17.* 以降) が実行できます。
 <q>Implement runx.
 It can run instructiontest.x and fputest.x (before 0.16.* and after 0.17.*).</q>
</ul>
<p>

<dt>0.7.3 (2024/07/03)
<dd><ul>
<li>vm(Fix): LUNA-88K のリセットでスケジューラが停止する場合がある問題を修正。
 <q>Fix problem that resetting on LUNA-88K sometimes stops the scheduler.</q>
<li>vm(Fix): MSX-DOS モードが ver 0.7.0 以降即終了していた問題を修正。
 <q>Fix problem that MSX-DOS mode immediately exits since er 0.7.0.</q>
<li>vm(Fix): LUNA-I の実機 PROM から SPC へのアクセスが ver 0.7.0
以降正しく行えていなかったのを修正。
 <q>Fix problem that the real PROM image could not access SPC correctly on
 LUNA-I since ver 0.7.0.</q>
<li>vm(Fix): 起動時に windrv-path で指定したディレクトリがない場合はエラーにする。
 <q>Make an error if the directory specified by windrv-path does not exist
 on startup.</q>
<li>vm(Fix): レンダラが過剰に動作していたのを修正。
 <q>Fix problem that the renderer runs excessively.</q>
<li>vm(New): X68030 のコントラスト処理を aarch64 の NEON に対応。
 <q>X68030 Contrast rendering now can use NEON on aarch64.</q>
<li>vm(New): SSG (YM2149) をレジスタアクセスだけ実装 (まだ何も動きません)。
 <q>Implement SSG (YM2149) registers only (It doesn't work yet).</q>
<li>vm(Update): メイン画面の拡大縮小をレンダラスレッドで行うように変更。
 <q>Mainview scaling is now done by the renderer thread.</q>
<li>vm(Update): SPC モニタにレジスタのアドレスを表示。
 <q>Display register addresses on the SPC monitor.</q>
<li>vm(Update): SCSI の内部構造を変更。外部動作は変更ないはず。
 <q>Change several SCSI internal structures.
 No functional changes intended.</q>
<li>vm(Update): その他動作に影響ないはずの変更や修正をいろいろ。
 <q>Various internal improvements.  No functional changes intended.</q>
<li>m68k(Update): ATC のライン数を 22 本に戻す。パフォーマンスは約2%改善。
 <q>Put back the number of ATC lines to 22.  It improves the performance
 about 2%.</q>
<li>GUI(New): アクセス状況モニタをグラフィカルに。
 <q>Make the access status monitor graphical.</q>
<li>GUI(Update): ビットマップ全般の内部構造を変更。外部動作は変更ないはず。
 <q>Change whole bitmap internal structures. No functional changes intended.</q>
<li>GUI(Update): プリセット倍率での拡大縮小処理を 3-5 倍高速化。
 <q>Improve scaling performance at preset magnification by 3-5 times.</q>
<li><span class=strike>vm(New): CPU アフィニティの設定を可能にする(デバッグ評価用)
 <q>Allow CPU affinity configuration for debugging and evaluation.</q></span>
</ul>
<p>

<dt>0.7.2 (2024/05/11)
<dd><ul>
<li>m68k(Update): ATC および TT サーチのパフォーマンスを約10%改善。
 <q>Improve ATC and TT search performance about 10%.</q>
<li>vm(Update): LUNA、virt-m68k でバースト転送をサポートし、
パフォーマンスを m68k で約6-10%程度、m88k で約3%改善。
(X68030 は本体回路がバースト転送をサポートしていません)
 <q>Implement a burst transfer on LUNA and virt-m68k.
 It improves the performance of m68k by about 6-10% and m88k by about 3%.
 (X68030 hardware doesn't support the burst transfer)</q>
<li>vm(Update): virt-m68k 全体と virtio-block のパフォーマンスもわずかに改善。
 <q>Improve performance of whole virt-m68k and virtio-block slightly.</q>
<li>vm(Update): スケジューラモニタと 88100 レジスタモニタを調整。
 <q>Minor adjustment for scheduler monitor and 88100 register monitor.</q>
<li>vm(Update): X68030 のアクセス状況モニタを他機種と統一するため
 2MB/char に変更。
 <q>Change unit to 2MB/char on X68030 access stat monitor
 to be consistent with other VMs.</q>
<li><span class="strike">vm(New): virt-m68k のパフォーマンス測定ギミックを実装。
 <q>Implement performance measurement gimic on virt-m68k.</q></span>
<li><span class="strike">m68k(Fix): ver 0.6.3 以降「VM 再実行」で終了するケースがあったのを修正。
 <q>Fix problem that "Restart VM" sometimes causes app termination
 since ver 0.6.3.</q></span>
</ul>
<p>

<dt>0.7.1 (2024/03/28)
<dd><ul>
<li>m88k(Update): m88100、m88200 に適切なマスクバージョンを設定。
OpenBSD/luna88k が1〜2割高速になります。
 <q>Set good m88100, m88200 mask version.
 It makes OpenBSD/luna88k faster 10~20%.</q>
<li>vm(Update): virt68k の機種名を virt-m68k に変更
 (従来の vmtype=virt68k も使えます)。
 <q>Change canonical machine name from virt68k to virt-m68k.
 (vmtype=virt68k can also be used.)</q>
<li>vm(Update): VirtIO の間接ディスクリプタを実装。
 <q>Support VirtIO's indirect descriptor.</q>
<li>vm(Update): VirtIO Network のキューサイズを調整。
 <q>Adjust VirtIO Network's queue size.</q>
<li>vm(New): VirtIO Entropy デバイスを実装。
 <q>Implement VirtIO Entropy device.</q>
<li>vm(Fix): Goldfish Timer で過去の時刻が指定された場合に即割り込みを
上げるよう修正。
 <q>Fix Goldfish timer to raise an interrupt immediately
 if the specified time is in the past.</q>
<li>vm(Fix): X68030 CRTC アクセスが ver 0.7.0 以降壊れていたのを修正。
 <q>Fix CRTC accesses on X68030 broken since ver 0.7.0.</q>
</ul>
<p>

<dt>0.7.0 (2024/02/21)
<dd><ul>
<li>vm(New): virt68k をサポート開始。
 <q>Start to support virt68k.</q>
<li>vm(Fix): Nereid イーサネットボード2枚モードで
割り込みアクノリッジが正しく処理されないのを修正。
 <q>Fix problem that the interrupt acknowledge didn't handle correctly
 when two Nereid boards are installed simultaneously.</q>
<li>vm(Fix): リセット時にいくつかのデバイスでスプリアス割り込みが起きる場合があったのを修正。
 <q>Fix several spurious interrupts on resetting on various devices.</q>
<li>vm(Fix): X68030 SCC の MIE を実装。
 <q>Implement MIE on X68030 SCC.</q>
<li>vm(Fix): X68030 MFP でタイマー開始時に TxDR を更新しないよう修正。
 <q>Fix not to update TxDR on starting the timer on X68030 MFP.</q>
<li>vm(Fix): X68030 CRTC のアクセスを色々改善。
 <q>Fix several accesses to CRTC on X68030.</q>
<li>vm(Update): バスアクセス全体を色々整理中。
 デバイスのウェイトが意図的に、あるいは意図せず変わっているかも知れません。
 <q>Fix and rearrange whole bus access.
 Some device wait may be changed intentionally or unintentionally.</q>
<li>vm(Update): 全機種の電源デバイスを整理。
 <q>Rearrange the power devices on all architecture.</q>
<li>app(New): 画面レンダリングを amd64 の AVX2 に対応。
 <q>Graphic rendering now can use AVX2 on amd64.</q>
<li>app(Update): -X は -H なしだと引数1つだけを受け取るように変更。
 <q>-X option is changed to accept only one argument if -H is not specified.</q>
<li>app(Update): 設定項目に exec-file, exec-arg を追加。
 <q>Configuration item exec-file and exec-arg are added.</q>
<li>app(Update): オプション --initrd と設定項目 exec-initrd を追加。
 <q>--initrd option and configuration item exec-initrd are added.</q>
<li>app(Update): 設定ファイル中のパスの '~' をホームディレクトリに置換する。
 <q>Path beginning of '~' in the configuration file is replaced to the
 home directory.</q>
<li>app(Fix): -X が指定されても -Lhelp が表示できるよう修正。
 <q>-Lhelp can be displayed even if -X is specified.</q>
<li><span class=strike>debugger(Update): dt、mt コマンドを廃止。</span>
</ul>
<p>

<dt>0.6.4 (2023/12/28)
<dd><ul>
<li>vm(New): X68030 に Windrv 互換デバイスを実装。
Human68k からホストのディレクトリが見えるようになります。
 <q>Implement a Windrv compatible device on X68030.
 You can access a host directory via the device on Human68k.</q>
<li>vm(New): X68030 のコントラスト設定を実装。
 <q>Implement a contrast feature on X68030.</q>
<li>vm(Update): X68030 で SPC のキューが一杯で書き込みが待たされるのを実装。
Human68k から SCSI メディアに書き込みが出来るようになります。
 <q>Implement that writing to the SPC is made to wait if the internal
 queue is full.  You can write a SCSI media on Human68k.</q>
<li>vm(Update): X68030 DMAC からのアクセスに FC (ファンクションコード) を反映。
 <q>DMAC now uses FC (Function Code) to access on X68030.</q>
<li>vm(Update): JP キーボードモードでホストの [PageUp]、[PageDown]、[End]
 キーを X68030 の [ROLL UP]、[ROLL DOWN]、[UNDO] キーに対応。
 <q>Connect the host's [PageUp], [PageDown] and [End] key to guest's
 [ROLL UP], [ROLL DOWN] and [UNDO] key respectively on X68030.
<li>vm(Fix): X68030 で SCC、FDC、SPC、Nereid
が正しくリセットされていなかったのを修正。
 <q>Fix the problem that SCC, FDC, SPC and Nereid are not reset
 correctly on X68030.</q>
<li>vm(Fix): X68030 の CIIN 信号線の条件が誤っていたので修正。
 <q>Fix a CIIN condition on X68030.</q>
<li>vm(Fix): X68030 の $ED0000..$EDFFFF がユーザアクセス可能だったのを修正。
 <q>Fix $ED0000..$EDFFFF was user-accessible on X68030.</q>
<li>vm(Fix): X68030 マウスのデータ送出タイミングを調整。影響はないはず。
 <q>Fix timing that mouse sends its data on X68030.
 It should not affect anything.</q>
<li>m68k(Update): m68k コアのパフォーマンスを改善しました。
 <q>Improve m68k core performance.</q>
<li>GUI(New): メニューを再編して、
「デバイス &gt; 操作」の一部と旧「ファイル」を「VM」に統合。
 <q>Rearrange menus.  A part of "Device &gt; Operation" and old "File"
 menus are integrated into"VM".</q>
<li>GUI(New): X68030 のメニューに「CTRL+OPT.1+DEL を送信」を追加。
 <q>Add "Send CTRL+OPT.1+DEL" menu on X68030.</q>
<li>GUI(Fix): 0.6.3 以降、
ログレベル設定ウィンドウを開くと不正終了していたのを修正。
 <q>Fix an abnormal termination when open the loglevel setting window
 since 0.6.3.</q>
<li>debugger(Fix): コマンドラインオプション -b の引数が16進数として処理できない場合に不正終了していたのを修正。
 <q>Fix an abnormal termination when the argument of command line option
 <tt>-b</tt> cannot be parsed as a hexadecimal number.</q>
<li><span class="strike">debugger(New): --bi-exg オプションを実装。</span>
</ul><p>

<dt>0.6.3 (2023/11/30)
<dd><ul>
<li>m68k(New): 命令キャッシュを実装。
 X68030 IPL の MPU クロック表示が正しく表示されるようになります。
 <q>Implement an instruction cache.
 Finally X68030 IPL can display correct MPU clock speed.</q>
<li>vm(New): X68030 のエリアセット、拡張エリアセットをたぶん実装。
 <q>Implement areaset and extended areaset features on X68030.</q>
<li>vm(New): X68030 の FC2 ピンを切断するオプションを実装。
 <q>Implement an option whether to cut FC2 or not on X68030.</q>
<li>vm(New): X68030 システムポートモニタを実装。
 <q>Implement a system port monitor on X68030.</q>
<li>vm(New): アクセス状況モニタを実装。
 <q>Implement an access status monitor.</q>
<li>vm(Update): LUNA-I で実機 PROM イメージを使う場合のメモリ上限を
255MB に制限する。
 <q>Restrict memory size to 255MB when using PROM image on LUNA-I.</q>
<li>vm(Update): LUNA-I, LUNA-88K のメモリ上限、
X68030 の拡張メモリの上限を 512MB に変更。
 <q>Change memory size limit to 512MB on LUNA-I, LUNA-88K and X68030.</q>
<li>m68k(Fix): バスエラーハンドラ起動中のアドレスエラーが二重バスフォールトに
ならなかったのを修正。
 <q>Fix the problem that an address error while executing bus error handler
does not cause double bus fault.</q>
<li>vm(Fix): LUNA-88K の XP プロセッサの割り込みレベルを修正。Issue#131
 <q>Correct interrupt levels from XP Processor on LUNA-88K.</q>
<li>GUI(Fix): ビットマッププレーンモニタが 256色モードに対応していなかった
のを修正。Issue#133
 <q>Fix the problem that the bitmap plane monitor did not support
256-color mode.</q>
<li>build(Fix): util/mkcgrom を OpenBSD でのビルドに対応。
 <q>Make util/mkcgrom buildable on OpenBSD.</q>
</ul>
<p>

<dt>0.6.2 (2023/08/16)
<dd><ul>
<li>m88k(Fix): m88200 のアドレス変換がオフの場合でも暗黙 BATC を有効にする。
 <q>Implement that hardwired BATCs are enable even if the address
 translation is disabled on m88200.</q>
<li>m88k(Update): m88200 の BATC/PATC サーチのパフォーマンスを改善。
 <q>Improve m88200 BATC/PATC search performance.</q>
<li>vm(Fix): リセット時に PEDEC の割り込みをクリアする。
 <q>Negate PEDEC interrupts when resetting.</q>
<li>vm(Update): Nereid、Lance のマルチキャストフィルタを実装。
 <q>Implement multicast filter on Nereid and Lance.</q>
<li>vm(Update): LUNA-I, LUNA-88K 内蔵 PROM のホストファイルの処理を再編。
 <tt>--load-only</tt> オプションを廃止。
 <q>Reorganize host file handling on LUNA-I/LUNA-88K internal PROM.
 It obsoletes <tt>--load-only</tt> option.</q>
<li>build(Update): wxWidgets を 3.2 → 3.0 の順で探すように変更。
 <q>Search wxWidgets 3.2, 3.0 in order.</q>
</ul>
<p>

<dt>0.6.1 (2023/04/23)
<dd><ul>
<li>vm(Update): NWS-1750 の $e000'0000〜$efff'ffff
のうちデバイスのない領域をバスエラーにしないよう変更。
またそれに伴い、設定の <tt>xxx-news-sic-ignore</tt> を廃止。
 <q>Change that access to the range from $e000'0000 to $efff'ffff
 doesn't cause a bus error on NWS-1750.
 Along with this, <tt>xxx-news-sic-ignore</tt> is obsoleted.</q>
<li>vm(Update): NWS-1750 の PROM エミュレーションに
TRAP#15 のダミーハンドラを実装。
 <q>Implement dummy TRAP#15 handler on NWS-1750's PROM emulation.</q>
<li>GUI(New): NEWS のデバイスマップモニタを実装。
 <q>Implement NEWS' device map monitor.</q>
<li>GUI(Fix): ver 0.6.0 で一部のモニタがメニューからなくなっていたのを修正。
 <q>Fix problem that some monitors are not shown in menu since ver 0.6.0.</q>
</ul>
<p>

<dt>0.6.0 (2023/03/22)
<dd><ul>
<li>vm(New): Nereid 拡張ボードのバンクメモリとイーサネット(RTL8019AS)を実装。
 <q>Implement a bank memory and ethernet (RTL8019AS) of Nereid expansion
 board.</q>
<li>vm(Fix): X68030 で -X オプションで起動した時の割り込みレベルを修正。
 <q>Fix an interrupt level when -X option is used in X68030.</q>
<li>debugger(Update): 例外履歴を X68030 の IOCS コールに対応。
 <q>Support X68030 IOCS call in the exception history.</q>
</ul>
<p>

<dt>0.5.1 (2023/02/12)
<dd><ul>
<li>vm(Fix): X68030 拡張メモリがない領域がバスエラーにならないよう修正。
 <q>Fix a bus error in areas with no extended memory in X68030.</q>
<li>vm(Update): HD647180 の DAA 命令を実装。
 <q>Implement DAA instruction on HD647180.</q>
<li>debugger(Fix): HD647180 リセット状態中にセットしたブレークポイントが
効かなかったのを修正。
 <q>Fix breakpoints set while HD647180 is in reset state not working.</q>
<li>GUI(New): デバイスマップモニタを実装。
 <q>Implement a device map monitor.</q>
<li>GUI(Update): DIPSW ウィンドウのスイッチをフォントサイズに連動させる。
 <q>Link control size with font size, on DIPSW window.</q>
<li>GUI(Fix): ビットマップモニタウィンドウを24ドットフォントに対応。
 <q>Support 24 dot fonts in a bitmap monitor window.</q>
<li>GUI(Fix): ビットマップモニタウィンドウをリサイズすると不正終了する
場合があったのを修正。
 <q>Fix an abnormal termination when a bitmap monitor window is resized.</q>
</ul>
<p>


<dt>0.5.0 (2023/01/25)
<dd><ul>
<li>vm(New): HD647180 を実装開始。とりあえず動く程度。
 <q>Start to implement HD647180.</q>
<li>vm(New): X68030 拡張メモリを実装。
 <q>Implement X68030 extended memory.</q>
<li>vm(Fix): SPC の DREG バッファフルで書き込みを行うと不正終了していたのを修正。
 <q>Fix an abnormal termination on writing to DREG when buffer full in SPC.</q>
<li>m68k(Update): m68030 のパフォーマンスを改善。
 <q>Improve performance of m68030.</q>
<li>debugger(Fix): BS 入力に対応。
 <q>Fix BackSpace input.</q>
<li>GUI(Update): モニタメニューを再編。
 <q>Reorganize monitor menu.</q>
<li>GUI(Update): 設定で指定されたスケールとモニタ更新レートをメニューに追加。
 <q>Add mainview scale specified in configuration and monitor rate to menu.</q>
<li>GUI(Fix): メモリダンプウィンドウを24ドットフォントに対応。
 <q>Support 24 dot fonts in memory dump window.</q>
<li>app(New): --create-sram オプションを実装。
 <q>Implement --create-sram option.</q>
<li>app(New): 設定ファイル ~/.nono.cfg も読み込むようにする。
 <q>Support configuration file ~/.nono.cfg.</q>
<li>app(Update): 設定項目 <tt>fast-mode</tt>、<tt>monitor-fontsize</tt>、
<tt>mainview-scale</tt> を実装。
<li>app(Update): -Mmemdump に表示形式指定を実装。
 <q>Support display format specification in -Mmemdump.</q>
</ul>
<p>

<dt>0.4.4 (2022/10/27)
<dd><ul>
<li>vm(New): LUNA の 8bpp ボードに仮対応。
 <q>Support 8bpp board on LUNA provisionally.</q>
<li>vm(Fix): 設定項目 <tt>xxx-news-sci-ignore</tt> を <tt>xxx-news-sic-ignore</tt> に変更。
 <q>Change configuration item name from <tt>xxx-new-sci-ignore</tt> to
 <tt>xxx-new-sic-ignore</tt>.</q>
<li>vm(Fix): NWS-1750 の RAM が一部で配置されていなかったのを修正。
 <q>Fix a problem that RAM is not placed correctly.</q>
<li>vm(Fix): X68030 のパレットレジスタへのアクセスを修正。
 <q>Fix an access to X68030 palette registers.</q>
<li>m88k(Update): m88k コアのパフォーマンスを約 3% 改善。
 <q>Improve m88k core performance about 3%.</q>
<li>debugger(Fix): メモリブレークポイントが 0番地でも動作するよう修正。
 <q>Memory break point now works even on address 0.</q>
<li>host(Fix): ホストシリアルコンソールにペーストとかすると内部キューが
あふれていたのを修正。
 <q>Fix a queue overflow when many characters are pasted to the host
 serial console at a time.</q>
<li>GUI(New): メインウィンドウの表示倍率 x1.5, x2.0 を実装。
 <q>Implement x1.5 and x2.0 scale on the main window.</q>
<li>GUI(New): フォントサイズ 24 を追加。
 <q>Add fontsize 24.</q>
<li>GUI(New): 前面 LCD ウィンドウおよび LCD キャラクタモニタの大きさを
フォントサイズと連動させる。
 <q>Link the front LCD window size and LCD charactor monitor size
 to font size.</q>
<li>GUI(New): Bt454/458 モニタをビデオモニタから独立。
 <q>Split the Bt454/458 monitor from video monitor.</q>
<li>GUI(New): パレットモニタを実装。
 <q>Implement a palette monitor.</q>
<li>GUI(New): DIPSW 設定ウィンドウを実装。
 <q>Implement DIPSW setting window.</q>
<li>GUI(New): メモリの編集機能を実装。
 <q>Implement memory edit.</q>
<li>GUI(New): 逆アセンブラモニタを実装。
 <q>Implement disassemble monitor.</q>
<li>GUI(Update): メモリダンプモニタに表示形式の切り替えを実装。
MMU ディスクリプタの表示に対応。
 <q>Implement output format selector on the memory dump monitor,
and support MMU descriptor.</q>
<li>GUI(Update): メモリダンプモニタに1行移動ボタンを追加。
 <q>Implement one line up/down button on the memory dump monitor.</q>
<li>GUI(Update): メモリダンプモニタをマウスホイールに対応。
 <q>Support mouse wheel on the memory dump monitor.</q>
<li>GUI(Update): GTK コントロールは GTK パネルの上に置くように変更。
GTK 側のテーマ変更に対応するため。
 <q>Place a GTK control on the GTK panel correctly.</q>
<li>GUI(Update): デフォルトカタログを読み込まないように変更。
 一部のメッセージだけ(意図せず)翻訳された状態になるため。
 <q>Don't load the default catalog.
 Because it contains unintended translation.</q>
<li>build(New): wxWidgets-3.2 系でのビルドに対応。
 <q>Support wxWidgets 3.2 series.</q>
</ul>
<p>

<dt>0.4.3 (2022/08/27)
<dd><ul>
<li>m68k(Fix): PTESTR/PTESTW 命令のレベル0、レベル7 を実装。
 <q>Implement case level 0 and level 7 of PTESTR/PTESTW instructions.</q>
<li>m68k(Fix): TT0/1 レジスタの R/W ビットが指定された時の動作を修正。
 <q>Fix match behavior when R/W bit are set on TT0/1 registers.</q>
<li>m68k(Fix): ダブルバスフォールトでアプリケーションが応答出来なくなっていたのを修正。
 <q>Fix that an application becomes inoperable on double bus fault in VM.</q>
<li>m88k(Fix): 疑似 STOP の動作を改善。
 <q>Improve pseudo STOP behaviors.</q>
<li>vm(Update): LUNA-88K 内蔵 PROM の GETC/PUTC を(まじめに)実装。
 <q>Implement GETC/PUTC routines on LUNA-88K's internal PROM.</q>
<li>vm(New): NWS-1750 をサポートしてみるネタ。
 <q>Support NWS-1750.  It's just a joke.</q>
</ul>
<p>

<dt>0.4.2 (2022/08/03)
<dd><ul>
<li>vm(Update): LUNA-88K のメモリマップを実機に近づける。
 <q>Improve a memory map on LUNA-88K.</q>
<li>vm(Update): LUNA キーボードブザーの処理を改善。
ソフトウェアキーボードにインジケータを実装。
 <q>Improve a keyboard buzzer handling on LUNA.
 Implement the buzzer indicator on the software keyboard window.</q>
<li>vm(Update): LUNA-88K で PROM 1.20 使用時はメモリ上限を 240MB に制限する。
ROM コードの制約のため。
 <q>Limit maximum ram size to 240MB when using PROM 1.20 on LUNA-88K
 due to PROM code constraint.</q>
<li>vm(Update): TVRAM で水平スクロールが右にはみ出した時の挙動をたぶん実装。
 <q>Implement behaviors when TVRAM scroll protrudes to the right, probably.</q>
<li>vm(Fix): RFCNT の水平スクロール量を実機に合わせて修正。
 <q>Fix a horizontal scroll amount of RFCNT to match real machine.</q>
<li>m88k(Fix): m88200 キャッシュのライン無効化時のアドレスマスクを修正。
 <q>Fix an address mask when m88200 invalidates cache line.</q>
<li>m88k(Fix): 書き込みでキャッシュエントリ作成時のキャッシュステータスを修正。
 <q>Fix cache status when m88200 creates cache entry for writing.</q>
<li>debugger(Update): 例外履歴に非公式 NetBSD/luna88k のシステムコールを追加。
 <q>Add unofficial NetBSD/luna88k system call to the exception history.</q>
<li>app(Update): -X オプションで NetBSD カーネルのシンボル読み込みに対応。
 <q>-X option supports loading symbol tables in NetBSD kernel.</q>
<li>app(Fix): デバッガ使用時にアプリケーションが終了できない場合があったのを修正。
 <q>Fix a problem that application may not be able to be terminated
 when debugger is used.</q>
<li>app(Fix): Ctrl+Q でアプリケーションが終了してしまうのを修正。
 <q>Fix a silent termination when Ctrl+Q is entered.</q>
</ul>
<p>

<dt>0.4.1 (2022/07/24)
<dd><ul>
<li>vm(Fix): X68030 システムポートの電源オフ制御ポートに4回以上書き込んだ時に
不正終了していたのを修正。
 <q>Fix a problem that writing power-off control on the system port 4 or more
 times causes an abnormal termination on X68030.</q>
<li>vm(Fix): CMMU のログ表示で不正終了していた問題を修正。
 <q>Fix an abnormal termination on CMMU log.</q>
<li>vm(Fix): LUNA の ROM エミュレーション使用時にメニューの
「Press Power Button」で即電源が落ちるようになっていたのを修正。
 <q>Fix a problem that selecting "Press Power Button" menu when using
 LUNA ROM emulation causes a silent termination.</q>
<li>vm(Fix): LUNA-88K ROM エミュレーションで
キー入力によりハングアップする場合があったのを修正。
 <q>Fix a problem that may hang on keystrokes on LUNA-88K ROM emulation.</q>
<li>vm(Fix): LUNA でブザー発声中に再度ブザーコマンドが来ると
高速モードに戻れなくなっていた問題を修正。
 <q>Fix a problem that the full speed mode is suppressed parmanently
 when buzzer command is issued again during buzzer execution on LUNA.</q>
<li>vm(Update): BT454 設定値とホストカラーとのマッピングを少し明るく調整。
 <q>Adjust color mappings between BT454 value and the host palette.</q>
<li>host(Fix): Ubuntu ホストで [_] キーが入力できなかったのを修正。
 <q>Fix a problem that [_] key does not work on Ubuntu.</q>
<li>host(Fix): [F11] キーの入力が出来ていなかったのを修正。
 <q>Fix a problem that [F11] key does not work.</q>
<li>GUI(Fix): サブウィンドウがメイン画面の中心にある時でも
マウスモードに入れるようにする。
 <q>Entering the mouse mode now works even that some subwindows are
 displayed on the center of the mainwindoiw.</q> (Issue#1)
<li>GUI(New): LUNA フレームバッファ/X68030 TVRAM モニタでピクセル情報を表示。
 <q>Display the pixel information on LUNA Framebuffer/X68030 TVRAM monitor.</q>
<li>app(Update): -X で NetBSD/x68k カーネルの起動に対応。
 <q>-X option supports booting NetBSD/x68k kernel.</q>
</ul></dd>
<p>


<dt>0.4.0 (2022/06/18)
<dd><ul>
<li>vm(New): X68030 FDC/FDD と 2HD/2HC フロッピーを実装。
 <q>Implement FDC/FDD on X68030 and 2HD/2HC floppies.</q>
<li>vm(New): X68030 OPM レジスタの BUSY を実装。
 <q>Implement a BUSY state on OPM Registers on X68030.</q>
<li>vm(New): X68030 DMAC をもう少し実装。
 <q>Implement DMAC more.</q>
<li>vm(New): X68030 ROM ファイルの外部イメージパスを指定できるようにする。
 <q>Support to specify external image path for X68030 ROM.</q>
<li>vm(New): X68030 ROM30 エミュレーションを実装。NetBSD/x68k が起動する程度で
Human68k は起動できない。
 <q>Implement X68030 ROM30 Emulation.
 It can boot NetBSD/x68k but not Human68k.</q>
<li>vm(New): X68030 CGROM 外部イメージに 6x12 フォントがない場合警告を出す。
 <q>Warn if an external CGROM image doesn't contain 6x12 font on X68030.</q>
<li>vm(New): X68030 電源 LED と電源オフを実装。
 <q>Implement power LED and power off on X68030.</q>
<li>vm(New): X68030 SRAM の RAM 容量欄を設定値と同期するオプションを実装。
 <q>Implement an option that synchronize RAM size field in SRAM and actual RAM size on X68030.</q>
<li>vm(New): X68030 キーボードモニタ、TVRAM モニタを実装。
 <q>Implement keyboard monitor and TVRAM monitor.</q>
<li>vm(Update): X68030 SRAM ファイル名を "SRAM.DAT" に変更。
 <q>Change SRAM filename to "SRAM.DAT".</q>
<li>vm(Update): X68030 FPU 設定項目名を fpu-type に変更。
 <q>Change configuration keyname of FPU to fpu-type.</q>
<li>vm(Update): X68030 CRTC モニタに一部のレジスタを追加。
 <q>Add some registers to CRTC monitor on X68030.</q>
<li>vm(Fix): X68030 TVRAM のラスターコピーのタイミングとアクセス先を修正。
 <q>Fix timing and destination address of TVRAM raster copy on X68030.</q>
<li>vm(Fix): X68030 SCC のレジスタアクセスを修正。
 <q>Fix register access on SCC on X68030.</q>
<li>vm(Fix): X68030 SCC でビットレートをチャンネルごとに設定できるよう修正。
 <q>Fix to allow SCC bit rate to be set for each channel on X68030.</q>
<li>vm(Fix): X68030 マウスボタンが左右逆だったのを修正。
 <q>Fix reversed mouse buttons.</q>
<li>vm(Fix): X68030 本体の SCSI ID を 7 固定に変更。
 <q>Change SCSI ID to be fixed to 7 on X68030.</q>
<li>vm(Update): 実時間の再同期を実装。
 <q>Implement resynchronizing time.</q>
<li>m68k(Fix): 割り込みチェックのタイミングを修正。
 <q>Fix timing that MPU checks interrupts.</q>
<li>GUI(New): LUNA フレームバッファ/X68030 TVRAM モニタに拡大機能を実装。
 <q>Implement zoom in feature for LUNA Frame buffer/X68030 TVRAM monitor.</q>
<li>GUI(Fix): LUNA フレームバッファ/X68030 TVRAM モニタの最大サイズを正しく設定。
 <q>Fix the maximum window size of LUNA Frame buffer/X68030 TVRAM monitor
 window.</q>
<li>GUI(Fix): ベクタモニタのサイズを広げると死ぬ場合があったのを修正。
 <q>Fix an abnormal termination on vector monitor.</q>
<li>GUI(Fix): 更新レートが低い場合にスクロールの描画も遅くなっていたのを修正。
 <q>Fix drawing when update rate is low.</q>
<li>debugger(Fix): ver 0.3.0 以降 m68k でステップ実行中にリセット例外が起きた場合の動作を修正。
 <q>Fix m68k step execution when a reset exception occurs since 0.3.0.</q>
<li>debugger(Fix): ver 0.3.0 以降 m88k でステップ実行した時の命令位置を修正。
 <q>Fix m88k instruction pointer on step execution since 0.3.0</q>
<li>debugger(Update): ct コマンドを実装。
 <q>Implement a ct command.</q>
<li>app(Fix): ver 0.2.6 以降アプリケーションが終了できない場合があったのを修正。
 <q>Fix a problem that application may not be able to be terminated since
 0.2.6</q>
<li>app(Fix): マウスキャプチャが外れた場合に不正終了する場合があったのを修正。
 <q>Fix an abnormal termination when mouse capture is released.</q>
</ul></dd>
<p>


<dt>0.3.0 (2022/04/30)
<dd><ul>
<li>m88k(Update): m88200 のパフォーマンスを改善。
 <q>Improve performance of m88200.</q>
<li>m88k(New): m88200 の M バススヌープを実装。
 <q>Implement M bus snooping of m88200.</q>
<li>m88k(Fix): BATC の一部のフラグが動作に反映されていなかった問題を修正。
 <q>Fix a problem that some BATC flags were not reflected.</q>
<li>m68k(Fix): 割り込みタイミングを調整。
 <q>Adjust minor interrupt timings.</q>
<li>m68k(Fix): リセット例外でフェッチした PC が奇数アドレスなら
ダブルバスフォールトにするところを実装 (ただし通常は起きない)。
 <q>Implement double bus fault, which occurs when a reset exception fetches
 odd address PC. (However, it does not usually occur)</q>
<li>vm(Update): VM スケジューラと CPU 駆動方法を全面改装。
 <q>Rewrite VM scheduler and how to drive CPU completely.</q>
<li>vm(Update): VM 再起動で仮想時間をリセットする。
 <q>Reset virtual time when VM is reset.</q>
<li>vm(New): FDC と OPM を少し実装。
NetBSD/x68k カーネルが fdc プローブを通過できるのと
HD 起動の Human68k が起動できる程度。
 <q>Implement FDC and OPM a bit.
 Now NetBSD/x68k kernel can pass probing fdc, and
 Human68k can be booted from HD.</q>
<li>vm(New): SPC の DMA 転送を実装。NetBSD/x68k の CD 起動が可能。
 <q>Implement DMA transfer to/from SPC.
 Now NetBSD/x68k can be booted from CD.</q>
<li>vm(New): TVRAM のアクセスマスクを実装。
 <q>Implement an access mask of TVRAM.</q>
<li>vm(Fix): ver 0.2.6 以降動作してなかったフレームバッファ(テキスト画面)
の横スクロールを復活。
 <q>Revive horizontal scroll of frame buffer (text screen)
which is not worked since ver 0.2.6.</q>
<li>debugger(Fix): トレース表示でレジスタ値が更新されるよう修正。
 <q>Fix a problem that register values are not updated if trace modifier
 is specified.</q>
<li>host(Fix): libkqueue ではディスクリプタクローズで kevent が削除されない
問題に対応。
 <q>Address a problem that libkqueue does not automatically remove closed
 descriptors from kevent.</q>
<li>build(New): configure に --without-gui オプションを用意。
 <q>configure now supports --without-gui option.</q>
<li><span class=strike>debugger(Update): コンソールを HostCOM 機構に変更。
 <q>Change debugger console to HostCOM feature.</q></span>
<li><span class=strike>vm(Update): --force-rtc-fixed オプションを廃止、--perf オプションを追加。
 <q>Remove --force-rtc-fixed option and add --perf option for developpers.</q>
 </span>
</ul></dd>
<p>


<dt>0.2.6 (2022/02/15)
<dd><ul>
<li>m88k(Update): m88k コアのパフォーマンスを少し改善。
 <q>Improve the performance of m88k core slightly.</q>
<li>m68k(Fix): 68881 FCMP 命令の結果が正しくない場合があったのを動作を修正。
 <q>Fix 68881's FCMP instruction that may return wrong result.</q>
<li>vm(Update): レンダラをいろいろ改良、パフォーマンスを向上。
 <q>Improve the renderer including performance.</q>
<li>vm(Fix): SCSI イメージパスに絶対パスが書けなかった問題を修正。
 <q>Fix a problem that the absolute path for SCSI images could not be specified.</q>
<li>vm(Fix): SCSI ディスクの最終セクタのアクセスがエラーになっていたのを修正。
 <q>Fix a problem that accessing the last sector causes an error.</q>
<li>GUI(New): ベクタテーブルモニタを実装。
 <q>Implement a vector table monitor.</q>
<li>GUI(New): ログレベル設定ウィンドウを実装。
 <q>Implement a log level setting window.</q>
<li>GUI(Update): 各種ウィンドウの描画パフォーマンスを向上。
 <q>Improve performance of window drawing.</q>
<li>GUI(Fix): ビットマップモニタウィンドウの上部コントロールが塗りつぶされる問題を修正。
 <q>Fix a rendering problem of the control area on the bitmap plane window.</q>
<li>GUI(Fix): フォントサイズを変更するとビットマップモニタウィンドウが小さくなる問題を修正。
 <q>Fix a resize problem on the bitmap plane window.</q>
<li>app(Fix): シグナルの処理をいろいろ修正。
 <q>Fix several UNIX signal handling.</q>
<li>app(Fix): プロセス起動時に不正終了する場合があったのを修正。
 <q>Fix some abnormal terminations at the beginning of the process.</q>
<li>app(Fix): プロセス終了時に不正終了する場合があったのを修正。
 <q>Fix some abnormal terminations at the end of the process.</q>
<li><span class="strike">app(Fix): スレッド名が正しくないところを修正 (開発用)
 <q>Fix some thread names for development.</q></span>
<li><span class="strike">vm(Update): CRTC の水平同期信号を適当実装。
テキスト VRAM のラスターコピーを適当実装。
 <q>Implement the horizontal synchronizing signal on CRTC in progress.
 Implement the raster copy on the text VRAM in progress.</q></span>
</ul></dd>
<p>

<dt>0.2.5 (2021/12/30)
<dd><ul>
<li>vm(New): 4bpp プレーンに対応中。
 <q>Supporting 4bpp video plane.</q>
<li>vm(Fix): Lance(AM7990) でジャンボパケット送受信時のエラー処理を改善。
 <q>Fix error handlings of sending and receiving jumbo pakcets
 on Lance(AM7990).</q>
<li>vm(Fix): Lance(AM7990) の BSWP 処理を修正。
4.4BSD ゲストが動くように。
 <q>Fix a BSWP operation on Lance(AM7990).  This makes 4.4BSD work.</q>
<li>vm(Fix): RTC(MK48T02) の基準年を設定可能にする。
4.4BSD ゲストに対応するため。
 <q>Make RTC(MK48T02) epoch year configurable in order to support 4.4BSD.</q>
<li>vm(Fix): LUNA-88K の FUSEROM チェックバイトを実装。(Issue#99)
 <q>Implement a check byte in FUSEROM on LUNA-88K.</q>
<li>vm(Update): ROM エミュレーションで a.out の MID チェックを廃止。
 <q>The ROM emulation becomes not to verify a.out MID to boot.</q>
<li>vm(Update): LUNA-I ROM エミュレーションでも
^C で ROM に戻れるようにする。(Issue#95)
 <q>LUNA-I ROM Emulation accepts ^C to back to the ROM.</q>
<li>GUI(Update): ウィンドウ全体の描画性能を改善。
メインウィンドウの(拡大)縮小も自前で実装。
 <q>Improve whole window drawing scheme, and implement
 main window's reduction.</q>
<li>GUI(Fix): ウィンドウサイズがいろいろおかしかったのをたぶん修正。(Issue#77)
 <q>Fix many window size problems.</q>
<li>GUI(New): テキストウィンドウにコンテキストメニュー「コピー」を実装。
 <q>Implement "Copy" context menu on text windows.</q>
<li>Host(New): Linux でインタフェースの GRO が有効ならエラーにする。
 <q>Reject network interface GRO on Linux host.</q>
<li>Host(Fix): Linux でコアダンプが出力できるようにする。
 <q>Now it can dump a core even on Linux.</q>
</ul></dd>
<p>

<dt>0.2.4 (2021/11/22)
<dd><ul>
<li>Host(New): シリアルコンソールの stdio, tcp ホストドライバをサポート。
 <q>Support serial console host driver for stdio, tcp.</q>
<li>vm(New): キーボードの接続、取り外しをサポート。
 <q>Support keyboard connection/disconnection.</q>
<li>vm(New): ABORT ボタンを実装。
 <q>Implement an ABORT button.</q>
<li>vm(New): LUNA-88K ROM エミュレーションの PROM PUTCHAR(?) ルーチンに対応。
 <q>Supports PROM PUTCHAR(?) routine on LUNA-88K ROM emulation.</q>
<li>vm(Update): SIO(uPD7201), SCC(Z8530) を書き直して改良。
 <q>Rewrite and improve SIO(uPD7201) and SCC(Z8530).</q>
<li>vm(Update): MK48T02 NVRAM は全域を保存する。
 <q>MK48T02 now saves the whole NVRAM.</q>
<li>vm(Update): LUNA ROM エミュレーションでテンキーの入力も受け付ける。
 <q>LUNA ROM emulation accepts numpad keys as well as the real machine.</q>
<li>vm(Fix): MK48T02 のレジスタ読み出し値の ver 0.2.3 でのエンバグを修正。
 <q>Fix an MK48T02 degradation since ver 0.2.3 </q>
<li>vm(Fix): Lance(AM7990) で受信パケットが失われる場合があったのを修正。
 <q>Fix an issue that Lance(AM7990) may lose packets it received.</q>
<li>vm(Fix): Lance(AM7990) の CSR0 レジスタ INIT/STRT ビットの動作を修正。
 <q>Fix INIT/STRT bit behavior in CSR0 on Lance(AM7990).</q>
<li>m68k(Fix): FSAVE -(An) 命令を修正。
 <q>Fix an FSAVE -(An) instruction.</q>
<li>m88k(Fix): Data Access Exception 発生時の DMx レジスタの内容を修正。
 <q>Fix DMx registers when Data Access Exception occurs.</q>
<li>GUI(Fix): 例外履歴モニタの表示方向を修正。
 <q>Fix sort direction on the exception history monitor.</q>
<li>GUI(Fix): ver 0.2.2 以降アクセラレータキーが効かなくなっていたのを修正。
 <q>Fix accelaration keys not working since ver 0.2.2.</q>
<li>app(Update): -V オプションのキー名が正しくなければエラーにする、
また設定ファイルのキー名が正しくなければ警告を出すように変更。
 <q>Make an error if keyname of -V option is not correct.
 Make a warning if keyname in the configuration file is not correct.</q>
<li>build(Fix): clang11 でのビルド対応。
 <q>Fix build with clang11.</q>
<li><span class=strike>vm(New): --force-rtc-fixed オプションを追加。開発用。
 <q>Add --force-rtc-fixed option for developpers.</q></strike>
</dl></dd>
<p>

<dt>0.2.3 (2021/10/03)
<dd><ul>
<li>m88k(Fix): INT、NINT、TRNC、FCMP、FLDCR、FSTCR、FXCR 命令の動作を改善。
浮動小数点例外を実装。
 たぶん gcc が動くように。
 <q>Improve several floating point instructions and floating point exceptions.
 This may make gcc work.</q>
<li>vm(Update): uPD7201 (SIO) の Error Reset コマンドを実装。(Issue#65)
 <q>Implement the Error Reset command on uPD7201 (SIO).</q>
<li>vm(Update): LUNA キーボードコマンドを実装。
 <q>Implement all commands on LUNA keyboard.</a>
<li>vm(Fix): エミュレーション ROM 起動時にもキーボードコマンドを送信。
 <q>Emulated ROM now sends the keyboard commands on boot, as the real ROM
 does. </q>
<li>vm(Fix): LUNA の LED キー押下開放時の動作を修正。(Issue#83)
 <q>Fix the behaviors of LUNA LED key when it is pressed/released.</q>
<li>vm(Update): MK48T02 のレジスタ読み出しマスクを修正。(Issue#75)
 <q>Improve a read mask on MK48T02.</a>
<li>GUI(Update): ソフトウェアキーボードの CTRL、SHIFT キーの動作を変更。
 <q>Change CTRL, SHIFT key behavior on the software keyboard window.</q>
<li>app(Update): -X オプションが DIPSW に影響受けないように変更。
 <q>-X option is no longer affected by DIPSW.</q>
</ul></dd>
<p>

<dt>0.2.2 (2021/09/09)
<dd><ul>
<li>host(New): キー入力にキャラクタ入力モードを実装。(Issue#64)
 <q>Implement character input mode for keyboard input.</q>
<li>m88k(Fix): FLT 命令の動作を修正。
 <q>Fix a bug of FLT instruction.</q>
<li>vm(Fix): ver 0.2.0 以降 LUNA-88K の PROM エミュレーションが
	いろいろおかしかったのを修正。
 <q>Fix a few bugs in LUNA-88K PROM emulation since ver 0.2.0.</q>
<li>host(Update): ディスクイメージのアクセスを mmap(2) から read(2)/write(2)
	に変更。(Issue#60)
 <q>Change to use read(2)/write(2) instead of mmap(2) to access disk images.</q>
</ul></dd>
<p>

<dt>0.2.1 (2021/08/18)
<dd><ul>
<li>vm(New): SCSI CD と MO をサポート。(Issue#63)
 <q>Support SCSI CD and MO.</q>
<li>vm(Update): SCSI エミュレーションをいろいろ改善。
	ModeSelect(10)、ModeSense(10) コマンドを実装、
	SynchronizeCache コマンドを空で実装、
	StartStopUnit コマンドの LoEj(Load/Eject) ビットに対応、
	ModeSense コマンドのページ 04, 05, 08 をサポート。
	RequestSense コマンドのパラメータを修正。
 <q>Improve various things about SCSI emulation:
	Implement ModeSelect(10), ModeSense(10) command.
	Implement SynchronizeCache command as no-op.
	Support LoEj(Load/Eject) bit of StartStopUnit command.
	Support ModePage 04, 05 and 08 of ModeSense command.
	Fix RequestSense command parameters.</q>
<li>vm(Fix): 指定のアロケーション長で SCSI 転送を打ち切れるよう修正。
 <q>SCSI devices can terminate the SCSI transfer correctly
 at the specified allocation length.</q>
<li>vm(Fix): SCSI 転送速度制限(1MB/s)を実装。
 <q>Implement SCSI transfer speed limit.</q>
<li>vm(Fix): LUNA-88K PIO で DIPSW のビット配置を修正。(Issue#67)
 <q>Fix DIPSW pin placement in PIO on LUNA-88K.</q>
<li>vm(Fix): LUNA-88K システムコントローラのリセット動作を修正。
 <q>Fix a reset operation of LUNA-88K system controller.</q>
<li>vm(Update): RTC (MK48T02、RP5C15) エミュレーションを改善。
 <q>Improve RTC (MK48T02, RP5C15) emulations.</q>
<li>vm(Update): LCD エミュレーションを改善。(Issue#66)
 <q>Improve LCD emulation.</q>
<li>vm(Update): LUNA のマウス移動量が±1の時の動作を改善。
 <q>Improve LUNA mouse behavior when its movement amount is plus or minus 1.</q>
<li>m88k(Fix): add/sub 命令でオーバーフロー例外発生時の動作を修正。
 <q>Fix add/sub instruction behavior when it occurs overflow exception.</q>
<li>m88k(Fix): ジャンプ命令がジャンプ先アドレスをマスクしていなかったバグを修正。
 <q>Fix jump instructions' bug which doesn't mask the destination address.</q>
<li>app(Fix): ver 0.2.0 以降、特定の環境(Xsixel?)で起動時に VM 電源オンにならない問題を修正。(Issue#72)
 <q>Fix a bug that could not poweron on start under certain environment
 (Xsixel?) after ver 0.2.0.</q>
<li>app(Update): ステータスパネル SCSI インジケータで
イメージファイルパスをツールチップ表示。
 <q>Display filepath as a tooltip in SCSI indicators on the status panel.</q>
<li>app(Update): -A オプションを -X オプションに変更(移動)。
 <q>Change(rename) -A option to -X option.</q>
<li><span class=strike>app(Update): -X オプションを -H オプションに移動。
 <q>Change(rename) -X option to -H option.</q></span>
<li><span class=strike>m88k(New): デバッグ用ニーモニックを追加。
 <q>Implement an alternate mnemonic just for us.</q></span>
<li><span class=strike>m88k(Update): エミュレーション ROM で
UniOS-Mach の a.out ファイルをロードできるようにする。
 <q>Emulated ROM can boot UniOS-Mach a.out executable.</q></span>
<li><span class=strike>vm(New): X68k マウスを SCC に接続途中。
 <q>Trying to connect a mouse to SCC on X68k.</q></span>
</ul></dd>
<p>

<dt>0.2.0 (2021/06/20)
<dd><ul>
<li>vm(New): LUNA-88K の NVRAM をサポート。
 <q>Support LUNA-88K's NVRAM.</q>
<li>vm(New): LUNA-88K の内蔵 ROM コンソールに nvram コマンドを実装。
 <q>Support nvram command on LUNA-88K's emulated ROM console.</q>
<li>vm(Fix): ホストが受信したパケットの処理をいろいろ改善。
 <q>Various fixes for network packets received at the host.</q>
<li>vm(New): LUNA-I/LUNA-88K のシステムクロックに実時間同期モードをサポート
 (実験中)。
 <q>Support real-time synchronization on LUNA-I/LUNA-88K's system clock
 (experimental).</q>
<li>m88k(New): 疑似 STOP 状態をサポート。
 <q>Support pseudo stop status for m88k.</q>
<li>host(Update): ネットワークドライバあたりをいろいろ改善。
ホストがサポートしているものから実行時に選択する方式に変更。
そのため設定ファイル項目も変更。
 <q>Various changes on the host network drivers.</q>
<li>host(New): ホストネットワークドライバ AF_PACKET をサポート。
 <q>Add AF_PACKET as host network driver.</q>
<li>GUI(Update): ステータスパネルの表記を改善、LAN インジケータを追加、
HD にライトプロテクト状態を表示など。
 <q>Improve the status panel, including adding a LAN indicator,
 displaying write-protect icon on HD.</q>
<li>GUI(Update): メモリダンプモニタを4枚に増加。
 <q>Increase the number of memory dump windows to four.</q>
<li>GUI(Fix): サブウィンドウが正しいサイズで表示されない場合があったのを修正。
 <q>Fix window size problem under certain environment(?).</q>
<li>GUI(Fix): モニタとサブウィンドウあたりをいろいろ改善。
 <q>Fix/Improve various monitors and subwindows behaviors.</q>
<li>app(Update): -L, -M オプションをいろいろ改善。
 <q>Fix/Improve about -L and -M options.</q>
<li>debugger(Fix): m68k で TT のみが有効だとアドレスが表示できない場合があったのを修正。
<li><span class=strike>vm(New): -A オプションで ELF オブジェクトファイルのロードをサポート。
 <q>Support loading ELF object file on -A option.</q></span>
<li><span class=strike>vm(New): X68k キーボードのキーリピートを実装。
 <q>Implement key repeat feature on X68k keyboard.</q></span>
</ul></dd>
<br>

<dt>0.1.6 (2021/04/18)
<dd><ul>
<li>vm (Update): スケジューラをいろいろ改善。
 <q>Improve the scheduler.</q>
<li>vm (Update): キー入力をいろいろ改善。
キー入力をバッファリングする、
LUNA でのチャタリング抑制のためキー入力中は高速モードを抑制する、
キーコードは物理キーコードでなく論理キーコードを使うように変更、
その他バグ修正など。
 <q>Improve the key input:
 Buffer the keystrokes from the host.
 Suppress the full speed mode while any keys are pressed
 in order to prevent chattering on LUNA.
 Use the logical keycode instead of the phisical keycode.
 And several bugfixes.
<li>vm (Update): m68k, m88k のリセット例外を正しく実装。
 <q>Improve the reset exception of m68k, m88k.</q>
<li>vm (Fix): LUNA-88K のバスエラー領域を実装。PROM 1.20 が起動できる。
 <q>Implement the bus error area correctly on LUNA-88K.
 This makes PROM 1.20 work.</q>
<li>GUI (New): ステータスパネルを実装。
 <q>Implement a status panel.</q>
<li>GUI (Update): ソフトウェアキーボードを改修。
ソフトウェアキーボードウィンドウでもキー入力を受け付ける。
また現在のキー入力状態を反映して表示する。
 <q>Modify the software keyboard window.
 Accept keystrokes in this window as well.
 Also, the window displays the current keystroke status.</q>
<li>GUI (Fix): ウィンドウマネージャによっては(?)
ウィンドウが正しいサイズで表示されなかったのを修正。
 <q>Fix window size problem under certain window managers(?).</q>
<li>GUI (Fix): ログウィンドウをいろいろ修正。
 <q>Fix several problems on the log window.</q>
<li>debugger (Fix): m88k ニーモニックをちょっと修正。
 <q>Fix a few m88k mnemonics.</q>
</ul></dd>
<br>

<dt>0.1.5 (2020/12/05)
<dd><ul>
<li>vm (Update): m88k コアのパフォーマンスを改善。
 <q>Improve m88k performance.</q>
<li>vm (New): LUNA-88K に ROM エミュレーションを実装。とりあえず起動できる程度。
 <q>Implement emulated ROM for LUNA-88K.  For now, it only can boot.</q>
<li>vm (New): RAM 容量の変更をサポート。
 <q>Make the RAM size changable.</q>
<li>host (Update): OpenBSD の tap(4) に対応。
 <q>Support OpenBSD's tap(4).
<li>vm (Fix): LUNA-I の ROM エミュレーションが 0.0.3 および 0.1.4 以降
 いろいろおかしかったのを修正。
 <q>Fix several bugs on LUNA-I's emulated ROM since 0.0.3 and 0.1.4.</q>
<li>vm (Update): ROM エミュレーションの UFS 読み込み処理を改善。
 <q>Improve reading UFS on emulated ROM.
<li>vm (Fix): SIO(uPD7201) の受信キューが壊れるケースがあったのを修正。
 <q>Fix a bug that might break receive queue on SIO(uPD7201).</q>
<li>vm (Fix): SCSI 転送中に VM リセットすると不正終了していたのを修正。
 <q>Fix abnormal termination on resetting VM during SCSI transfer.</q>
<li>vm (Update): SPC の SCMD Intercept ビットのログを改善。
 <q>Improve a log message about SCMD Intercept bit on SPC.</q>
<li>app (Update): -c オプションに設定ファイル名も指定できるよう変更。
 <q>Make -c option acceptable configuration filename.</q>
</ul></dd>
<p>

<dt>0.1.4 (2020/11/20)
<dd><ul>
<li>vm (Fix): SCSI HD に WRITE(10) コマンドを実装。
 <q>Implement WRITE(10) command on SCSI HD.</q>
<li>vm (Fix): m88k の xmem.bu 命令のバグを修正。
 <q>Fix a bug on m88k xmem.bu instruction.</q>
<li>vm (Fix): m68k の STOP 命令や m88k の疑似 STOP
 状態で仮想時間がおかしくなる場合があるバグを修正。
 <q>Fix a bug that STOP instruction on m68k or pseudo STOP state on m88k
 may break virtual time.</q>
<li>vm (Fix): 0.1.3 以降 LUNA-I のエミュレーション ROM がキー入力を
 受け付けなくなっていたのを修正。
 <q>Fix a bug that LUNA-I emulated ROM does not accept any key inputs
 since 0.1.3.</q>
</ul></dd>
<p>

<dt>0.1.3 (2020/11/18)
<dd><ul>
<li>vm (Fix): m88k DAE エミュレーションを改善。
 <q>Improve DAE emulation on m88k.</q>
<li>vm (Fix): m88k ストア命令のバグを修正。
 <q>Fix a bug on m88k store instructions.</q>
<li>vm (Update): m88k の浮動小数点命令を実装中。
 <q>Implement floating point instructions.</q>
<li>vm (Fix): LUNA-88K の RAM が正しくアクセスできてなかったのを修正。
 <q>Fix incorrect RAM device assignment on LUNA-88K.</q>
<li>vm (Fix): LUNA-88K のシステムクロックデバイスが正しくアクセスできてなかったのを修正。
 <q>Fix accessing to the system clock device on LUNA-88K.</q>
<li>vm (Fix): uPD7201 (SIO) モニタの表示をいろいろ修正。
 <q>Various fixes on uPD7201 (SIO) monitor.</q>
<li>vm (Update): 割り込み周り全般を書き直し。
 <q>Rewrite and update whole around interrupt system.</q>
<li>vm (Update): SPC の SCMD Intercept ビットの動作を改善。
 <q>Improve SCMD's Intercept bit behavior on SPC.</q>
<li>debugger (Update): d,m コマンドなどメモリアクセス周りを改善。
 <q>Improve about memory access including d,m commands.</q>
<li>debugger (Update): 履歴のブランチ元に Supervisor/User 区分の表示を追加。
 <q>Show the Supervisor/User distinction of branch source address in
 branch windows.</q>
<li><span class=strike>vm (Update): X68k にダミーの OPM デバイスを用意。
 <q>Assign (currently no-op) OPM device on X68k.</q></span>
<li><span class=strike>vm (Update): MFP のタイマーの実装を改善中。
 <q>Improve MFP timer on X68k.</q></span>
</ul></dd>
<p>

<dt>0.1.2 (2020/10/28)
<dd><ul>
<li>build (Update): gcc5.5 以下はサポート外と明記。
<q>Mention explicitly that it does not support gcc5.5 or below.</q>
<li>vm (New): メモリとデバイスのアクセスウェイトをいくつか実装中。
<q>Implement access wait partially on some memory and devices.</q>
<li>vm (New): VM リセットを実装。<q>Implement VM reset.</q>
<li>vm (Fix): m88xx0 エミュレーションをいくつか改善。
OpenBSD/luna88k ユーザランドが少しだけ動くように。
<q>Improve some m88xx0 emulations.
This makes OpenBSD/luna88k userland apps work a little.</q>
<li>vm (Update): LUNA-88K の RAM 初期値を 64MB に変更。
<q>Change the initial value of LUNA-88K RAM to 64MB.</q>
<li>vm (Update): LUNA-88K の dipsw1 の初期値を変更。
<q>Change the initial value of LUNA-88K dipsw1.</q>
<li>debugger (Update): 設定の debugger-port の初期値を 0 に変更。
<q>Change the default value of debugger-port configuration field to 0.</q>
<li>debugger (Update): d, m, n, s, t, help コマンドを色々改良。
disp , reset コマンドを実装。
<q> Various improvements for d, m, n, s, t, and help commands.
Implement disp, reset commands.</q>
<li>wx (Fix): メインウィンドウの最大化とリサイズを不可にする。
<q>Disable main window's maximize and resize.</a>
<li>wx (Fix): ビッグエンディアン環境で wxIMAGE_QUALITY_HIGH
による縮小が化けるのを回避。
<q>Avoid broken resize using wxIMAGE_QUALITY_HIGH on big endian.</q>
</ul></dd>
<p>

<dt>0.1.1 (2020/10/06)
<dd><ul>
<li>host(Fix): sparc などのホストでミスアラインドアクセスで死ぬのを修正。
<q>Fix abnormal termination due to mis-aligned access on some architecture
hosts such as sparc.</q>
<li>vm (New): SCSI の Start Stop Unit コマンドをダミーで実装。
(OpenBSD カーネルが使っている)
<q>Implement SCSI Start Stop Unit command as no-op. (OpenBSD kernel uses it.)</q>
<li>vm (Fix): LUNA-I の PROM V4.22 以外はそのまま起動するようにしてみる。
<q>On LUNA-I, when PROM is other than V4.22, run it as is.</q>
<li>vm (Fix): SCSI コマンドがメディアサイズを超える位置やサイズを要求した時に死ぬのを修正。
<q>Fix abnormal termination when SCSI command requests exceeded position or length than actual media.</q>
<li>vm (Fix): LUNA-I エミュレーション ROM 上で、マウス操作でゴミが入力されるのを修正。
<q>Fix emitting garbage characters on mouse operation on LUNA-I emulated ROM.</q>
<li>GUI (New): LUNA のフロントパネル LCD ウィンドウを実装。
<q>Implement LUNA's front panel LCD window.</q>
<li>GUI (New): モニタウィンドウの更新頻度を設定可能にする。
<q>Make monitor window's refresh rate configureable.</q>
<li>GUI (New): ホスト情報ウィンドウ、ブレークポイントウィンドウ、履歴ウィンドウを実装。
<q>Implement host information window, breakpoint window, and
history window.</q>
<li>GUI (New): ログウィンドウのバックログを実装。
<q>Implement backlog of log window.</q>
<li>debugger (New): bi, bm, bv コマンドを実装。
<q>Implement bi, bm, and bv commands.</q>
<li>debugger (New): ブランチ履歴、例外履歴を実装。
<q>Implement branch history and exception history.</q>
<li>debugger (Fix): 逆アセンブラが 68020 の callm 命令で死んでいたのを修正。
<q>Fix abnormal termination when disassembling 68020 CALLM instruction.</q>
<li>vm (Fix): LUNA-88K 用の luna-dipsw1 の初期値を用意。
<q>luna-dipsw1 uses a different initial value for LUNA-88K.</q>
<li><span class=strike>vm (Update): X68k TVRAM レンダリングを改良。
<q>Improve performance on X68k TVRAM rendering.</q></span>
<li><span class=strike>debugger (Fix): 逆アセンブラで moveq.l が %d0 でない時にも IOCS コールと解釈していたのを修正。</span>
</ul></dd>
<p>

<dt>0.1.0 (2020/07/19)
<dd><ul>
<li>build(Fix): OpenBSD/FreeBSD でビルド可能に。
<q>Make it buildable on OpenBSD/FreeBSD.</q>
<li>GUI(Update): GUI メニューの L10N 対応
(GUI メニュー以外(ログメッセージなど)については当面対応予定はないです)。
<q>Support L10N for GUI menus
(There are no plans to support more messages (like log messages)
at least for now).</q>
<li>GUI(Fix): サブウィンドウを表示しているとマウスモードでクリック入力が入らなかった問題を修正。
<q>Fix problem that you can not enter any clicks in mouse mode
when you display some sub windows.</q>
<li>vm(New): m88k の疑似 STOP 状態に対応。
<q>Support pseudo STOP state on m88k.</q>

</ul></dd>
<p>


<dt>0.0.4 (2020/06/13)
<dd><ul>
<li>vm(Fix): 例外ベクタ取得中のバスエラーで死んでいたのを修正。
<q>Fix abnormal termination when fetching exception vector causes bus error.</q>
<li>vm(Update): ダブルバスフォールトを通知。
<q>Notify when double bus fault has occurred.</q>
<li>vm(New): m88100 の改良と m88200 を実装中。
OpenBSD/luna88k カーネルが起動しますが、
まだユーザランドに入るあたりまでです。
<q>Improve m88100 and implement m88200.
It can run OpenBSD/luna88k kernel and
it has just entered in userland.
</q>
<li><span class=strike>vm(New): x68k の MFP、DMAC を適当実装したので
実は NetBSD/x68k ブートローダまでは起動します。
CRTC が不完全なのでスクロールはまだできません。
<q>Implement MFP and DMAC in underground x68k mode.
It can run NetBSD/x68k boot loader.
However, CRTC emulation is not completed yet,
so you cannot scroll text.</q></span>
</ul></dd>
<p>

<dt>0.0.3 (2020/05/16)
<dd><ul>
<li>vm(New): ROM モニタエミュレーションを実装。<q>Support emulated ROM monitor.</q>
<li>vm(New): 地下で m88k 実装開始。
今のところ OpenBSD/luna88k のブートローダが起動できるだけです。
<q>Start to implement m88k in underground.
It just can run OpenBSD/luna88k's boot loader for now.
</q>
</ul></dd>
<p>

<dt>0.0.2 (2020/04/21)
<dd><ul>
<li>vm(New): SCSI エミュレーションを改善。<q>Improve(Reimplement) SCSI emulation.</q>
<li>vm(New): マウスをサポート。<q>Support mouse.</q>
<li>vm(Fix): RFCNT の Y 座標を修正。<q>Fix Y coordinate of RFCNT.</q>
</ul></dd>
<p>

<dt>0.0.1 (2020/03/06)
<dd><ul>
<li>Initial Release
</ul></dd>

</dl>
</div>
<hr>
nono project
</body>
</html>
