//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// シリアルポートの TCP ドライバ
//

#pragma once

#include "comdriver.h"
#include "autofd.h"

class COMDriverTCP : public COMDriver
{
	using inherited = COMDriver;
 public:
	explicit COMDriverTCP(HostDevice *hostdev_);
	~COMDriverTCP() override;

	bool InitDriver(bool startup) override;
	int Dispatch(int udata) override;
	int Read() override;
	void Write(uint32 data) override;
	void MonitorUpdateMD(TextScreen&, int y) override;

 private:
	bool Accept();

	void WriteCmd(const std::vector<uint8>& cmd);
	int Command(uint8 code);
	void Close();

	int port {};

	autofd ls {};
	autofd sock {};

	// TELNET コマンド受信バッファ
	std::vector<uint8> recvcmd {};
	// TELNET コマンド (ステート)
	int cmdstate {};

	// ネゴシエーション中なら 1 以上。
	// WILL, DO, WONT, DONT コマンドは、送信側がこの4種のコマンドを送信し、
	// 受信側もこの4種で応答する。サーバ、クライアントどちらも送信側に
	// なりうるため、これを受信しただけでは、対向が自発的に送信してきた
	// ものか (こちらはそれに応答する必要がある)、こちらからのコマンドに
	// 対向が応答したものか (こちらはそれ以上返答しない) の区別が出来ない。
	// negotiation はこちらからコマンドを送った際に非 0 にして、受信した
	// コマンドが応答であることを示すことにする。本来は bool でいいのだが
	// 接続開始時にコマンドを複数投げる必要があるので、残りの応答数を
	// 保持している。
	int negotiation {};

	// コマンド名を返す
	static std::string GetCommandName(uint8 code);
};
