//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

#pragma once

#include "autofd.h"
#include "diskimage.h"

// ディスクイメージ (生イメージ形式)
class DiskImageRaw : public DiskImageDriver
{
	using inherited = DiskImageDriver;
 public:
	explicit DiskImageRaw(const std::string& pathname_);
	~DiskImageRaw() override;

	int IsWriteable() const override;
	bool Open(bool read_only) override;
	void Close() override;
	off_t GetSize() const override { return filesize; }
	bool Read(void *buf, off_t offset, size_t size) override;
	bool Write(const void *buf, off_t offset, size_t size) override;

 private:
	autofd fd {};
	off_t filesize {};
};
