//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// イベント
//

#include "event.h"
#include "scheduler.h"

// コンストラクタ
Event::Event(Device *dev_, int code_,
	EventCallback_t func_, const std::string& name_)
{
	dev = dev_;
	code = code_;
	func = func_;
	name = name_;
}

// デストラクタ
Event::~Event()
{
}

// 名前をセットする
void
Event::SetName(const std::string& val)
{
	name = val;
	if (name.length() > 25) {
		dev->putmsgn("Event Name \"%s\" is too long(%u chars)",
			name.c_str(), (uint)name.length());
		name.resize(25);
	}
}


//
// イベントマネージャ
//

// コンストラクタ
EventManager::EventManager()
	: inherited(OBJ_EVENT_MANAGER)
{
}

// デストラクタ
EventManager::~EventManager()
{
}

// イベントを登録する。
// こっちは初期設定のほう。イベントを有効にする、ではない。
Event *
EventManager::Regist(Device *dev_, int code_,
	EventCallback_t func_, const std::string& name_)
{
	all.push_back(new Event(dev_, code_, func_, name_));
	return all.back();
}
