//
// nono
// Copyright (C) 2023 nono project
// Licensed under nono-license.txt
//

#pragma once

#include "device.h"

class X68kIODevice;

class ExtAreaDevice : public IODevice
{
	using inherited = IODevice;

	static const uint32 baseaddr = 0xeae000;

 public:
	ExtAreaDevice();
	~ExtAreaDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;

 private:
	X68kIODevice *x68kio {};
};
