//
// Copyright (C) 2012-2022 isaki@NetBSD.org
//
// ROM イメージを C ソースに変換する
//
// 書式
//	genrom <rom.dat> <rom.cpp> <variable_name>
// 例
//	genrom CGROM.DAT cgrom.cpp CGROM
//

#include <cstdint>
#include <cstdio>
#include <cstdlib>
#include <cstring>

int
main(int ac, char *av[])
{
	char buf[4096];
	const char *infile;
	const char *outfile;
	const char *varname;
	FILE *in;
	FILE *out;
	int n;
	int i;

	if (ac < 4) {
		fprintf(stderr, "usage: %s <infile> <outfile> <variable_name>\n",
			av[0]);
		exit(1);
	}

	infile  = av[1];
	outfile = av[2];
	varname = av[3];

	in = fopen(infile, "rb");
	if (in == NULL) {
		fprintf(stderr, "cannot open %s\n", infile);
		exit(1);
	}

	out = fopen(outfile, "wb");
	if (out == NULL) {
		fprintf(stderr, "cannot open %s\n", outfile);
		exit(1);
	}

	fprintf(out, "// This file was generated by %s\n", av[0]);
	fprintf(out, "#include \"builtinrom.h\"\n");
	fprintf(out, "/*static*/ uint8 const Builtin::%s[] = {", varname);

	for (;;) {
		n = fread(buf, 1, sizeof(buf), in);
		if (n == 0) {
			break;
		}

		for (i = 0; i < n; i++) {
			if (i % 8 == 0) {
				fprintf(out, "\n\t");
			}
			fprintf(out, "0x%02x,", (unsigned char)buf[i]);
		}
	}
	fprintf(out, "\n};\n");

	fclose(in);
	fclose(out);
	exit(0);
}
