//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// メインバス (LUNA)
//

#pragma once

#include "mainbus.h"

class LunaMainbus : public Mainbus24Device
{
	using inherited = Mainbus24Device;
 public:
	LunaMainbus();
	~LunaMainbus() override;

	bool InitMainbus() override;

 protected:
	// ブートページを切り替える。
	void SwitchBootPage(bool isrom) override;

	// デバイスマップから devtable を作成
	void MakeDevtable(const uint8 *maptable);

	// ブートページ切り替え用 (unique_ptr ではない)
	IODevice *ram0 {};

	std::unique_ptr<IODevice> pBusErr {};
	std::unique_ptr<IODevice> pBT45x {};
	std::unique_ptr<IODevice> pCRTC2 {};
	std::unique_ptr<IODevice> pEthernet {};
	std::unique_ptr<IODevice> pInterrupt {};
	std::unique_ptr<IODevice> pMainRAM {};
	std::unique_ptr<IODevice> pNopIO {};
	std::unique_ptr<IODevice> pPartialRAM {};
	std::unique_ptr<IODevice> pPlaneVRAM {};
	std::unique_ptr<IODevice> pPROM {};
	std::unique_ptr<IODevice> pPROM0 {};
	std::unique_ptr<IODevice> pPIO0 {};
	std::unique_ptr<IODevice> pPIO1 {};
	std::unique_ptr<IODevice> pRTC {};
	std::unique_ptr<IODevice> pSIO {};
	std::unique_ptr<IODevice> pSPC {};
	std::unique_ptr<IODevice> pSubRAM {};
	std::unique_ptr<IODevice> pSysClk {};
	std::unique_ptr<IODevice> pTAS {};
	std::unique_ptr<IODevice> pXPbus {};
};

class Luna1Mainbus final : public LunaMainbus
{
	using inherited = LunaMainbus;
 public:
	Luna1Mainbus();
	~Luna1Mainbus() override;

	bool Create() override;

 private:
	static const uint8 maptable[256];
};

class Luna88kMainbus final : public LunaMainbus
{
	using inherited = LunaMainbus;
 public:
	Luna88kMainbus();
	~Luna88kMainbus() override;

	bool Create() override;

 private:
	std::unique_ptr<IODevice> pCMMU {};
	std::unique_ptr<IODevice> pFuseROM {};

	static const uint8 maptable[256];
};
