//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// ABORT/INTERRUPT スイッチによる NMI 機構デバイス
//

#pragma once

#include "device.h"
#include "message.h"

class InterruptDevice;

class NMIDevice : public Device
{
	using inherited = Device;
 public:
	NMIDevice();
	~NMIDevice() override;

	bool Init() override;

	// NMI ボタンを押す
	void PressNMI();

	// NMI 信号線をアサートする
	void AssertNMI();

	// NMI 信号線をネゲートする
	void NegateNMI();

 private:
	void AssertMessage(MessageID, uint32);
	void NegateCallback(Event *);

	InterruptDevice *interrupt {};

	Event *event {};
};

static inline NMIDevice *GetNMIDevice() {
	return Object::GetObject<NMIDevice>(OBJ_NMI);
}
