//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// LUNA-I の ROM エミュレーション
//

#pragma once

#include "romemu_luna.h"

class Luna1PROMEmuDevice : public LunaPROMEmuDevice
{
	using inherited = LunaPROMEmuDevice;

 public:
	Luna1PROMEmuDevice();
	~Luna1PROMEmuDevice() override;

	bool Init() override;

 private:
	void ROM_InitMD() override;
	void ROM_Close() override;
	uint32 LoadFile(const std::string& fname) override;
	void Command() override;

	void CommandG(const std::vector<std::string>& arg);
	void CommandK(const std::vector<std::string>& arg);
	bool CommandKInput(const std::string& val);
	void CommandX();

	// NVRAM
	bool InitNVRAM() override;
	void GetNVRAM(bootinfo_t&) override;

	// プロンプトの状態。
	// 0 が通常プロンプト。
	// 1 以降は k コマンドのプロンプトを示す
	int prompt_idx {};
};
