//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// X68030 の ROM30 (SCSI ROM) エミュレーション
//

#pragma once

#include "romemu.h"

class MainbusDevice;
class SPCDevice;

class ROM30EmuDevice : public ROMEmuDevice
{
	using inherited = ROMEmuDevice;

 private:
	// このデバイスの先頭アドレス
	static const uint32 baseaddr		= 0x00fc0000;

	// 謎の I/O 空間
	static const uint32 ROMIO_BASE		= 0xfc0080;
	static const uint32 ROMIO_SCSI		= (ROMIO_BASE + 0);
	static const uint32 ROMIO_BOOT		= (ROMIO_BASE + 4);

 public:
	ROM30EmuDevice();
	~ROM30EmuDevice() override;

	bool Init() override;

 private:
	uint64 ReadROMIO(busaddr addr) override;

	uint32 SCSIBoot() const;
	uint32 SCSIIOCS();
	uint32 SCSI_S_INQUIRY(uint32);
	uint32 SCSI_S_READEXT(uint32);
	uint32 SCSI_S_TESTUNIT(uint32);
	uint32 SCSI_S_READCAP(uint32);

	// SCSI IOCS コール名を返す
	static std::string GetSCSICallName(uint number);

	MainbusDevice *mainbus {};
	SPCDevice *spc {};

	static const char * const x68k_scsicall[0x40];
};
