//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// ステータスパネル
//

#pragma once

#include "wxtextpanel.h"
#include "fdd.h"
#include <array>

class Indicator;
class PowerDevice;
class Syncer;
class Status;
class WXStatusPanel;

// ステータスパネル
class WXStatusPanel : public WXTextPanel
{
	using inherited = WXTextPanel;

 public:
	explicit WXStatusPanel(wxWindow *parent);
	~WXStatusPanel() override;

	void FontChanged() override;
	void Fit() override;
	bool Layout() override;

	void Init();

 private:
	void OnClose(wxCloseEvent&);
	void OnShow(wxShowEvent&);
	void OnTimer(wxTimerEvent&);
	void OnLeftDClick(wxMouseEvent&);
	void OnContextMenu(wxContextMenuEvent&);
	void OnSCSIMediaChanged(wxCommandEvent&);
	void OnFDDMediaChanged(wxCommandEvent&);
	void OnLEDChanged(wxCommandEvent&);

	bool UpdateStat();
	void Draw() override;
	void InitIndicators();
	wxSize LayoutIndicators();
	void DrawPerf(const Indicator *);
	void DrawSCSI(const Indicator *);
	void DrawVBlk(const Indicator *);
	void DrawNet(const Indicator *);
	void DrawFD(const Indicator *);
	void DrawNewsLED1(const Indicator *);
	void DrawNewsLED2(const Indicator *);
	void DrawPower(const Indicator *);
	void DrawTextLED(const Indicator *, Color fg, Color bg);
	void DClickPerf(const Indicator *);
	void ContextMenuCD(const Indicator *);
	void ContextMenuFD(const Indicator *);

	// 状態
	std::vector<Status*> stats {};

	// インジケータ情報
	std::vector<Indicator*> indicators {};

	// インジケータ表示用
	bool ispower {};
	bool powerled {};
	uint clock_khz {};
	uint perf_mode {};
	uint perf_rate {};
	std::array<bool, 8> scsi_loaded {};
	std::array<bool, 4> fd_loaded {};

	// 丸いアクセスマーク (X68k FD 用)
	std::unique_ptr<BitmapI8> accmark /*{}*/;

	// 背景再描画
	bool refresh_background {};

	PowerDevice *power {};
	Syncer *syncer {};

	// タイマー
	wxTimer timer {};

	// イベントテーブル
	wxDECLARE_EVENT_TABLE();

	static const uint8 AccessMark12[];
	static const uint8 AccessMark16[];
	static const uint8 AccessMark24[];
};
