//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// FuseROM
//

#pragma once

#include "device.h"
#include <array>

class FuseROMDevice : public IODevice
{
	using inherited = IODevice;

	// この ROM が保持できるデータ量 (バイト数換算)
	static const uint32 SRCBYTES = 128;
 public:
	FuseROMDevice();
	~FuseROMDevice() override;

	bool Init() override;

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = SRCBYTES * 2;	// XXX 未調査
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);
	bool PokePort(uint32 offset, uint32 data);

 private:
	uint8 GetByte(uint32 offset) const;

	// バイトデータで保持しておく
	std::array<uint8, SRCBYTES> src {};
};

inline FuseROMDevice *GetFuseROMDevice() {
	return Object::GetObject<FuseROMDevice>(OBJ_FUSEROM);
}
