//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// 何もしないデバイス
//

#pragma once

#include "device.h"

// 何もしないデバイス。
// 読み込むと全域で 0xff が読めて、書き込んでも何も起きない。
class NopIODevice : public IODevice
{
	using inherited = IODevice;
 public:
	NopIODevice();
	~NopIODevice() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Read1(uint32 addr) override;
	busdata Write1(uint32 addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
};

inline NopIODevice *GetNopIODevice() {
	return Object::GetObject<NopIODevice>(OBJ_NOPIO);
}
