//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// virt-m68k の IPLROM 相当の何か
//

#pragma once

#include "romemu.h"

class BootInfo;
class IODeviceStream;
class LoadInfo;
class MainRAMDevice;

class Virt68kROMEmuDevice : public ROMEmuDevice
{
	using inherited = ROMEmuDevice;

	// BootInfo (抜粋)

	// タグ
	static const uint BI_LAST		= 0;
	static const uint BI_MACHTYPE	= 1;	// machine type (uint32)
	static const uint BI_CPUTYPE	= 2;	// CPU type (uint32)
	static const uint BI_FPUTYPE	= 3;	// FPU type (uint32)
	static const uint BI_MMUTYPE	= 4;	// MMU type (uint32)
	static const uint BI_MEMCHUNK	= 5;	// memory segment (bi_mem_info)
	static const uint BI_RAMDISK	= 6;	// RAMDISK (bi_mem_info)
	static const uint BI_COMMANDLINE= 7;	// カーネルコマンドライン
											//  パラメータ (C string)
	static const uint BI_RNG_SEED	= 8;	// 乱数シード (bi_data)

	#define BI_MACHDEP(x) (0x8000 + (x))
	static const uint BI_QEMU_VER	= BI_MACHDEP(0);	// (uint32)
	static const uint BI_GFPIC		= BI_MACHDEP(1);	// (bi_virt_dev *)
	static const uint BI_GFRTC		= BI_MACHDEP(2);
	static const uint BI_GFTTY		= BI_MACHDEP(3);
	static const uint BI_VIRTIO		= BI_MACHDEP(4);
	static const uint BI_CTRL		= BI_MACHDEP(5);

	// BI_MACHTYPE
	static const uint32 BI_MACH_VIRT	= 14;

	// BI_CPUTYPE
	static const uint32 BI_CPU_68020	= (1U << 0);
	static const uint32 BI_CPU_68030	= (1U << 1);
	static const uint32 BI_CPU_68040	= (1U << 2);
	static const uint32 BI_CPU_68060	= (1U << 3);

	// BI_FPUTYPE
	static const uint32 BI_FPU_68881	= (1U << 0);
	static const uint32 BI_FPU_68882	= (1U << 1);
	static const uint32 BI_FPU_68040	= (1U << 2);
	static const uint32 BI_FPU_68060	= (1U << 3);

	// BI_MMUTYPE
	static const uint32 BI_MMU_68851	= (1U << 0);
	static const uint32 BI_MMU_68030	= (1U << 1);
	static const uint32 BI_MMU_68040	= (1U << 2);
	static const uint32 BI_MMU_68060	= (1U << 3);

	// bi_mem_info {
	//  uint32 addr;
	//  uint32 size;
	// };
	//
	// bi_data {
	//  uint16 data_length;
	//  uint8[] data_bytes;
	// };
	//
	// bi_vert_dev {
	//  uint32 addr;
	//  uint32 irq;
	// };

 protected:
	// このデバイス先頭アドレス
	static const uint32 baseaddr		= 0xff000000;

	// 謎の I/O 空間
	static const uint32 ROMIO_BASE		= 0xff008000;
	static const uint32 ROMIO_INIT		= (ROMIO_BASE + 0);

 public:
	Virt68kROMEmuDevice();
	~Virt68kROMEmuDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

 private:
	uint64 ReadROMIO(busaddr addr) override;

	uint32 ROM_Init();
	bool MakeBootInfo(LoadInfo *);
	void WriteBootInfo(IODeviceStream&, BootInfo&);

	static const std::pair<uint32, const char *> tag_str[];
	static const std::pair<uint32, const char *> mach_str[];
	static const std::pair<uint32, const char *> cpu_str[];
	static const std::pair<uint32, const char *> fpu_str[];
	static const std::pair<uint32, const char *> mmu_str[];

	MainRAMDevice *mainram {};
};
