//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// SIO (uPD7201)
//

#pragma once

#include "mpscc.h"

class Keyboard;

class SIODevice : public MPSCCDevice
{
	using inherited = MPSCCDevice;
 public:
	SIODevice();
	~SIODevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	// BusIO インタフェース
	// (内蔵 ROM からのアクセス用に特別に public にしてある)
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
 protected:
	busdata PeekPort(uint32 offset);

	void Tx(int ch, uint32 data) override;
	uint GetHighestInt() const override;

 private:
	// 指定のレジスタ名を返す
	const char *CRName(const MPSCCChan&, uint n) const override;
	const char *SRName(const MPSCCChan&, uint n) const override;
	// 現在のレジスタ名を返す
	const char *CRName(const MPSCCChan& chan) const {
		return CRName(chan, chan.ptr);
	}
	const char *SRName(const MPSCCChan& chan) const {
		return SRName(chan, chan.ptr);
	}

	void ResetChannel(MPSCCChan&);

	uint8 ReadCtrl(MPSCCChan&);
	void WriteCtrl(MPSCCChan&, uint32 data);
	uint8 PeekCtrl(const MPSCCChan&) const;

	uint8 GetCR1(const MPSCCChan&) const;
	uint8 GetCR2A() const;
	uint8 GetCR2B() const;
	uint8 GetSR0(const MPSCCChan&) const;

	void WriteCR0(MPSCCChan&, uint32 data);
	void WriteCR1(MPSCCChan&, uint32 data);
	void WriteCR2(MPSCCChan&, uint32 data);

	// VIS モードを更新
	void SetVIS();

	DECLARE_MONITOR_SCREEN(MonitorScreen);
	void MonitorScreenCh(TextScreen&, int ch, int xbase, int ybase);

	Keyboard *keyboard {};

	static const char * const crnames[16];
	static const char * const srnames[16];
};

inline SIODevice *GetSIODevice() {
	return Object::GetObject<SIODevice>(OBJ_MPSCC);
}
