//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

#include "m88100disasm.h"
#include "debugger_memory.h"
#include "mpu.h"
#include "mystring.h"

#define O(inst, expstd)			{ __LINE__, inst, expstd }
#define T(inst, expstd, expalt) { __LINE__, inst, expstd, expalt }
#define M(b, d, s1, s2)		((b) | ((d)<<21) | ((s1)<<16) | (s2))

struct {
	int line;
	uint32 inst;
	std::string expstd;
	std::string expalt;
} table[] = {
 T(0x02328765, "xmem.bu r17,r18,#0x8765",	"{xmem.bu r17,(r18,#0x8765)}"),
 T(0x06328765, "xmem    r17,r18,#0x8765",	"{xmem   r17,(r18,#0x8765)}"),
 T(0x06320000, "xmem    r17,r18,#0x0000",	"{xmem   r17,(r18)}"),
 T(0x06200001, "xmem    r17,r0, #0x0001",	"{xmem   r17,(r0,#0x0001)}"),
 T(0x0a328765, "ld.hu   r17,r18,#0x8765",	"{ld.hu  r17,(r18,#0x8765)}"),
 T(0x0e328765, "ld.bu   r17,r18,#0x8765",	"{ld.bu  r17,(r18,#0x8765)}"),
 T(0x12328765, "ld.d    r17,r18,#0x8765",	"{ld.d   r17,(r18,#0x8765)}"),
 T(0x16328765, "ld      r17,r18,#0x8765",	"{ld     r17,(r18,#0x8765)}"),
 T(0x1a328765, "ld.h    r17,r18,#0x8765",	"{ld.h   r17,(r18,#0x8765)}"),
 T(0x1e328765, "ld.b    r17,r18,#0x8765",	"{ld.b   r17,(r18,#0x8765)}"),
 T(0x22328765, "st.d    r17,r18,#0x8765",	"{st.d   r17,(r18,#0x8765)}"),
 T(0x26328765, "st      r17,r18,#0x8765",	"{st     r17,(r18,#0x8765)}"),
 T(0x2a328765, "st.h    r17,r18,#0x8765",	"{st.h   r17,(r18,#0x8765)}"),
 T(0x2e328765, "st.b    r17,r18,#0x8765",	"{st.b   r17,(r18,#0x8765)}"),
 T(0x32328765, "lda.d   r17,r18,#0x8765",	"{lda.d  r17,r18,#0x8765}"),
 T(0x36328765, "lda     r17,r18,#0x8765",	"{lda    r17,r18,#0x8765}"),
 T(0x3a328765, "lda.h   r17,r18,#0x8765",	"{lda.h  r17,r18,#0x8765}"),
 T(0x3e328765, "lda.b   r17,r18,#0x8765",	"{lda.b  r17,r18,#0x8765}"),
 T(0x36320000, "lda     r17,r18,#0x0000",	"{lda    r17,r18}"),
 T(0x36200001, "lda     r17,r0, #0x0001",	"{lda    r17,r0,#0x0001}"),

 T(0x40128765, "and     r0, r18,#0x8765",	"{nop}"),
 T(0x42208765, "and     r17,r0, #0x8765",	"{clr    r17}"),
 T(0x42318765, "and     r17,r17,#0x8765",	"{and    r17,#0xffff8765}"),
 T(0x42328765, "and     r17,r18,#0x8765",	"{and    r17,r18,#0xffff8765}"),
 T(0x44128765, "and.u   r0, r18,#0x8765",	"{nop}"),
 T(0x46208765, "and.u   r17,r0, #0x8765",	"{clr    r17}"),
 T(0x46318765, "and.u   r17,r17,#0x8765",	"{and    r17,#0x8765ffff}"),
 T(0x46328765, "and.u   r17,r18,#0x8765",	"{and    r17,r18,#0x8765ffff}"),
 T(0x48128765, "mask    r0, r18,#0x8765",	"{nop}"),
 T(0x4a208765, "mask    r17,r0, #0x8765",	"{clr    r17}"),
 T(0x4a318765, "mask    r17,r17,#0x8765",	"{and    r17,#0x00008765}"),
 T(0x4a328765, "mask    r17,r18,#0x8765",	"{and    r17,r18,#0x00008765}"),
 T(0x4c128765, "mask.u  r0, r18,#0x8765",	"{nop}"),
 T(0x4e208765, "mask.u  r17,r0, #0x8765",	"{clr    r17}"),
 T(0x4e318765, "mask.u  r17,r17,#0x8765",	"{and    r17,#0x87650000}"),
 T(0x4e328765, "mask.u  r17,r18,#0x8765",	"{and    r17,r18,#0x87650000}"),

 T(0x50128765, "xor     r0, r18,#0x8765",	"{nop}"),
 T(0x52208765, "xor     r17,r0, #0x8765",	"{mov    r17,#0x8765}"),
 T(0x52318765, "xor     r17,r17,#0x8765",	"{xor    r17,#0x8765}"),
 T(0x52328765, "xor     r17,r18,#0x8765",	"{xor    r17,r18,#0x8765}"),
 T(0x54128765, "xor.u   r0, r18,#0x8765",	"{nop}"),
 T(0x56208765, "xor.u   r17,r0, #0x8765",	"{mov    r17,#0x87650000}"),
 T(0x56318765, "xor.u   r17,r17,#0x8765",	"{xor    r17,#0x87650000}"),
 T(0x56328765, "xor.u   r17,r18,#0x8765",	"{xor    r17,r18,#0x87650000}"),
 T(0x58128765, "or      r0, r18,#0x8765",	"{nop}"),
 T(0x5a208765, "or      r17,r0, #0x8765",	"{mov    r17,#0x8765}"),
 T(0x5a318765, "or      r17,r17,#0x8765",	"{or     r17,#0x8765}"),
 T(0x5a328765, "or      r17,r18,#0x8765",	"{or     r17,r18,#0x8765}"),
 T(0x5c128765, "or.u    r0, r18,#0x8765",	"{nop}"),
 T(0x5e208765, "or.u    r17,r0, #0x8765",	"{mov    r17,#0x87650000}"),
 T(0x5e318765, "or.u    r17,r17,#0x8765",	"{or     r17,#0x87650000}"),
 T(0x5e328765, "or.u    r17,r18,#0x8765",	"{or     r17,r18,#0x87650000}"),

 T(0x60128765, "addu    r0, r18,#0x8765",	"{nop}"),
 T(0x62208765, "addu    r17,r0, #0x8765",	"{mov    r17,#0x00008765}"),
 T(0x62318765, "addu    r17,r17,#0x8765",	"{addu   r17,#0x00008765}"),
 T(0x62328765, "addu    r17,r18,#0x8765",	"{addu   r17,r18,#0x00008765}"),
 T(0x64128765, "subu    r0, r18,#0x8765",	"{nop}"),
 T(0x66208765, "subu    r17,r0, #0x8765",	"{mov    r17,#0xffff789b}"),
 T(0x66318765, "subu    r17,r17,#0x8765",	"{subu   r17,#0x00008765}"),
 T(0x66328765, "subu    r17,r18,#0x8765",	"{subu   r17,r18,#0x00008765}"),
 T(0x68128765, "divu    r0, r18,#0x8765",	"{divu   r0, r18,#0x00008765}"),
 T(0x6a208765, "divu    r17,r0, #0x8765",	"{divu   r17,r0, #0x00008765}"),
 T(0x6a318765, "divu    r17,r17,#0x8765",	"{divu   r17,#0x00008765}"),
 T(0x6a328765, "divu    r17,r18,#0x8765",	"{divu   r17,r18,#0x00008765}"),
 T(0x6c128765, "mul     r0, r18,#0x8765",	"{mul    r0, r18,#0x00008765}"),
 T(0x6e208765, "mul     r17,r0, #0x8765",	"{mul    r17,r0, #0x00008765}"),
 T(0x6e318765, "mul     r17,r17,#0x8765",	"{mul    r17,#0x00008765}"),
 T(0x6e328765, "mul     r17,r18,#0x8765",	"{mul    r17,r18,#0x00008765}"),

 T(0x70128765, "add     r0, r18,#0x8765",	"{adds   r0, r18,#0x00008765}"),
 T(0x72208765, "add     r17,r0, #0x8765",	"{adds   r17,r0, #0x00008765}"),
 T(0x72318765, "add     r17,r17,#0x8765",	"{adds   r17,#0x00008765}"),
 T(0x72328765, "add     r17,r18,#0x8765",	"{adds   r17,r18,#0x00008765}"),
 T(0x74128765, "sub     r0, r18,#0x8765",	"{subs   r0, r18,#0x00008765}"),
 T(0x76208765, "sub     r17,r0, #0x8765",	"{subs   r17,r0, #0x00008765}"),
 T(0x76318765, "sub     r17,r17,#0x8765",	"{subs   r17,#0x00008765}"),
 T(0x76328765, "sub     r17,r18,#0x8765",	"{subs   r17,r18,#0x00008765}"),
 T(0x78128765, "div     r0, r18,#0x8765",	"{div    r0, r18,#0x00008765}"),
 T(0x7a208765, "div     r17,r0, #0x8765",	"{div    r17,r0, #0x00008765}"),
 T(0x7a318765, "div     r17,r17,#0x8765",	"{div    r17,#0x00008765}"),
 T(0x7a328765, "div     r17,r18,#0x8765",	"{div    r17,r18,#0x00008765}"),
 T(0x7c128765, "cmp     r0, r18,#0x8765",	"{nop}"),
 T(0x7e208765, "cmp     r17,r0, #0x8765",	"{cmp    r17,r0, #0x00008765}"),
 T(0x7e318765, "cmp     r17,r17,#0x8765",	"{cmp    r17,r17,#0x00008765}"),
 T(0x7e328765, "cmp     r17,r18,#0x8765",	"{cmp    r17,r18,#0x00008765}"),

 O(0x82204260, "ldcr    r17,sr2"),
 O(0x82204fe0, "fldcr   r17,fpcr"),
 O(0x80118271, "stcr    r17,sr2"),
 O(0x80118ff1, "fstcr   r17,fpcr"),
 O(0x8232c272, "xcr     r17,r18,sr2"),
 O(0x8232cff2, "fxcr    r17,r18,fpcr"),

 O(0x86320001, "fmul.sss r17,r18,r1"),
 O(0x86202001, "flt.ss  r17,r1"),
 O(0x86322801, "fadd.sss r17,r18,r1"),
 O(0x86323001, "fsub.sss r17,r18,r1"),
 O(0x86323801, "fcmp.sss r17,r18,r1"),
 O(0x86204801, "int.ss  r17,r1"),
 O(0x86205001, "nint.ss r17,r1"),
 O(0x86205801, "trnc.ss r17,r1"),
 O(0x86327001, "fdiv.sss r17,r18,r1"),
 // fmul のサイズ
 O(0x86320021, "fmul.dss r17,r18,r1"),
 O(0x86320081, "fmul.ssd r17,r18,r1"),
 O(0x863200a1, "fmul.dsd r17,r18,r1"),
 O(0x86320201, "fmul.sds r17,r18,r1"),
 O(0x86320221, "fmul.dds r17,r18,r1"),
 O(0x86320281, "fmul.sdd r17,r18,r1"),
 O(0x863202a1, "fmul.ddd r17,r18,r1"),

 O(0xc3ffffff, "br      0x000000fc"),
 O(0xc7ffffff, "br.n    0x000000fc"),
 O(0xcbffffff, "bsr     0x000000fc"),
 O(0xcfffffff, "bsr.n   0x000000fc"),
 O(0xd232ffff, "bb0     #17,r18,0x000000fc"),
 O(0xd632ffff, "bb0.n   #17,r18,0x000000fc"),
 O(0xda32ffff, "bb1     #17,r18,0x000000fc"),
 O(0xde32ffff, "bb1.n   #17,r18,0x000000fc"),

#define L "0x000000fc"
 T(0xe852ffff, "bcnd    eq0,r18," L, "{br     (r18==0|(float)r18==+0)," L "}"),
 T(0xec52ffff, "bcnd.n  eq0,r18," L, "{br.n   (r18==0|(float)r18==+0)," L "}"),
#define A(m5, s1)	M(0xe8000000, m5, s1, 0xffff)
 T(A(0x00, 2), "bcnd    #0, r2, " L, "{br     false," L "}"),
 T(A(0x01, 2), "bcnd    gt0,r2, " L, "{br     (r2>0|(float)r2>+0)," L "}"),
 T(A(0x02, 2), "bcnd    eq0,r2, " L, "{br     (r2==0|(float)r2==+0)," L "}"),
 T(A(0x03, 2), "bcnd    ge0,r2, " L, "{br     (r2>=0|(float)r2>=+0)," L "}"),
 T(A(0x04, 2), "bcnd    #4, r2, " L, "{br     ((float)r2<-0)," L "}"),
 T(A(0x05, 2), "bcnd    #5, r2, " L, "{br     ((float)r2!=0)," L "}"),
 O(A(0x06, 2), "bcnd    #6, r2, " L),
 T(A(0x07, 2), "bcnd    #7, r2, " L, "{br     (r2!=0x80000000)," L "}"),
 T(A(0x08, 2), "bcnd    #8, r2, " L, "{br     (r2==0x80000000)," L "}"),
 O(A(0x09, 2), "bcnd    #9, r2, " L),
 T(A(0x0a, 2), "bcnd    #10,r2, " L, "{br     ((float)r2==0)," L "}"),
 T(A(0x0b, 2), "bcnd    #11,r2, " L, "{br     ((float)r2>=-0)," L "}"),
 T(A(0x0c, 2), "bcnd    lt0,r2, " L, "{br     (r2<0|(float)r2<+0)," L "}"),
 T(A(0x0d, 2), "bcnd    ne0,r2, " L, "{br     (r2!=0|(float)r2!=+0)," L "}"),
 T(A(0x0e, 2), "bcnd    le0,r2, " L, "{br     (r2<=0|(float)r2<=+0)," L "}"),
 T(A(0x0f, 2), "bcnd    #15,r2, " L, "{br     " L "}"),
 O(A(0x10, 2), "bcnd    #16,r2, " L),
 O(A(0x1f, 2), "bcnd    #31,r2, " L),
 T(A(0x00, 0), "bcnd    #0, r0, " L, "{br     false," L "}"),
 T(A(0x01, 0), "bcnd    gt0,r0, " L, "{br     false," L "}"),
 T(A(0x02, 0), "bcnd    eq0,r0, " L, "{br     " L "}"),
 T(A(0x03, 0), "bcnd    ge0,r0, " L, "{br     " L "}"),
 T(A(0x04, 0), "bcnd    #4, r0, " L, "{br     false," L "}"),
 T(A(0x05, 0), "bcnd    #5, r0, " L, "{br     false," L "}"),
 T(A(0x06, 0), "bcnd    #6, r0, " L, "{br     " L "}"),
 T(A(0x07, 0), "bcnd    #7, r0, " L, "{br     " L "}"),
 T(A(0x08, 0), "bcnd    #8, r0, " L, "{br     false," L "}"),
 T(A(0x09, 0), "bcnd    #9, r0, " L, "{br     false," L "}"),
 T(A(0x0a, 0), "bcnd    #10,r0, " L, "{br     " L "}"),
 T(A(0x0b, 0), "bcnd    #11,r0, " L, "{br     " L "}"),
 T(A(0x0c, 0), "bcnd    lt0,r0, " L, "{br     false," L "}"),
 T(A(0x0d, 0), "bcnd    ne0,r0, " L, "{br     false," L "}"),
 T(A(0x0e, 0), "bcnd    le0,r0, " L, "{br     " L "}"),
 T(A(0x0f, 0), "bcnd    #15,r0, " L, "{br     " L "}"),
 O(A(0x10, 0), "bcnd    #16,r0, " L),
 O(A(0x1f, 0), "bcnd    #31,r0, " L),
#undef A
#undef L

 T(0xf2328034, "clr     r17,r18,1<20>",		"{and    r17,r18,0xffefffff}"),
 T(0xf2328274, "clr     r17,r18,19<20>",	"{and    r17,r18,0x000fffff}"),
 T(0xf2328834, "set     r17,r18,1<20>",		"{or     r17,r18,0x00100000}"),
 T(0xf2328a74, "set     r17,r18,19<20>",	"{or     r17,r18,0xfff00000}"),

 T(0xf0129274, "ext     r0, r18,19<20>",	"{nop}"),
 T(0xf2209274, "ext     r17,r0, 19<20>",	"{clr    r17}"),
 T(0xf2319014, "ext     r17,r17,32<20>",	"{asr    r17,#20}"),
 T(0xf2329014, "ext     r17,r18,32<20>",	"{asr    r17,r18,#20}"),
 T(0xf2319194, "ext     r17,r17,12<20>",	"{asr    r17,#20}"),
 T(0xf2319174, "ext     r17,r17,11<20>",	"{bfexts r17,11<20>}"),
 T(0xf2329194, "ext     r17,r18,12<20>",	"{asr    r17,r18,#20}"),
 T(0xf2329174, "ext     r17,r18,11<20>",	"{bfexts r17,r18,11<20>}"),
 T(0xf0129a74, "extu    r0, r18,19<20>",	"{nop}"),
 T(0xf2209a74, "extu    r17,r0, 19<20>",	"{clr    r17}"),
 T(0xf2319814, "extu    r17,r17,32<20>",	"{lsr    r17,#20}"),
 T(0xf2329814, "extu    r17,r18,32<20>",	"{lsr    r17,r18,#20}"),
 T(0xf2319994, "extu    r17,r17,12<20>",	"{lsr    r17,#20}"),
 T(0xf2319974, "extu    r17,r17,11<20>",	"{bfextu r17,11<20>}"),
 T(0xf2329994, "extu    r17,r18,12<20>",	"{lsr    r17,r18,#20}"),
 T(0xf2329974, "extu    r17,r18,11<20>",	"{bfextu r17,r18,11<20>}"),

 T(0xf012a274, "mak     r0, r18,19<20>",	"{nop}"),
 T(0xf220a274, "mak     r17,r0, 19<20>",	"{clr    r17}"),
 T(0xf231a014, "mak     r17,r17,32<20>",	"{lsl    r17,#20}"),
 T(0xf232a014, "mak     r17,r18,32<20>",	"{lsl    r17,r18,#20}"),
 T(0xf231a194, "mak     r17,r17,12<20>",	"{lsl    r17,#20}"),
 T(0xf231a174, "mak     r17,r17,11<20>",	"{bfmak  r17,11<20>}"),
 T(0xf232a194, "mak     r17,r18,12<20>",	"{lsl    r17,r18,#20}"),
 T(0xf232a174, "mak     r17,r18,11<20>",	"{bfmak  r17,r18,11<20>}"),
 T(0xf012a814, "rot     r0, r18,<20>",		"{nop}"),
 T(0xf231a800, "rot     r17,r17,<0>",		"{nop}"),
 T(0xf220a814, "rot     r17,r0, <20>",		"{clr    r17}"),
 T(0xf231a810, "rot     r17,r17,<16>",		"{ror    r17,#16}"),
 T(0xf232a810, "rot     r17,r18,<16>",		"{ror    r17,r18,#16}"),
 T(0xf231a814, "rot     r17,r17,<20>",		"{rol    r17,#12}"),
 T(0xf232a814, "rot     r17,r18,<20>",		"{rol    r17,r18,#12}"),

 O(0xf232d101, "tb0     #17,r18,#0x101"),
 O(0xf232d901, "tb1     #17,r18,#0x101"),
 T(0xf220d87f, "tb1     #17,r0, #0x07f",	"{ssync}"),
 T(0xf220d880, "tb1     #17,r0, #0x080",	"{usync}"),
 O(0xf052e901, "tcnd    eq0,r18,#0x101"),

 T(0xf6320001, "xmem.bu r17,r18,r1",		"{xmem.bu r17,(r18,r1)}"),
 T(0xf6320401, "xmem    r17,r18,r1",		"{xmem   r17,(r18,r1)}"),
 T(0xf6320801, "ld.hu   r17,r18,r1",		"{ld.hu  r17,(r18,r1)}"),
 T(0xf6320c01, "ld.bu   r17,r18,r1",		"{ld.bu  r17,(r18,r1)}"),
 T(0xf6321001, "ld.d    r17,r18,r1",		"{ld.d   r17,(r18,r1)}"),
 T(0xf6321401, "ld      r17,r18,r1",		"{ld     r17,(r18,r1)}"),
 T(0xf6321801, "ld.h    r17,r18,r1",		"{ld.h   r17,(r18,r1)}"),
 T(0xf6321c01, "ld.b    r17,r18,r1",		"{ld.b   r17,(r18,r1)}"),
 T(0xf6322001, "st.d    r17,r18,r1",		"{st.d   r17,(r18,r1)}"),
 T(0xf6322401, "st      r17,r18,r1",		"{st     r17,(r18,r1)}"),
 T(0xf6322801, "st.h    r17,r18,r1",		"{st.h   r17,(r18,r1)}"),
 T(0xf6322c01, "st.b    r17,r18,r1",		"{st.b   r17,(r18,r1)}"),
 // 全種について全引数パターンはつらいので ld だけで引数を変える
 T(0xf6321000, "ld.d    r17,r18,r0",		"{ld.d   r17,(r18)}"),
 T(0xf6321200, "ld.d    r17,r18[r0]",		"{ld.d   r17,(r18)}"),
 T(0xf6201001, "ld.d    r17,r0, r1",		"{ld.d   r17,(r1)}"),
 T(0xf6321001, "ld.d    r17,r18,r1",		"{ld.d   r17,(r18,r1)}"),
 T(0xf6201201, "ld.d    r17,r0[r1]",		"{ld.d   r17,(r0[r1])}"),
 T(0xf6321201, "ld.d    r17,r18[r1]",		"{ld.d   r17,(r18[r1])}"),
 // .usr も一部代表だけ
 T(0xf6321101, "ld.d.usr r17,r18,r1",		"{ldusr.d r17,(r18,r1)}"),
 T(0xf6321401, "ld      r17,r18,r1",		"{ld     r17,(r18,r1)}"),
 T(0xf6321501, "ld.usr  r17,r18,r1",		"{ldusr  r17,(r18,r1)}"),
 // lda
 T(0xf6323001, "lda.d   r17,r18,r1",		"{lda.d  r17,r18,r1}"),
 T(0xf6323401, "lda     r17,r18,r1",		"{lda    r17,r18,r1}"),
 T(0xf6323801, "lda.h   r17,r18,r1",		"{lda.h  r17,r18,r1}"),
 T(0xf6323c01, "lda.b   r17,r18,r1",		"{lda.b  r17,r18,r1}"),

 // ここから3項になってパターンが増えるので r17, r18 ではなく r1, r2 を使う
#define A(d, s1, s2)	M(0xf400'4000, d, s1, s2)
 T(A(0, 0, 0), "and     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "and     r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "and     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "and     r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "and     r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "and     r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "and     r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "and     r1, r0, r1",		"{clr    r1}"),
 T(A(1, 0, 2), "and     r1, r0, r2",		"{clr    r1}"),
 T(A(1, 1, 0), "and     r1, r1, r0",		"{clr    r1}"),
 T(A(1, 1, 1), "and     r1, r1, r1",		"{nop}"),
 T(A(1, 1, 2), "and     r1, r1, r2",		"{and    r1, r2}"),
 T(A(1, 2, 0), "and     r1, r2, r0",		"{clr    r1}"),
 T(A(1, 2, 1), "and     r1, r2, r1",		"{and    r1, r2}"),
 T(A(1, 2, 2), "and     r1, r2, r2",		"{mov    r1, r2}"),
 T(A(1, 2, 3), "and     r1, r2, r3",		"{and    r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'4400, d, s1, s2)
 T(A(0, 0, 0), "and.c   r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "and.c   r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "and.c   r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "and.c   r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "and.c   r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "and.c   r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "and.c   r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "and.c   r1, r0, r1",		"{clr    r1}"),
 T(A(1, 0, 2), "and.c   r1, r0, r2",		"{clr    r1}"),
 T(A(1, 1, 0), "and.c   r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "and.c   r1, r1, r1",		"{clr    r1}"),
 T(A(1, 1, 2), "and.c   r1, r1, r2",		"{and    r1, ~r2}"),
 T(A(1, 2, 0), "and.c   r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "and.c   r1, r2, r1",		"{and    r1, r2, ~r1}"),
 T(A(1, 2, 2), "and.c   r1, r2, r2",		"{clr    r1}"),
 T(A(1, 2, 3), "and.c   r1, r2, r3",		"{and    r1, r2, ~r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'5000, d, s1, s2)
 T(A(0, 0, 0), "xor     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "xor     r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "xor     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "xor     r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "xor     r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "xor     r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "xor     r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "xor     r1, r0, r1",		"{nop}"),
 T(A(1, 0, 2), "xor     r1, r0, r2",		"{mov    r1, r2}"),
 T(A(1, 1, 0), "xor     r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "xor     r1, r1, r1",		"{clr    r1}"),
 T(A(1, 1, 2), "xor     r1, r1, r2",		"{xor    r1, r2}"),
 T(A(1, 2, 0), "xor     r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "xor     r1, r2, r1",		"{xor    r1, r2}"),
 T(A(1, 2, 2), "xor     r1, r2, r2",		"{clr    r1}"),
 T(A(1, 2, 3), "xor     r1, r2, r3",		"{xor    r1, r2, r3}"),
#undef A

 // 独自ニーモニック側の XOR rD,rS1,~rS2 はもうちょっと演算したい
#define A(d, s1, s2)	M(0xf400'5400, d, s1, s2)
 T(A(0, 0, 0), "xor.c   r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "xor.c   r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "xor.c   r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "xor.c   r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "xor.c   r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "xor.c   r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "xor.c   r1, r0, r0",		"{mov    r1, #0xffffffff}"),
 T(A(1, 0, 1), "xor.c   r1, r0, r1",		"{not    r1}"),
 T(A(1, 0, 2), "xor.c   r1, r0, r2",		"{not    r1, r2}"),
 T(A(1, 1, 0), "xor.c   r1, r1, r0",		"{not    r1}"),
 T(A(1, 1, 1), "xor.c   r1, r1, r1",		"{mov    r1, #0xffffffff}"),
 T(A(1, 1, 2), "xor.c   r1, r1, r2",		"{xor    r1, ~r2}"),
 T(A(1, 2, 0), "xor.c   r1, r2, r0",		"{not    r1, r2}"),
 T(A(1, 2, 1), "xor.c   r1, r2, r1",		"{xor    r1, r2, ~r1}"),
 T(A(1, 2, 2), "xor.c   r1, r2, r2",		"{mov    r1, #0xffffffff}"),
 T(A(1, 2, 3), "xor.c   r1, r2, r3",		"{xor    r1, r2, ~r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'5800, d, s1, s2)
 T(A(0, 0, 0), "or      r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "or      r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "or      r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "or      r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "or      r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "or      r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "or      r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "or      r1, r0, r1",		"{nop}"),
 T(A(1, 0, 2), "or      r1, r0, r2",		"{mov    r1, r2}"),
 T(A(1, 1, 0), "or      r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "or      r1, r1, r1",		"{nop}"),
 T(A(1, 1, 2), "or      r1, r1, r2",		"{or     r1, r2}"),
 T(A(1, 2, 0), "or      r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "or      r1, r2, r1",		"{or     r1, r2}"),
 T(A(1, 2, 2), "or      r1, r2, r2",		"{mov    r1, r2}"),
 T(A(1, 2, 3), "or      r1, r2, r3",		"{or     r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'5c00, d, s1, s2)
 T(A(0, 0, 0), "or.c    r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "or.c    r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "or.c    r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "or.c    r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "or.c    r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "or.c    r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "or.c    r1, r0, r0",		"{mov    r1, #0xffffffff}"),
 T(A(1, 0, 1), "or.c    r1, r0, r1",		"{not    r1}"),
 T(A(1, 0, 2), "or.c    r1, r0, r2",		"{not    r1, r2}"),
 T(A(1, 1, 0), "or.c    r1, r1, r0",		"{mov    r1, #0xffffffff}"),
 T(A(1, 1, 1), "or.c    r1, r1, r1",		"{mov    r1, #0xffffffff}"),
 T(A(1, 1, 2), "or.c    r1, r1, r2",		"{or     r1, ~r2}"),
 T(A(1, 2, 0), "or.c    r1, r2, r0",		"{mov    r1, #0xffffffff}"),
 T(A(1, 2, 1), "or.c    r1, r2, r1",		"{or     r1, r2, ~r1}"),
 T(A(1, 2, 2), "or.c    r1, r2, r2",		"{mov    r1, #0xffffffff}"),
 T(A(1, 2, 3), "or.c    r1, r2, r3",		"{or     r1, r2, ~r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'6000, d, s1, s2)
 T(A(0, 0, 0), "addu    r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "addu    r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "addu    r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "addu    r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "addu    r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "addu    r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "addu    r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "addu    r1, r0, r1",		"{nop}"),
 T(A(1, 0, 2), "addu    r1, r0, r2",		"{mov    r1, r2}"),
 T(A(1, 1, 0), "addu    r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "addu    r1, r1, r1",		"{addu   r1, r1}"),
 T(A(1, 1, 2), "addu    r1, r1, r2",		"{addu   r1, r2}"),
 T(A(1, 2, 0), "addu    r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "addu    r1, r2, r1",		"{addu   r1, r2}"),
 T(A(1, 2, 2), "addu    r1, r2, r2",		"{addu   r1, r2, r2}"),
 T(A(1, 2, 3), "addu    r1, r2, r3",		"{addu   r1, r2, r3}"),
#undef A

 // Carry In/Out を含むやつは 2オペランドへの省略のみ (.coだけ代表でテスト)
#define A(d, s1, s2)	M(0xf400'6100, d, s1, s2)
 T(A(0, 0, 0), "addu.co r0, r0, r0",		"{addu.co r0, r0}"),
 T(A(0, 0, 1), "addu.co r0, r0, r1",		"{addu.co r0, r1}"),
 T(A(0, 1, 0), "addu.co r0, r1, r0",		"{addu.co r0, r1, r0}"),
 T(A(0, 1, 1), "addu.co r0, r1, r1",		"{addu.co r0, r1, r1}"),
 T(A(0, 1, 2), "addu.co r0, r1, r2",		"{addu.co r0, r1, r2}"),
 T(A(0, 2, 1), "addu.co r0, r2, r1",		"{addu.co r0, r2, r1}"),
 T(A(1, 0, 0), "addu.co r1, r0, r0",		"{addu.co r1, r0, r0}"),
 T(A(1, 0, 1), "addu.co r1, r0, r1",		"{addu.co r1, r0, r1}"),
 T(A(1, 0, 2), "addu.co r1, r0, r2",		"{addu.co r1, r0, r2}"),
 T(A(1, 1, 0), "addu.co r1, r1, r0",		"{addu.co r1, r0}"),
 T(A(1, 1, 1), "addu.co r1, r1, r1",		"{addu.co r1, r1}"),
 T(A(1, 1, 2), "addu.co r1, r1, r2",		"{addu.co r1, r2}"),
 T(A(1, 2, 0), "addu.co r1, r2, r0",		"{addu.co r1, r2, r0}"),
 T(A(1, 2, 1), "addu.co r1, r2, r1",		"{addu.co r1, r2, r1}"),
 T(A(1, 2, 2), "addu.co r1, r2, r2",		"{addu.co r1, r2, r2}"),
 T(A(1, 2, 3), "addu.co r1, r2, r3",		"{addu.co r1, r2, r3}"),
#undef A
 T(0xf6326201, "addu.ci r17,r18,r1",		"{addu.ci r17,r18,r1}"),
 T(0xf6326301, "addu.cio r17,r18,r1",		"{addu.cio r17,r18,r1}"),

#define A(d, s1, s2)	M(0xf400'6400, d, s1, s2)
 T(A(0, 0, 0), "subu    r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "subu    r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "subu    r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "subu    r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "subu    r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "subu    r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "subu    r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "subu    r1, r0, r1",		"{subu   r1, r0, r1}"),
 T(A(1, 0, 2), "subu    r1, r0, r2",		"{subu   r1, r0, r2}"),
 T(A(1, 1, 0), "subu    r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "subu    r1, r1, r1",		"{clr    r1}"),
 T(A(1, 1, 2), "subu    r1, r1, r2",		"{subu   r1, r2}"),
 T(A(1, 2, 0), "subu    r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "subu    r1, r2, r1",		"{subu   r1, r2, r1}"),
 T(A(1, 2, 2), "subu    r1, r2, r2",		"{clr    r1}"),
 T(A(1, 2, 3), "subu    r1, r2, r3",		"{subu   r1, r2, r3}"),
#undef A

 // Carry In/Out を含むやつは 2オペランドへの省略のみ (.coだけ代表でテスト)
#define A(d, s1, s2)	M(0xf400'6500, d, s1, s2)
 T(A(0, 0, 0), "subu.co r0, r0, r0",		"{subu.co r0, r0}"),
 T(A(0, 0, 1), "subu.co r0, r0, r1",		"{subu.co r0, r1}"),
 T(A(0, 1, 0), "subu.co r0, r1, r0",		"{subu.co r0, r1, r0}"),
 T(A(0, 1, 1), "subu.co r0, r1, r1",		"{subu.co r0, r1, r1}"),
 T(A(0, 1, 2), "subu.co r0, r1, r2",		"{subu.co r0, r1, r2}"),
 T(A(0, 2, 1), "subu.co r0, r2, r1",		"{subu.co r0, r2, r1}"),
 T(A(1, 0, 0), "subu.co r1, r0, r0",		"{subu.co r1, r0, r0}"),
 T(A(1, 0, 1), "subu.co r1, r0, r1",		"{subu.co r1, r0, r1}"),
 T(A(1, 0, 2), "subu.co r1, r0, r2",		"{subu.co r1, r0, r2}"),
 T(A(1, 1, 0), "subu.co r1, r1, r0",		"{subu.co r1, r0}"),
 T(A(1, 1, 1), "subu.co r1, r1, r1",		"{subu.co r1, r1}"),
 T(A(1, 1, 2), "subu.co r1, r1, r2",		"{subu.co r1, r2}"),
 T(A(1, 2, 0), "subu.co r1, r2, r0",		"{subu.co r1, r2, r0}"),
 T(A(1, 2, 1), "subu.co r1, r2, r1",		"{subu.co r1, r2, r1}"),
 T(A(1, 2, 2), "subu.co r1, r2, r2",		"{subu.co r1, r2, r2}"),
 T(A(1, 2, 3), "subu.co r1, r2, r3",		"{subu.co r1, r2, r3}"),
#undef A
 T(0xf6326601, "subu.ci r17,r18,r1",		"{subu.ci r17,r18,r1}"),
 T(0xf6326701, "subu.cio r17,r18,r1",		"{subu.cio r17,r18,r1}"),

#define A(d, s1, s2)	M(0xf400'6800, d, s1, s2)
 T(A(0, 0, 0), "divu    r0, r0, r0",		"{divu   r0, r0}"),
 T(A(0, 0, 1), "divu    r0, r0, r1",		"{divu   r0, r1}"),
 T(A(0, 1, 0), "divu    r0, r1, r0",		"{divu   r0, r1, r0}"),
 T(A(0, 1, 1), "divu    r0, r1, r1",		"{divu   r0, r1, r1}"),
 T(A(0, 1, 2), "divu    r0, r1, r2",		"{divu   r0, r1, r2}"),
 T(A(0, 2, 1), "divu    r0, r2, r1",		"{divu   r0, r2, r1}"),
 T(A(1, 0, 0), "divu    r1, r0, r0",		"{divu   r1, r0, r0}"),
 T(A(1, 0, 1), "divu    r1, r0, r1",		"{divu   r1, r0, r1}"),
 T(A(1, 0, 2), "divu    r1, r0, r2",		"{divu   r1, r0, r2}"),
 T(A(1, 1, 0), "divu    r1, r1, r0",		"{divu   r1, r0}"),
 T(A(1, 1, 1), "divu    r1, r1, r1",		"{divu   r1, r1}"),
 T(A(1, 1, 2), "divu    r1, r1, r2",		"{divu   r1, r2}"),
 T(A(1, 2, 0), "divu    r1, r2, r0",		"{divu   r1, r2, r0}"),
 T(A(1, 2, 1), "divu    r1, r2, r1",		"{divu   r1, r2, r1}"),
 T(A(1, 2, 2), "divu    r1, r2, r2",		"{divu   r1, r2, r2}"),
 T(A(1, 2, 3), "divu    r1, r2, r3",		"{divu   r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'6c00, d, s1, s2)
 T(A(0, 0, 0), "mul     r0, r0, r0",		"{mul    r0, r0}"),
 T(A(0, 0, 1), "mul     r0, r0, r1",		"{mul    r0, r1}"),
 T(A(0, 1, 0), "mul     r0, r1, r0",		"{mul    r0, r1, r0}"),
 T(A(0, 1, 1), "mul     r0, r1, r1",		"{mul    r0, r1, r1}"),
 T(A(0, 1, 2), "mul     r0, r1, r2",		"{mul    r0, r1, r2}"),
 T(A(0, 2, 1), "mul     r0, r2, r1",		"{mul    r0, r2, r1}"),
 T(A(1, 0, 0), "mul     r1, r0, r0",		"{mul    r1, r0, r0}"),
 T(A(1, 0, 1), "mul     r1, r0, r1",		"{mul    r1, r0, r1}"),
 T(A(1, 0, 2), "mul     r1, r0, r2",		"{mul    r1, r0, r2}"),
 T(A(1, 1, 0), "mul     r1, r1, r0",		"{mul    r1, r0}"),
 T(A(1, 1, 1), "mul     r1, r1, r1",		"{mul    r1, r1}"),
 T(A(1, 1, 2), "mul     r1, r1, r2",		"{mul    r1, r2}"),
 T(A(1, 2, 0), "mul     r1, r2, r0",		"{mul    r1, r2, r0}"),
 T(A(1, 2, 1), "mul     r1, r2, r1",		"{mul    r1, r2, r1}"),
 T(A(1, 2, 2), "mul     r1, r2, r2",		"{mul    r1, r2, r2}"),
 T(A(1, 2, 3), "mul     r1, r2, r3",		"{mul    r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'7000, d, s1, s2)
 T(A(0, 0, 0), "add     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "add     r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "add     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "add     r0, r1, r1",		"{adds   r0, r1, r1}"),
 T(A(0, 1, 2), "add     r0, r1, r2",		"{adds   r0, r1, r2}"),
 T(A(0, 2, 1), "add     r0, r2, r1",		"{adds   r0, r2, r1}"),
 T(A(1, 0, 0), "add     r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "add     r1, r0, r1",		"{nop}"),
 T(A(1, 0, 2), "add     r1, r0, r2",		"{mov    r1, r2}"),
 T(A(1, 1, 0), "add     r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "add     r1, r1, r1",		"{adds   r1, r1}"),
 T(A(1, 1, 2), "add     r1, r1, r2",		"{adds   r1, r2}"),
 T(A(1, 2, 0), "add     r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "add     r1, r2, r1",		"{adds   r1, r2, r1}"),
 T(A(1, 2, 2), "add     r1, r2, r2",		"{adds   r1, r2, r2}"),
 T(A(1, 2, 3), "add     r1, r2, r3",		"{adds   r1, r2, r3}"),
#undef A

 // Carry In/Out を含むやつは 2オペランドへの省略のみ (.coだけ代表でテスト)
#define A(d, s1, s2)	M(0xf400'7100, d, s1, s2)
 T(A(0, 0, 0), "add.co  r0, r0, r0",		"{adds.co r0, r0}"),
 T(A(0, 0, 1), "add.co  r0, r0, r1",		"{adds.co r0, r1}"),
 T(A(0, 1, 0), "add.co  r0, r1, r0",		"{adds.co r0, r1, r0}"),
 T(A(0, 1, 1), "add.co  r0, r1, r1",		"{adds.co r0, r1, r1}"),
 T(A(0, 1, 2), "add.co  r0, r1, r2",		"{adds.co r0, r1, r2}"),
 T(A(0, 2, 1), "add.co  r0, r2, r1",		"{adds.co r0, r2, r1}"),
 T(A(1, 0, 0), "add.co  r1, r0, r0",		"{adds.co r1, r0, r0}"),
 T(A(1, 0, 1), "add.co  r1, r0, r1",		"{adds.co r1, r0, r1}"),
 T(A(1, 0, 2), "add.co  r1, r0, r2",		"{adds.co r1, r0, r2}"),
 T(A(1, 1, 0), "add.co  r1, r1, r0",		"{adds.co r1, r0}"),
 T(A(1, 1, 1), "add.co  r1, r1, r1",		"{adds.co r1, r1}"),
 T(A(1, 1, 2), "add.co  r1, r1, r2",		"{adds.co r1, r2}"),
 T(A(1, 2, 0), "add.co  r1, r2, r0",		"{adds.co r1, r2, r0}"),
 T(A(1, 2, 1), "add.co  r1, r2, r1",		"{adds.co r1, r2, r1}"),
 T(A(1, 2, 2), "add.co  r1, r2, r2",		"{adds.co r1, r2, r2}"),
 T(A(1, 2, 3), "add.co  r1, r2, r3",		"{adds.co r1, r2, r3}"),
#undef A
 T(0xf6327201, "add.ci  r17,r18,r1",		"{adds.ci r17,r18,r1}"),
 T(0xf6327301, "add.cio r17,r18,r1",		"{adds.cio r17,r18,r1}"),

#define A(d, s1, s2)	M(0xf400'7400, d, s1, s2)
 T(A(0, 0, 0), "sub     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "sub     r0, r0, r1",		"{subs   r0, r1}"),
 T(A(0, 1, 0), "sub     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "sub     r0, r1, r1",		"{subs   r0, r1, r1}"),
 T(A(0, 1, 2), "sub     r0, r1, r2",		"{subs   r0, r1, r2}"),
 T(A(0, 2, 1), "sub     r0, r2, r1",		"{subs   r0, r2, r1}"),
 T(A(1, 0, 0), "sub     r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "sub     r1, r0, r1",		"{subs   r1, r0, r1}"),
 T(A(1, 0, 2), "sub     r1, r0, r2",		"{subs   r1, r0, r2}"),
 T(A(1, 1, 0), "sub     r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "sub     r1, r1, r1",		"{subs   r1, r1}"),
 T(A(1, 1, 2), "sub     r1, r1, r2",		"{subs   r1, r2}"),
 T(A(1, 2, 0), "sub     r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "sub     r1, r2, r1",		"{subs   r1, r2, r1}"),
 T(A(1, 2, 2), "sub     r1, r2, r2",		"{subs   r1, r2, r2}"),
 T(A(1, 2, 3), "sub     r1, r2, r3",		"{subs   r1, r2, r3}"),
#undef A

 // Carry In/Out を含むやつは 2オペランドへの省略のみ (.coだけ代表でテスト)
#define A(d, s1, s2)	M(0xf400'7500, d, s1, s2)
 T(A(0, 0, 0), "sub.co  r0, r0, r0",		"{subs.co r0, r0}"),
 T(A(0, 0, 1), "sub.co  r0, r0, r1",		"{subs.co r0, r1}"),
 T(A(0, 1, 0), "sub.co  r0, r1, r0",		"{subs.co r0, r1, r0}"),
 T(A(0, 1, 1), "sub.co  r0, r1, r1",		"{subs.co r0, r1, r1}"),
 T(A(0, 1, 2), "sub.co  r0, r1, r2",		"{subs.co r0, r1, r2}"),
 T(A(0, 2, 1), "sub.co  r0, r2, r1",		"{subs.co r0, r2, r1}"),
 T(A(1, 0, 0), "sub.co  r1, r0, r0",		"{subs.co r1, r0, r0}"),
 T(A(1, 0, 1), "sub.co  r1, r0, r1",		"{subs.co r1, r0, r1}"),
 T(A(1, 0, 2), "sub.co  r1, r0, r2",		"{subs.co r1, r0, r2}"),
 T(A(1, 1, 0), "sub.co  r1, r1, r0",		"{subs.co r1, r0}"),
 T(A(1, 1, 1), "sub.co  r1, r1, r1",		"{subs.co r1, r1}"),
 T(A(1, 1, 2), "sub.co  r1, r1, r2",		"{subs.co r1, r2}"),
 T(A(1, 2, 0), "sub.co  r1, r2, r0",		"{subs.co r1, r2, r0}"),
 T(A(1, 2, 1), "sub.co  r1, r2, r1",		"{subs.co r1, r2, r1}"),
 T(A(1, 2, 2), "sub.co  r1, r2, r2",		"{subs.co r1, r2, r2}"),
 T(A(1, 2, 3), "sub.co  r1, r2, r3",		"{subs.co r1, r2, r3}"),
#undef A
 T(0xf6327601, "sub.ci  r17,r18,r1",		"{subs.ci r17,r18,r1}"),
 T(0xf6327701, "sub.cio r17,r18,r1",		"{subs.cio r17,r18,r1}"),

#define A(d, s1, s2)	M(0xf400'7800, d, s1, s2)
 T(A(0, 0, 0), "div     r0, r0, r0",		"{div    r0, r0}"),
 T(A(0, 0, 1), "div     r0, r0, r1",		"{div    r0, r1}"),
 T(A(0, 1, 0), "div     r0, r1, r0",		"{div    r0, r1, r0}"),
 T(A(0, 1, 1), "div     r0, r1, r1",		"{div    r0, r1, r1}"),
 T(A(0, 1, 2), "div     r0, r1, r2",		"{div    r0, r1, r2}"),
 T(A(0, 2, 1), "div     r0, r2, r1",		"{div    r0, r2, r1}"),
 T(A(1, 0, 0), "div     r1, r0, r0",		"{div    r1, r0, r0}"),
 T(A(1, 0, 1), "div     r1, r0, r1",		"{div    r1, r0, r1}"),
 T(A(1, 0, 2), "div     r1, r0, r2",		"{div    r1, r0, r2}"),
 T(A(1, 1, 0), "div     r1, r1, r0",		"{div    r1, r0}"),
 T(A(1, 1, 1), "div     r1, r1, r1",		"{div    r1, r1}"),
 T(A(1, 1, 2), "div     r1, r1, r2",		"{div    r1, r2}"),
 T(A(1, 2, 0), "div     r1, r2, r0",		"{div    r1, r2, r0}"),
 T(A(1, 2, 1), "div     r1, r2, r1",		"{div    r1, r2, r1}"),
 T(A(1, 2, 2), "div     r1, r2, r2",		"{div    r1, r2, r2}"),
 T(A(1, 2, 3), "div     r1, r2, r3",		"{div    r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'7c00, d, s1, s2)
 T(A(0, 0, 0), "cmp     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "cmp     r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "cmp     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "cmp     r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "cmp     r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "cmp     r0, r2, r1",		"{nop}"),
 O(A(1, 0, 0), "cmp     r1, r0, r0"),
 O(A(1, 0, 1), "cmp     r1, r0, r1"),
 O(A(1, 0, 2), "cmp     r1, r0, r2"),
 O(A(1, 1, 0), "cmp     r1, r1, r0"),
 O(A(1, 1, 1), "cmp     r1, r1, r1"),
 O(A(1, 1, 2), "cmp     r1, r1, r2"),
 O(A(1, 2, 0), "cmp     r1, r2, r0"),
 O(A(1, 2, 1), "cmp     r1, r2, r1"),
 O(A(1, 2, 2), "cmp     r1, r2, r2"),
 O(A(1, 2, 3), "cmp     r1, r2, r3"),
#undef A

#define A(d, s1, s2)	M(0xf400'8000, d, s1, s2)
 T(A(0, 0, 0), "clr     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "clr     r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "clr     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "clr     r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "clr     r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "clr     r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "clr     r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "clr     r1, r0, r1",		"{clr    r1}"),
 T(A(1, 0, 2), "clr     r1, r0, r2",		"{clr    r1}"),
 T(A(1, 1, 0), "clr     r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "clr     r1, r1, r1",		"{bfclr  r1, r1}"),
 T(A(1, 1, 2), "clr     r1, r1, r2",		"{bfclr  r1, r2}"),
 T(A(1, 2, 0), "clr     r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "clr     r1, r2, r1",		"{bfclr  r1, r2, r1}"),
 T(A(1, 2, 2), "clr     r1, r2, r2",		"{bfclr  r1, r2, r2}"),
 T(A(1, 2, 3), "clr     r1, r2, r3",		"{bfclr  r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'8800, d, s1, s2)
 T(A(0, 0, 0), "set     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "set     r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "set     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "set     r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "set     r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "set     r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "set     r1, r0, r0",		"{mov    r1, #0xffffffff}"),
 T(A(1, 0, 1), "set     r1, r0, r1",		"{bfset  r1, r0, r1}"),
 T(A(1, 0, 2), "set     r1, r0, r2",		"{bfset  r1, r0, r2}"),
 T(A(1, 1, 0), "set     r1, r1, r0",		"{mov    r1, #0xffffffff}"),
 T(A(1, 1, 1), "set     r1, r1, r1",		"{bfset  r1, r1}"),
 T(A(1, 1, 2), "set     r1, r1, r2",		"{bfset  r1, r2}"),
 T(A(1, 2, 0), "set     r1, r2, r0",		"{mov    r1, #0xffffffff}"),
 T(A(1, 2, 1), "set     r1, r2, r1",		"{bfset  r1, r2, r1}"),
 T(A(1, 2, 2), "set     r1, r2, r2",		"{bfset  r1, r2, r2}"),
 T(A(1, 2, 3), "set     r1, r2, r3",		"{bfset  r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'9000, d, s1, s2)
 T(A(0, 0, 0), "ext     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "ext     r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "ext     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "ext     r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "ext     r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "ext     r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "ext     r1, r0, r0",		"{mov    r1, r0}"),
 T(A(1, 0, 1), "ext     r1, r0, r1",		"{bfexts r1, r0, r1}"),
 T(A(1, 0, 2), "ext     r1, r0, r2",		"{bfexts r1, r0, r2}"),
 T(A(1, 1, 0), "ext     r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "ext     r1, r1, r1",		"{bfexts r1, r1}"),
 T(A(1, 1, 2), "ext     r1, r1, r2",		"{bfexts r1, r2}"),
 T(A(1, 2, 0), "ext     r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "ext     r1, r2, r1",		"{bfexts r1, r2, r1}"),
 T(A(1, 2, 2), "ext     r1, r2, r2",		"{bfexts r1, r2, r2}"),
 T(A(1, 2, 3), "ext     r1, r2, r3",		"{bfexts r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'9800, d, s1, s2)
 T(A(0, 0, 0), "extu    r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "extu    r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "extu    r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "extu    r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "extu    r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "extu    r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "extu    r1, r0, r0",		"{mov    r1, r0}"),
 T(A(1, 0, 1), "extu    r1, r0, r1",		"{bfextu r1, r0, r1}"),
 T(A(1, 0, 2), "extu    r1, r0, r2",		"{bfextu r1, r0, r2}"),
 T(A(1, 1, 0), "extu    r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "extu    r1, r1, r1",		"{bfextu r1, r1}"),
 T(A(1, 1, 2), "extu    r1, r1, r2",		"{bfextu r1, r2}"),
 T(A(1, 2, 0), "extu    r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "extu    r1, r2, r1",		"{bfextu r1, r2, r1}"),
 T(A(1, 2, 2), "extu    r1, r2, r2",		"{bfextu r1, r2, r2}"),
 T(A(1, 2, 3), "extu    r1, r2, r3",		"{bfextu r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'a000, d, s1, s2)
 T(A(0, 0, 0), "mak     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "mak     r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "mak     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "mak     r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "mak     r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "mak     r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "mak     r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "mak     r1, r0, r1",		"{clr    r1}"),
 T(A(1, 0, 2), "mak     r1, r0, r2",		"{clr    r1}"),
 T(A(1, 1, 0), "mak     r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "mak     r1, r1, r1",		"{bfmak  r1, r1}"),
 T(A(1, 1, 2), "mak     r1, r1, r2",		"{bfmak  r1, r2}"),
 T(A(1, 2, 0), "mak     r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "mak     r1, r2, r1",		"{bfmak  r1, r2, r1}"),
 T(A(1, 2, 2), "mak     r1, r2, r2",		"{bfmak  r1, r2, r2}"),
 T(A(1, 2, 3), "mak     r1, r2, r3",		"{bfmak  r1, r2, r3}"),
#undef A

#define A(d, s1, s2)	M(0xf400'a800, d, s1, s2)
 T(A(0, 0, 0), "rot     r0, r0, r0",		"{nop}"),
 T(A(0, 0, 1), "rot     r0, r0, r1",		"{nop}"),
 T(A(0, 1, 0), "rot     r0, r1, r0",		"{nop}"),
 T(A(0, 1, 1), "rot     r0, r1, r1",		"{nop}"),
 T(A(0, 1, 2), "rot     r0, r1, r2",		"{nop}"),
 T(A(0, 2, 1), "rot     r0, r2, r1",		"{nop}"),
 T(A(1, 0, 0), "rot     r1, r0, r0",		"{clr    r1}"),
 T(A(1, 0, 1), "rot     r1, r0, r1",		"{clr    r1}"),
 T(A(1, 0, 2), "rot     r1, r0, r2",		"{clr    r1}"),
 T(A(1, 1, 0), "rot     r1, r1, r0",		"{nop}"),
 T(A(1, 1, 1), "rot     r1, r1, r1",		"{ror    r1, r1}"),
 T(A(1, 1, 2), "rot     r1, r1, r2",		"{ror    r1, r2}"),
 T(A(1, 2, 0), "rot     r1, r2, r0",		"{mov    r1, r2}"),
 T(A(1, 2, 1), "rot     r1, r2, r1",		"{ror    r1, r2, r1}"),
 T(A(1, 2, 2), "rot     r1, r2, r2",		"{ror    r1, r2, r2}"),
 T(A(1, 2, 3), "rot     r1, r2, r3",		"{ror    r1, r2, r3}"),
#undef A

 O(0xf400c011, "jmp     r17"),
 O(0xf400c411, "jmp.n   r17"),
 O(0xf400c811, "jsr     r17"),
 O(0xf400cc11, "jsr.n   r17"),

#define A(d, s2)		M(0xf400'e800, d, 0, s2)
 T(A(0, 0),    "ff1     r0, r0",			"{nop}"),
 T(A(0, 1),    "ff1     r0, r1",			"{nop}"),
 T(A(1, 0),    "ff1     r1, r0",			"{mov    r1, #32}"),
 T(A(1, 1),    "ff1     r1, r1",			"{ff1    r1, r1}"),
 T(A(1, 2),    "ff1     r1, r2",			"{ff1    r1, r2}"),
#undef A
#define A(d, s2)		M(0xf400'ec00, d, 0, s2)
 T(A(0, 0),    "ff0     r0, r0",			"{nop}"),
 T(A(0, 1),    "ff0     r0, r1",			"{nop}"),
 T(A(1, 0),    "ff0     r1, r0",			"{clr    r1}"),
 T(A(1, 1),    "ff0     r1, r1",			"{ff0    r1, r1}"),
 T(A(1, 2),    "ff0     r1, r2",			"{ff0    r1, r2}"),
#undef A

 O(0xf400fc00, "rte"),
 O(0xf411f801, "tbnd    r17,r1"),
 O(0xf8118765, "tbnd    r17,#0x8765"),
};

static uint8 ram[1024];
static int failed;

#include "test_debugger_memory.cpp"

// リンカを通すためのダミー
DisasmLine::~DisasmLine() { }
DebuggerMD::~DebuggerMD() { }
uint32 DebuggerMD::GetNextPC() { return 0; }
void DebuggerMD::PrintExceptionFrame(FILE *, busaddr) { }

int
main(int ac, char *av[])
{
	busaddr saddr;

	m88100disasm::use_altname = 1;

	// DebuggerMD (の継承クラス)を用意するのは芋づる式に大変なので、
	// 中でアクセスする変数だけ強引に用意する。
	DebuggerMD *md = (DebuggerMD *)calloc(1, sizeof(DebuggerMD));
	md->inst_bytes = 4;

	for (int i = 0; i < countof(table); i++) {
		int line = table[i].line;
		std::string expstd = table[i].expstd;
		std::string expalt = table[i].expalt;
		uint32 inst = table[i].inst;

		// エラー表示用
		std::string inst_str = string_format("%d: $%08x", line, inst);

		// 全体を初期化
		memset(ram, 0xdd, sizeof(ram));
		// 100番地に命令列を書き込む
		*(uint16 *)(ram + 0x100) = inst >> 16;
		*(uint16 *)(ram + 0x102) = inst & 0xffff;
		// 検査
		saddr = busaddr(0x100);
		m88100disasm dis;
		DebuggerMemoryStream mem(NULL, saddr);
		dis.Exec(&mem);
		// 照合
		if (dis.text != expstd) {
			printf("%s std expects \"%s\" but \"%s\"\n", inst_str.c_str(),
				expstd.c_str(), dis.text.c_str());
			failed++;
			continue;
		}
		uint32 expected_len = 4;
		if (dis.bin.size() != expected_len) {
			printf("%s std expects len=$%x but $%x\n", inst_str.c_str(),
				expected_len, (uint)dis.bin.size());
			failed++;
			continue;
		}

		// 照合(別名)
		if (dis.alttext != expalt) {
			printf("%s alt expects \"%s\" but \"%s\"\n", inst_str.c_str(),
				expalt.c_str(), dis.alttext.c_str());
			failed++;
			continue;
		}
	}

	int total = countof(table);
	printf("%d tests, %d success", total, total - failed);
	if (failed > 0) {
		printf(", %d failed", failed);
	}
	printf("\n");
	return 0;
}
