//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// VM (LUNA)
//

#pragma once

#include "vm.h"

class VM_LUNA : public VM
{
	using inherited = VM;
 protected:
	explicit VM_LUNA(const char *name_);
 public:
	~VM_LUNA() override;

 protected:
	std::unique_ptr<Device> pDipsw {};
	std::unique_ptr<Device> pLCD {};
	std::unique_ptr<Device> pMPU64180 {};
	std::unique_ptr<Device> pXPbus {};
};

class VM_LUNA1 final : public VM_LUNA
{
	using inherited = VM_LUNA;
 public:
	VM_LUNA1();
	~VM_LUNA1() override;

 private:
	std::unique_ptr<Device> pSSG {};
};

class VM_LUNA88K final : public VM_LUNA
{
	using inherited = VM_LUNA;
 public:
	VM_LUNA88K();
	~VM_LUNA88K() override;
};
