/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __RCX_Target_h
#define __RCX_Target_h

typedef enum
{
	kRCX_RCXTarget = 0,	// original RCX
	kRCX_CMTarget,		// CyberMaster
	kRCX_ScoutTarget,	// Scout
	kRCX_RCX2Target		// RCX 2.0
} RCX_TargetType;


class RCX_Target
{
public:
	RCX_TargetType	fType;
	const char*		fName;
	const char*		fDefine;
	const char*		fDefValue;
	int				fMaxTasks;
	int				fMaxSubs;
	int				fMaxGlobalVars;
	int				fMaxTaskVars;
	bool			fResources;
	bool			fEvents;
	bool			fArrays;
	
	bool			SourceWritable(int source) const;
};


extern const RCX_Target *getTarget(RCX_TargetType type);


#endif
