/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleCollections;
import it.unimi.dsi.fastutil.doubles.DoubleIterable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public final class DoubleCollections {
    private DoubleCollections() {
    }

    public static DoubleCollection synchronize(DoubleCollection c) {
        return new SynchronizedCollection(c);
    }

    public static DoubleCollection synchronize(DoubleCollection c, Object sync) {
        return new SynchronizedCollection(c, sync);
    }

    public static DoubleCollection unmodifiable(DoubleCollection c) {
        return new UnmodifiableCollection(c);
    }

    public static DoubleCollection asCollection(DoubleIterable iterable) {
        if (iterable instanceof DoubleCollection) {
            return (DoubleCollection)iterable;
        }
        return new IterableCollection(iterable);
    }

    static class SizeDecreasingSupplier<C extends DoubleCollection>
    implements Supplier<C> {
        static final int RECOMMENDED_MIN_SIZE = 8;
        final AtomicInteger suppliedCount = new AtomicInteger(0);
        final int expectedFinalSize;
        final IntFunction<C> builder;

        SizeDecreasingSupplier(int expectedFinalSize, IntFunction<C> builder) {
            this.expectedFinalSize = expectedFinalSize;
            this.builder = builder;
        }

        @Override
        public C get() {
            int expectedNeededNextSize = 1 + (this.expectedFinalSize - 1) / this.suppliedCount.incrementAndGet();
            if (expectedNeededNextSize < 0) {
                expectedNeededNextSize = 8;
            }
            return (C)((DoubleCollection)this.builder.apply(expectedNeededNextSize));
        }
    }
}

