/*
 * ntesla - a program for designing Tesla Coils
 * 
 * Copyright (C) 1997  Steven A. Falco
 * 
 * Email contact: sfalco@worldnet.att.net
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define EXTERN extern
#include "protos.h"

double
gauge_to_inch(int gauge)
{
	return .324845 * exp(gauge / -8.625);
}

/* Only used for metric input to estimate gauge */
int
inch_to_gauge(double dia)
{
	return (int)(-8.625 * log(dia / .324845));
}

double
inch_to_ohm(double dia)
{
	return 1.0 / ((((dia / 2) * (dia / 2)) * PI) * 1473232.41);
}
