// Portable Arcade Game writtened by Pancake
//
//

#ifndef PREFIX
#error PREFIX not defined 
#else
#define LEVEL_PATH PREFIX"/share/pag/levels/"
#endif

#define MAX_X 80
#define MAX_Y 23
#define MAX_OBJ 30

#include <ncurses.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "version.h"
#include "structs.h"
#include "functions.h"
#include "pag.h"

int show_screen (array screen, struct user *user, struct obj *obj)
{
	int i,i2;

	for(i=0; i<MAX_Y; i++)
	for(i2=0; i2<MAX_X; i2++)
	if ( screen[i][i2]!=0 )
	{
		move(i,i2);
		addch( screen[i][i2] );
	}

	for(i=0;i<user->num_obj;i++)
	for (i2=0; i2<obj[i].len; i2++)
	{
		if (obj[i].visible == 0) continue;
		move(obj[i].y,obj[i].x+i2);
		addch(obj[i].name);
	}
	if (user->y>=MAX_Y-1)
	{
		return -1;
	}

	move(user->y,user->x);
	addch(USER);
	return 0;
}


     
int show_free(array screen,int y, int x, int l, int u,
              struct user *user, struct obj *obj )
{
	//int u; // s'agafa com a argument, especifica si volem
	// que miri tots els objectes (-1), o noms un. (XAPUES S.A.)
	char b=0;
	int i,i2;
	int ret=-1; // 1 - lliure.
	// 0 - pas barrat.

	while ((ret==-1)&&(l))
	{
		l--;
		b = screen[y][x+l];

		switch(b)
		{
		case ' ':
		case '.':
		case 'o':
		case '\'':
		case ',':
		case '@':
		case '\\':
		case '/':
		case 0:
		case 'd':
		case 'b':
		case 'z':
		case 'Z':
		case '^':
		case '?':
		case '~':
			ret = -1;
			break;
		default:
			ret = 0;
		}
/*
		if ((b==' ')||(b=='.')||(b=='o')||(b=='\'')||(b==',')||(b=='@')||
		(b=='\\')||(b=='/')||(b==0)||(b=='d')||(b=='b')||(b=='z')||
		(b=='Z')||(b=='^')||(b==0))
		ret=-1;
		else ret=0;
*/

		//          b=screen[y-1][x];
		//           if ((b=='~')||(b==0)) ret=0;


		// *****************
		// ** PLATAFORMES **
		// *****************

		if (u!=-1) i=u;
		else i=0;
		u=user->num_obj;

		while ((i<u) && (ret==-1))
		{

			if (obj[i].name=='=')
			{
				if (obj[i].dir==RIGHT) i2=1; else
				if (obj[i].dir==LEFT) i2=-1;
				else i2=0;

				if ( (user->x+i2 >= obj[i].x) && ( user->x+i2 <  (obj[i].x+obj[i].len)) ) 
				if ( (user->y+1)==(obj[i].y) ) 
				{
					if ((obj[i].dir!=UP)&&(obj[i].dir!=DOWN))
					{
					ret=obj[i].dir;
					}
				}
				else if ( user->y == obj[i].y )
				{
					user->y--;
					ret=UP;           // salta per pujar-s'hi al damunt
				}
			}
			if (obj[i].name=='&')
			{
				if ( (user->x == obj[i].x) && (user->y+1 == obj[i].y) )
				ret=666;
			}
			if (obj[i].name=='-')
			if ( (user->x == obj[i].x) && (user->y+1 == obj[i].y) )
			{
				obj[i].old_dir++;
				ret=0;
			}

			i++;
			if (obj[i].visible == 0) continue;
		}
	}
	return(ret);
}

int load_screen(array screen, struct user *user, struct pos *posxy, struct obj *obj)
{
	FILE *fd;
	int i,i2,i3;
	int key;
	char buffer[80];
	int len;

	for(i=0;i<10;i++)
	{
		posxy[i].xl=0;
		posxy[i].yl=0;
		posxy[i].ini_pos=0;
		posxy[i].filename[0]=0;
	}

	fd = fopen(user->filename,"r");
	if ( fd == NULL ) quit(2);

	for(i=0;i<MAX_Y;i++)
	{
		for(i2=0;i2<MAX_X;i2++)
		{
		screen[i][i2]=' ';
		}
		screen[i][i2]=0;
	}

	move(MAX_Y,0);
	printw("Now loading...");

	i=0;
	while(!feof(fd))
	{
		buffer[0]=0;
		fgets(buffer, MAX_X, fd);
		if (buffer[0]==0) continue;
		len=strlen(buffer);

		/*## CHECK FOR COMMANDS ##*/

		if ( len )
		{
			if (! strncmp(buffer,";",1) )
			{
				//asm ( "nop;" );
			} else    // assembly rulezz.. :)
			if (! strncmp(buffer,"#ver=",5) )
			{
				if ( atoi(buffer+5) > VERSION ) quit(3);
			} else
			if (! strncmp(buffer,"#lives=",7) )
			{
				user->life=atoi(buffer+7);
			} else
			if (! strncmp(buffer,"#door",5) )
			{
				buffer[6]=0; buffer[8]=0;
				i2 = atoi(buffer+7);
				strcpy ( posxy[atoi(buffer+5)].tipus, "door" );
				strcpy ( posxy[i2].tipus, "open" );
				strcpy ( posxy[i2].filename, buffer+5 );
				i2 = atoi(buffer+9);
				strcpy ( posxy[i2].tipus, "close");
				strcpy ( posxy[i2].filename, buffer+5 );
			} else
			if (! strncmp(buffer,"#link",5) )
			{
				buffer[6]=0;
				i2=atoi(buffer+5);
				strcpy(posxy[i2].tipus, "link");
				buffer[6+strlen(buffer+7)]=0;
				strcpy( posxy[i2].filename, buffer+7 );
				i3=0;
				while( (i3<strlen(posxy[i2].filename)) && (posxy[i2].filename[i3]!=':') ) i3++;
				posxy[i2].filename[i3]=0;
				posxy[i2].ini_pos=atoi(posxy[i2].filename+i3+1);
			} else
			if (! strncmp(buffer,"#tele",5) )
			{
				buffer[6]=0;
				buffer[8]=0;
				i2=atoi(buffer+5);
				strcpy(posxy[i2].tipus, "tele");
				strcpy ( posxy[i2].filename, buffer+7 );
			} else
			if (! strncmp(buffer, "#mesg=",6) )
			{
				mesg(buffer+6,1,1);
			} else
			if (! strncmp(buffer, "#mesg",5) )
			{
				buffer[6]=0;
				i2=atoi(buffer+5);
				strcpy(posxy[i2].tipus, "mesg");
				strcpy (posxy[i2].filename, buffer+7);
			}
			else
			{
				strncpy(screen[i], buffer, strlen(buffer));
				screen[i][len-1]=' ';
				screen[i][MAX_X]=0;
				i++;
			}
		}
	}
	fclose(fd);

	/*## SEARCH FOR LINKS ##*/

	erase();
	for(i=0;i<MAX_Y;i++)
	for(i2=0;i2<MAX_X;i2++)
	if ( (screen[i][i2]>='0') && (screen[i][i2]<='9') )
	{
		i3=screen[i][i2]-'0';
		posxy[i3].xl=i2;
		posxy[i3].yl=i;
		if (!strcmp(posxy[i3].tipus,"door")) screen[i][i2]='#';
		else screen[i][i2]=' ';
	}

	/*## CHECK FOR POSITIONS ##*/
	i3=0;
	for(i=0;i<MAX_Y;i++)
	for(i2=0;i2<MAX_X;i2++)
	if (screen[i][i2]=='A')
	{
		posxy[i3].x=i2;
		posxy[i3].y=i; 
		screen[i][i2]=' ';
		i3++;
	}

	user->max_pos=i3;
	if (! i3) quit(5);

	if (user->max_pos==1) user->ini_pos=1;
	else i3=user->ini_pos;

	if (i3>user->max_pos) quit(6);
	if ( i3 ) { user->x=posxy[i3-1].x; user->y=posxy[i3-1].y; }
	else
	{
		key=0;
		i3=0;
		while(key!=' ')
		{
			erase();
			user->x=posxy[i3].x;
			user->y=posxy[i3].y;
			move(MAX_Y,0);
			printw("Press RIGHT/LEFT and SPACE to select the position");
			show_screen(screen, user, obj);
			key=getch();
			if (key==RIGHT) {
				i3++;
				if (i3>=user->max_pos) i3=0;
			}
			if (key==LEFT) {
				i3--;
				if (i3<0) i3=user->max_pos-1;
			}
		}
	}

	/*## FLOOR? ##*/
	user->floor=show_free(screen,user->y+1,user->x, 1, -1, user, obj);

	/*## LOOKING FOR OBJECTS... ##*/
	i3=0; // contador d'objectes en pantalla.
	for(i=0;i<MAX_Y;i++)
	for(i2=0;i2<MAX_X;i2++)
	{
		if (screen[i][i2]=='=')
		{
			obj[i3].visible=1;
			obj[i3].y=i;
			obj[i3].x=i2;
			obj[i3].name='=';
			while (screen[i][i2]=='=') { screen[i][i2]=' '; i2++; }
			obj[i3].len=i2-obj[i3].x;
			obj[i3].dir=RIGHT;
			obj[i3].jump=0;
			i3++;
		}
		if (screen[i][i2]=='\"')
		{
			obj[i3].visible=1;
			obj[i3].y=i;
			obj[i3].x=i2;
			obj[i3].name='=';
			while (screen[i][i2]=='\"') { screen[i][i2]=' '; i2++;}
			obj[i3].len=i2-obj[i3].x;
			obj[i3].dir=DOWN;
			obj[i3].jump=0;
			i3++;
		}
		if (screen[i][i2]=='x')
		{
			obj[i3].visible=1;
			obj[i3].y=i;
			obj[i3].x=i2;
			obj[i3].name='x';
			screen[i][i2]=' ';
			obj[i3].len=1;
			obj[i3].dir=LEFT;
			obj[i3].jump=0;
			i3++;
		}
		if (screen[i][i2]=='&')
		{
			obj[i3].visible=1;
			obj[i3].y=i;
			obj[i3].x=i2;
			obj[i3].name='&';
			screen[i][i2]=' ';
			obj[i3].len=1;
			obj[i3].dir=0;
			obj[i3].jump=0;
			i3++;
		}
		if (screen[i][i2]=='-')
		{
			obj[i3].visible=1;
			obj[i3].y=i;
			obj[i3].x=i2;
			obj[i3].name='-';
			screen[i][i2]=' ';
			obj[i3].len=1;
			obj[i3].dir=0;
			obj[i3].old_dir=0;
			obj[i3].jump=0;
			i3++; 
		}
		if (i3>=MAX_OBJ) break;
	}

	user->num_obj=i3;
}

/*****************************
 *                           *
 * CONTROL DE PLATAFORMES!!! *
 *                           *
 *****************************/


int show_obj(array screen, struct user *user, struct obj *obj)
{
	int i,i2;

	// EL MOU
	for(i=0;i<user->num_obj;i++)
	{
		if (obj[i].visible==0) continue;
		/**/
		if (obj[i].name=='&')
		{
			if ((screen[obj[i].y+1][obj[i].x]==' ')&&
			(!obj[i].jump)) obj[i].y++;
			if (screen[obj[i].y+1][obj[i].x]=='\\') obj[i].x++;
			if (screen[obj[i].y+1][obj[i].x]=='/') obj[i].x--;
			if (screen[obj[i].y+1][obj[i].x]=='>') obj[i].x++;
			if (screen[obj[i].y+1][obj[i].x]=='<') obj[i].x--;
			if (screen[obj[i].y+1][obj[i].x]=='z') obj[i].jump=5;
			if (screen[obj[i].y+1][obj[i].x]=='Z') obj[i].jump=10;
			if (screen[obj[i].y+1][obj[i].x]=='~')
			{
				i2=random()%8;
				if (i2>1) i2=0;
				else i2=1;
				obj[i].y+=i2;
			}
		}
		/**/
		if (obj[i].name=='_')
		{ // falling ground...
			if (show_free(screen,obj[i].y+1,obj[i].x, 1, -1, user, obj) )
				obj[i].y++;
			else 
				if (screen[obj[i].y+1][obj[i].x]=='#')
				{
					obj[i].visible=0;
					obj[i].x=666;
					obj[i].y=666;
				}
		}
		/**/
		if (obj[i].name=='x')
		{
			if ((user->x==obj[i].x)&&(user->y==obj[i].y))
			return(-1);

			if (screen[obj[i].y+1][obj[i].x]=='z')
			{
				obj[i].jump=5;
				obj[i].dir=UP;
			}
			if (screen[obj[i].y+1][obj[i].x]=='Z')
			{
				obj[i].jump=10; 
				obj[i].dir=UP;
			}

			if (obj[i].jump)
			{
				if (obj[i].old_dir==RIGHT) i2=1;
				else i2=-1; //** LEFT **//
				if (show_free(screen,obj[i].y, obj[i].x+i2, 1, i, user, obj))
				obj[i].dir=obj[i].old_dir;
			}

			if (obj[i].dir==RIGHT)
			if (!show_free(screen, obj[i].y, obj[i].x+1, 1, i, user, obj))
			{
				obj[i].dir=LEFT;
				if (obj[i].jump) obj[i].dir=0;
			}

			if (obj[i].dir==LEFT)
			if (!show_free(screen, obj[i].y, obj[i].x-1, 1, i, user, obj))
				obj[i].dir=RIGHT;

			if ((obj[i].dir!=DOWN)&&(obj[i].dir!=UP))
				obj[i].old_dir=obj[i].dir;

			if ( (show_free(screen, obj[i].y+1, obj[i].x, 1, i, user, obj))&&
			(!obj[i].jump) ) obj[i].dir=DOWN;
			else obj[i].dir=obj[i].old_dir;
		}

		/*## PLATAFORMES ##*/              
		/**/
		if (obj[i].name=='=')
		{
			if (obj[i].dir==RIGHT)
			{
				if (screen[obj[i].y][obj[i].x+obj[i].len-1]=='/')
					{ obj[i].dir=UP; } else
				if (screen[obj[i].y][obj[i].x+obj[i].len-1]=='\\')
					{ obj[i].dir=DOWN; } else
				if (screen[obj[i].y][obj[i].x+obj[i].len]=='#')
					obj[i].dir=LEFT;
			} else
			if (obj[i].dir==LEFT)
			{
				if (screen[obj[i].y][obj[i].x]=='\\')
					obj[i].dir=UP; else
				if (screen[obj[i].y][obj[i].x]=='/')
					obj[i].dir=DOWN; else
				if ((screen[obj[i].y][obj[i].x-1]=='#')|| (obj[i].x==-1))
					obj[i].dir=RIGHT;
			} else
			if (obj[i].dir==UP)
			{
				if (screen[obj[i].y][obj[i].x]=='/')
					obj[i].dir=RIGHT; else
				if (screen[obj[i].y][obj[i].x+obj[i].len-1]=='\\')
					obj[i].dir=LEFT; else
				if (!show_free(screen, obj[i].y-2, obj[i].x,
					obj[i].len, i,  user, obj))
					obj[i].dir=DOWN;
			} else
			if (obj[i].dir==DOWN)
			{
				if (screen[obj[i].y][obj[i].x+obj[i].len-1]=='/')
					obj[i].dir=LEFT; else
				if (screen[obj[i].y][obj[i].x]=='\\')
					obj[i].dir=RIGHT; else
				if (!show_free(screen, obj[i].y+1, obj[i].x,
					obj[i].len, i,  user, obj)) 
					obj[i].dir=UP;
			}
		}

		/**/
		if (obj[i].jump)
		if (show_free(screen, obj[i].y-1, obj[i].x, 1, i, user, obj))
		{
			obj[i].dir=UP;
			//obj[i].y--;
			obj[i].jump--;
		}
		else obj[i].jump=0;

		/*##*************##*/
		/*## PART COMUNA ##*/
		/*##-------------##*/

		if (obj[i].dir==RIGHT) obj[i].x++;
		if (obj[i].dir==LEFT) obj[i].x--;
		if (obj[i].dir==UP) obj[i].y--;
		if (obj[i].dir==DOWN) obj[i].y++;
	}
}

int check_link (array screen, struct user *user, struct pos *posxy, struct obj *obj)
{
	int i,i2;

	for(i=0;i<10;i++)
	if ((posxy[i].xl==user->x)&&(posxy[i].yl==user->y))
	{
		if (!strcmp(posxy[i].tipus,"link"))
		{
			if (strlen(posxy[i].filename))
			{
			strcpy(user->filename, posxy[i].filename);
			user->ini_pos=posxy[i].ini_pos;
			load_screen(screen, user, posxy, obj);
			return(0);
			}
		} else
		if (!strcmp(posxy[i].tipus,"open"))
		{
			i2=atoi(posxy[i].filename);
			screen[ posxy[i2].yl ] [ posxy[i2].xl ] =' ';
			return(0);
		} else
		if (!strcmp(posxy[i].tipus, "close"))
		{
			i2=atoi(posxy[i].filename);
			screen[ posxy[i2].yl ] [ posxy[i2].xl ] ='#'; 
			return(0);
		} else
		if (!strcmp(posxy[i].tipus, "tele"))
		{
			i2=atoi(posxy[i].filename);
			user->x=posxy[i2].xl;
			user->y=posxy[i2].yl;
			return(0); 
		} else
		if (!strcmp(posxy[i].tipus, "mesg"))
		{
			mesg(posxy[i].filename,1,0);
		}
	}
}

void dead (array screen, struct user *user, struct pos *posxy, struct obj *obj)
{
	int key=0,i=0;

	strcpy(user->filename, user->last_file);
	user->ini_pos=1;

	show_screen(screen, user, obj);

	mesg("You are dead. Press space to start again.",0,0);

	while(key!=' ')
	{
		move(user->y, user->x);
		if (!i) addch('X');
		else addch(USER);
		key=getch();
		i^=1;
	}

	load_screen(screen, user, posxy, obj);
	getch();

	user->x=user->last_x;
	user->y=user->last_y;
	user->life--;

	if (!user->life) quit(7);
}


int user_move(int d, array screen, struct user *user, struct obj *obj)
{
	int i,i2,ret=0;
	int x=user->x, y=user->y;
	int up; // show free up

	user->floor=show_free(screen, y+1, x, 1, -1, user, obj);
	if (user->floor==666) user->floor=0;
	if (screen[y+1][x]=='^') user->floor=0;

	up=show_free(screen,y-1,x,1,-1,user,obj);
	if (screen[y-1][x]=='H') up=1;
	if (screen[y][x]=='~') up=1;
	if (screen[y-1][x]=='~') up=1;
	if (screen[y-1][x]=='+') up=1;
	if ((screen[y-1][x]=='>')||(screen[y-1][x]=='<')) up=1;

	if ( ( (user->jump)&&(show_free(screen,user->y-1,user->x, 1, -1, user, obj)) )
		||( (user->jump) &&(up) ))
	{
		y--;
		user->jump--;
	} else {
		user->jump=0;
	}

	if (user->floor==RIGHT)
	{
		x++;
		user->floor=0;
	}
	if (user->floor==LEFT)
	{
		x--;
		user->floor=0;
	}
	if (user->floor==UP)
	{
		y--;
		user->floor=0;
	}
	if (user->floor==-1)
		user->floor=1;

	up=show_free(screen,y-1,x,1,-1,user,obj);
	if (screen[y-1][x]=='H') up=1;
	if (screen[y][x]=='~') up=1;
	if (screen[y-1][x]=='~') up=1;
	if (screen[y-1][x]=='+') up=1;

	if      (d==RIGHT) x++;
	else if (d==LEFT) x--;
	else if (d==UP) { if ((!user->floor)&&(up))  y--; }
	else if (d==UP2) { if ((!user->floor)&&(up)) { y--; user->jump=2; } }
	else if (d==UPRIGHT) { x++;
	if ((!user->floor)&&(up)) y--; }
	else if (d==UPRIGHT2){ x++;
	if ((!user->floor)&&(up)) { y--; user->jump=2;} }
	else if (d==UPLEFT) { x--;
	if ((!user->floor)&&(up)) y--; }
	else if (d==UPLEFT2) { x--;
	if ((!user->floor)&&(up)) { y--; user->jump=2; } }
	else if (d==DOWN)
	{
		switch(screen[y+1][x])
		{
		case ' ':
		case 'H':
		case '~':
		case '+':
			y++;
			user->floor=0;
		}
	}


	/*## USE SWITCH!!! ##*/

	if (d==RIGHT) i2=1;
	else if (d==LEFT) i2=-1;
	else i2=0;

	for(i=0;i<user->num_obj;i++)
	{
		if (obj[i].name=='&')
		{
			if ((user->x+i2==obj[i].x)&&(user->y==obj[i].y))
			if (screen[obj[i].y][obj[i].x+i2]==' ')
				obj[i].x+=i2;
			else	x=user->x; 
		} else
		if (obj[i].name=='-')
		{
			if (obj[i].old_dir) obj[i].name='_';
			if ((user->x==obj[i].x)&&(user->y==obj[i].y)) user->jump=1;
		}

		if (obj[i].name=='_')
		if ((user->x==obj[i].x)&&(user->y==obj[i].y))
			y--;
	}

	if (screen[y][x]=='#')
	{
		x=user->x;
		if (d==RIGHT) i2=1;
		else if (d==LEFT) i2=-1;
		else i2=0;
		if (screen[y][x+i2]==' ') user->jump=0;
	}

	if (screen[y+1][x]=='\\')
	{
		if (show_free(screen,y,x+1,1,-1,user,obj)) x++;
	}

	if (screen[y][x]=='\\')
	{
		x=user->x;
		y=user->y;
	}

	if (screen[y+1][x]=='/')
	{
		if (show_free(screen,y,x-1,1,-1,user,obj)) x--;
	}
	if (screen[y][x]=='/')
	{
		x=user->x;
		y=user->y;
	}

	if (screen[y+1][x]=='>')
	{
		if (show_free(screen,y,x+1,1,-1,user,obj)) x++;
	}
	if (screen[y][x]=='>')
	{
		y--;
	}

	if (screen[y+1][x]=='<')
	{
		if (show_free(screen,y,x-1,1,-1,user,obj)) x--;
	}
	if (screen[y][x]=='<')
	{
		y--;
	}

	if (screen[y][x]==0)
	{
		x=user->x;
		y=user->y;
	} 

	if (screen[y+1][x]=='Z')
	{
		user->jump=10;
	}
	if (screen[y+1][x]=='z')
	{
		user->jump=5;
	}

	if (screen[y][x]=='^')
	{
		user->jump=1;
	}

	if (screen[y][x]=='H')
	{
		user->floor=0;
		user->jump=0;
	} 

	if (screen[y][x]=='b') user->hjump=5;

	if (screen[y][x]=='d') user->hjump=-5;

	if (screen[y+1][x]=='~')
	{
		i=random()%8;
		if (i>1) i=0; else i=1;
		y=y+i;
	}
	else
	{
		if ((user->floor)&&(!user->jump)
		&&(show_free(screen,y+1,x,1,-1,user,obj))) y++;
		/*## efecte de la gravetat ##*/
	}

	if (user->hjump>0)
	{
		user->hjump--;
		if ((show_free(screen,y,x+2,1,-1,user,obj))&&
		(show_free(screen,y,x+1,1,-1,user,obj)))
		x+=2;
	} else
	if (user->hjump<0)
	{
		user->hjump++;
		if ((show_free(screen,y,x-2,1,-1,user,obj))&&
		(show_free(screen,y,x-1,1,-1,user,obj)))
		x-=2;
	} 

	if (screen[y][x]=='.')
	{
		screen[y][x]=' ';
		user->points++;
	}

	if (screen[y][x]=='o')
	{
		screen[y][x]=' ';
		user->points=user->points+5;
	}

	if (screen[y][x]=='@')
	{
		screen[y][x]=' ';
		user->life++;
	}

	if (screen[y][x]=='~') user->air--; 
	else if (user->air < user->air_max) user->air++;
	if (screen[y][x]=='?')
	{
		if (user->air < user->air_max) user->air++;
		else screen[y][x]='~';
	}
	if (screen[y][x]=='!')
	{
		user->air_max+=5;
		screen[y][x]=' ';
	}

	if (screen[y][x]=='P')
	{
		strcpy(user->last_file, user->filename);
		user->last_x=user->x;
		user->last_y=user->y;
	}

	if ((screen[y][x]=='\'')||(screen[y][x]==','))
	{
		ret=-1;
	}

	if (x<0) { x++; user->jump=0; }
	else if (x>MAX_X) x--;
	else if (y<0) y++;
//	else if (y>MAX_Y) y--;

	user->x=x;
	user->y=y;

	if (! user->air) ret=-1;

	return(ret);
}



/*##      ##*/
/*## MAIN ##*/ 
/*##      ##*/

int main(int argc, char *argv[])
{
	array screen;
	int key=' ';
	int i,i2,i3;
	struct pos posxy[10];
	struct obj obj[MAX_OBJ];
	struct user user;
	user.filename[0]='\0';
	user.life=3;
	user.points=0;
	user.jump=0;
	user.hjump=0;
	user.air=30;
	user.air_max=30;
	user.num_obj=0;
	user.ini_pos=0; // cap per defecte, l'escull el fitxer, o l'user

	if (argc>1)
	if ((!strcmp(argv[1], "-h"))||(!strcmp(argv[1], "--help")))
	{
		usage(argv[0]);
	}

	if (argc==1)
	{
		system("pag_intro");
		chdir(LEVEL_PATH);
		strcpy(user.filename,"001.pag");
	} else {
		if (!chdir(argv[1])) strcpy(user.filename,"001.pag"); else
		if (!access(argv[1],F_OK)) strcpy(user.filename,argv[1]); else
		if (  (!chdir(LEVEL_PATH)) && (!chdir(argv[1]))  )
			strcpy(user.filename,"001.pag");
	}

	initscr();
	load_screen(screen, &user, posxy, obj);

	strcpy(user.last_file,user.filename);
	user.last_x=user.x;
	user.last_y=user.y;

	/*## GAME LOOP STARTS HERE ##*/
	noecho();

	show_screen(screen,&user, obj);
	while (! show_status(&user) )
	{
		notimeout(stdscr,FALSE);
		timeout(100*DELAY);
		key=getch();

		if (show_obj(screen, &user, obj)==-1)
		dead(screen, &user, posxy, obj);

		if (key=='h') show_help(); else
		if (key==PAUSE) show_pause(); else
		if (key==QUIT) quit(4); else
		if (key=='+') DELAY+=.1; else
		if (key=='-') DELAY-=.1; else
		if (user_move(key, screen, &user, obj)==-1)
			dead(screen, &user, posxy, obj);
		if (show_screen(screen, &user, obj)==-1)
			dead(screen, &user, posxy, obj);
		check_link(screen, &user, posxy, obj);
	}

	endwin();

	exit(0);
}
